/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.DataProvider;
import y.base.Edge;
import y.layout.LayoutGraph;
import y.layout.PortConstraintKeys;

public class PortConstraint
implements PortConstraintKeys {
    public static final byte ANY_SIDE = 0;
    public static final byte NORTH = 1;
    public static final byte SOUTH = 2;
    public static final byte EAST = 4;
    public static final byte WEST = 8;
    private static final PortConstraint fbb = new PortConstraint(0);
    private static final PortConstraint zab = new PortConstraint(1);
    private static final PortConstraint dbb = new PortConstraint(2);
    private static final PortConstraint yab = new PortConstraint(4);
    private static final PortConstraint ebb = new PortConstraint(8);
    private static final PortConstraint xab = new PortConstraint(0, true);
    private static final PortConstraint vab = new PortConstraint(4, true);
    private static final PortConstraint wab = new PortConstraint(8, true);
    private static final PortConstraint uab = new PortConstraint(1, true);
    private static final PortConstraint bbb = new PortConstraint(2, true);
    private byte abb;
    private boolean cbb;

    public PortConstraint() {
        this(0);
    }

    public PortConstraint(byte by) {
        this.abb = by;
    }

    public PortConstraint(byte by, boolean bl) {
        this(by);
        this.cbb = bl;
    }

    public boolean isStrong() {
        return this.cbb;
    }

    public byte getSide() {
        return this.abb;
    }

    public boolean isAtNorth() {
        return this.abb == 1;
    }

    public boolean isAtSouth() {
        return this.abb == 2;
    }

    public boolean isAtEast() {
        return this.abb == 4;
    }

    public boolean isAtWest() {
        return this.abb == 8;
    }

    public boolean isAtAnySide() {
        return this.abb == 0;
    }

    public static boolean hasPC(LayoutGraph layoutGraph, Edge edge) {
        return PortConstraint.hasSPC(layoutGraph, edge) || PortConstraint.hasTPC(layoutGraph, edge);
    }

    public static boolean hasSPC(LayoutGraph layoutGraph, Edge edge) {
        PortConstraint portConstraint = PortConstraint.getSPC(layoutGraph, edge);
        return portConstraint != null && (portConstraint.abb != 0 || portConstraint.cbb);
    }

    public static boolean hasTPC(LayoutGraph layoutGraph, Edge edge) {
        PortConstraint portConstraint = PortConstraint.getTPC(layoutGraph, edge);
        return portConstraint != null && (portConstraint.abb != 0 || portConstraint.cbb);
    }

    public static PortConstraint getSPC(LayoutGraph layoutGraph, Edge edge) {
        DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
        if (dataProvider == null) {
            return null;
        }
        return (PortConstraint)dataProvider.get(edge);
    }

    public static PortConstraint getTPC(LayoutGraph layoutGraph, Edge edge) {
        DataProvider dataProvider = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        if (dataProvider == null) {
            return null;
        }
        return (PortConstraint)dataProvider.get(edge);
    }

    public static PortConstraint create(byte by) {
        return PortConstraint.create(by, false);
    }

    public int hashCode() {
        return this.cbb ? 1024 + this.abb : this.abb;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PortConstraint)) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        PortConstraint portConstraint = (PortConstraint)object;
        return portConstraint.cbb == this.cbb && portConstraint.abb == this.abb;
    }

    public static PortConstraint create(byte by, boolean bl) {
        if (bl) {
            switch (by) {
                case 0: {
                    return xab;
                }
                case 1: {
                    return uab;
                }
                case 2: {
                    return bbb;
                }
                case 4: {
                    return vab;
                }
                case 8: {
                    return wab;
                }
            }
            return null;
        }
        switch (by) {
            case 0: {
                return fbb;
            }
            case 1: {
                return zab;
            }
            case 2: {
                return dbb;
            }
            case 4: {
                return yab;
            }
            case 8: {
                return ebb;
            }
        }
        return null;
    }

    public String toString() {
        if (this.abb == 0) {
            if (this.cbb) {
                return "ANY_SIDE [strong] [-]";
            }
            return "ANY_SIDE [-]";
        }
        String string = null;
        switch (this.abb) {
            case 1: {
                string = "NORTH";
                break;
            }
            case 2: {
                string = "SOUTH";
                break;
            }
            case 4: {
                string = "EAST";
                break;
            }
            case 8: {
                string = "WEST";
            }
        }
        if (this.cbb) {
            string = string + " [strong] ";
        }
        return string;
    }
}

