/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Insets;
import y.base.DataMap;
import y.base.DataProvider;
import y.base.EdgeCursor;
import y.base.NodeCursor;
import y.geom.YDimension;
import y.geom.YInsets;
import y.geom.YPoint;
import y.layout.AbstractLayoutStage;
import y.layout.EdgeLayout;
import y.layout.LabelLayoutData;
import y.layout.LabelLayoutKeys;
import y.layout.LayoutGraph;
import y.layout.LayoutOrientation;
import y.layout.Layouter;
import y.layout.NodeHalo;
import y.layout.NodeLayout;
import y.layout.PortConstraint;
import y.layout.PortConstraintKeys;
import y.layout.PreferredPlacementDescriptor;
import y.layout.grid.PartitionGrid;
import y.layout.grouping.Grouping;
import y.layout.grouping.GroupingKeys;
import y.util.DataProviderAdapter;
import y.util.DataProviders;
import y.util.Maps;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OrientationLayouter
extends AbstractLayoutStage
implements LayoutOrientation {
    DataProvider cmc;
    DataProvider gmc;
    DataProvider zlc;
    DataProvider bmc;
    private DataMap amc = null;
    private DataMap emc = null;
    private byte ylc;
    private int hmc = 4;
    private boolean dmc = true;
    public static final int MIRROR_NONE = 0;
    public static final int MIRROR_TOP_TO_BOTTOM = 1;
    public static final int MIRROR_RIGHT_TO_LEFT = 2;
    public static final int MIRROR_BOTTOM_TO_TOP = 4;
    public static final int MIRROR_LEFT_TO_RIGHT = 8;
    private static final String fmc = "PARTITION_ORIENTATION_DPKEY";

    public OrientationLayouter(Layouter layouter) {
        this();
        this.setCoreLayouter(layouter);
        this.setOrientation((byte)0);
    }

    public OrientationLayouter() {
    }

    public OrientationLayouter(byte by) {
        this.setOrientation(by);
    }

    public void setOrientation(byte by) {
        this.ylc = by;
    }

    public byte getOrientation() {
        return this.ylc;
    }

    public int getMirrorMask() {
        return this.hmc;
    }

    public void setMirrorMask(int n2) {
        this.hmc = n2;
    }

    public boolean isHorizontalOrientation() {
        return this.ylc == 1 || this.ylc == 3;
    }

    public boolean isConsiderEdgeLabelsEnabled() {
        return this.dmc;
    }

    public void setConsiderEdgeLabelsEnabled(boolean bl) {
        this.dmc = bl;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.canLayoutCore(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        layoutGraph.addDataProvider(fmc, DataProviders.createConstantDataProvider(this));
        Transformer transformer = new Transformer();
        PartitionGrid partitionGrid = PartitionGrid.getPartitionGrid(layoutGraph);
        if (partitionGrid != null) {
            partitionGrid.prepareOrientationChange(this, transformer);
        }
        this.amc = Maps.createHashedDataMap();
        this.emc = Maps.createHashedDataMap();
        this.prepareOrientationChange(layoutGraph);
        if (this.getCoreLayouter() != null) {
            this.doLayoutCore(layoutGraph);
        }
        this.completeOrientationChange(layoutGraph);
        this.amc = null;
        this.emc = null;
        if (partitionGrid != null) {
            partitionGrid.finalizeOrientationChange(this, transformer);
        }
        layoutGraph.removeDataProvider(fmc);
    }

    public boolean isOrientationMirrored(byte by) {
        boolean bl = LayoutGraph.z;
        boolean bl2 = false;
        switch (by) {
            case 0: {
                boolean bl3 = bl2 = (1 & this.hmc) != 0;
                if (!bl) break;
            }
            case 3: {
                boolean bl4 = bl2 = (2 & this.hmc) != 0;
                if (!bl) break;
            }
            case 2: {
                boolean bl5 = bl2 = (4 & this.hmc) != 0;
                if (!bl) break;
            }
            case 1: {
                boolean bl6 = bl2 = (8 & this.hmc) != 0;
                if (!bl) break;
            }
            default: {
                bl2 = false;
            }
        }
        return bl2;
    }

    protected void prepareOrientationChange(LayoutGraph layoutGraph) {
        this.rf(layoutGraph);
        this.tf(layoutGraph);
        this.vf(layoutGraph);
        this.qf(layoutGraph);
        this.sf(layoutGraph);
        this.mf(layoutGraph);
        this.if(layoutGraph);
    }

    private void if(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
        if (dataProvider != null) {
            dataProvider = new _e(dataProvider);
            layoutGraph.addDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY, dataProvider);
        }
    }

    private void kf(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
        if (dataProvider != null) {
            dataProvider = ((_e)dataProvider).gd;
            layoutGraph.removeDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY);
            layoutGraph.addDataProvider(GroupingKeys.MINIMUM_NODE_SIZE_DPKEY, dataProvider);
        }
    }

    private void sf(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(NodeHalo.NODE_HALO_DPKEY);
        if (dataProvider != null) {
            layoutGraph.addDataProvider(NodeHalo.NODE_HALO_DPKEY, new _b(dataProvider));
        }
    }

    private void jf(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(NodeHalo.NODE_HALO_DPKEY);
        if (dataProvider instanceof _b) {
            layoutGraph.removeDataProvider(NodeHalo.NODE_HALO_DPKEY);
            layoutGraph.addDataProvider(NodeHalo.NODE_HALO_DPKEY, ((_b)dataProvider).dd);
        }
    }

    private void mf(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
        if (Grouping.isGrouped(layoutGraph) && dataProvider != null) {
            dataProvider = new _c(dataProvider);
            layoutGraph.addDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY, dataProvider);
        }
    }

    private void lf(LayoutGraph layoutGraph) {
        DataProvider dataProvider = layoutGraph.getDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
        if (Grouping.isGrouped(layoutGraph) && dataProvider instanceof _c) {
            dataProvider = ((_c)dataProvider).ed;
            layoutGraph.removeDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY);
            layoutGraph.addDataProvider(GroupingKeys.GROUP_NODE_INSETS_DPKEY, dataProvider);
        }
    }

    private void rf(LayoutGraph layoutGraph) {
        boolean bl = LayoutGraph.z;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            YPoint yPoint = layoutGraph.getCenter(nodeCursor.node());
            if (this.isHorizontalOrientation()) {
                NodeLayout nodeLayout = layoutGraph.getLayout(nodeCursor.node());
                nodeLayout.setSize(nodeLayout.getHeight(), nodeLayout.getWidth());
            }
            layoutGraph.setCenter(nodeCursor.node(), this.prepareTransform(yPoint));
            nodeCursor.next();
            if (!bl) continue;
        }
    }

    protected void completeOrientationChange(LayoutGraph layoutGraph) {
        this.nf(layoutGraph);
        this.of(layoutGraph);
        this.uf(layoutGraph);
        this.pf(layoutGraph);
        this.jf(layoutGraph);
        this.lf(layoutGraph);
        this.kf(layoutGraph);
    }

    private void nf(LayoutGraph layoutGraph) {
        boolean bl = LayoutGraph.z;
        NodeCursor nodeCursor = layoutGraph.nodes();
        while (nodeCursor.ok()) {
            YPoint yPoint = layoutGraph.getCenter(nodeCursor.node());
            if (this.isHorizontalOrientation()) {
                NodeLayout nodeLayout = layoutGraph.getLayout(nodeCursor.node());
                nodeLayout.setSize(nodeLayout.getHeight(), nodeLayout.getWidth());
            }
            layoutGraph.setCenter(nodeCursor.node(), this.completeTransform(yPoint));
            nodeCursor.next();
            if (!bl) continue;
        }
    }

    private void of(LayoutGraph layoutGraph) {
        boolean bl = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            block3: {
                EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
                YPoint yPoint = edgeLayout.getSourcePoint();
                edgeLayout.setSourcePoint(this.completeTransform(yPoint));
                yPoint = edgeLayout.getTargetPoint();
                edgeLayout.setTargetPoint(this.completeTransform(yPoint));
                for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                    yPoint = this.completeTransform(edgeLayout.getPoint(i2));
                    edgeLayout.setPoint(i2, yPoint.getX(), yPoint.getY());
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                edgeCursor.next();
            }
            if (!bl) continue;
        }
    }

    private void tf(LayoutGraph layoutGraph) {
        boolean bl = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            block3: {
                EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
                YPoint yPoint = edgeLayout.getSourcePoint();
                edgeLayout.setSourcePoint(this.prepareTransform(yPoint));
                yPoint = edgeLayout.getTargetPoint();
                edgeLayout.setTargetPoint(this.prepareTransform(yPoint));
                for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                    yPoint = this.prepareTransform(edgeLayout.getPoint(i2));
                    edgeLayout.setPoint(i2, yPoint.getX(), yPoint.getY());
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                edgeCursor.next();
            }
            if (!bl) continue;
        }
    }

    protected YPoint transform(YPoint yPoint, boolean bl) {
        return bl ? this.prepareTransform(yPoint) : this.completeTransform(yPoint);
    }

    protected YPoint prepareTransform(YPoint yPoint) {
        block15: {
            block14: {
                if (!this.isOrientationMirrored(this.ylc)) break block14;
                switch (this.ylc) {
                    case 0: {
                        return new YPoint(-yPoint.x, yPoint.y);
                    }
                    case 1: {
                        return new YPoint(yPoint.getY(), yPoint.getX());
                    }
                    case 3: {
                        return new YPoint(-yPoint.getY(), -yPoint.getX());
                    }
                    case 2: {
                        return new YPoint(yPoint.getX(), -yPoint.getY());
                    }
                }
                if (!LayoutGraph.z) break block15;
            }
            switch (this.ylc) {
                case 0: {
                    return yPoint;
                }
                case 1: {
                    return new YPoint(-yPoint.getY(), yPoint.getX());
                }
                case 3: {
                    return new YPoint(yPoint.getY(), -yPoint.getX());
                }
                case 2: {
                    return new YPoint(-yPoint.getX(), -yPoint.getY());
                }
            }
        }
        return yPoint;
    }

    protected YPoint completeTransform(YPoint yPoint) {
        block15: {
            block14: {
                if (!this.isOrientationMirrored(this.ylc)) break block14;
                switch (this.ylc) {
                    case 0: {
                        return new YPoint(-yPoint.x, yPoint.y);
                    }
                    case 1: {
                        return new YPoint(yPoint.getY(), yPoint.getX());
                    }
                    case 3: {
                        return new YPoint(-yPoint.getY(), -yPoint.getX());
                    }
                    case 2: {
                        return new YPoint(yPoint.getX(), -yPoint.getY());
                    }
                }
                if (!LayoutGraph.z) break block15;
            }
            switch (this.ylc) {
                case 0: {
                    return yPoint;
                }
                case 1: {
                    return new YPoint(yPoint.getY(), -yPoint.getX());
                }
                case 3: {
                    return new YPoint(-yPoint.getY(), yPoint.getX());
                }
                case 2: {
                    return new YPoint(-yPoint.getX(), -yPoint.getY());
                }
            }
        }
        return yPoint;
    }

    private void uf(LayoutGraph layoutGraph) {
        if (this.cmc != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, this.cmc);
            this.cmc = null;
            this.zlc = null;
        }
        if (this.gmc != null) {
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, this.gmc);
            this.gmc = null;
            this.bmc = null;
        }
    }

    private void pf(LayoutGraph layoutGraph) {
        this.f(layoutGraph, false);
    }

    private void vf(LayoutGraph layoutGraph) {
        this.cmc = layoutGraph.getDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY);
        if (this.cmc != null) {
            this.zlc = new _d(this.cmc);
            layoutGraph.addDataProvider(PortConstraintKeys.SOURCE_PORT_CONSTRAINT_KEY, this.zlc);
        }
        this.gmc = layoutGraph.getDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY);
        if (this.gmc != null) {
            this.bmc = new _d(this.gmc);
            layoutGraph.addDataProvider(PortConstraintKeys.TARGET_PORT_CONSTRAINT_KEY, this.bmc);
        }
    }

    private void qf(LayoutGraph layoutGraph) {
        this.f(layoutGraph, true);
    }

    private void f(LayoutGraph layoutGraph, boolean bl) {
        this.e(layoutGraph, bl);
        if (this.isConsiderEdgeLabelsEnabled()) {
            this.d(layoutGraph, bl);
        }
    }

    private void d(LayoutGraph layoutGraph, boolean bl) {
        boolean bl2 = LayoutGraph.z;
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.EDGE_LABEL_LAYOUT_KEY);
        if (dataProvider != null) {
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(edgeCursor.edge());
                if (labelLayoutDataArray != null && labelLayoutDataArray.length > 0) {
                    for (int i2 = 0; i2 < labelLayoutDataArray.length; ++i2) {
                        LabelLayoutData labelLayoutData = labelLayoutDataArray[i2];
                        this.c(labelLayoutData, bl);
                        if (!bl2) {
                            if (!bl2) continue;
                        }
                        break;
                    }
                } else {
                    edgeCursor.next();
                }
                if (!bl2) continue;
            }
        }
    }

    private void e(LayoutGraph layoutGraph, boolean bl) {
        boolean bl2 = LayoutGraph.z;
        DataProvider dataProvider = layoutGraph.getDataProvider(LabelLayoutKeys.NODE_LABEL_LAYOUT_KEY);
        if (dataProvider != null) {
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                LabelLayoutData[] labelLayoutDataArray = (LabelLayoutData[])dataProvider.get(nodeCursor.node());
                if (labelLayoutDataArray != null && labelLayoutDataArray.length > 0) {
                    for (int i2 = 0; i2 < labelLayoutDataArray.length; ++i2) {
                        LabelLayoutData labelLayoutData = labelLayoutDataArray[i2];
                        this.b(labelLayoutData, bl);
                        if (!bl2) {
                            if (!bl2) continue;
                        }
                        break;
                    }
                } else {
                    nodeCursor.next();
                }
                if (!bl2) continue;
            }
        }
    }

    private void b(LabelLayoutData labelLayoutData, boolean bl) {
        YPoint yPoint = this.transform(new YPoint(labelLayoutData.getX() + labelLayoutData.getWidth() / 2.0, labelLayoutData.getY() + labelLayoutData.getHeight() / 2.0), bl);
        YPoint yPoint2 = this.transform(new YPoint(labelLayoutData.getBounds().getUpX(), labelLayoutData.getBounds().getUpY()), bl);
        labelLayoutData.getBounds().setUpVector(yPoint2.x, yPoint2.y);
        double d2 = yPoint.getX() - labelLayoutData.getWidth() / 2.0;
        double d3 = yPoint.getY() - labelLayoutData.getHeight() / 2.0;
        labelLayoutData.setLocation(d2, d3);
    }

    private void c(LabelLayoutData labelLayoutData, boolean bl) {
        block8: {
            PreferredPlacementDescriptor preferredPlacementDescriptor;
            block9: {
                YPoint yPoint = this.transform(new YPoint(labelLayoutData.getX() + labelLayoutData.getWidth() / 2.0, labelLayoutData.getY() + labelLayoutData.getHeight() / 2.0), bl);
                YPoint yPoint2 = this.transform(new YPoint(labelLayoutData.getBounds().getUpX(), labelLayoutData.getBounds().getUpY()), bl);
                labelLayoutData.getBounds().setUpVector(yPoint2.x, yPoint2.y);
                double d2 = yPoint.getX() - labelLayoutData.getWidth() / 2.0;
                double d3 = yPoint.getY() - labelLayoutData.getHeight() / 2.0;
                labelLayoutData.setLocation(d2, d3);
                boolean bl2 = this.isOrientationMirrored(this.ylc);
                if (!bl2) break block8;
                if (!bl) break block9;
                preferredPlacementDescriptor = labelLayoutData.getPreferredPlacementDescriptor();
                byte by = 0;
                if (preferredPlacementDescriptor.isOnEdge()) {
                    by = (byte)(by | 8);
                }
                if (preferredPlacementDescriptor.isLeftOfEdge()) {
                    by = (byte)(by | 0x20);
                }
                if (preferredPlacementDescriptor.isRightOfEdge()) {
                    by = (byte)(by | 0x10);
                }
                if (preferredPlacementDescriptor.getSideOfEdge() == by) break block8;
                this.amc.set(labelLayoutData, preferredPlacementDescriptor);
                PreferredPlacementDescriptor preferredPlacementDescriptor2 = (PreferredPlacementDescriptor)this.emc.get(preferredPlacementDescriptor);
                if (preferredPlacementDescriptor2 == null) {
                    preferredPlacementDescriptor2 = new PreferredPlacementDescriptor(preferredPlacementDescriptor);
                    preferredPlacementDescriptor2.setSideOfEdge(by);
                    this.emc.set(preferredPlacementDescriptor, preferredPlacementDescriptor2);
                }
                labelLayoutData.setPreferredPlacementDescriptor(preferredPlacementDescriptor2);
                if (!LayoutGraph.z) break block8;
            }
            if ((preferredPlacementDescriptor = (PreferredPlacementDescriptor)this.amc.get(labelLayoutData)) != null) {
                labelLayoutData.setPreferredPlacementDescriptor(preferredPlacementDescriptor);
            }
        }
    }

    public YInsets createOrientedInsets(Insets insets) {
        return this.createOrientedInsets(new YInsets(insets));
    }

    public YInsets createOrientedInsets(YInsets yInsets) {
        if (this.isOrientationMirrored(this.ylc)) {
            switch (this.ylc) {
                case 2: {
                    return new YInsets(yInsets.bottom, yInsets.left, yInsets.top, yInsets.right);
                }
                case 1: {
                    return new YInsets(yInsets.left, yInsets.top, yInsets.right, yInsets.bottom);
                }
                case 3: {
                    return new YInsets(yInsets.right, yInsets.bottom, yInsets.left, yInsets.top);
                }
            }
            return new YInsets(yInsets.top, yInsets.right, yInsets.bottom, yInsets.left);
        }
        switch (this.ylc) {
            case 2: {
                return new YInsets(yInsets.bottom, yInsets.right, yInsets.top, yInsets.left);
            }
            case 1: {
                return new YInsets(yInsets.left, yInsets.bottom, yInsets.right, yInsets.top);
            }
            case 3: {
                return new YInsets(yInsets.right, yInsets.top, yInsets.left, yInsets.bottom);
            }
        }
        return yInsets;
    }

    public NodeHalo createOrientedNodeHalo(NodeHalo nodeHalo) {
        if (this.isOrientationMirrored(this.ylc)) {
            switch (this.ylc) {
                case 2: {
                    return NodeHalo.create(nodeHalo.bottom, nodeHalo.left, nodeHalo.top, nodeHalo.right);
                }
                case 1: {
                    return NodeHalo.create(nodeHalo.left, nodeHalo.top, nodeHalo.right, nodeHalo.bottom);
                }
                case 3: {
                    return NodeHalo.create(nodeHalo.right, nodeHalo.bottom, nodeHalo.left, nodeHalo.top);
                }
            }
            return NodeHalo.create(nodeHalo.top, nodeHalo.right, nodeHalo.bottom, nodeHalo.left);
        }
        switch (this.ylc) {
            case 2: {
                return NodeHalo.create(nodeHalo.bottom, nodeHalo.right, nodeHalo.top, nodeHalo.left);
            }
            case 1: {
                return NodeHalo.create(nodeHalo.left, nodeHalo.bottom, nodeHalo.right, nodeHalo.top);
            }
            case 3: {
                return NodeHalo.create(nodeHalo.right, nodeHalo.top, nodeHalo.left, nodeHalo.bottom);
            }
        }
        return nodeHalo;
    }

    public YDimension createOrientedNodeSize(YDimension yDimension) {
        switch (this.ylc) {
            case 1: 
            case 3: {
                return new YDimension(yDimension.getHeight(), yDimension.getWidth());
            }
        }
        return new YDimension(yDimension.getWidth(), yDimension.getHeight());
    }

    public final class Transformer {
        Transformer() {
        }

        public YPoint finalizeTransform(YPoint yPoint) {
            return OrientationLayouter.this.completeTransform(yPoint);
        }

        public YPoint initTransform(YPoint yPoint) {
            return OrientationLayouter.this.prepareTransform(yPoint);
        }
    }

    private class _d
    extends DataProviderAdapter {
        DataProvider fd;

        _d(DataProvider dataProvider) {
            this.fd = dataProvider;
        }

        public Object get(Object object) {
            PortConstraint portConstraint;
            block55: {
                byte by;
                boolean bl;
                block56: {
                    portConstraint = (PortConstraint)this.fd.get(object);
                    if (portConstraint == null || portConstraint.isAtAnySide()) break block55;
                    bl = portConstraint.isStrong();
                    by = OrientationLayouter.this.getOrientation();
                    if (!OrientationLayouter.this.isOrientationMirrored(by)) break block56;
                    switch (by) {
                        case 1: {
                            switch (portConstraint.getSide()) {
                                case 2: {
                                    return PortConstraint.create((byte)4, bl);
                                }
                                case 8: {
                                    return PortConstraint.create((byte)1, bl);
                                }
                                case 1: {
                                    return PortConstraint.create((byte)8, bl);
                                }
                                case 4: {
                                    return PortConstraint.create((byte)2, bl);
                                }
                            }
                        }
                        case 3: {
                            switch (portConstraint.getSide()) {
                                case 2: {
                                    return PortConstraint.create((byte)8, bl);
                                }
                                case 4: {
                                    return PortConstraint.create((byte)1, bl);
                                }
                                case 1: {
                                    return PortConstraint.create((byte)4, bl);
                                }
                                case 8: {
                                    return PortConstraint.create((byte)2, bl);
                                }
                            }
                        }
                        case 2: {
                            switch (portConstraint.getSide()) {
                                case 2: {
                                    return PortConstraint.create((byte)1, bl);
                                }
                                case 4: {
                                    return portConstraint;
                                }
                                case 1: {
                                    return PortConstraint.create((byte)2, bl);
                                }
                                case 8: {
                                    return portConstraint;
                                }
                            }
                        }
                        case 0: {
                            switch (portConstraint.getSide()) {
                                case 2: {
                                    return portConstraint;
                                }
                                case 4: {
                                    return PortConstraint.create((byte)8, bl);
                                }
                                case 1: {
                                    return portConstraint;
                                }
                                case 8: {
                                    return PortConstraint.create((byte)4, bl);
                                }
                            }
                        }
                    }
                    if (!LayoutGraph.z) break block55;
                }
                switch (by) {
                    case 1: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)8, bl);
                            }
                            case 8: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 1: {
                                return PortConstraint.create((byte)4, bl);
                            }
                            case 4: {
                                return PortConstraint.create((byte)2, bl);
                            }
                        }
                    }
                    case 3: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)4, bl);
                            }
                            case 4: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 1: {
                                return PortConstraint.create((byte)8, bl);
                            }
                            case 8: {
                                return PortConstraint.create((byte)2, bl);
                            }
                        }
                    }
                    case 2: {
                        switch (portConstraint.getSide()) {
                            case 2: {
                                return PortConstraint.create((byte)1, bl);
                            }
                            case 4: {
                                return PortConstraint.create((byte)8, bl);
                            }
                            case 1: {
                                return PortConstraint.create((byte)2, bl);
                            }
                            case 8: {
                                return PortConstraint.create((byte)4, bl);
                            }
                        }
                    }
                }
            }
            return portConstraint;
        }
    }

    class _e
    extends DataProviderAdapter {
        DataProvider gd;

        _e(DataProvider dataProvider) {
            this.gd = dataProvider;
        }

        public Object get(Object object) {
            Object object2 = this.gd.get(object);
            if (object2 instanceof YDimension) {
                object2 = OrientationLayouter.this.createOrientedNodeSize((YDimension)object2);
            }
            return object2;
        }
    }

    class _b
    extends DataProviderAdapter {
        DataProvider dd;

        _b(DataProvider dataProvider) {
            this.dd = dataProvider;
        }

        public Object get(Object object) {
            if (this.dd.get(object) instanceof NodeHalo) {
                NodeHalo nodeHalo = (NodeHalo)this.dd.get(object);
                return OrientationLayouter.this.createOrientedNodeHalo(nodeHalo);
            }
            return null;
        }
    }

    class _c
    extends DataProviderAdapter {
        DataProvider ed;

        _c(DataProvider dataProvider) {
            this.ed = dataProvider;
        }

        public Object get(Object object) {
            YInsets yInsets = YInsets.asYInsets(this.ed.get(object));
            if (yInsets != null) {
                return OrientationLayouter.this.createOrientedInsets(yInsets);
            }
            return yInsets;
        }
    }
}

