/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.DataProvider;
import y.base.Node;
import y.geom.YRectangle;
import y.layout.LayoutGraph;
import y.layout.NodeLayout;

public final class NodeHalo {
    public static final Object NODE_HALO_DPKEY = "y.layout.NodeHalo.NODE_HALO_DPKEY";
    public static final NodeHalo ZERO_HALO = NodeHalo.create(0.0);
    public final double top;
    public final double left;
    public final double bottom;
    public final double right;

    private NodeHalo(double d2, double d3, double d4, double d5) {
        this.top = d2;
        this.left = d3;
        this.bottom = d4;
        this.right = d5;
    }

    public static NodeHalo create(double d2, double d3, double d4, double d5) {
        NodeHalo.b(d2);
        NodeHalo.b(d3);
        NodeHalo.b(d4);
        NodeHalo.b(d5);
        return new NodeHalo(d2, d3, d4, d5);
    }

    public static NodeHalo create(double d2) {
        NodeHalo.b(d2);
        return new NodeHalo(d2, d2, d2, d2);
    }

    private static void b(double d2) {
        if (d2 < 0.0 || Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException(Double.toString(d2));
        }
    }

    public static boolean hasHalos(LayoutGraph layoutGraph) {
        return layoutGraph.getDataProvider(NODE_HALO_DPKEY) != null;
    }

    public static NodeHalo getHalo(LayoutGraph layoutGraph, Node node) {
        NodeHalo nodeHalo;
        DataProvider dataProvider = layoutGraph.getDataProvider(NODE_HALO_DPKEY);
        if (dataProvider != null && (nodeHalo = (NodeHalo)dataProvider.get(node)) != null) {
            return nodeHalo;
        }
        return ZERO_HALO;
    }

    public static YRectangle getHaloBox(LayoutGraph layoutGraph, Node node) {
        NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
        NodeHalo nodeHalo = NodeHalo.getHalo(layoutGraph, node);
        return new YRectangle(nodeLayout.getX() - nodeHalo.left, nodeLayout.getY() - nodeHalo.top, nodeLayout.getWidth() + nodeHalo.left + nodeHalo.right, nodeLayout.getHeight() + nodeHalo.top + nodeHalo.bottom);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NodeHalo nodeHalo = (NodeHalo)object;
        if (nodeHalo.bottom != this.bottom) {
            return false;
        }
        if (nodeHalo.left != this.left) {
            return false;
        }
        if (nodeHalo.right != this.right) {
            return false;
        }
        return nodeHalo.top == this.top;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.top);
        int n2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.left);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.bottom);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.right);
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }
}

