/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.Graph;
import y.base.ListCell;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.YCursor;
import y.base.YList;
import y.geom.Geom;
import y.geom.LineSegment;
import y.geom.OrientedRectangle;
import y.geom.YDimension;
import y.geom.YLineSegmentCursor;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.geom.YVector;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.GraphLayout;
import y.layout.LabelLayout;
import y.layout.LabelLayoutFactory;
import y.layout.LayoutGraph;
import y.layout.NodeHalo;
import y.layout.NodeLabelModel;
import y.layout.NodeLayout;
import y.util.Comparators;

public class LayoutTool {
    public static final int LEADING = 1;
    public static final int TRAILING = 2;
    public static final int JUSTIFIED = 3;
    public static final int CENTER = 4;
    public static final byte MULTI_ROW_NO_CONSTRAINT = 0;
    public static final byte MULTI_ROW_HEIGHT_CONSTRAINT = 1;
    public static final byte MULTI_ROW_WIDTH_CONSTRAINT = 2;
    private static final double g = 0.5;
    private static final double c = 100.0;
    public static final byte FLOW_UP = 2;
    public static final byte FLOW_DOWN = 0;
    public static final byte FLOW_LEFT = 3;
    public static final byte FLOW_RIGHT = 1;
    public static final byte FLOW_NONE = -1;
    public static final byte ALIGN_NODES_LEADING = -1;
    public static final byte ALIGN_NODES_CENTERED = 0;
    public static final byte ALIGN_NODES_TRAILING = 1;
    public static final byte ALIGN_NODES_DISTRIBUTED = 2;
    private static final double f = 1.0E-4;
    private static final byte d = 0;
    private static final byte b = 1;
    private static final YPointPath e = new YPointPath();
    private static final YPoint h = YPoint.ORIGIN;

    public static LabelLayoutFactory getLabelFactory(LayoutGraph layoutGraph) {
        return layoutGraph.r();
    }

    public static byte determineEdgeFlowDirection(LayoutGraph layoutGraph, DataProvider dataProvider) {
        boolean bl = LayoutGraph.z;
        int n2 = 0;
        int[] nArray = new int[4];
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (dataProvider == null || dataProvider.getBool(edge)) {
                YPointPath yPointPath = layoutGraph.getPath(edge);
                n2 += yPointPath.length() - 1;
                YLineSegmentCursor yLineSegmentCursor = yPointPath.lineSegments();
                while (yLineSegmentCursor.ok()) {
                    LineSegment lineSegment = yLineSegmentCursor.lineSegment();
                    LayoutTool.b(lineSegment, nArray);
                    yLineSegmentCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break;
                }
            } else {
                edgeCursor.next();
            }
            if (!bl) continue;
        }
        return LayoutTool.b(nArray, n2);
    }

    public static boolean isUsingOrthogonalEdgeRoutes(LayoutGraph layoutGraph, DataProvider dataProvider) {
        return LayoutTool.b(layoutGraph, dataProvider, (byte)1);
    }

    public static boolean isUsingOctilinearEdgeRoutes(LayoutGraph layoutGraph, DataProvider dataProvider) {
        return LayoutTool.b(layoutGraph, dataProvider, (byte)0);
    }

    private static boolean b(LayoutGraph layoutGraph, DataProvider dataProvider, byte by) {
        block14: {
            block12: {
                boolean bl = LayoutGraph.z;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                EdgeCursor edgeCursor = layoutGraph.edges();
                while (edgeCursor.ok()) {
                    Edge edge = edgeCursor.edge();
                    if (bl) break block12;
                    if (dataProvider == null || dataProvider.getBool(edge)) {
                        int n5;
                        block13: {
                            ++n2;
                            YPointPath yPointPath = layoutGraph.getPath(edge);
                            if (yPointPath.length() == 2) {
                                ++n4;
                            }
                            int n6 = 1;
                            YLineSegmentCursor yLineSegmentCursor = yPointPath.lineSegments();
                            while (yLineSegmentCursor.ok()) {
                                LineSegment lineSegment = yLineSegmentCursor.lineSegment();
                                double d2 = Math.abs(lineSegment.getDeltaX());
                                double d3 = Math.abs(lineSegment.getDeltaY());
                                double d4 = d2 - 1.0E-4;
                                n5 = d4 == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
                                if (!bl) {
                                    if (n5 > 0 && d3 > 1.0E-4 && (by == 1 || Math.abs(d2 - d3) > 1.0E-4)) {
                                        n6 = 0;
                                        if (!bl) break;
                                    }
                                    yLineSegmentCursor.next();
                                    if (!bl) continue;
                                }
                                break block13;
                            }
                            n5 = n6;
                        }
                        if (n5 != 0) {
                            ++n3;
                        }
                    }
                    edgeCursor.next();
                    if (!bl) continue;
                }
                if (n3 != n2 && (n3 <= n4 || !((double)n3 > 0.5 * (double)n2))) break block14;
            }
            return true;
        }
        return false;
    }

    private static byte b(int[] nArray, int n2) {
        int n3 = 2;
        byte by = 0;
        if (nArray[n3] > nArray[0]) {
            n3 = 0;
            by = 2;
        }
        if (nArray[n3] > nArray[3]) {
            n3 = 3;
            by = 1;
        }
        if (nArray[n3] > nArray[1]) {
            n3 = 1;
            by = 3;
        }
        if ((double)nArray[by] > 0.3 * (double)n2 && nArray[by] > 5 * nArray[n3]) {
            return by;
        }
        return -1;
    }

    private static boolean b(LineSegment lineSegment) {
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        return yPoint.x == yPoint2.x || yPoint.y == yPoint2.y;
    }

    private static void b(LineSegment lineSegment, int[] nArray) {
        block11: {
            YPoint yPoint;
            YPoint yPoint2;
            block10: {
                boolean bl;
                block9: {
                    block8: {
                        bl = LayoutGraph.z;
                        yPoint2 = lineSegment.getFirstEndPoint();
                        yPoint = lineSegment.getSecondEndPoint();
                        if (!(yPoint2.x < yPoint.x)) break block8;
                        nArray[1] = nArray[1] + 1;
                        if (!bl) break block9;
                    }
                    if (yPoint2.x > yPoint.x) {
                        nArray[3] = nArray[3] + 1;
                    }
                }
                if (!(yPoint2.y < yPoint.y)) break block10;
                nArray[0] = nArray[0] + 1;
                if (!bl) break block11;
            }
            if (yPoint2.y > yPoint.y) {
                nArray[2] = nArray[2] + 1;
            }
        }
    }

    public static double getNodeDistance(LayoutGraph layoutGraph, Node node, Node node2) {
        double d2 = layoutGraph.getCenterX(node);
        double d3 = layoutGraph.getCenterY(node);
        double d4 = layoutGraph.getCenterX(node2);
        double d5 = layoutGraph.getCenterY(node2);
        return YPoint.distance(d2, d3, d4, d5);
    }

    public static double getPathLength(LayoutGraph layoutGraph, Edge edge) {
        double d2;
        YPoint yPoint;
        double d3;
        double d4;
        double d5;
        block2: {
            boolean bl = LayoutGraph.z;
            YPoint yPoint2 = layoutGraph.getSourcePointAbs(edge);
            d5 = yPoint2.x;
            d4 = yPoint2.y;
            EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
            double d6 = 0.0;
            for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                YPoint yPoint3 = edgeLayout.getPoint(i2);
                d3 = yPoint3.x;
                yPoint = yPoint3;
                if (!bl) {
                    d2 = yPoint.y;
                    d6 += YPoint.distance(d5, d4, d3, d2);
                    d5 = d3;
                    d4 = d2;
                    if (!bl) continue;
                }
                break block2;
            }
            yPoint = layoutGraph.getTargetPointAbs(edge);
        }
        YPoint yPoint4 = yPoint;
        d3 = yPoint4.x;
        d2 = yPoint4.y;
        return d6 += YPoint.distance(d5, d4, d3, d2);
    }

    public static void reverseEdgeLayout(EdgeLayout edgeLayout) {
        EdgeLayout edgeLayout2;
        Object object;
        block6: {
            boolean bl = LayoutGraph.z;
            if (edgeLayout.pointCount() > 0) {
                int n2;
                block5: {
                    object = new ArrayList(edgeLayout.pointCount());
                    for (n2 = edgeLayout.pointCount() - 1; n2 >= 0; --n2) {
                        object.add(edgeLayout.getPoint(n2));
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block5;
                    }
                    edgeLayout.clearPoints();
                }
                for (n2 = 0; n2 < object.size(); ++n2) {
                    YPoint yPoint = (YPoint)object.get(n2);
                    edgeLayout2 = edgeLayout;
                    if (!bl) {
                        edgeLayout2.addPoint(yPoint.getX(), yPoint.getY());
                        if (!bl) continue;
                    }
                    break block6;
                }
            }
            edgeLayout2 = edgeLayout;
        }
        object = edgeLayout2.getSourcePoint();
        edgeLayout.setSourcePoint(edgeLayout.getTargetPoint());
        edgeLayout.setTargetPoint((YPoint)object);
    }

    public static void resetPaths(LayoutGraph layoutGraph) {
        LayoutTool.resetPaths(layoutGraph, true);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static void resetPaths(LayoutGraph layoutGraph, boolean bl) {
        EdgeCursor edgeCursor;
        boolean bl2 = LayoutGraph.z;
        if (bl) {
            edgeCursor = layoutGraph.edges();
            do {
                if (!edgeCursor.ok()) return;
                Edge edge = edgeCursor.edge();
                layoutGraph.setSourcePointRel(edge, h);
                layoutGraph.setTargetPointRel(edge, h);
                layoutGraph.setPoints(edge, e);
                edgeCursor.next();
            } while (!bl2);
        }
        edgeCursor = layoutGraph.edges();
        do {
            if (!edgeCursor.ok()) return;
            layoutGraph.setPoints(edgeCursor.edge(), e);
            edgeCursor.next();
        } while (!bl2);
    }

    public static void resetPath(LayoutGraph layoutGraph, Edge edge) {
        LayoutTool.resetPath(layoutGraph, edge, true);
    }

    public static void resetPath(LayoutGraph layoutGraph, Edge edge, boolean bl) {
        if (bl) {
            layoutGraph.setSourcePointRel(edge, h);
            layoutGraph.setTargetPointRel(edge, h);
        }
        layoutGraph.setPoints(edge, e);
    }

    public static void removeDuplicateBends(LayoutGraph layoutGraph) {
        boolean bl = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            LayoutTool.removeDuplicateBends(layoutGraph, edgeCursor.edge());
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    public static void removeDuplicateBends(LayoutGraph layoutGraph, Edge edge) {
        boolean bl = LayoutGraph.z;
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        boolean bl2 = false;
        YPoint yPoint = layoutGraph.getSourcePointAbs(edge);
        if (edgeLayout.pointCount() > 0) {
            boolean bl3;
            YPoint yPoint2;
            block7: {
                for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                    yPoint2 = edgeLayout.getPoint(i2);
                    bl3 = yPoint.equals(yPoint2);
                    if (!bl) {
                        if (bl3) {
                            bl2 = true;
                            if (!bl) break;
                        }
                        yPoint = yPoint2;
                        if (!bl) continue;
                    }
                    break block7;
                }
                bl3 = bl2;
            }
            if (bl3 || yPoint.equals(layoutGraph.getTargetPointAbs(edge))) {
                YList yList = layoutGraph.getPathList(edge);
                yPoint2 = (YPoint)yList.firstCell().getInfo();
                for (ListCell listCell = yList.firstCell().succ(); listCell != yList.lastCell(); listCell = listCell.succ()) {
                    if (listCell.getInfo().equals(yPoint2)) {
                        yList.removeCell(listCell);
                    }
                    yPoint2 = (YPoint)listCell.getInfo();
                    if (!bl) continue;
                }
                layoutGraph.setPath(edge, yList);
            }
        }
    }

    public static void moveEdge(LayoutGraph layoutGraph, Edge edge, double d2, double d3) {
        boolean bl = LayoutGraph.z;
        EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edge);
        for (int i2 = edgeLayout.pointCount() - 1; i2 >= 0; --i2) {
            YPoint yPoint = edgeLayout.getPoint(i2);
            edgeLayout.setPoint(i2, yPoint.x + d2, yPoint.y + d3);
            if (!bl) continue;
        }
    }

    public static void moveEdges(LayoutGraph layoutGraph, EdgeCursor edgeCursor, double d2, double d3) {
        boolean bl = LayoutGraph.z;
        while (edgeCursor.ok()) {
            block3: {
                EdgeLayout edgeLayout = layoutGraph.getEdgeLayout(edgeCursor.edge());
                for (int i2 = edgeLayout.pointCount() - 1; i2 >= 0; --i2) {
                    YPoint yPoint = edgeLayout.getPoint(i2);
                    edgeLayout.setPoint(i2, yPoint.x + d2, yPoint.y + d3);
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block3;
                }
                edgeCursor.next();
            }
            if (!bl) continue;
        }
    }

    public static void moveNode(LayoutGraph layoutGraph, Node node, double d2, double d3) {
        NodeLayout nodeLayout = layoutGraph.getNodeLayout(node);
        nodeLayout.setLocation(nodeLayout.getX() + d2, nodeLayout.getY() + d3);
    }

    public static void moveNodes(LayoutGraph layoutGraph, NodeCursor nodeCursor, double d2, double d3) {
        boolean bl = LayoutGraph.z;
        while (nodeCursor.ok()) {
            NodeLayout nodeLayout = layoutGraph.getNodeLayout(nodeCursor.node());
            nodeLayout.setLocation(nodeLayout.getX() + d2, nodeLayout.getY() + d3);
            nodeCursor.next();
            if (!bl) continue;
        }
    }

    public static void moveSubgraph(LayoutGraph layoutGraph, EdgeCursor edgeCursor, double d2, double d3) {
        HashSet<Node> hashSet;
        Object object;
        boolean bl;
        block3: {
            bl = LayoutGraph.z;
            HashSet<Node> hashSet2 = new HashSet<Node>();
            while (edgeCursor.ok()) {
                object = edgeCursor.edge();
                hashSet2.add(((Edge)object).source());
                hashSet = hashSet2;
                if (!bl) {
                    hashSet.add(((Edge)object).target());
                    LayoutTool.moveEdge(layoutGraph, (Edge)object, d2, d3);
                    edgeCursor.next();
                    if (!bl) continue;
                }
                break block3;
            }
            hashSet = hashSet2;
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            LayoutTool.moveNode(layoutGraph, node, d2, d3);
            if (!bl) continue;
        }
    }

    public static void moveSubgraph(LayoutGraph layoutGraph, NodeCursor nodeCursor, double d2, double d3) {
        LayoutGraph layoutGraph2;
        HashSet<Node> hashSet;
        boolean bl;
        block4: {
            bl = LayoutGraph.z;
            hashSet = new HashSet<Node>();
            while (nodeCursor.ok()) {
                layoutGraph2 = layoutGraph;
                if (!bl) {
                    LayoutTool.moveNode(layoutGraph2, nodeCursor.node(), d2, d3);
                    hashSet.add(nodeCursor.node());
                    nodeCursor.next();
                    if (!bl) continue;
                }
                break block4;
            }
            layoutGraph2 = layoutGraph;
        }
        EdgeCursor edgeCursor = layoutGraph2.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (hashSet.contains(edge.source()) && hashSet.contains(edge.target())) {
                LayoutTool.moveEdge(layoutGraph, edge, d2, d3);
            }
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, NodeCursor nodeCursor, EdgeCursor edgeCursor) {
        Rectangle2D rectangle2D = LayoutTool.getBoundingBox(layoutGraph, nodeCursor);
        Rectangle2D rectangle2D2 = LayoutTool.getBoundingBox(layoutGraph, edgeCursor);
        if (rectangle2D.getWidth() < 0.0) {
            return rectangle2D2;
        }
        if (rectangle2D2.getWidth() < 0.0) {
            return rectangle2D;
        }
        rectangle2D.add(rectangle2D2);
        return rectangle2D;
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, Node node) {
        NodeLayout nodeLayout = layoutGraph.getLayout(node);
        return new Rectangle2D.Double(nodeLayout.getX(), nodeLayout.getY(), nodeLayout.getWidth(), nodeLayout.getHeight());
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, NodeCursor nodeCursor) {
        boolean bl = LayoutGraph.z;
        if (!nodeCursor.ok()) {
            return new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
        }
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        while (nodeCursor.ok()) {
            NodeLayout nodeLayout = layoutGraph.getLayout(nodeCursor.node());
            d2 = Math.min(d2, nodeLayout.getX());
            d3 = Math.min(d3, nodeLayout.getY());
            d4 = Math.max(d4, nodeLayout.getX() + nodeLayout.getWidth());
            d5 = Math.max(d5, nodeLayout.getY() + nodeLayout.getHeight());
            nodeCursor.next();
            if (!bl) continue;
        }
        return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, Edge edge) {
        boolean bl = LayoutGraph.z;
        YPoint yPoint = layoutGraph.getSourcePointAbs(edge);
        double d2 = yPoint.x;
        double d3 = yPoint.x;
        double d4 = yPoint.y;
        double d5 = yPoint.y;
        yPoint = layoutGraph.getTargetPointAbs(edge);
        d2 = Math.min(d2, yPoint.x);
        d3 = Math.max(d3, yPoint.x);
        d4 = Math.min(d4, yPoint.y);
        d5 = Math.max(d5, yPoint.y);
        EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
        for (int i2 = edgeLayout.pointCount() - 1; i2 >= 0; --i2) {
            yPoint = edgeLayout.getPoint(i2);
            d2 = Math.min(d2, yPoint.x);
            d3 = Math.max(d3, yPoint.x);
            d4 = Math.min(d4, yPoint.y);
            d5 = Math.max(d5, yPoint.y);
            if (!bl) continue;
        }
        return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, EdgeCursor edgeCursor) {
        boolean bl = LayoutGraph.z;
        if (!edgeCursor.ok()) {
            return new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
        }
        YPoint yPoint = layoutGraph.getSourcePointAbs(edgeCursor.edge());
        double d2 = yPoint.x;
        double d3 = yPoint.x;
        double d4 = yPoint.y;
        double d5 = yPoint.y;
        while (edgeCursor.ok()) {
            block4: {
                Edge edge = edgeCursor.edge();
                EdgeLayout edgeLayout = layoutGraph.getLayout(edge);
                for (int i2 = edgeLayout.pointCount() - 1; i2 >= 0; --i2) {
                    yPoint = edgeLayout.getPoint(i2);
                    d2 = Math.min(d2, yPoint.x);
                    d3 = Math.max(d3, yPoint.x);
                    d4 = Math.min(d4, yPoint.y);
                    d5 = Math.max(d5, yPoint.y);
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block4;
                }
                yPoint = layoutGraph.getSourcePointAbs(edge);
                d2 = Math.min(d2, yPoint.x);
                d3 = Math.max(d3, yPoint.x);
                d4 = Math.min(d4, yPoint.y);
                d5 = Math.max(d5, yPoint.y);
                yPoint = layoutGraph.getTargetPointAbs(edge);
                d2 = Math.min(d2, yPoint.x);
                d3 = Math.max(d3, yPoint.x);
                d4 = Math.min(d4, yPoint.y);
                d5 = Math.max(d5, yPoint.y);
                edgeCursor.next();
            }
            if (!bl) continue;
        }
        return new Rectangle2D.Double(d2, d4, d3 - d2, d5 - d4);
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, NodeCursor nodeCursor, EdgeCursor edgeCursor, boolean bl) {
        return LayoutTool.getBoundingBox(layoutGraph, nodeCursor, edgeCursor, bl, bl);
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, NodeCursor nodeCursor, EdgeCursor edgeCursor, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        LabelLayout[] labelLayoutArray;
        boolean bl3 = LayoutGraph.z;
        Rectangle2D rectangle2D = LayoutTool.getBoundingBox(layoutGraph, nodeCursor, edgeCursor);
        if (bl) {
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                labelLayoutArray = layoutGraph.getNodeLabelLayout(nodeCursor.node());
                object2 = layoutGraph.getLayout(nodeCursor.node());
                if (!bl3) {
                    if (labelLayoutArray != null && labelLayoutArray.length > 0) {
                        for (int i2 = 0; i2 < labelLayoutArray.length; ++i2) {
                            object = labelLayoutArray[i2].getLabelModel();
                            YRectangle yRectangle = object.getLabelPlacement(labelLayoutArray[i2].getOrientedBox().getSize(), (NodeLayout)object2, labelLayoutArray[i2].getModelParameter()).getBoundingBox();
                            rectangle2D.add(yRectangle.x, yRectangle.y);
                            rectangle2D.add(yRectangle.x + yRectangle.width, yRectangle.y + yRectangle.height);
                            if (!bl3) {
                                if (!bl3) continue;
                            }
                            break;
                        }
                    } else {
                        nodeCursor.next();
                    }
                    if (!bl3) continue;
                }
                break;
            }
        } else if (bl2) {
            edgeCursor.toFirst();
            while (edgeCursor.ok()) {
                labelLayoutArray = layoutGraph.getEdgeLabelLayout(edgeCursor.edge());
                object2 = layoutGraph.getEdgeLayout(edgeCursor.edge());
                NodeLayout nodeLayout = layoutGraph.getNodeLayout(edgeCursor.edge().source());
                object = layoutGraph.getNodeLayout(edgeCursor.edge().target());
                if (labelLayoutArray != null && labelLayoutArray.length > 0) {
                    for (int i3 = 0; i3 < labelLayoutArray.length; ++i3) {
                        EdgeLabelModel edgeLabelModel = labelLayoutArray[i3].getLabelModel();
                        YRectangle yRectangle = edgeLabelModel.getLabelPlacement(labelLayoutArray[i3].getOrientedBox().getSize(), (EdgeLayout)object2, nodeLayout, (NodeLayout)object, labelLayoutArray[i3].getModelParameter()).getBoundingBox();
                        rectangle2D.add(yRectangle.x, yRectangle.y);
                        rectangle2D.add(yRectangle.x + yRectangle.width, yRectangle.y + yRectangle.height);
                        if (!bl3) {
                            if (!bl3) continue;
                        }
                        break;
                    }
                } else {
                    edgeCursor.next();
                }
                if (!bl3) continue;
            }
        }
        return rectangle2D;
    }

    public static Rectangle2D getBoundingBox(LayoutGraph layoutGraph, NodeCursor nodeCursor, EdgeCursor edgeCursor, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = LayoutGraph.z;
        Rectangle2D rectangle2D = LayoutTool.getBoundingBox(layoutGraph, nodeCursor, edgeCursor, bl, bl2);
        if (bl3 && NodeHalo.hasHalos(layoutGraph)) {
            nodeCursor.toFirst();
            while (nodeCursor.ok()) {
                Node node = nodeCursor.node();
                NodeHalo nodeHalo = NodeHalo.getHalo(layoutGraph, node);
                if (!NodeHalo.ZERO_HALO.equals(nodeHalo)) {
                    NodeLayout nodeLayout = layoutGraph.getLayout(node);
                    rectangle2D.add(nodeLayout.getX() - nodeHalo.left, nodeLayout.getY() - nodeHalo.top);
                    rectangle2D.add(nodeLayout.getX() + nodeLayout.getWidth() + nodeHalo.right, nodeLayout.getY() + nodeLayout.getHeight() + nodeHalo.bottom);
                }
                nodeCursor.next();
                if (!bl4) continue;
            }
        }
        return rectangle2D;
    }

    public static YPoint getLabelPlacement(NodeLabelModel nodeLabelModel, YDimension yDimension, NodeLayout nodeLayout, Object object) {
        return nodeLabelModel.getLabelPlacement(yDimension, nodeLayout, object).getBoundingBox().getLocation();
    }

    public static YPoint getLabelPlacement(EdgeLabelModel edgeLabelModel, YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, Object object) {
        return edgeLabelModel.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, object).getBoundingBox().getLocation();
    }

    public static void resetPorts(LayoutGraph layoutGraph) {
        boolean bl = LayoutGraph.z;
        YPoint yPoint = YPoint.ORIGIN;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            layoutGraph.setSourcePointRel(edge, yPoint);
            layoutGraph.setTargetPointRel(edge, yPoint);
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    public static YPointPath getEdgeClippedOnBB(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        return LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, 0.0);
    }

    public static YPointPath getEdgeClippedOnBB(LayoutGraph layoutGraph, Edge edge) {
        return LayoutTool.getEdgeClippedOnBB(layoutGraph.getLayout(edge), layoutGraph.getLayout(edge.source()), layoutGraph.getLayout(edge.target()));
    }

    public static YPointPath getEdgeClippedOnBB(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, double d2) {
        ArrayList<YPoint> arrayList;
        boolean bl;
        block16: {
            ArrayList<YPoint> arrayList2;
            block15: {
                int n2;
                YDimension yDimension;
                YPoint yPoint;
                block14: {
                    int n3;
                    block13: {
                        int n4;
                        bl = LayoutGraph.z;
                        YPoint yPoint2 = new YPoint(nodeLayout.getX() - d2, nodeLayout.getY() - d2);
                        YDimension yDimension2 = new YDimension(nodeLayout.getWidth() + 2.0 * d2, nodeLayout.getHeight() + 2.0 * d2);
                        yPoint = new YPoint(nodeLayout2.getX() - d2, nodeLayout2.getY() - d2);
                        yDimension = new YDimension(nodeLayout2.getWidth() + 2.0 * d2, nodeLayout2.getHeight() + 2.0 * d2);
                        arrayList2 = new ArrayList<YPoint>(edgeLayout.pointCount() + 2);
                        YPoint yPoint3 = new YPoint(edgeLayout.getSourcePoint().getX() + yPoint2.getX() + yDimension2.getWidth() / 2.0, edgeLayout.getSourcePoint().getY() + yPoint2.getY() + yDimension2.getHeight() / 2.0);
                        arrayList2.add(yPoint3);
                        for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                            arrayList2.add(edgeLayout.getPoint(i2));
                            if (!bl) continue;
                        }
                        YPoint yPoint4 = new YPoint(edgeLayout.getTargetPoint().getX() + yPoint.getX() + yDimension.getWidth() / 2.0, edgeLayout.getTargetPoint().getY() + yPoint.getY() + yDimension.getHeight() / 2.0);
                        arrayList2.add(yPoint4);
                        YPoint yPoint5 = (YPoint)arrayList2.get(0);
                        YPoint yPoint6 = (YPoint)arrayList2.get(arrayList2.size() - 1);
                        arrayList = new ArrayList<YPoint>();
                        int n5 = 0;
                        while (LayoutTool.b(yPoint2, yDimension2, (YPoint)arrayList2.get(n5))) {
                            if (++n5 != arrayList2.size()) continue;
                            return new YPointPath();
                        }
                        if (n5 > 0) {
                            arrayList.add(LayoutTool.b(yPoint2, yDimension2, (YPoint)arrayList2.get(n5 - 1), (YPoint)arrayList2.get(n5)));
                        }
                        for (n2 = arrayList2.size() - 1; n2 >= n5; --n2) {
                            n4 = LayoutTool.b(yPoint, yDimension, (YPoint)arrayList2.get(n2)) ? 1 : 0;
                            if (!bl) {
                                if (n4 == 0) break;
                                if (!bl) continue;
                            }
                            break block13;
                        }
                        n4 = n3 = n5;
                    }
                    while (n3 <= n2) {
                        arrayList.add((YPoint)arrayList2.get(n3));
                        ++n3;
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block14;
                    }
                    if (n2 == arrayList2.size() - 1) {
                        return new YPointPath(arrayList);
                    }
                }
                if (arrayList.isEmpty()) break block15;
                arrayList.add(LayoutTool.b(yPoint, yDimension, (YPoint)arrayList2.get(n2 + 1), (YPoint)arrayList.get(arrayList.size() - 1)));
                if (!bl) break block16;
            }
            arrayList = arrayList2;
        }
        YPointPath yPointPath = new YPointPath(arrayList);
        if (Graph.z != 0) {
            LayoutGraph.z = !bl;
        }
        return yPointPath;
    }

    public static boolean isEdgeOutsideNodes(LayoutGraph layoutGraph, Edge edge) {
        return LayoutTool.isEdgeOutsideNodes(layoutGraph.getLayout(edge), layoutGraph.getLayout(edge.source()), layoutGraph.getLayout(edge.target()), 0.0);
    }

    public static boolean isEdgeOutsideNodes(EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, double d2) {
        boolean bl;
        boolean bl2;
        block6: {
            boolean bl3 = LayoutGraph.z;
            YPoint yPoint = new YPoint(nodeLayout.getX() - d2, nodeLayout.getY() - d2);
            YDimension yDimension = new YDimension(nodeLayout.getWidth() + 2.0 * d2, nodeLayout.getHeight() + 2.0 * d2);
            YPoint yPoint2 = new YPoint(nodeLayout2.getX() - d2, nodeLayout2.getY() - d2);
            YDimension yDimension2 = new YDimension(nodeLayout2.getWidth() + 2.0 * d2, nodeLayout2.getHeight() + 2.0 * d2);
            ArrayList<YPoint> arrayList = new ArrayList<YPoint>(edgeLayout.pointCount() + 2);
            YPoint yPoint3 = new YPoint(edgeLayout.getSourcePoint().getX() + yPoint.getX() + yDimension.getWidth() / 2.0, edgeLayout.getSourcePoint().getY() + yPoint.getY() + yDimension.getHeight() / 2.0);
            arrayList.add(yPoint3);
            for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                arrayList.add(edgeLayout.getPoint(i2));
                if (!bl3) continue;
                int n2 = Graph.z;
                Graph.z = ++n2;
                break;
            }
            YPoint yPoint4 = new YPoint(edgeLayout.getTargetPoint().getX() + yPoint2.getX() + yDimension2.getWidth() / 2.0, edgeLayout.getTargetPoint().getY() + yPoint2.getY() + yDimension2.getHeight() / 2.0);
            arrayList.add(yPoint4);
            YPoint yPoint5 = (YPoint)arrayList.get(0);
            YPoint yPoint6 = (YPoint)arrayList.get(arrayList.size() - 1);
            if (!LayoutTool.b(yPoint, yDimension, yPoint5)) {
                arrayList.add(0, new YPoint(yPoint.getX() + yDimension.getWidth() / 2.0, yPoint.getY() + yDimension.getHeight() / 2.0));
            }
            if (!LayoutTool.b(yPoint2, yDimension2, yPoint6)) {
                arrayList.add(new YPoint(yPoint2.getX() + yDimension2.getWidth() / 2.0, yPoint2.getY() + yDimension2.getHeight() / 2.0));
            }
            bl2 = false;
            boolean bl4 = false;
            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                YPoint yPoint7 = (YPoint)arrayList.get(i3);
                bl = LayoutTool.b(yPoint, yDimension, yPoint7);
                if (!bl3) {
                    if (!bl) {
                        bl2 = true;
                    }
                    if (LayoutTool.b(yPoint2, yDimension2, yPoint7)) continue;
                    bl4 = true;
                    if (!bl3) continue;
                }
                break block6;
            }
            bl = bl4;
        }
        return bl && bl2;
    }

    public static void clipEdgesOnBB(LayoutGraph layoutGraph) {
        boolean bl = LayoutGraph.z;
        EdgeCursor edgeCursor = layoutGraph.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            LayoutTool.clipEdgeOnBB(layoutGraph, edge);
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    public static void clipEdgeOnBB(LayoutGraph layoutGraph, Edge edge) {
        YPointPath yPointPath = LayoutTool.getEdgeClippedOnBB(layoutGraph, edge);
        List list = yPointPath.toList();
        if (!list.isEmpty()) {
            layoutGraph.setSourcePointAbs(edge, (YPoint)list.get(0));
            layoutGraph.setTargetPointAbs(edge, (YPoint)list.get(list.size() - 1));
            list.remove(list.size() - 1);
            list.remove(0);
            layoutGraph.setPoints(edge, new YPointPath(list));
        }
    }

    public static String edgeLayoutString(LayoutGraph layoutGraph, Edge edge) {
        StringBuffer stringBuffer;
        block2: {
            boolean bl = LayoutGraph.z;
            StringBuffer stringBuffer2 = new StringBuffer();
            YCursor yCursor = layoutGraph.getPoints(edge).cursor();
            while (yCursor.ok()) {
                YPoint yPoint = (YPoint)yCursor.current();
                stringBuffer = stringBuffer2.append("X: " + yPoint.getX() + " Y: " + yPoint.getY() + "\n");
                if (!bl) {
                    yCursor.next();
                    if (!bl) continue;
                }
                break block2;
            }
            stringBuffer = stringBuffer2;
        }
        return stringBuffer.toString();
    }

    public static void roundNodeLayout(LayoutGraph layoutGraph, Node node) {
        YDimension yDimension = layoutGraph.getSize(node);
        layoutGraph.setSize(node, LayoutTool.b(yDimension));
        YPoint yPoint = layoutGraph.getLocation(node);
        layoutGraph.setLocation(node, LayoutTool.b(yPoint));
    }

    public static void roundEdgeLayout(LayoutGraph layoutGraph, Edge edge) {
        block2: {
            boolean bl = LayoutGraph.z;
            List list = layoutGraph.getPoints(edge).toList();
            ArrayList<YPoint> arrayList = new ArrayList<YPoint>(list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                arrayList.add(LayoutTool.b((YPoint)list.get(i2)));
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            layoutGraph.setPoints(edge, new YPointPath(arrayList));
            layoutGraph.setSourcePointRel(edge, LayoutTool.b(layoutGraph.getSourcePointRel(edge)));
            layoutGraph.setTargetPointRel(edge, LayoutTool.b(layoutGraph.getTargetPointRel(edge)));
        }
    }

    public static void roundLayout(LayoutGraph layoutGraph) {
        LayoutGraph layoutGraph2;
        YCursor yCursor;
        boolean bl;
        block3: {
            bl = LayoutGraph.z;
            yCursor = layoutGraph.edges();
            while (yCursor.ok()) {
                layoutGraph2 = layoutGraph;
                if (!bl) {
                    LayoutTool.roundEdgeLayout(layoutGraph2, yCursor.edge());
                    yCursor.next();
                    if (!bl) continue;
                }
                break block3;
            }
            layoutGraph2 = layoutGraph;
        }
        yCursor = layoutGraph2.nodes();
        while (yCursor.ok()) {
            LayoutTool.roundNodeLayout(layoutGraph, yCursor.node());
            yCursor.next();
            if (!bl) continue;
        }
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, Edge edge2, double d2) {
        LayoutTool.routeEdgesParallel(layoutGraph, edge, edge2, d2, false, 0.0, 0.0);
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, Edge edge2, double d2, boolean bl, double d3, double d4) {
        block40: {
            YPoint yPoint;
            YPoint yPoint2;
            Object object;
            block39: {
                boolean bl2;
                block38: {
                    YVector yVector;
                    YPoint[] yPointArray;
                    int n2;
                    block37: {
                        YVector yVector2;
                        block32: {
                            Object object2;
                            Object object3;
                            YPoint yPoint3;
                            block36: {
                                YVector yVector3;
                                block35: {
                                    int n3;
                                    Object object4;
                                    block31: {
                                        bl2 = LayoutGraph.z;
                                        n2 = layoutGraph.getPath(edge).length();
                                        yPointArray = new YPoint[n2];
                                        int n4 = 0;
                                        object = layoutGraph.getPath(edge).cursor();
                                        while (object.ok()) {
                                            block33: {
                                                block34: {
                                                    object4 = (YPoint)object.current();
                                                    n3 = n4;
                                                    if (bl2) break block31;
                                                    if (n3 > 0 && ((YPoint)object4).equals(yPointArray[n4 - 1])) break block33;
                                                    if (n4 <= 1 || !Geom.collinear(yPointArray[n4 - 2], yPointArray[n4 - 1], (YPoint)object4)) break block34;
                                                    yPointArray[n4 - 1] = new YPoint(((YPoint)object4).getX(), ((YPoint)object4).getY());
                                                    if (!bl2) break block33;
                                                }
                                                yPointArray[n4] = new YPoint(((YPoint)object4).getX(), ((YPoint)object4).getY());
                                                ++n4;
                                            }
                                            object.next();
                                            if (!bl2) continue;
                                        }
                                        n3 = n2 = n4;
                                    }
                                    if (n3 < 2 || n2 == 2 && YPoint.distance(yPointArray[0], yPointArray[1]) < 1.0E-4) {
                                        LayoutTool.resetPath(layoutGraph, edge2);
                                        return;
                                    }
                                    object = new YList();
                                    object4 = new YVector(yPointArray[1], yPointArray[0]);
                                    yVector3 = YVector.orthoNormal((YVector)object4);
                                    yVector3.scale(d2);
                                    yPoint3 = YVector.add(yPointArray[1], yVector3);
                                    if (!bl) break block35;
                                    object3 = new YVector((YVector)object4);
                                    boolean bl3 = true;
                                    double d5 = ((YVector)object3).length();
                                    double d6 = (d4 * d5 + d3) / d5;
                                    if (n2 == 2 && d6 > 0.5) {
                                        d6 = 0.5;
                                    }
                                    ((YVector)object3).scale(d6);
                                    ((YVector)object3).add(yVector3);
                                    if (n2 > 2) {
                                        object2 = YVector.orthoNormal(new YVector(yPointArray[2], yPointArray[1]));
                                        ((YVector)object2).scale(d2);
                                        YPoint yPoint4 = Geom.calcIntersection(YVector.add(yPointArray[1], yVector3), YVector.add(yPointArray[0], yVector3), YVector.add(yPointArray[2], (YVector)object2), YVector.add(yPointArray[1], (YVector)object2));
                                        if (yPoint4 != null) {
                                            YVector yVector4 = new YVector(yPoint4, yPointArray[0]);
                                            if (((YVector)object3).length() > yVector4.length()) {
                                                bl3 = false;
                                                yPoint3 = yPoint4;
                                            }
                                        }
                                    }
                                    if (bl3) {
                                        ((YList)object).add(YVector.add(yPointArray[0], (YVector)object3));
                                    }
                                    yPoint2 = yPointArray[0];
                                    if (!bl2) break block36;
                                }
                                yPoint2 = YVector.add(yPointArray[0], yVector3);
                            }
                            object3 = yPoint2;
                            YPoint yPoint5 = yPoint3;
                            for (int i2 = 1; i2 < n2 - 1; ++i2) {
                                yVector2 = yVector = YVector.orthoNormal(new YVector(yPointArray[i2 + 1], yPointArray[i2]));
                                if (!bl2) {
                                    yVector2.scale(d2);
                                    YPoint yPoint6 = YVector.add(yPointArray[i2], yVector);
                                    YPoint yPoint7 = YVector.add(yPointArray[i2 + 1], yVector);
                                    object2 = Geom.calcIntersection((YPoint)object3, yPoint5, yPoint6, yPoint7);
                                    if (object2 != null) {
                                        ((YList)object).add(object2);
                                    }
                                    object3 = yPoint6;
                                    yPoint5 = yPoint7;
                                    if (!bl2) continue;
                                }
                                break block32;
                            }
                            yVector2 = new YVector(yPointArray[n2 - 1], yPointArray[n2 - 2]);
                        }
                        YVector yVector5 = yVector2;
                        yVector = YVector.orthoNormal(yVector5);
                        yVector.scale(d2);
                        if (!bl) break block37;
                        YVector yVector6 = new YVector(yVector5);
                        boolean bl4 = true;
                        double d7 = yVector6.length();
                        double d8 = (d4 * d7 + d3) / d7;
                        if (n2 == 2 && d8 > 0.5) {
                            d8 = 0.5;
                            bl4 = false;
                        }
                        yVector6.scale(-d8);
                        yVector6.add(yVector);
                        if (n2 > 2) {
                            YVector yVector7 = YVector.orthoNormal(new YVector(yPointArray[n2 - 2], yPointArray[n2 - 3]));
                            yVector7.scale(d2);
                            YPoint yPoint8 = Geom.calcIntersection(YVector.add(yPointArray[n2 - 2], yVector7), YVector.add(yPointArray[n2 - 3], yVector7), YVector.add(yPointArray[n2 - 1], yVector), YVector.add(yPointArray[n2 - 2], yVector));
                            if (yPoint8 != null) {
                                YVector yVector8 = new YVector(yPoint8, yPointArray[n2 - 1]);
                                if (yVector6.length() > yVector8.length()) {
                                    bl4 = false;
                                }
                            }
                        }
                        if (bl4) {
                            ((YList)object).add(YVector.add(yPointArray[n2 - 1], yVector6));
                        }
                        yPoint = yPointArray[n2 - 1];
                        if (!bl2) break block38;
                    }
                    yPoint = YVector.add(yPointArray[n2 - 1], yVector);
                }
                if (!edge.source().equals(edge2.source())) break block39;
                layoutGraph.setPoints(edge2, (YList)object);
                layoutGraph.setEndPointsAbs(edge2, yPoint2, yPoint);
                if (!bl2) break block40;
            }
            ((YList)object).reverse();
            layoutGraph.setPoints(edge2, (YList)object);
            layoutGraph.setEndPointsAbs(edge2, yPoint, yPoint2);
        }
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, EdgeList edgeList, double d2) {
        LayoutTool.routeEdgesParallel(layoutGraph, edge, edgeList, d2, false, false, 0.0, 0.0);
    }

    public static void routeEdgesParallel(LayoutGraph layoutGraph, Edge edge, EdgeList edgeList, double d2, boolean n2, boolean bl, double d3, double d4) {
        int n3;
        block5: {
            boolean bl2 = LayoutGraph.z;
            double d5 = d2;
            double d6 = 0.0;
            if (n2 != 0 && edgeList.size() % 2 == 1) {
                d6 -= d2 * 0.5;
            }
            EdgeCursor edgeCursor = edgeList.edges();
            while (edgeCursor.ok()) {
                Edge edge2 = edgeCursor.edge();
                LayoutTool.routeEdgesParallel(layoutGraph, edge, edge2, d5 + d6, bl, d3, d4);
                double d7 = d5 - 0.0;
                n3 = d7 == 0.0 ? 0 : (d7 < 0.0 ? -1 : 1);
                if (!bl2) {
                    if (n3 < 0) {
                        d5 -= d2;
                    }
                    d5 = -d5;
                    edgeCursor.next();
                    if (!bl2) continue;
                }
                break block5;
            }
            n3 = n2;
        }
        if (n3 != 0 && edgeList.size() % 2 == 1) {
            LayoutTool.routeEdgesParallel(layoutGraph, edge, edge, -d2 * 0.5, bl, d3, d4);
        }
    }

    static YList d(YList yList) {
        boolean bl = LayoutGraph.z;
        if (yList.size() < 3) {
            return yList;
        }
        ListCell listCell = yList.firstCell();
        YPoint yPoint = (YPoint)listCell.getInfo();
        ListCell listCell2 = listCell.succ();
        YPoint yPoint2 = (YPoint)listCell2.getInfo();
        for (ListCell listCell3 = listCell2.succ(); listCell3 != null; listCell3 = listCell3.succ()) {
            YPoint yPoint3;
            block6: {
                block5: {
                    yPoint3 = (YPoint)listCell3.getInfo();
                    if (!LayoutTool.b(yPoint, yPoint2, yPoint3)) break block5;
                    yList.removeCell(listCell2);
                    if (!bl) break block6;
                }
                listCell = listCell2;
                yPoint = yPoint2;
            }
            listCell2 = listCell3;
            yPoint2 = yPoint3;
            if (!bl) continue;
        }
        return yList;
    }

    private static boolean b(YPoint yPoint, YPoint yPoint2, YPoint yPoint3) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = Math.rint(yPoint.x * 100.0) / 100.0;
        return Geom.orientation(d7, d6 = Math.rint(yPoint.y * 100.0) / 100.0, d5 = Math.rint(yPoint2.x * 100.0) / 100.0, d4 = Math.rint(yPoint2.y * 100.0) / 100.0, d3 = Math.rint(yPoint3.x * 100.0) / 100.0, d2 = Math.rint(yPoint3.y * 100.0) / 100.0) == 0;
    }

    public static void routeSelfLoop(LayoutGraph layoutGraph, Edge edge) {
        ArrayList<YPoint> arrayList = new ArrayList<YPoint>();
        YPoint yPoint = layoutGraph.getLocation(edge.source());
        YDimension yDimension = layoutGraph.getSize(edge.source());
        YPoint yPoint2 = new YPoint(yPoint.getX() + yDimension.getWidth() / 4.0, yPoint.getY() + yDimension.getHeight() / 4.0);
        arrayList.add(new YPoint(yPoint.getX() + yDimension.getWidth() / 4.0, yPoint.getY() - 20.0));
        arrayList.add(new YPoint(yPoint.getX() - 20.0, yPoint.getY() - 20.0));
        arrayList.add(new YPoint(yPoint.getX() - 20.0, yPoint.getY() + yDimension.getHeight() / 4.0));
        layoutGraph.setPoints(edge, new YPointPath(arrayList));
        layoutGraph.setSourcePointAbs(edge, yPoint2);
        layoutGraph.setTargetPointAbs(edge, yPoint2);
    }

    public static void assignReverseLayout(LayoutGraph layoutGraph, Edge edge, Edge edge2) {
        layoutGraph.setSourcePointAbs(edge, layoutGraph.getTargetPointAbs(edge2));
        layoutGraph.setTargetPointAbs(edge, layoutGraph.getSourcePointAbs(edge2));
        layoutGraph.setPoints(edge, layoutGraph.getPoints(edge2).createReverse());
    }

    public static String getNodePositions(LayoutGraph layoutGraph) {
        StringBuffer stringBuffer;
        block2: {
            boolean bl = LayoutGraph.z;
            StringBuffer stringBuffer2 = new StringBuffer("Node Positions:\n");
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                stringBuffer = stringBuffer2.append(nodeCursor.node() + " " + layoutGraph.getLocation(nodeCursor.node()) + "\n");
                if (!bl) {
                    nodeCursor.next();
                    if (!bl) continue;
                }
                break block2;
            }
            stringBuffer = stringBuffer2;
        }
        return stringBuffer.toString();
    }

    public static void initDiagram(LayoutGraph layoutGraph) {
        block2: {
            boolean bl = LayoutGraph.z;
            NodeCursor nodeCursor = layoutGraph.nodes();
            while (nodeCursor.ok()) {
                layoutGraph.setLocation(nodeCursor.node(), new YPoint(0.0, 0.0));
                nodeCursor.next();
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            LayoutTool.resetPaths(layoutGraph);
        }
    }

    private static boolean b(YPoint yPoint, YDimension yDimension, YPoint yPoint2) {
        return yPoint2.x >= yPoint.x && yPoint2.y >= yPoint.y && yPoint2.x <= yPoint.x + yDimension.getWidth() && yPoint2.y <= yPoint.y + yDimension.getHeight();
    }

    private static YPoint b(YPoint yPoint, YDimension yDimension, YPoint yPoint2, YPoint yPoint3) {
        Point2D.Double double_ = LayoutTool.b(yPoint.x, yPoint.y, yDimension.getWidth(), yDimension.getHeight(), yPoint2.x, yPoint2.y, yPoint3.x, yPoint3.y, null);
        return new YPoint(double_.x, double_.y);
    }

    private static Point2D.Double b(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Point2D.Double double_) {
        if (double_ == null) {
            double_ = new Point2D.Double();
        }
        if (d6 >= d2 && d7 >= d3 && d6 <= d2 + d4 && d7 <= d3 + d5) {
            double d10 = d8 - d6;
            double d11 = d9 - d7;
            if (d10 == 0.0) {
                if (d11 < 0.0) {
                    double_.x = d6;
                    double_.y = d3;
                    return double_;
                }
                double_.x = d6;
                double_.y = d3 + d5;
                return double_;
            }
            if (d11 == 0.0) {
                if (d10 < 0.0) {
                    double_.x = d2;
                    double_.y = d7;
                    return double_;
                }
                double_.x = d2 + d4;
                double_.y = d7;
                return double_;
            }
            double d12 = d11 / d10;
            if (d10 > 0.0) {
                double d13 = d7 + d12 * (d2 + d4 - d6);
                if (d13 < d3) {
                    double_.x = d6 + (d3 - d7) / d12;
                    double_.y = d3;
                    return double_;
                }
                if (d13 <= d3 + d5) {
                    double_.x = d2 + d4;
                    double_.y = d13;
                    return double_;
                }
                double_.x = d6 + (d3 + d5 - d7) / d12;
                double_.y = d3 + d5;
                return double_;
            }
            double d14 = d7 + d12 * (d2 - d6);
            if (d14 < d3) {
                double_.x = d6 + (d3 - d7) / d12;
                double_.y = d3;
                return double_;
            }
            if (d14 <= d3 + d5) {
                double_.x = d2;
                double_.y = d14;
                return double_;
            }
            double_.x = d6 + (d3 + d5 - d7) / d12;
            double_.y = d3 + d5;
            return double_;
        }
        double_.x = d6;
        double_.y = d7;
        return double_;
    }

    private static YPoint b(YPoint yPoint) {
        return new YPoint(LayoutTool.b(yPoint.getX()), LayoutTool.b(yPoint.getY()));
    }

    private static YDimension b(YDimension yDimension) {
        return new YDimension(LayoutTool.b(yDimension.getWidth()), LayoutTool.b(yDimension.getHeight()));
    }

    private static double b(double d2) {
        return Math.floor(d2 + 0.5);
    }

    public static int arrangeRectangleRows(Rectangle2D[] rectangle2DArray, Rectangle2D rectangle2D, double d2) {
        return LayoutTool.arrangeRectangleRows(rectangle2DArray, rectangle2D, d2, 1);
    }

    /*
     * Unable to fully structure code
     */
    static void b(Rectangle2D[] var0, Rectangle2D var1_1, double var2_2, int[] var4_3) {
        block14: {
            block16: {
                block15: {
                    block13: {
                        var28_4 = LayoutGraph.z;
                        if (var0 == null || var0.length < 1) {
                            if (var1_1 != null) {
                                var1_1.setFrame(0.0, 0.0, 0.0, 0.0);
                            }
                            var4_3[1] = 0;
                            var4_3[0] = 0;
                        }
                        var5_5 = 0.0;
                        var7_6 = 0.0;
                        for (var9_7 = 0; var9_7 < var0.length; ++var9_7) {
                            var10_9 = var0[var9_7];
                            var5_5 = Math.max(var5_5, var10_9.getWidth());
                            v0 = Math.max(var7_6, var10_9.getHeight());
                            if (!var28_4) {
                                var7_6 = v0;
                                if (!var28_4) continue;
                            }
                            break block13;
                        }
                        v0 = var5_5 * var7_6 * (double)var0.length;
                    }
                    var9_8 = v0;
                    var11_10 = Math.sqrt(var9_8 / var2_2);
                    var13_11 = var9_8 / var11_10;
                    var15_12 = (int)Math.floor(var13_11 / var5_5);
                    var16_13 = (int)Math.ceil(var13_11 / var5_5);
                    var17_14 = (int)Math.ceil((double)var0.length / (double)var15_12);
                    if (var15_12 * var17_14 >= var16_13 * (var18_15 = (int)Math.ceil((double)var0.length / (double)var16_13))) break block15;
                    var19_16 = var15_12;
                    var20_17 = var17_14;
                    if (!var28_4) break block16;
                }
                var19_16 = var16_13;
                var20_17 = var18_15;
            }
            var21_18 = 0;
            var22_19 = 0;
            var23_20 = 0.0;
            var25_21 = 0.0;
            if (!(var5_5 > var7_6)) ** GOTO lbl49
            for (var27_22 = 0; var27_22 < var0.length; ++var27_22) {
                var0[var27_22].setFrame((double)var22_19 * var5_5, (double)var21_18 * var7_6, var0[var27_22].getWidth(), var0[var27_22].getHeight());
                var23_20 = Math.max(var23_20, var0[var27_22].getMaxX());
                var25_21 = Math.max(var25_21, var0[var27_22].getMaxY());
                ++var22_19;
                if (!var28_4) {
                    if (var22_19 < var19_16) continue;
                    ++var21_18;
                    var22_19 = 0;
                    if (!var28_4) continue;
                }
                break block14;
lbl49:
                // 4 sources

                for (var27_22 = 0; var27_22 < var0.length; ++var27_22) {
                    var0[var27_22].setFrame((double)var22_19 * var5_5, (double)var21_18 * var7_6, var0[var27_22].getWidth(), var0[var27_22].getHeight());
                    var23_20 = Math.max(var23_20, var0[var27_22].getMaxX());
                    var25_21 = Math.max(var25_21, var0[var27_22].getMaxY());
                    ++var21_18;
                    if (!var28_4) {
                        if (var21_18 < var20_17) continue;
                        ++var22_19;
                        var21_18 = 0;
                        if (!var28_4) continue;
                    }
                    break block14;
                }
            }
            if (var1_1 != null) {
                var1_1.setFrame(0.0, 0.0, var23_20, var25_21);
            }
            var4_3[0] = var20_17;
            var4_3[1] = var19_16;
        }
    }

    public static Dimension arrangeRectangleGrid(Rectangle2D[] rectangle2DArray, Rectangle2D rectangle2D, double d2) {
        int[] nArray = new int[2];
        LayoutTool.b(rectangle2DArray, rectangle2D, d2, nArray);
        return new Dimension(nArray[0], nArray[1]);
    }

    public static int arrangeRectangleMultiRows(Rectangle2D[] rectangle2DArray, Rectangle2D rectangle2D, double d2, double d3, boolean bl, byte by) {
        return LayoutTool.arrangeRectangleMultiRows(rectangle2DArray, rectangle2D, d2, d3, bl, by, 1);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static int arrangeRectangleMultiRows(Rectangle2D[] var0, Rectangle2D var1_1, double var2_2, double var4_3, boolean var6_4, byte var7_5, int var8_6) {
        block53: {
            block51: {
                block48: {
                    block50: {
                        block46: {
                            block57: {
                                block58: {
                                    block47: {
                                        block54: {
                                            block45: {
                                                var55_7 = LayoutGraph.z;
                                                var9_8 = var0.length;
                                                if (var0 == null || var9_8 < 1) {
                                                    if (var1_1 != null) {
                                                        var1_1.setFrame(0.0, 0.0, 0.0, 0.0);
                                                    }
                                                    return 0;
                                                }
                                                var10_9 = 0.0;
                                                var12_10 = 0.0;
                                                var14_11 = 0.0;
                                                var16_12 = 1.7976931348623157E308;
                                                var18_13 = new Rectangle2D[var9_8];
                                                for (var19_14 = 0; var19_14 < var9_8; ++var19_14) {
                                                    var20_16 = var0[var19_14];
                                                    var18_13[var19_14] = var20_16;
                                                    var21_17 = var20_16.getWidth();
                                                    var23_19 = var20_16.getHeight();
                                                    var10_9 += var21_17 * var23_19;
                                                    var12_10 = Math.max(var12_10, var21_17);
                                                    var14_11 = Math.max(var14_11, var23_19);
                                                    var16_12 = Math.min(var16_12, var21_17);
                                                    if (!var55_7) {
                                                        if (!var55_7) continue;
                                                    }
                                                    break block45;
                                                }
                                                Arrays.sort(var18_13, 0, var9_8, new Comparator(){

                                                    public int compare(Object object, Object object2) {
                                                        Rectangle2D rectangle2D = (Rectangle2D)object;
                                                        Rectangle2D rectangle2D2 = (Rectangle2D)object2;
                                                        int n2 = Comparators.compare(rectangle2D2.getHeight(), rectangle2D.getHeight());
                                                        if (n2 == 0) {
                                                            return Comparators.compare(rectangle2D2.getWidth(), rectangle2D.getWidth());
                                                        }
                                                        return n2;
                                                    }
                                                });
                                            }
                                            var19_15 /* !! */  = new double[var9_8];
                                            var20_16 = new double[var9_8];
                                            var21_18 = new double[var9_8];
                                            var22_21 /* !! */  = new double[var9_8];
                                            var23_20 = new double[2];
                                            var24_22 = 0.0;
                                            var26_23 = 0.0;
                                            var28_24 = 0.0;
                                            var30_25 = 0.0;
                                            var32_26 = 0;
                                            if (var7_5 != 2) break block54;
                                            var34_27 = 0;
                                            var35_30 = 0;
                                            while (var34_27 < var9_8) {
                                                block56: {
                                                    block55: {
                                                        var34_27 = LayoutTool.b(var23_20, var18_13, var19_15 /* !! */ , (double[])var20_16, new YDimension(var2_2, 0.0), 0.0, var24_22, var34_27, var8_6);
                                                        cfr_temp_0 = var23_20[0] - 0.0;
                                                        v0 = cfr_temp_0 == 0.0 ? 0 : (cfr_temp_0 > 0.0 ? 1 : -1);
                                                        if (var55_7) break block46;
                                                        if (v0 != false) break block55;
                                                        var36_32 = var18_13[var34_27];
                                                        var19_15 /* !! */ [var34_27] = 0.0;
                                                        var20_16[var34_27] = var24_22;
                                                        ++var34_27;
                                                        var24_22 += var36_32.getHeight();
                                                        if (!var55_7) break block56;
                                                    }
                                                    var26_23 = Math.max(var26_23, var23_20[0]);
                                                    var24_22 += var23_20[1];
                                                }
                                                ++var35_30;
                                                if (!var55_7) continue;
                                            }
                                            var36_32 = var21_18;
                                            var37_36 = var22_21 /* !! */ ;
                                            var21_18 = var19_15 /* !! */ ;
                                            var22_21 /* !! */  = (double[])var20_16;
                                            var19_15 /* !! */  = var36_32;
                                            var20_16 = var37_36;
                                            var28_24 = var26_23;
                                            var30_25 = var24_22;
                                            var32_26 = var35_30;
                                            if (!var55_7) break block57;
                                        }
                                        if (var7_5 != 1) ** GOTO lbl180
                                        v1 = var34_27 = var18_13[0].getHeight() > var4_3 ? 1 : 0;
                                        if (!var6_4 && var34_27 == 0) ** GOTO lbl-1000
                                        var35_31 = var12_10;
                                        var37_37 = 0;
                                        var38_38 = 0.0;
                                        if (var34_27 != 0) {
                                            for (var40_40 = 0; var40_40 < var9_8; ++var40_40) {
                                                var41_44 = var18_13[var40_40];
                                                cfr_temp_1 = var41_44.getHeight() - var4_3;
                                                v2 = cfr_temp_1 == 0.0 ? 0 : (cfr_temp_1 > 0.0 ? 1 : -1);
                                                if (!var55_7) {
                                                    if (v2 > 0) {
                                                        var19_15 /* !! */ [var40_40] = var38_38;
                                                        var20_16[var40_40] = 0.0;
                                                        var38_38 += var41_44.getWidth();
                                                        ++var37_37;
                                                        if (!var55_7) continue;
                                                    }
                                                    var38_38 += var41_44.getWidth();
                                                    if (!var55_7) break;
                                                    if (!var55_7) continue;
                                                }
                                                break block47;
                                            }
                                            var35_31 = var38_38;
                                        }
                                        v2 = var37_37;
                                    }
                                    if (v2 < var18_13.length) break block58;
                                    var21_18 = var19_15 /* !! */ ;
                                    var22_21 /* !! */  = (double[])var20_16;
                                    var32_26 = 1;
                                    if (!var55_7) break block57;
                                }
                                var40_41 = var38_38 == 0.0 ? 0.0 : var38_38 - var18_13[var37_37].getWidth();
                                var42_46 = 50;
                                block3: while (var42_46-- > 0) {
                                    var26_23 = 0.0;
                                    var24_22 = 0.0;
                                    var43_49 = var37_37;
                                    var44_52 = 0;
                                    var45_57 = 1.7976931348623157E308;
                                    if (!var55_7) {
                                        var47_62 = new YDimension(var35_31, var4_3);
                                        while (var43_49 < var9_8) {
                                            var43_49 = LayoutTool.b(var23_20, var18_13, var19_15 /* !! */ , (double[])var20_16, var47_62, var40_41, var24_22, var43_49, var8_6);
                                            var45_57 = Math.min(var45_57, var23_20[0]);
                                            var26_23 = Math.max(var26_23, var23_20[0]);
                                            var24_22 += var23_20[1];
                                            ++var44_52;
                                            if (var34_27 == 0) continue;
                                        }
                                        if (var43_49 != var9_8 || var24_22 > var4_3) {
                                            if (var45_57 < 1.7976931348623157E308) {
                                                var35_31 = Math.max(1.1 * var35_31, var45_57);
                                                if (!var55_7) continue;
                                            }
                                            var35_31 *= 1.1;
                                            if (!var55_7) continue;
                                        }
                                        var48_63 = var21_18;
                                        var49_64 /* !! */  = var22_21 /* !! */ ;
                                        var21_18 = var19_15 /* !! */ ;
                                        var22_21 /* !! */  = (double[])var20_16;
                                        var19_15 /* !! */  = (double[])var48_63;
                                        var20_16 = var49_64 /* !! */ ;
                                        var28_24 = var26_23;
                                        var30_25 = var24_22;
                                        var32_26 = var44_52;
                                        if (!var55_7) break;
                                    }
                                    break block48;
                                }
lbl-1000:
                                // 2 sources

                                {
                                    var35_30 = 50;
                                    var36_33 = var16_12;
                                    var38_38 = var12_10 * (double)var9_8;
                                    while (var35_30-- > 0) {
                                        block49: {
                                            var40_41 = (var38_38 + var36_33) / 2.0;
                                            var26_23 = 0.0;
                                            var24_22 = 0.0;
                                            var42_46 = 0;
                                            var43_49 = 0;
                                            if (var55_7) break block48;
                                            var44_54 = new YDimension(var40_41, 0.0);
                                            while (var42_46 < var9_8) {
                                                block60: {
                                                    block59: {
                                                        var42_46 = LayoutTool.b(var23_20, var18_13, var19_15 /* !! */ , (double[])var20_16, var44_54, 0.0, var24_22, var42_46, var8_6);
                                                        cfr_temp_2 = var23_20[0] - 0.0;
                                                        v3 = cfr_temp_2 == 0.0 ? 0 : (cfr_temp_2 > 0.0 ? 1 : -1);
                                                        if (var55_7) break block49;
                                                        if (v3 != false) break block59;
                                                        var45_59 = var18_13[var42_46];
                                                        var19_15 /* !! */ [var42_46] = 0.0;
                                                        var20_16[var42_46] = var24_22;
                                                        ++var42_46;
                                                        var24_22 += var45_59.getHeight();
                                                        if (!var55_7) break block60;
                                                    }
                                                    var26_23 = Math.max(var26_23, var23_20[0]);
                                                    var24_22 += var23_20[1];
                                                }
                                                ++var43_49;
                                                if (!var55_7) continue;
                                            }
                                            v3 = var24_22 == var4_3 ? 0 : (var24_22 < var4_3 ? -1 : 1);
                                        }
                                        if (v3 <= 0) {
                                            var45_60 = var21_18;
                                            var46_66 /* !! */  = var22_21 /* !! */ ;
                                            var21_18 = var19_15 /* !! */ ;
                                            var22_21 /* !! */  = (double[])var20_16;
                                            var19_15 /* !! */  = var45_60;
                                            var20_16 = var46_66 /* !! */ ;
                                            var30_25 = var24_22;
                                            var28_24 = var26_23;
                                            var32_26 = var43_49;
                                            if (var38_38 / var40_41 < 1.1) break block3;
                                            var38_38 = var40_41;
                                            if (!var55_7) continue;
                                        }
                                        var36_33 = var40_41;
                                        if (!var55_7) continue;
lbl180:
                                        // 2 sources

                                        var34_28 = var2_2 / var4_3;
                                        var38_38 = var36_34 = Math.max(var12_10, 0.9 * (var34_28 * Math.sqrt(var10_9 / var34_28)));
                                        var40_41 = 1.7976931348623157E308;
                                        var42_46 = 50;
                                        var43_49 = 0;
                                        while (var43_49 == 0 && var42_46-- > 0) {
                                            var26_23 = 0.0;
                                            var24_22 = 0.0;
                                            var44_55 = 0;
                                            var45_61 = 0;
                                            var46_67 = 1.7976931348623157E308;
                                            var48_63 = new YDimension(var38_38, 0.0);
                                            block8: while (true) {
                                                var44_55 = LayoutTool.b(var23_20, var18_13, var19_15 /* !! */ , (double[])var20_16, (YDimension)var48_63, 0.0, var24_22, var44_55, var8_6);
                                                var46_67 = Math.min(var46_67, var23_20[0]);
                                                var26_23 = Math.max(var26_23, var23_20[0]);
                                                var24_22 += var23_20[1];
                                                ++var45_61;
                                                v4 = var44_55;
                                                do {
                                                    if (v4 < var9_8) continue block8;
                                                    var49_65 = var26_23 / var24_22;
                                                    cfr_temp_3 = var49_65 - 0.0;
                                                    v4 = cfr_temp_3 == 0.0 ? 0 : (cfr_temp_3 > 0.0 ? 1 : -1);
                                                } while (var55_7);
                                                break;
                                            }
                                            if (v4 > 0 && (var51_68 = Math.max(var49_65, var34_28) / Math.min(var49_65, var34_28)) < var40_41) {
                                                var53_69 = var21_18;
                                                var54_70 /* !! */  = var22_21 /* !! */ ;
                                                var21_18 = var19_15 /* !! */ ;
                                                var22_21 /* !! */  = (double[])var20_16;
                                                var19_15 /* !! */  = var53_69;
                                                var20_16 = var54_70 /* !! */ ;
                                                var40_41 = var51_68;
                                                var28_24 = var26_23;
                                                var30_25 = var24_22;
                                                var32_26 = var45_61;
                                            }
                                            var43_49 = 1;
                                            if (!(var34_28 * var24_22 > var26_23)) continue;
                                            v5 = var45_61;
                                            v6 = 1;
                                            if (!var55_7) {
                                                if (v5 <= v6) continue;
                                                var43_49 = 0;
                                                if (var46_67 < 1.7976931348623157E308) {
                                                    var38_38 = Math.max(1.1 * var38_38, var46_67);
                                                    if (!var55_7) continue;
                                                }
                                                var38_38 *= 1.1;
                                                if (!var55_7) continue;
                                            }
                                            break block50;
                                        }
                                        break block3;
                                    }
                                    break block3;
                                }
                            }
                            v0 = (double)var6_4;
                        }
                        if (v0 == false) break block48;
                        v5 = var7_5;
                        v6 = 1;
                    }
                    if (v5 == v6) break block48;
                    var34_29 = var28_24;
                    var36_35 = var12_10;
                    var38_38 = (var34_29 + var36_35) / 2.0;
                    for (var40_42 = 0; var40_42 < 50; ++var40_42) {
                        block62: {
                            block52: {
                                block61: {
                                    cfr_temp_4 = var34_29 - var36_35 - var16_12;
                                    v7 = cfr_temp_4 == 0.0 ? 0 : (cfr_temp_4 > 0.0 ? 1 : -1);
                                    if (var55_7) break block51;
                                    if (v7 <= 0) break;
                                    var41_45 = 0;
                                    var24_22 = 0.0;
                                    var42_47 = new YDimension(var38_38, 0.0);
                                    while (var41_45 < var9_8) {
                                        var41_45 = LayoutTool.b(var23_20, var18_13, var19_15 /* !! */ , (double[])var20_16, var42_47, 0.0, var24_22, var41_45, var8_6);
                                        var24_22 += var23_20[1];
                                        if (!var55_7) {
                                            if (!var55_7) continue;
                                        }
                                        break block52;
                                    }
                                    if (!(var24_22 > var30_25)) break block61;
                                    var36_35 = var38_38;
                                    if (!var55_7) break block62;
                                }
                                var34_29 = var38_38;
                            }
                            var43_51 = var21_18;
                            var44_56 /* !! */  = var22_21 /* !! */ ;
                            var21_18 = var19_15 /* !! */ ;
                            var22_21 /* !! */  = (double[])var20_16;
                            var19_15 /* !! */  = var43_51;
                            var20_16 = var44_56 /* !! */ ;
                        }
                        var38_38 = (var34_29 + var36_35) / 2.0;
                        if (!var55_7) continue;
                    }
                }
                var34_29 = 0.0;
                var36_35 = 0.0;
                v7 = var38_39 = 0;
            }
            while (var38_39 < var9_8) {
                var39_71 = var18_13[var38_39];
                var40_43 = var21_18[var38_39];
                var42_48 = var22_21 /* !! */ [var38_39];
                var39_71.setFrame(var40_43, var42_48, var39_71.getWidth(), var39_71.getHeight());
                var34_29 = Math.max(var34_29, var40_43 + var39_71.getWidth());
                var36_35 = Math.max(var36_35, var42_48 + var39_71.getHeight());
                ++var38_39;
                if (!var55_7) {
                    if (!var55_7) continue;
                }
                break block53;
            }
            if (var1_1 != null) {
                var1_1.setFrame(0.0, 0.0, var34_29, var36_35);
            }
        }
        return var32_26;
    }

    /*
     * Unable to fully structure code
     */
    private static int b(double[] var0, Rectangle2D[] var1_1, double[] var2_2, double[] var3_3, YDimension var4_4, double var5_5, double var7_6, int var9_7, int var10_8) {
        block13: {
            var32_9 = LayoutGraph.z;
            var11_10 = var4_4.getWidth();
            if (var11_10 == 0.0) {
                return var9_7;
            }
            var13_11 = var9_7;
            var14_12 = var5_5;
            var16_13 = var7_6;
            var18_14 = var1_1[var9_7];
            var19_15 = var4_4.getHeight() == 0.0 ? var18_14.getHeight() : var4_4.getHeight();
            block0: while (true) lbl-1000:
            // 3 sources

            {
                v0 = var9_7;
                block1: while (v0 < var1_1.length) {
                    block16: {
                        block17: {
                            block15: {
                                var18_14 = var1_1[var9_7];
                                v1 = var11_10 - var18_14.getWidth();
                                v2 = 0.0;
                                if (var32_9) break block13;
                                if (!(v1 >= v2) || !(var18_14.getHeight() <= var19_15)) break block0;
                                if (var9_7 >= var1_1.length - 1 || !(var1_1[var9_7 + 1].getHeight() + var18_14.getHeight() <= var19_15)) break block15;
                                var21_16 = new double[2];
                                var22_18 = var9_7;
                                var9_7 = LayoutTool.b(var21_16, var1_1, var2_2, var3_3, new YDimension(var11_10, var18_14.getHeight()), var14_12, var16_13, var9_7, var10_8);
                                var23_19 = var21_16[1];
                                var25_20 = var21_16[0];
                                while (var9_7 < var1_1.length) {
                                    block14: {
                                        cfr_temp_0 = var23_19 + var1_1[var9_7].getHeight() - var19_15;
                                        v0 = cfr_temp_0 == 0.0 ? 0 : (cfr_temp_0 < 0.0 ? -1 : 1);
                                        if (var32_9) continue block1;
                                        if (v0 > 0) break;
                                        var27_21 = var16_13 + var23_19;
                                        if (var10_8 == 1) {
                                            var29_22 = 0.0;
                                            for (var31_23 = var22_18 - 1; var31_23 > var13_11; --var31_23) {
                                                cfr_temp_1 = var2_2[var31_23] - var14_12;
                                                v3 = cfr_temp_1 == 0.0 ? 0 : (cfr_temp_1 < 0.0 ? -1 : 1);
                                                if (!var32_9) {
                                                    if (v3 >= 0 || !(var3_3[var31_23] + var1_1[var31_23].getHeight() < var27_21)) continue;
                                                    var14_12 = var2_2[var31_23];
                                                    var29_22 += var1_1[var31_23].getWidth();
                                                    if (!var32_9) continue;
                                                }
                                                break block14;
                                            }
                                            var11_10 += var29_22;
                                        }
                                        var9_7 = LayoutTool.b(var21_16, var1_1, var2_2, var3_3, new YDimension(var11_10, var1_1[var9_7].getHeight()), var14_12, var27_21, var9_7, var10_8);
                                        cfr_temp_2 = var21_16[0] - 0.0;
                                        v3 = cfr_temp_2 == 0.0 ? 0 : (cfr_temp_2 > 0.0 ? 1 : -1);
                                    }
                                    if (v3 == false) break;
                                    var25_20 = Math.max(var25_20, var21_16[0]);
                                    var23_19 += var21_16[1];
                                    if (!var32_9) continue;
                                }
                                var11_10 -= var25_20;
                                if (!var32_9) ** GOTO lbl-1000
                            }
                            var2_2[var9_7] = var14_12;
                            var3_3[var9_7] = var16_13;
                            if (!(var18_14.getHeight() < var19_15)) break block16;
                            if (var10_8 != 2) break block17;
                            v4 = var9_7;
                            var3_3[v4] = var3_3[v4] + (var19_15 - var18_14.getHeight());
                            if (!var32_9) break block16;
                        }
                        if (var10_8 == 4) {
                            v5 = var9_7;
                            var3_3[v5] = var3_3[v5] + (var19_15 - var18_14.getHeight()) / 2.0;
                        }
                    }
                    ++var9_7;
                    var11_10 -= var18_14.getWidth();
                    var14_12 += var18_14.getWidth();
                    if (!var32_9) continue block0;
                }
                break;
            }
            v1 = var4_4.getWidth();
            v2 = var11_10;
        }
        var0[0] = var21_17 = v1 - v2;
        var0[1] = var21_17 == 0.0 ? 0.0 : var19_15;
        return var9_7;
    }

    /*
     * Unable to fully structure code
     */
    public static int arrangeRectangleRows(Rectangle2D[] var0, Rectangle2D var1_1, double var2_2, int var4_3) {
        block52: {
            block49: {
                block48: {
                    var50_4 = LayoutGraph.z;
                    if (var0 == null || var0.length < 1) {
                        if (var1_1 != null) {
                            var1_1.setFrame(0.0, 0.0, 0.0, 0.0);
                        }
                        return 0;
                    }
                    var5_6 = var7_5 = var0[0].getWidth();
                    var9_8 = var11_7 = var0[0].getHeight();
                    for (var13_9 = 1; var13_9 < var0.length; ++var13_9) {
                        var14_14 = var0[var13_9].getWidth();
                        var5_6 = Math.min(var5_6, var14_14);
                        var7_5 = Math.max(var7_5, var14_14);
                        var16_12 = var0[var13_9].getHeight();
                        var9_8 = Math.min(var9_8, var16_12);
                        var11_7 = Math.max(var11_7, var16_12);
                        if (!var50_4) {
                            if (!var50_4) continue;
                        }
                        break block48;
                    }
                    if (var9_8 / var11_7 > 0.95 && var5_6 / var7_5 > 0.95) {
                        var13_10 = new int[2];
                        LayoutTool.b(var0, var1_1, var2_2, var13_10);
                        return var13_10[0];
                    }
                }
                var13_11 = new YList();
                var14_14 = 0.0;
                var16_13 = false;
                for (var17_15 = 0; var17_15 < var0.length; ++var17_15) {
                    var18_17 = var0[var17_15];
                    var13_11.add(var0[var17_15]);
                    var14_14 += var18_17.getWidth() * var18_17.getHeight();
                    if (!var50_4) {
                        if (!var50_4) continue;
                    }
                    break block49;
                }
                var13_11.sort(new Comparator(){

                    public int compare(Object object, Object object2) {
                        Rectangle2D rectangle2D = (Rectangle2D)object;
                        Rectangle2D rectangle2D2 = (Rectangle2D)object2;
                        int n2 = Comparators.compare((int)rectangle2D2.getHeight(), (int)rectangle2D.getHeight());
                        if (n2 == 0) {
                            return Comparators.compare((int)rectangle2D2.getWidth(), (int)rectangle2D.getWidth());
                        }
                        return n2;
                    }
                });
            }
            var17_16 = 0.0;
            var19_18 = 0.0;
            var22_19 = Math.max(var7_5, 0.9 * (var2_2 * Math.sqrt(var14_14 / var2_2)));
            var24_20 = 0.0;
            var26_21 = 0.0;
            var28_22 = 0.0;
            var30_23 = 0.0;
            var32_24 = var22_19;
            var34_25 = 1.7976931348623157E308;
            var36_26 = null;
            var21_27 = new YList();
            var37_28 = false;
            var38_29 = 0;
            var39_30 = 0;
            block7: while (true) {
                block50: {
                    ++var38_29;
                    var40_31 = 1.7976931348623157E308;
                    var42_32 = new YList();
                    var21_27.add(var42_32);
                    var26_21 = 0.0;
                    var24_20 = 0.0;
                    var30_23 = 0.0;
                    for (var43_34 = var13_11.firstCell(); var43_34 != null; var43_34 = var43_34.succ()) {
                        block54: {
                            block53: {
                                var44_37 = (Rectangle2D)var43_34.getInfo();
                                cfr_temp_0 = var30_23 + var44_37.getWidth() - var32_24;
                                v0 = cfr_temp_0 == 0.0 ? 0 : (cfr_temp_0 > 0.0 ? 1 : -1);
                                if (var50_4) break block50;
                                if (v0 <= 0 || var42_32.size() <= 0) break block53;
                                var40_31 = Math.min(var30_23 + var44_37.getWidth(), var40_31);
                                var26_21 = Math.max(var26_21, var30_23);
                                var42_32 = new YList();
                                var42_32.add(var44_37);
                                var21_27.add(var42_32);
                                var30_23 = var44_37.getWidth();
                                if (!var50_4) break block54;
                            }
                            var42_32.add(var44_37);
                            var30_23 += var44_37.getWidth();
                        }
                        if (var42_32.size() == 1) {
                            var24_20 += ((Rectangle2D)var42_32.first()).getHeight();
                        }
                        var26_21 = Math.max(var26_21, var30_23);
                        if (!var50_4) continue;
                    }
                    v0 = var39_30 = var21_27.size();
                }
                if ((var43_33 = var26_21 / var24_20) > 0.0 && (var45_40 = Math.max(var43_33, var2_2) / Math.min(var43_33, var2_2)) < var34_25) {
                    var34_25 = var45_40;
                    var36_26 = var21_27;
                    var21_27 = new YList();
                }
                var37_28 = true;
                if (!(var2_2 * var24_20 > var26_21) || var39_30 <= 1) ** GOTO lbl100
                var37_28 = false;
                v1 = var21_27;
                do {
                    block56: {
                        block55: {
                            v1.clear();
                            if (!(var40_31 < 1.7976931348623157E308)) break block55;
                            var32_24 = Math.max(1.1 * var32_24, var40_31);
                            if (!var50_4) break block56;
                        }
                        var32_24 *= 1.1;
                    }
                    if (var38_29 > 50) {
                        var37_28 = true;
                    }
                    if (!var37_28) continue block7;
                    v1 = var36_26;
                } while (var50_4);
                break;
            }
            if (v1 != null) {
                var21_27 = var36_26;
            }
            var40_31 = 0.0;
            var42_32 = var21_27.cursor();
            while (var42_32.ok()) {
                var43_33 = 0.0;
                var45_41 = (YList)var42_32.current();
                v2 = var45_41.cursor();
                if (!var50_4) {
                    block51: {
                        var46_43 = v2;
                        while (var46_43.ok()) {
                            var47_45 = (Rectangle2D)var46_43.current();
                            var47_45.setFrame(var43_33, var40_31, var47_45.getWidth(), var47_45.getHeight());
                            var43_33 += var47_45.getWidth();
                            var46_43.next();
                            if (!var50_4) {
                                if (!var50_4) continue;
                            }
                            break block51;
                        }
                        var17_16 = Math.max(var17_16, var43_33);
                        var19_18 = Math.max(var19_18, var40_31 += LayoutTool.c(var45_41));
                        var42_32.next();
                    }
                    if (!var50_4) continue;
                }
                ** GOTO lbl148
            }
            block0 : switch (var4_3) {
                case 4: {
                    var42_32 = var21_27.cursor();
                    block12: while (var42_32.ok()) {
                        var43_35 = (YList)var42_32.current();
                        var44_38 = (var17_16 - LayoutTool.b(var43_35)) / 2.0;
                        v3 = var43_35;
                        if (var50_4) break block0;
                        for (var46_43 = (v282980).firstCell(); var46_43 != null; var46_43 = var46_43.succ()) {
                            var47_45 = (Rectangle2D)var46_43.getInfo();
                            var47_45.setFrame(var47_45.getX() + var44_38, var47_45.getY(), var47_45.getWidth(), var47_45.getHeight());
                            if (var50_4) continue block12;
                            if (!var50_4) continue;
                        }
                        var42_32.next();
                    }
                    ** GOTO lbl180
                }
                case 2: {
                    v2 = var42_32 = var21_27.cursor();
lbl148:
                    // 4 sources

                    block14: while (var42_32.ok()) {
                        var43_36 = (YList)var42_32.current();
                        var44_39 = var17_16 - LayoutTool.b(var43_36);
                        v3 = var43_36;
                        if (var50_4) break block0;
                        for (var46_43 = (v282980).firstCell(); var46_43 != null; var46_43 = var46_43.succ()) {
                            var47_45 = (Rectangle2D)var46_43.getInfo();
                            var47_45.setFrame(var47_45.getX() + var44_39, var47_45.getY(), var47_45.getWidth(), var47_45.getHeight());
                            if (var50_4) continue block14;
                            if (!var50_4) continue;
                        }
                        var42_32.next();
                    }
                    ** GOTO lbl180
                }
                case 3: {
                    var42_32 = var21_27.cursor();
                    while (var42_32.ok()) {
                        var43_33 = 0.0;
                        var45_42 = (YList)var42_32.current();
                        v4 = var45_42.size();
                        if (!var50_4) {
                            if (v4 > 1) {
                                var46_44 = (var17_16 - LayoutTool.b(var45_42)) / (double)(var45_42.size() - 1);
                                for (var48_46 = var45_42.firstCell(); var48_46 != null; var48_46 = var48_46.succ()) {
                                    var49_47 = (Rectangle2D)var48_46.getInfo();
                                    var49_47.setFrame(var43_33, var49_47.getY(), var49_47.getWidth(), var49_47.getHeight());
                                    var43_33 += var49_47.getWidth() + var46_44;
                                    if (!var50_4) {
                                        if (!var50_4) continue;
                                    }
                                    break;
                                }
                            } else {
                                var42_32.next();
                            }
                            if (!var50_4) continue;
                        }
                        break block52;
                    }
                }
lbl180:
                // 5 sources

                default: {
                    if (var1_1 != null) {
                        var1_1.setFrame(0.0, 0.0, var17_16, var19_18);
                    }
                    v3 = var21_27;
                }
            }
            v4 = v3.size();
        }
        return v4;
    }

    private static double c(YList yList) {
        double d2;
        block2: {
            boolean bl = LayoutGraph.z;
            double d3 = 0.0;
            for (ListCell listCell = yList.firstCell(); listCell != null; listCell = listCell.succ()) {
                d2 = Math.max(((Rectangle2D)listCell.getInfo()).getHeight(), d3);
                if (!bl) {
                    d3 = d2;
                    if (!bl) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }

    private static double b(YList yList) {
        double d2;
        block2: {
            boolean bl = LayoutGraph.z;
            double d3 = 0.0;
            for (ListCell listCell = yList.firstCell(); listCell != null; listCell = listCell.succ()) {
                d2 = d3 + ((Rectangle2D)listCell.getInfo()).getWidth();
                if (!bl) {
                    d3 = d2;
                    if (!bl) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }

    public static boolean pathIntersectsRect(LayoutGraph layoutGraph, Edge edge, Rectangle2D rectangle2D) {
        boolean bl;
        block3: {
            boolean bl2 = LayoutGraph.z;
            YList yList = layoutGraph.getPathList(edge);
            YPoint yPoint = (YPoint)yList.pop();
            while (!yList.isEmpty()) {
                YPoint yPoint2 = (YPoint)yList.pop();
                bl = rectangle2D.intersectsLine(yPoint.x, yPoint.y, yPoint2.x, yPoint2.y);
                if (!bl2) {
                    if (bl) {
                        return true;
                    }
                    yPoint = yPoint2;
                    if (!bl2) continue;
                }
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void applyGraphLayout(LayoutGraph var0, GraphLayout var1_1) {
        var8_2 = LayoutGraph.z;
        var2_3 = var0.nodes();
        while (var2_3.ok()) {
            var3_4 /* !! */  = var2_3.node();
            var4_5 = var1_1.getNodeLayout(var3_4 /* !! */ );
            if (var4_5 != null) {
                var5_6 = var0.getNodeLayout(var3_4 /* !! */ );
                var0.setSize(var3_4 /* !! */ , var4_5.getWidth(), var4_5.getHeight());
                var0.setLocation(var3_4 /* !! */ , var4_5.getX(), var4_5.getY());
            }
            var5_6 = var1_1.getNodeLabelLayout(var3_4 /* !! */ );
            var6_7 = var0.getNodeLabelLayout(var3_4 /* !! */ );
            if (var5_6 != null && var6_7 != null) {
                var7_10 = 0;
                block1: while (true) {
                    v0 = var7_10;
                    v1 = ((Object)var5_6).length;
                    while (v0 < v1) {
                        v0 = var7_10;
                        v1 = var6_7.length;
                        if (var8_2) continue;
                        if (v0 >= v1) break block1;
                        var6_7[var7_10].setModelParameter(var5_6[var7_10].getModelParameter());
                        var6_7[var7_10].getOrientedBox().adoptValues(var5_6[var7_10].getOrientedBox());
                        ++var7_10;
                        if (!var8_2) continue block1;
                    }
                    break;
                }
            }
            var2_3.next();
            if (!var8_2) continue;
        }
        var2_3 = var0.edges();
        block3: while (var2_3.ok()) {
            block11: {
                var3_4 /* !! */  = var2_3.edge();
                var4_5 = var1_1.getEdgeLayout(var3_4 /* !! */ );
                if (var4_5 == null) break block11;
                var5_6 = var0.getEdgeLayout(var3_4 /* !! */ );
                var5_6.setSourcePoint(var4_5.getSourcePoint());
                var5_6.setTargetPoint(var4_5.getTargetPoint());
                if (var5_6.pointCount() == var4_5.pointCount()) ** GOTO lbl43
                var5_6.clearPoints();
                for (var6_8 = 0; var6_8 < var4_5.pointCount(); ++var6_8) {
                    var7_12 = var4_5.getPoint(var6_8);
                    var5_6.addPoint(var7_12.getX(), var7_12.getY());
                    if (var8_2) continue block3;
                    if (!var8_2) continue;
lbl43:
                    // 3 sources

                    for (var6_9 = 0; var6_9 < var4_5.pointCount(); ++var6_9) {
                        var7_13 = var4_5.getPoint(var6_9);
                        var5_6.setPoint(var6_9, var7_13.getX(), var7_13.getY());
                        if (var8_2) continue block3;
                        if (!var8_2) continue;
                    }
                }
            }
            var5_6 = var1_1.getEdgeLabelLayout(var3_4 /* !! */ );
            var6_7 = var0.getEdgeLabelLayout(var3_4 /* !! */ );
            if (var5_6 != null && var6_7 != null) {
                var7_14 = 0;
                block6: while (true) {
                    v2 = var7_14;
                    v3 = ((Object)var5_6).length;
                    while (v2 < v3) {
                        v2 = var7_14;
                        v3 = var6_7.length;
                        if (var8_2) continue;
                        if (v2 >= v3) break block6;
                        var6_7[var7_14].setModelParameter(var5_6[var7_14].getModelParameter());
                        var6_7[var7_14].getOrientedBox().adoptValues(var5_6[var7_14].getOrientedBox());
                        ++var7_14;
                        if (!var8_2) continue block6;
                    }
                    break;
                }
            }
            var2_3.next();
            if (!var8_2) continue;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static void alignNodeLayouts(final LayoutGraph var0, NodeList var1_1, Node var2_2, final boolean var3_3, byte var4_4) {
        var21_5 = LayoutGraph.z;
        if (var1_1.size() <= 1) return;
        var5_6 = 1.7976931348623157E308;
        var7_7 = -1.7976931348623157E308;
        var9_8 = 0.0;
        var11_9 = var1_1.nodes();
        while (var11_9.ok()) {
            block28: {
                block27: {
                    var12_10 = var11_9.node();
                    var13_18 = var0.getNodeLayout(var12_10);
                    if (var21_5) ** GOTO lbl-1000
                    if (!var3_3) break block27;
                    var9_8 += var13_18.getHeight();
                    var5_6 = Math.min(var5_6, var13_18.getY());
                    var7_7 = Math.max(var7_7, var13_18.getY() + var13_18.getHeight());
                    if (!var21_5) break block28;
                }
                var9_8 += var13_18.getWidth();
                var5_6 = Math.min(var5_6, var13_18.getX());
                var7_7 = Math.max(var7_7, var13_18.getX() + var13_18.getWidth());
            }
            var11_9.next();
            if (!var21_5) continue;
        }
        if (var2_2 != null) {
            v0 = var0.getNodeLayout(var2_2);
        } else lbl-1000:
        // 2 sources

        {
            v0 = null;
        }
        var11_9 = v0;
        switch (var4_4) {
            case -1: {
                if (var3_3) {
                    var12_11 = var11_9 != null ? var11_9.getY() : var5_6;
                    var14_19 = var1_1.nodes();
                    do {
                        if (var14_19.ok() == false) return;
                        var15_21 = var14_19.node();
                        var16_22 = var0.getNodeLayout(var15_21);
                        var16_22.setLocation(var16_22.getX(), var12_11);
                        var14_19.next();
                    } while (!var21_5);
                }
                var12_12 = var11_9 != null ? var11_9.getX() : var5_6;
                var14_19 = var1_1.nodes();
                do {
                    if (var14_19.ok() == false) return;
                    var15_21 = var14_19.node();
                    var16_22 = var0.getNodeLayout(var15_21);
                    var16_22.setLocation(var12_12, var16_22.getY());
                    var14_19.next();
                } while (!var21_5);
            }
            case 0: {
                if (var3_3) {
                    var12_13 = var11_9 != null ? var11_9.getY() + var11_9.getHeight() * 0.5 : (var5_6 + var7_7) * 0.5;
                    var14_19 = var1_1.nodes();
                    do {
                        if (var14_19.ok() == false) return;
                        var15_21 = var14_19.node();
                        var16_22 = var0.getNodeLayout(var15_21);
                        var16_22.setLocation(var16_22.getX(), var12_13 - var16_22.getHeight() * 0.5);
                        var14_19.next();
                    } while (!var21_5);
                }
                var12_14 = var11_9 != null ? var11_9.getX() + var11_9.getWidth() * 0.5 : (var5_6 + var7_7) * 0.5;
                var14_19 = var1_1.nodes();
                do {
                    if (var14_19.ok() == false) return;
                    var15_21 = var14_19.node();
                    var16_22 = var0.getNodeLayout(var15_21);
                    var16_22.setLocation(var12_14 - var16_22.getWidth() * 0.5, var16_22.getY());
                    var14_19.next();
                } while (!var21_5);
            }
            case 1: {
                if (var3_3) {
                    var12_15 = var11_9 != null ? var11_9.getY() + var11_9.getHeight() : var7_7;
                    var14_19 = var1_1.nodes();
                    do {
                        if (var14_19.ok() == false) return;
                        var15_21 = var14_19.node();
                        var16_22 = var0.getNodeLayout(var15_21);
                        var16_22.setLocation(var16_22.getX(), var12_15 - var16_22.getHeight());
                        var14_19.next();
                    } while (!var21_5);
                }
                var12_16 = var11_9 != null ? var11_9.getX() + var11_9.getWidth() : var7_7;
                var14_19 = var1_1.nodes();
                do {
                    if (var14_19.ok() == false) return;
                    var15_21 = var14_19.node();
                    var16_22 = var0.getNodeLayout(var15_21);
                    var16_22.setLocation(var12_16 - var16_22.getWidth(), var16_22.getY());
                    var14_19.next();
                } while (!var21_5);
            }
            case 2: {
                var1_1.sort(new Comparator(){

                    public int compare(Object object, Object object2) {
                        NodeLayout nodeLayout = var0.getNodeLayout(object);
                        NodeLayout nodeLayout2 = var0.getNodeLayout(object2);
                        if (var3_3) {
                            return Comparators.compare(nodeLayout.getY() + nodeLayout.getHeight() * 0.5, nodeLayout2.getY() + nodeLayout2.getHeight() * 0.5);
                        }
                        return Comparators.compare(nodeLayout.getX() + nodeLayout.getWidth() * 0.5, nodeLayout2.getX() + nodeLayout2.getWidth() * 0.5);
                    }
                });
                var12_17 = var7_7 - var5_6 - var9_8;
                if (!(var12_17 <= 0.0)) ** GOTO lbl95
                var14_20 = 0.0;
                if (!var21_5) ** GOTO lbl96
lbl95:
                // 2 sources

                var14_20 = var12_17 / (double)(var1_1.size() - 1);
lbl96:
                // 2 sources

                if (var3_3) {
                    var16_23 = var0.getNodeLayout(var1_1.firstNode()).getY();
                    var18_25 = var1_1.nodes();
                    do {
                        if (var18_25.ok() == false) return;
                        var19_26 = var18_25.node();
                        var20_27 = var0.getNodeLayout(var19_26);
                        var20_27.setLocation(var20_27.getX(), var16_23);
                        var16_23 += var20_27.getHeight() + var14_20;
                        var18_25.next();
                    } while (!var21_5);
                }
                var16_24 = var0.getNodeLayout(var1_1.firstNode()).getX();
                var18_25 = var1_1.nodes();
                do {
                    if (var18_25.ok() == false) return;
                    var19_26 = var18_25.node();
                    var20_27 = var0.getNodeLayout(var19_26);
                    var20_27.setLocation(var16_24, var20_27.getY());
                    var16_24 += var20_27.getWidth() + var14_20;
                    var18_25.next();
                } while (!var21_5);
                return;
            }
        }
    }

    static boolean b(OrientedRectangle orientedRectangle) {
        return Double.isNaN(orientedRectangle.getAnchorX()) || Double.isNaN(orientedRectangle.getAnchorY()) || Double.isNaN(orientedRectangle.getWidth()) || Double.isNaN(orientedRectangle.getHeight()) || Double.isNaN(orientedRectangle.getUpX()) || Double.isNaN(orientedRectangle.getUpY());
    }

    public static boolean autoFlipBox(OrientedRectangle orientedRectangle) {
        double d2 = orientedRectangle.getUpY();
        if (d2 > 0.0) {
            YPoint yPoint = orientedRectangle.getCenter();
            orientedRectangle.setUpVector(-orientedRectangle.getUpX(), -d2);
            orientedRectangle.setCenter(yPoint);
            return true;
        }
        return false;
    }

    private LayoutTool() {
    }
}

