/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.geom.OrientedRectangle;
import y.geom.YPoint;
import y.layout.LabelLayoutConstants;
import y.layout.LabelLayoutKeys;
import y.layout.LayoutGraph;
import y.layout.PreferredPlacementDescriptor;

public class LabelLayoutData
implements LabelLayoutConstants,
LabelLayoutKeys {
    private OrientedRectangle dc;
    private PreferredPlacementDescriptor cc;

    public LabelLayoutData(double d2, double d3) {
        this(d2, d3, 0);
    }

    public LabelLayoutData(double d2, double d3, byte by) {
        this(new OrientedRectangle(0.0, 0.0, d2, d3), by);
    }

    public LabelLayoutData(OrientedRectangle orientedRectangle) {
        this(orientedRectangle, 0);
    }

    public LabelLayoutData(OrientedRectangle orientedRectangle, byte by) {
        this(orientedRectangle, PreferredPlacementDescriptor.newSharedInstance(by));
    }

    public LabelLayoutData(OrientedRectangle orientedRectangle, PreferredPlacementDescriptor preferredPlacementDescriptor) {
        this.setBounds(orientedRectangle);
        this.setPreferredPlacementDescriptor(preferredPlacementDescriptor);
    }

    public void setBounds(OrientedRectangle orientedRectangle) {
        this.dc = orientedRectangle;
    }

    public OrientedRectangle getBounds() {
        return this.dc;
    }

    public void setSize(double d2, double d3) {
        this.dc = new OrientedRectangle(this.dc.getAnchorX(), this.dc.getAnchorY(), d2, d3, this.dc.getUpX(), this.dc.getUpY());
    }

    public double getWidth() {
        return this.dc.getBoundingBox().getWidth();
    }

    public double getHeight() {
        return this.dc.getBoundingBox().getHeight();
    }

    public void setLocation(double d2, double d3) {
        YPoint yPoint = this.dc.getBoundingBox().getLocation();
        this.dc.moveBy(d2 - yPoint.x, d3 - yPoint.y);
    }

    public double getX() {
        return this.dc.getBoundingBox().getX();
    }

    public double getY() {
        return this.dc.getBoundingBox().getY();
    }

    public void setPreferredPlacement(byte by) {
        this.cc = PreferredPlacementDescriptor.newSharedInstance(by);
    }

    public byte getPreferredPlacement() {
        byte by = this.cc.getPlaceAlongEdge();
        byte by2 = this.cc.getSideOfEdge();
        return (byte)(by | by2);
    }

    public void setPreferredPlacementDescriptor(PreferredPlacementDescriptor preferredPlacementDescriptor) {
        if (preferredPlacementDescriptor == null) {
            throw new IllegalArgumentException("null");
        }
        this.cc = preferredPlacementDescriptor;
    }

    public PreferredPlacementDescriptor getPreferredPlacementDescriptor() {
        return this.cc;
    }

    public String toString() {
        return this.getBounds().toString() + " " + this.f();
    }

    private String f() {
        boolean bl = LayoutGraph.z;
        byte by = this.cc.getPlaceAlongEdge();
        if (by == 0) {
            return LabelLayoutData.d(by);
        }
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[]{1, 2, 4};
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if ((by & byArray[i2]) != byArray[i2]) continue;
            stringBuffer.append(string).append(LabelLayoutData.d(byArray[i2]));
            string = "|";
            if (!bl) continue;
        }
        return stringBuffer.toString();
    }

    private static String d(byte by) {
        switch (by) {
            case 0: {
                return "PLACE_ANYWHERE";
            }
            case 1: {
                return "PLACE_AT_SOURCE";
            }
            case 2: {
                return "PLACE_AT_TARGET";
            }
            case 4: {
                return "PLACE_AT_CENTER";
            }
        }
        return "ILLEGAL_PLACEMENT: " + by;
    }
}

