/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.YList;
import y.geom.OrientedRectangle;
import y.geom.YDimension;
import y.geom.YPoint;
import y.layout.LayoutTool;
import y.layout.NodeLabelCandidate;
import y.layout.NodeLabelLayout;
import y.layout.NodeLabelModel;
import y.layout.NodeLayout;

public class FreeNodeLabelModel
implements NodeLabelModel {
    public Object getDefaultParameter() {
        return new ModelParameter(-20.0, -20.0);
    }

    public OrientedRectangle getLabelPlacement(YDimension yDimension, NodeLayout nodeLayout, Object object) {
        ModelParameter modelParameter = (ModelParameter)object;
        double d2 = yDimension.getHeight();
        return new OrientedRectangle(modelParameter.b - d2 * modelParameter.d + nodeLayout.getX(), modelParameter.e - d2 * modelParameter.c + nodeLayout.getY(), yDimension.getWidth(), d2, modelParameter.d, modelParameter.c);
    }

    public YList getLabelCandidates(NodeLabelLayout nodeLabelLayout, NodeLayout nodeLayout) {
        YList yList = new YList();
        yList.add(new NodeLabelCandidate(nodeLabelLayout.getOrientedBox(), nodeLabelLayout.getModelParameter(), nodeLabelLayout, false));
        return yList;
    }

    public Object createModelParameter(OrientedRectangle orientedRectangle, NodeLayout nodeLayout) {
        if (LayoutTool.b(orientedRectangle)) {
            throw new IllegalArgumentException("Invalid label bounds: " + orientedRectangle);
        }
        double d2 = orientedRectangle.getUpX();
        double d3 = orientedRectangle.getUpY();
        double d4 = orientedRectangle.getHeight();
        return new ModelParameter(orientedRectangle.getAnchorX() + d4 * d2 - nodeLayout.getX(), orientedRectangle.getAnchorY() + d4 * d3 - nodeLayout.getY(), d2, d3);
    }

    public static class ModelParameter {
        double b;
        double e;
        double d;
        double c;

        public ModelParameter() {
            this(0.0, 0.0, 0.0, -1.0);
        }

        public ModelParameter(double d2, double d3) {
            this(d2, d3, 0.0, -1.0);
        }

        ModelParameter(double d2, double d3, double d4, double d5) {
            this.b = d2;
            this.e = d3;
            this.d = d4;
            this.c = d5;
        }

        public YPoint getPoint() {
            return new YPoint(this.b, this.e);
        }

        public void setPoint(double d2, double d3) {
            this.b = d2;
            this.e = d3;
        }
    }
}

