/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeList;
import y.base.NodeList;
import y.geom.YPoint;
import y.layout.AbstractLayoutStage;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.Layouter;

public class FixNodeLayoutStage
extends AbstractLayoutStage {
    public static final Object FIXED_NODE_DPKEY = "y.layout.FixNodeLayoutStage.FIXED_NODE_DPKEY";
    public static final byte FIX_POINT_POLICY_CENTER = 1;
    public static final byte FIX_POINT_POLICY_UPPER_LEFT = 2;
    public static final byte FIX_POINT_POLICY_UPPER_RIGHT = 3;
    public static final byte FIX_POINT_POLICY_LOWER_RIGHT = 4;
    public static final byte FIX_POINT_POLICY_LOWER_LEFT = 5;
    private boolean zkc;
    private boolean alc;
    private byte ykc = 1;

    public FixNodeLayoutStage() {
    }

    public FixNodeLayoutStage(Layouter layouter) {
        super(layouter);
    }

    public byte getFixPointPolicy() {
        return this.ykc;
    }

    public void setFixPointPolicy(byte by) {
        switch (by) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.ykc = by;
                if (!LayoutGraph.z) break;
            }
            default: {
                throw new IllegalArgumentException("Invalid policy: " + by);
            }
        }
    }

    public boolean isIncludingEdges() {
        return this.zkc;
    }

    public void setIncludingEdges(boolean bl) {
        this.zkc = bl;
    }

    public boolean isIncludingLabels() {
        return this.alc;
    }

    public void setIncludingLabels(boolean bl) {
        this.alc = bl;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        return this.canLayoutCore(layoutGraph);
    }

    public void doLayout(LayoutGraph layoutGraph) {
        block7: {
            DataProvider dataProvider;
            boolean bl;
            block6: {
                bl = LayoutGraph.z;
                dataProvider = layoutGraph.getDataProvider(FIXED_NODE_DPKEY);
                if (dataProvider != null) break block6;
                this.doLayoutCore(layoutGraph);
                if (!bl) break block7;
            }
            NodeList nodeList = new NodeList();
            Object object = layoutGraph.nodes();
            while (object.ok()) {
                if (dataProvider.getBool(object.node())) {
                    nodeList.add(object.node());
                }
                object.next();
                if (!bl) continue;
            }
            object = this.calculateFixPoint(layoutGraph, nodeList);
            this.doLayoutCore(layoutGraph);
            YPoint yPoint = this.calculateFixPoint(layoutGraph, nodeList);
            if (object != null && yPoint != null) {
                LayoutTool.moveSubgraph(layoutGraph, layoutGraph.nodes(), ((YPoint)object).getX() - yPoint.getX(), ((YPoint)object).getY() - yPoint.getY());
            }
        }
    }

    protected YPoint calculateFixPoint(LayoutGraph layoutGraph, NodeList nodeList) {
        return this.calculateFixPoint(this.calculateBounds(layoutGraph, nodeList));
    }

    protected YPoint calculateFixPoint(Rectangle2D rectangle2D) {
        if (rectangle2D == null || rectangle2D.getWidth() < 0.0 || rectangle2D.getHeight() < 0.0) {
            return null;
        }
        byte by = this.getFixPointPolicy();
        switch (by) {
            case 1: {
                return new YPoint(rectangle2D.getCenterX(), rectangle2D.getCenterY());
            }
            case 2: {
                return new YPoint(rectangle2D.getX(), rectangle2D.getY());
            }
            case 3: {
                return new YPoint(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY());
            }
            case 4: {
                return new YPoint(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
            }
            case 5: {
                return new YPoint(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight());
            }
        }
        throw new IllegalArgumentException("Invalid policy: " + by);
    }

    protected Rectangle2D calculateBounds(LayoutGraph layoutGraph, NodeList nodeList) {
        boolean bl = LayoutGraph.z;
        if (nodeList.isEmpty()) {
            return new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
        }
        EdgeList edgeList = new EdgeList();
        if (this.isIncludingEdges()) {
            HashSet hashSet = new HashSet(nodeList);
            HashSet<Edge> hashSet2 = new HashSet<Edge>();
            EdgeCursor edgeCursor = layoutGraph.edges();
            while (edgeCursor.ok()) {
                Edge edge = edgeCursor.edge();
                if (hashSet2.add(edge) && hashSet.contains(edge.source()) && hashSet.contains(edge.target())) {
                    edgeList.add(edge);
                }
                edgeCursor.next();
                if (!bl) continue;
            }
        }
        return LayoutTool.getBoundingBox(layoutGraph, nodeList.nodes(), edgeList.edges(), this.isIncludingLabels());
    }
}

