/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.YList;
import y.geom.OrientedRectangle;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.NodeLabelCandidate;
import y.layout.NodeLabelLayout;
import y.layout.NodeLabelLayoutImpl;
import y.layout.NodeLabelModel;
import y.layout.NodeLayout;
import y.layout.d;

public class DiscreteNodeLabelModel
implements NodeLabelModel {
    public static final int NORTH = 1;
    public static final int NORTH_WEST = 2;
    public static final int NORTH_EAST = 4;
    public static final int EAST = 8;
    public static final int WEST = 16;
    public static final int SOUTH = 32;
    public static final int SOUTH_WEST = 64;
    public static final int SOUTH_EAST = 128;
    public static final int CENTER = 256;
    public static final int BOTTOM = 512;
    public static final int TOP = 1024;
    public static final int LEFT = 2048;
    public static final int RIGHT = 4096;
    public static final int TOP_LEFT = 8192;
    public static final int TOP_RIGHT = 16384;
    public static final int BOTTOM_LEFT = 32768;
    public static final int BOTTOM_RIGHT = 65536;
    public static final int SANDWICH_MASK = 33;
    public static final int INTERNAL_MASK = 130816;
    public static final int SIDES_MASK = 57;
    public static final int CORNER_MASK = 198;
    public static final int EIGHT_POS_MASK = 255;
    static final Integer[] e = new Integer[]{new Integer(1), new Integer(2), new Integer(4), new Integer(8), new Integer(16), new Integer(32), new Integer(64), new Integer(128), new Integer(256), new Integer(512), new Integer(1024), new Integer(2048), new Integer(4096), new Integer(8192), new Integer(16384), new Integer(32768), new Integer(65536)};
    private static final Object d = new Integer(256);
    private static final Object c = new Integer(4);
    private static final Object f = new Integer(1);
    private static final Object g = new Integer(8);
    private double h;
    private final int b;

    public DiscreteNodeLabelModel() {
        this(130816, 4.0);
    }

    public DiscreteNodeLabelModel(int n2) {
        this(n2, 4.0);
    }

    public DiscreteNodeLabelModel(int n2, double d2) {
        this.h = d2;
        this.b = n2;
    }

    public int getCandidateMask() {
        return this.b;
    }

    public double getDistance() {
        return this.h;
    }

    public void setDistance(double d2) {
        this.h = d2;
    }

    public Object getDefaultParameter() {
        if ((this.b & 0x100) != 0) {
            return d;
        }
        if ((this.b & 4) != 0) {
            return c;
        }
        if ((this.b & 1) != 0) {
            return f;
        }
        if ((this.b & 8) != 0) {
            return g;
        }
        return d;
    }

    public boolean isParameterValid(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return (this.b & n2) != 0;
        }
        return false;
    }

    public OrientedRectangle getLabelPlacement(YDimension yDimension, NodeLayout nodeLayout, Object object) {
        return this.getLabelPlacement(yDimension, nodeLayout, (Integer)object);
    }

    public YList getLabelCandidates(NodeLabelLayout nodeLabelLayout, NodeLayout nodeLayout) {
        boolean bl = LayoutGraph.z;
        YList yList = new YList();
        YRectangle yRectangle = nodeLabelLayout.getBox();
        for (int i2 = 0; i2 < e.length; ++i2) {
            int n2 = e[i2];
            if ((this.b & n2) == 0) continue;
            boolean bl2 = false;
            switch (n2) {
                case 256: 
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: 
                case 8192: 
                case 16384: 
                case 32768: 
                case 65536: {
                    bl2 = true;
                }
            }
            OrientedRectangle orientedRectangle = this.getLabelPlacement((YDimension)yRectangle, nodeLayout, n2);
            yList.add(new NodeLabelCandidate(orientedRectangle, (Object)e[i2], nodeLabelLayout, bl2));
            if (!bl) continue;
        }
        return yList;
    }

    protected OrientedRectangle getLabelPlacement(YDimension yDimension, NodeLayout nodeLayout, int n2) {
        boolean bl = LayoutGraph.z;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        switch (n2) {
            case 256: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                if (!bl) break;
            }
            case 512: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) - this.getDistance();
                if (!bl) break;
            }
            case 1024: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() + this.getDistance();
                if (!bl) break;
            }
            case 2048: {
                d2 = nodeLayout.getX() + this.getDistance();
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                if (!bl) break;
            }
            case 4096: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) - this.getDistance();
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                if (!bl) break;
            }
            case 8192: {
                d2 = nodeLayout.getX() + this.getDistance();
                d3 = nodeLayout.getY() + this.getDistance();
                if (!bl) break;
            }
            case 16384: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) - this.getDistance();
                d3 = nodeLayout.getY() + this.getDistance();
                if (!bl) break;
            }
            case 32768: {
                d2 = nodeLayout.getX() + this.getDistance();
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) - this.getDistance();
                if (!bl) break;
            }
            case 65536: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) - this.getDistance();
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) - this.getDistance();
                if (!bl) break;
            }
            case 1: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() - yDimension.getHeight() - this.getDistance();
                if (!bl) break;
            }
            case 2: {
                d2 = nodeLayout.getX() - yDimension.getWidth() - this.getDistance();
                d3 = nodeLayout.getY() - yDimension.getHeight();
                if (!bl) break;
            }
            case 4: {
                d2 = nodeLayout.getX() + nodeLayout.getWidth() + this.getDistance();
                d3 = nodeLayout.getY() - yDimension.getHeight();
                if (!bl) break;
            }
            case 8: {
                d2 = nodeLayout.getX() + nodeLayout.getWidth() + this.getDistance();
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                if (!bl) break;
            }
            case 16: {
                d2 = nodeLayout.getX() - yDimension.getWidth() - this.getDistance();
                d3 = nodeLayout.getY() + (nodeLayout.getHeight() - yDimension.getHeight()) / 2.0;
                if (!bl) break;
            }
            case 32: {
                d2 = nodeLayout.getX() + (nodeLayout.getWidth() - yDimension.getWidth()) / 2.0;
                d3 = nodeLayout.getY() + nodeLayout.getHeight() + this.getDistance();
                if (!bl) break;
            }
            case 64: {
                d2 = nodeLayout.getX() - yDimension.getWidth() - this.getDistance();
                d3 = nodeLayout.getY() + nodeLayout.getHeight();
                if (!bl) break;
            }
            case 128: {
                d2 = nodeLayout.getX() + nodeLayout.getWidth() + this.getDistance();
                d3 = nodeLayout.getY() + nodeLayout.getHeight();
            }
        }
        return new OrientedRectangle(new YPoint(d2, d3 + yDimension.getHeight()), yDimension);
    }

    public Object createModelParameter(OrientedRectangle orientedRectangle, NodeLayout nodeLayout) {
        if (LayoutTool.b(orientedRectangle)) {
            throw new IllegalArgumentException("Invalid label bounds: " + orientedRectangle);
        }
        NodeLabelLayoutImpl nodeLabelLayoutImpl = new NodeLabelLayoutImpl();
        nodeLabelLayoutImpl.setOrientedBox(orientedRectangle);
        YList yList = this.getLabelCandidates(nodeLabelLayoutImpl, nodeLayout);
        if (yList.isEmpty()) {
            return this.getDefaultParameter();
        }
        YPoint yPoint = orientedRectangle.getCenter();
        return y.layout.d.b(yList, yPoint).getModelParameter();
    }
}

