/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import y.base.YList;
import y.geom.LineSegment;
import y.geom.OrientedRectangle;
import y.geom.YDimension;
import y.geom.YLineSegmentCursor;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.geom.YRectangle;
import y.geom.YVector;
import y.layout.EdgeLabelCandidate;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLabelLayoutImpl;
import y.layout.EdgeLabelModel;
import y.layout.EdgeLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutTool;
import y.layout.NodeLayout;
import y.layout.SliderEdgeLabelModel;
import y.layout.d;

public class DiscreteEdgeLabelModel
implements EdgeLabelModel {
    public static final int SHEAD = 1;
    public static final int HEAD = 2;
    public static final int THEAD = 4;
    public static final int STAIL = 8;
    public static final int TAIL = 16;
    public static final int TTAIL = 32;
    public static final int SCENTER = 64;
    public static final int CENTER = 128;
    public static final int TCENTER = 256;
    public static final int TWO_POS = 18;
    public static final int CENTERED = 128;
    public static final int SIX_POS = 63;
    public static final int THREE_CENTER = 448;
    private static final double db = 0.0;
    private static final double jb = 1.0;
    private static final double fb = 0.5;
    static final Integer[] eb = new Integer[]{new Integer(1), new Integer(2), new Integer(4), new Integer(8), new Integer(16), new Integer(32), new Integer(64), new Integer(128), new Integer(256)};
    private static final Object cb = new Integer(128);
    private static final Object ab = new Integer(64);
    private static final Object hb = new Integer(16);
    private static final Object ib = new Integer(8);
    private int z;
    private SliderEdgeLabelModel gb;
    private double bb;

    public DiscreteEdgeLabelModel() {
        this(63);
    }

    public DiscreteEdgeLabelModel(int n2) {
        block3: {
            block2: {
                this.z = 63;
                this.bb = 2.0;
                this.z = n2;
                if (n2 != 128 && n2 != 448) break block2;
                this.gb = new SliderEdgeLabelModel(0);
                if (!LayoutGraph.z) break block3;
            }
            this.gb = new SliderEdgeLabelModel(1);
        }
    }

    public int getCandidateMask() {
        return this.z;
    }

    public double getDistance() {
        return this.bb;
    }

    public void setDistance(double d2) {
        this.bb = d2;
    }

    public Object getDefaultParameter() {
        if ((this.z & 0x80) != 0) {
            return cb;
        }
        if ((this.z & 0x40) != 0) {
            return ab;
        }
        if ((this.z & 0x10) != 0) {
            return hb;
        }
        if ((this.z & 8) != 0) {
            return ib;
        }
        return cb;
    }

    public Object createModelParameter(OrientedRectangle orientedRectangle, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        if (LayoutTool.b(orientedRectangle)) {
            throw new IllegalArgumentException("Invalid label bounds: " + orientedRectangle);
        }
        EdgeLabelLayoutImpl edgeLabelLayoutImpl = new EdgeLabelLayoutImpl();
        edgeLabelLayoutImpl.setOrientedBox(orientedRectangle);
        YList yList = this.getLabelCandidates(edgeLabelLayoutImpl, edgeLayout, nodeLayout, nodeLayout2);
        if (yList.isEmpty()) {
            return this.getDefaultParameter();
        }
        return d.b(yList, orientedRectangle.getCenter()).getModelParameter();
    }

    public static Object createPositionParameter(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: 
            case 128: 
            case 256: {
                return new Integer(n2);
            }
        }
        throw new IllegalArgumentException("Invalid position: " + n2);
    }

    public boolean isParameterValid(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return (this.z & n2) != 0;
        }
        return false;
    }

    public OrientedRectangle getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, Object object) {
        int n2 = object != null ? ((Number)object).intValue() : ((Number)this.getDefaultParameter()).intValue();
        return this.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, n2);
    }

    public YList getLabelCandidates(EdgeLabelLayout edgeLabelLayout, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2) {
        boolean bl = LayoutGraph.z;
        YList yList = new YList();
        YDimension yDimension = edgeLabelLayout.getOrientedBox().getSize();
        for (int i2 = 0; i2 < eb.length; ++i2) {
            boolean bl2;
            int n2;
            block6: {
                block7: {
                    block5: {
                        n2 = eb[i2];
                        if ((this.z & n2) == 0) continue;
                        bl2 = false;
                        if (n2 != 128) break block5;
                        bl2 = true;
                        if (!bl) break block6;
                    }
                    if (n2 != 64) break block7;
                    bl2 = true;
                    if (!bl) break block6;
                }
                if (n2 == 256) {
                    bl2 = true;
                }
            }
            OrientedRectangle orientedRectangle = this.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, n2);
            yList.add(new EdgeLabelCandidate(orientedRectangle, (Object)eb[i2], edgeLabelLayout, bl2));
            if (!bl) continue;
        }
        return yList;
    }

    protected OrientedRectangle getLabelPlacement(YDimension yDimension, EdgeLayout edgeLayout, NodeLayout nodeLayout, NodeLayout nodeLayout2, int n2) {
        int n3;
        double d2;
        int n4;
        int n5;
        YPointPath yPointPath;
        boolean bl;
        block17: {
            bl = LayoutGraph.z;
            yPointPath = LayoutTool.getEdgeClippedOnBB(edgeLayout, nodeLayout, nodeLayout2, 0.0);
            boolean bl2 = false;
            n5 = 0;
            double d3 = 0.0;
            n4 = -1;
            YLineSegmentCursor yLineSegmentCursor = yPointPath.lineSegments();
            while (yLineSegmentCursor.ok()) {
                ++n4;
                LineSegment lineSegment = yLineSegmentCursor.lineSegment();
                d2 = lineSegment.length();
                n3 = d2 == d3 ? 0 : (d2 > d3 ? 1 : -1);
                if (!bl) {
                    if (n3 > 0) {
                        d3 = d2;
                        n5 = n4;
                    }
                    yLineSegmentCursor.next();
                    if (!bl) continue;
                }
                break block17;
            }
            n3 = 0;
        }
        int n6 = n3;
        byte by = 3;
        d2 = 0.0;
        switch (n2) {
            case 1: {
                by = 2;
                n6 = 0;
                d2 = 0.0;
                if (!bl) break;
            }
            case 2: {
                by = 2;
                n6 = n5;
                d2 = 0.5;
                if (!bl) break;
            }
            case 4: {
                by = 2;
                n6 = n4;
                d2 = 1.0;
                if (!bl) break;
            }
            case 64: {
                by = 0;
                n6 = 0;
                d2 = 0.0;
                if (!bl) break;
            }
            case 128: {
                by = 0;
                n6 = n5;
                d2 = 0.5;
                if (!bl) break;
            }
            case 256: {
                by = 0;
                n6 = n4;
                d2 = 1.0;
                if (!bl) break;
            }
            case 8: {
                by = 1;
                n6 = 0;
                d2 = 0.0;
                if (!bl) break;
            }
            case 16: {
                by = 1;
                n6 = n5;
                d2 = 0.5;
                if (!bl) break;
            }
            case 32: {
                by = 1;
                n6 = n4;
                d2 = 1.0;
            }
        }
        LineSegment lineSegment = yPointPath.getLineSegment(n6);
        OrientedRectangle orientedRectangle = new OrientedRectangle(new YPoint(0.0, 0.0), yDimension);
        YRectangle yRectangle = orientedRectangle.getBoundingBox();
        if (lineSegment == null) {
            orientedRectangle.setCenter(nodeLayout.getX() + yRectangle.width * 0.5, nodeLayout.getY() - yRectangle.height * 0.5);
            return orientedRectangle;
        }
        YPoint yPoint = lineSegment.getFirstEndPoint();
        YPoint yPoint2 = lineSegment.getSecondEndPoint();
        double d4 = yPoint2.getX() - yPoint.getX();
        double d5 = yPoint2.getY() - yPoint.getY();
        if (d4 == 0.0 && d5 == 0.0) {
            d4 = nodeLayout.getX() + nodeLayout.getWidth() * 0.5 + edgeLayout.getSourcePoint().x - (nodeLayout2.getX() + nodeLayout2.getWidth() * 0.5 + edgeLayout.getTargetPoint().x);
            d5 = nodeLayout.getY() + nodeLayout.getHeight() * 0.5 + edgeLayout.getSourcePoint().y - (nodeLayout2.getY() + nodeLayout2.getHeight() * 0.5 + edgeLayout.getTargetPoint().y);
            if (d4 == 0.0 && d5 == 0.0) {
                d4 = 1.0E-6;
            }
        }
        YVector yVector = this.gb.getOffsetVec(d4, d5, yRectangle.getWidth(), yRectangle.getHeight(), by);
        yVector.norm();
        yVector.scale(this.bb);
        SliderEdgeLabelModel.ModelParameter modelParameter = new SliderEdgeLabelModel.ModelParameter(n6, d2, yVector, by, d2);
        return this.gb.getLabelPlacement(yDimension, edgeLayout, nodeLayout, nodeLayout2, modelParameter);
    }
}

