/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.util.HashMap;
import java.util.Map;
import y.base.Edge;
import y.base.EdgeMap;
import y.base.Node;
import y.base.NodeMap;
import y.base.YCursor;
import y.layout.DefaultEdgeLayout;
import y.layout.DefaultNodeLayout;
import y.layout.EdgeLabelLayout;
import y.layout.EdgeLayout;
import y.layout.LabelLayoutFactory;
import y.layout.LayoutGraph;
import y.layout.LayoutGraphCopyFactory;
import y.layout.NodeLabelLayout;
import y.layout.NodeLayout;
import y.util.GraphCopier;

public class DefaultLayoutGraph
extends LayoutGraph {
    private NodeMap ad;
    private EdgeMap bd;
    protected NodeMap nodeLabelMap;
    protected EdgeMap edgeLabelMap;
    protected Map nodeLabelFeatureMap = new HashMap();
    protected Map edgeLabelFeatureMap = new HashMap();

    public DefaultLayoutGraph() {
        this.ad = this.createNodeMap();
        this.nodeLabelMap = this.createNodeMap();
        this.bd = this.createEdgeMap();
        this.edgeLabelMap = this.createEdgeMap();
    }

    public DefaultLayoutGraph(LayoutGraph layoutGraph) {
        this(layoutGraph, (YCursor)layoutGraph.nodes());
    }

    public DefaultLayoutGraph(LayoutGraph layoutGraph, YCursor yCursor) {
        super(layoutGraph, yCursor);
        this.ad = this.createNodeMap();
        this.bd = this.createEdgeMap();
        this.nodeLabelMap = this.createNodeMap();
        this.edgeLabelMap = this.createEdgeMap();
    }

    protected GraphCopier.CopyFactory createGraphCopyFactory() {
        return new LayoutGraphCopyFactory.HierarchicGraphCopyFactory();
    }

    public DefaultLayoutGraph(DefaultLayoutGraph defaultLayoutGraph, YCursor yCursor) {
        this((LayoutGraph)defaultLayoutGraph, yCursor);
    }

    public NodeLayout getLayout(Node node) {
        NodeLayout nodeLayout = (NodeLayout)this.ad.get(node);
        if (nodeLayout == null) {
            nodeLayout = this.createNodeLayout();
            this.ad.set(node, nodeLayout);
        }
        return nodeLayout;
    }

    public void setLayout(Node node, NodeLayout nodeLayout) {
        this.ad.set(node, nodeLayout);
    }

    public void setLayout(Edge edge, EdgeLayout edgeLayout) {
        this.bd.set(edge, edgeLayout);
    }

    public EdgeLayout getLayout(Edge edge) {
        EdgeLayout edgeLayout = (EdgeLayout)this.bd.get(edge);
        if (edgeLayout == null) {
            edgeLayout = this.createEdgeLayout();
            this.bd.set(edge, edgeLayout);
        }
        return edgeLayout;
    }

    public NodeLabelLayout[] getLabelLayout(Node node) {
        NodeLabelLayout[] nodeLabelLayoutArray = (NodeLabelLayout[])this.nodeLabelMap.get(node);
        if (nodeLabelLayoutArray == null) {
            nodeLabelLayoutArray = new NodeLabelLayout[]{};
            this.nodeLabelMap.set(node, nodeLabelLayoutArray);
        }
        return nodeLabelLayoutArray;
    }

    public void setLabelLayout(Node node, NodeLabelLayout nodeLabelLayout) {
        NodeLabelLayout[] nodeLabelLayoutArray = new NodeLabelLayout[]{nodeLabelLayout};
        this.setLabelLayout(node, nodeLabelLayoutArray);
    }

    public void setLabelLayout(Node node, NodeLabelLayout[] nodeLabelLayoutArray) {
        boolean bl = LayoutGraph.z;
        Object object = this.nodeLabelMap.get(node);
        if (object instanceof NodeLabelLayout[]) {
            NodeLabelLayout[] nodeLabelLayoutArray2 = (NodeLabelLayout[])object;
            for (int i2 = 0; i2 < nodeLabelLayoutArray2.length; ++i2) {
                NodeLabelLayout nodeLabelLayout = nodeLabelLayoutArray2[i2];
                this.nodeLabelFeatureMap.remove(nodeLabelLayout);
                if (!bl) {
                    if (!bl) continue;
                }
                break;
            }
        } else {
            this.nodeLabelMap.set(node, nodeLabelLayoutArray);
        }
        for (int i3 = 0; i3 < nodeLabelLayoutArray.length; ++i3) {
            NodeLabelLayout nodeLabelLayout = nodeLabelLayoutArray[i3];
            this.nodeLabelFeatureMap.put(nodeLabelLayout, node);
            if (!bl) continue;
        }
    }

    public void setLabelLayout(Edge edge, EdgeLabelLayout[] edgeLabelLayoutArray) {
        boolean bl = LayoutGraph.z;
        Object object = this.edgeLabelMap.get(edge);
        if (object instanceof EdgeLabelLayout[]) {
            EdgeLabelLayout[] edgeLabelLayoutArray2 = (EdgeLabelLayout[])object;
            for (int i2 = 0; i2 < edgeLabelLayoutArray2.length; ++i2) {
                EdgeLabelLayout edgeLabelLayout = edgeLabelLayoutArray2[i2];
                this.edgeLabelFeatureMap.remove(edgeLabelLayout);
                if (!bl) {
                    if (!bl) continue;
                }
                break;
            }
        } else {
            this.edgeLabelMap.set(edge, edgeLabelLayoutArray);
        }
        for (int i3 = 0; i3 < edgeLabelLayoutArray.length; ++i3) {
            this.edgeLabelFeatureMap.put(edgeLabelLayoutArray[i3], edge);
            if (!bl) continue;
        }
    }

    public EdgeLabelLayout[] getLabelLayout(Edge edge) {
        EdgeLabelLayout[] edgeLabelLayoutArray = (EdgeLabelLayout[])this.edgeLabelMap.get(edge);
        if (edgeLabelLayoutArray == null) {
            edgeLabelLayoutArray = new EdgeLabelLayout[]{};
            this.edgeLabelMap.set(edge, edgeLabelLayoutArray);
        }
        return edgeLabelLayoutArray;
    }

    public Node getFeature(NodeLabelLayout nodeLabelLayout) {
        return (Node)this.nodeLabelFeatureMap.get(nodeLabelLayout);
    }

    public Edge getFeature(EdgeLabelLayout edgeLabelLayout) {
        return (Edge)this.edgeLabelFeatureMap.get(edgeLabelLayout);
    }

    protected EdgeLayout createEdgeLayout() {
        return new DefaultEdgeLayout();
    }

    protected NodeLayout createNodeLayout() {
        return new DefaultNodeLayout();
    }

    protected LabelLayoutFactory createLabelFactory() {
        return new _b();
    }

    private class _b
    extends LayoutGraph._b {
        private _b() {
        }

        public LayoutGraph getGraph() {
            return DefaultLayoutGraph.this;
        }

        public void addLabelLayout(Node node, NodeLabelLayout nodeLabelLayout) {
            LayoutGraph layoutGraph = this.getGraph();
            if (this.d(layoutGraph, nodeLabelLayout)) {
                throw new IllegalArgumentException("NodeLabelLayout already added!");
            }
            NodeLabelLayout[] nodeLabelLayoutArray = this.b(layoutGraph, node);
            if (nodeLabelLayoutArray == null) {
                nodeLabelLayoutArray = new NodeLabelLayout[]{};
            }
            NodeLabelLayout[] nodeLabelLayoutArray2 = new NodeLabelLayout[nodeLabelLayoutArray.length + 1];
            this.b(layoutGraph, node, nodeLabelLayoutArray2);
            System.arraycopy(nodeLabelLayoutArray, 0, nodeLabelLayoutArray2, 0, nodeLabelLayoutArray.length);
            nodeLabelLayoutArray2[nodeLabelLayoutArray.length] = nodeLabelLayout;
            this.c(layoutGraph, node, nodeLabelLayout);
        }

        public void addLabelLayout(Edge edge, EdgeLabelLayout edgeLabelLayout) {
            LayoutGraph layoutGraph = this.getGraph();
            if (this.d(layoutGraph, edgeLabelLayout)) {
                throw new IllegalArgumentException("EdgeLabelLayout already added!");
            }
            EdgeLabelLayout[] edgeLabelLayoutArray = this.b(layoutGraph, edge);
            if (edgeLabelLayoutArray == null) {
                edgeLabelLayoutArray = new EdgeLabelLayout[]{};
            }
            EdgeLabelLayout[] edgeLabelLayoutArray2 = new EdgeLabelLayout[edgeLabelLayoutArray.length + 1];
            this.b(layoutGraph, edge, edgeLabelLayoutArray2);
            System.arraycopy(edgeLabelLayoutArray, 0, edgeLabelLayoutArray2, 0, edgeLabelLayoutArray.length);
            edgeLabelLayoutArray2[edgeLabelLayoutArray.length] = edgeLabelLayout;
            this.c(layoutGraph, edge, edgeLabelLayout);
        }

        private void c(LayoutGraph layoutGraph, Node node, NodeLabelLayout nodeLabelLayout) {
            ((DefaultLayoutGraph)layoutGraph).nodeLabelFeatureMap.put(nodeLabelLayout, node);
        }

        private boolean d(LayoutGraph layoutGraph, NodeLabelLayout nodeLabelLayout) {
            return ((DefaultLayoutGraph)layoutGraph).nodeLabelFeatureMap.containsKey(nodeLabelLayout);
        }

        private void c(LayoutGraph layoutGraph, Edge edge, EdgeLabelLayout edgeLabelLayout) {
            ((DefaultLayoutGraph)layoutGraph).edgeLabelFeatureMap.put(edgeLabelLayout, edge);
        }

        private boolean d(LayoutGraph layoutGraph, EdgeLabelLayout edgeLabelLayout) {
            return ((DefaultLayoutGraph)layoutGraph).edgeLabelFeatureMap.containsKey(edgeLabelLayout);
        }

        void b(LayoutGraph layoutGraph, Node node, NodeLabelLayout[] nodeLabelLayoutArray) {
            ((DefaultLayoutGraph)layoutGraph).nodeLabelMap.set(node, nodeLabelLayoutArray);
        }

        NodeLabelLayout[] b(LayoutGraph layoutGraph, Node node) {
            return (NodeLabelLayout[])((DefaultLayoutGraph)layoutGraph).nodeLabelMap.get(node);
        }

        void b(LayoutGraph layoutGraph, NodeLabelLayout nodeLabelLayout) {
            ((DefaultLayoutGraph)layoutGraph).nodeLabelFeatureMap.remove(nodeLabelLayout);
        }

        void b(LayoutGraph layoutGraph, Edge edge, EdgeLabelLayout[] edgeLabelLayoutArray) {
            ((DefaultLayoutGraph)layoutGraph).edgeLabelMap.set(edge, edgeLabelLayoutArray);
        }

        EdgeLabelLayout[] b(LayoutGraph layoutGraph, Edge edge) {
            return (EdgeLabelLayout[])((DefaultLayoutGraph)layoutGraph).edgeLabelMap.get(edge);
        }

        void b(LayoutGraph layoutGraph, EdgeLabelLayout edgeLabelLayout) {
            ((DefaultLayoutGraph)layoutGraph).edgeLabelFeatureMap.remove(edgeLabelLayout);
        }
    }
}

