/*
 * Decompiled with CFR 0.152.
 */
package y.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import y.base.DataProvider;
import y.base.Graph;
import y.base.GraphInterface;
import y.layout.BufferedLayouter;
import y.layout.ComponentLayouter;
import y.layout.GraphLayout;
import y.layout.LayoutGraph;
import y.layout.LayoutStage;
import y.layout.Layouter;
import y.layout.NodeLayout;
import y.layout.OrientationLayouter;
import y.layout.ParallelEdgeLayouter;
import y.layout.SelfLoopLayouter;
import y.layout.SubgraphLayouter;
import y.layout.grouping.GroupNodeHider;
import y.layout.grouping.GroupingKeys;
import y.layout.labeling.GreedyMISLabeling;
import y.util.DataProviders;

public abstract class CanonicMultiStageLayouter
implements Layouter {
    private static final String km = "y.layout.CANONIC_MULTI_STAGE_LAYOUTER_NODE_SIZE_CHECKED_DPKEY";
    private LayoutStage hm;
    private LayoutStage pm;
    private LayoutStage qm;
    private LayoutStage mm;
    private LayoutStage tm;
    private LayoutStage om;
    private LayoutStage lm;
    boolean vm = true;
    boolean rm = true;
    boolean wm = true;
    boolean sm = false;
    boolean jm = true;
    boolean im = false;
    boolean um = true;
    List nm = new ArrayList(5);
    List gm = new ArrayList(5);

    public CanonicMultiStageLayouter() {
        this.hm = new SelfLoopLayouter();
        this.pm = new ParallelEdgeLayouter();
        this.qm = new ComponentLayouter();
        this.mm = new SubgraphLayouter();
        this.tm = new OrientationLayouter();
        this.om = new GreedyMISLabeling();
        this.lm = new GroupNodeHider();
    }

    protected abstract void doLayoutCore(LayoutGraph var1);

    protected abstract boolean canLayoutCore(LayoutGraph var1);

    private void m(LayoutGraph layoutGraph) {
        this.b(layoutGraph, layoutGraph);
    }

    private void b(GraphInterface graphInterface, GraphLayout graphLayout) {
        boolean bl = LayoutGraph.z;
        DataProvider dataProvider = graphInterface.getDataProvider(GroupingKeys.GROUP_DPKEY);
        if (dataProvider == null) {
            dataProvider = DataProviders.createConstantDataProvider(Boolean.FALSE);
        }
        Iterator iterator = graphInterface.nodeObjects();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!dataProvider.getBool(e2)) {
                this.checkNodeSize(graphLayout, e2);
                if (!bl) continue;
            }
            this.checkGroupNodeSize(graphLayout, e2);
            if (!bl) continue;
        }
    }

    protected void checkNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    protected void checkGroupNodeSize(GraphLayout graphLayout, Object object) throws IllegalArgumentException {
        NodeLayout nodeLayout = graphLayout.getNodeLayout(object);
        if (nodeLayout.getWidth() == 0.0 || nodeLayout.getHeight() == 0.0) {
            throw new IllegalArgumentException("Graph contains group nodes with zero width/height. Please enlarge those nodes manually or by using LayoutStage y.layout.MinNodeSizeStage.");
        }
    }

    public void prependStage(LayoutStage layoutStage) {
        this.nm.add(layoutStage);
    }

    public void appendStage(LayoutStage layoutStage) {
        this.gm.add(layoutStage);
    }

    public void removeStage(LayoutStage layoutStage) {
        int n2 = this.nm.indexOf(layoutStage);
        if (n2 >= 0) {
            this.nm.remove(n2);
        }
        if ((n2 = this.gm.indexOf(layoutStage)) >= 0) {
            this.gm.remove(n2);
        }
    }

    public LayoutStage getLabelLayouter() {
        return this.om;
    }

    public void setLabelLayouter(LayoutStage layoutStage) {
        this.om = layoutStage;
    }

    public LayoutStage getSelfLoopLayouter() {
        return this.hm;
    }

    public void setSelfLoopLayouter(LayoutStage layoutStage) {
        this.hm = layoutStage;
    }

    public LayoutStage getParallelEdgeLayouter() {
        return this.pm;
    }

    public void setParallelEdgeLayouter(LayoutStage layoutStage) {
        this.pm = layoutStage;
    }

    public LayoutStage getComponentLayouter() {
        return this.qm;
    }

    public void setComponentLayouter(LayoutStage layoutStage) {
        this.qm = layoutStage;
    }

    public LayoutStage getSubgraphLayouter() {
        return this.mm;
    }

    public void setSubgraphLayouter(LayoutStage layoutStage) {
        this.mm = layoutStage;
    }

    public LayoutStage getGroupNodeHider() {
        return this.lm;
    }

    public void setGroupNodeHider(LayoutStage layoutStage) {
        this.lm = layoutStage;
    }

    public LayoutStage getOrientationLayouter() {
        return this.tm;
    }

    public void setOrientationLayouter(LayoutStage layoutStage) {
        this.tm = layoutStage;
    }

    public void setOrientationLayouterEnabled(boolean bl) {
        this.jm = bl;
    }

    public void setLayoutOrientation(byte by) {
        if (this.tm instanceof OrientationLayouter) {
            ((OrientationLayouter)this.tm).setOrientation(by);
        }
    }

    public byte getLayoutOrientation() {
        if (this.tm instanceof OrientationLayouter) {
            return ((OrientationLayouter)this.tm).getOrientation();
        }
        return 0;
    }

    public boolean isOrientationLayouterEnabled() {
        return this.jm;
    }

    public void setSelfLoopLayouterEnabled(boolean bl) {
        this.rm = bl;
    }

    public boolean isSelfLoopLayouterEnabled() {
        return this.rm;
    }

    public void setLabelLayouterEnabled(boolean bl) {
        this.im = bl;
    }

    public boolean isLabelLayouterEnabled() {
        return this.im;
    }

    public boolean isGroupNodeHidingEnabled() {
        return this.um;
    }

    public void setGroupNodeHidingEnabled(boolean bl) {
        this.um = bl;
    }

    public void setComponentLayouterEnabled(boolean bl) {
        this.wm = bl;
    }

    public boolean isComponentLayouterEnabled() {
        return this.wm;
    }

    public void setParallelEdgeLayouterEnabled(boolean bl) {
        this.vm = bl;
    }

    public boolean isParallelEdgeLayouterEnabled() {
        return this.vm;
    }

    public void setSubgraphLayouterEnabled(boolean bl) {
        this.sm = bl;
    }

    public boolean isSubgraphLayouterEnabled() {
        return this.sm;
    }

    public void enableOnlyCore() {
        this.sm = false;
        this.vm = false;
        this.im = false;
        this.rm = false;
        this.wm = false;
        this.jm = false;
        this.um = false;
    }

    private Layouter oc() {
        Layouter layouter;
        block12: {
            LayoutStage layoutStage;
            int n2;
            Layouter layouter2;
            boolean bl;
            block11: {
                bl = LayoutGraph.z;
                layouter2 = new _b();
                for (n2 = this.gm.size() - 1; n2 >= 0; --n2) {
                    layoutStage = (LayoutStage)this.gm.get(n2);
                    layoutStage.setCoreLayouter(layouter2);
                    layouter2 = layoutStage;
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block11;
                }
                if (this.vm) {
                    this.pm.setCoreLayouter(layouter2);
                    layouter2 = this.pm;
                }
            }
            if (this.rm) {
                this.hm.setCoreLayouter(layouter2);
                layouter2 = this.hm;
            }
            if (this.jm) {
                this.tm.setCoreLayouter(layouter2);
                layouter2 = this.tm;
            }
            if (this.im) {
                this.om.setCoreLayouter(layouter2);
                layouter2 = this.om;
            }
            if (this.wm) {
                this.qm.setCoreLayouter(layouter2);
                layouter2 = this.qm;
            }
            if (this.sm) {
                this.mm.setCoreLayouter(layouter2);
                layouter2 = this.mm;
            }
            if (this.um) {
                this.lm.setCoreLayouter(layouter2);
                layouter2 = this.lm;
            }
            for (n2 = 0; n2 < this.nm.size(); ++n2) {
                layoutStage = (LayoutStage)this.nm.get(n2);
                layoutStage.setCoreLayouter(layouter2);
                layouter = layoutStage;
                if (!bl) {
                    layouter2 = layouter;
                    if (!bl) continue;
                }
                break block12;
            }
            layouter = layouter2;
        }
        return layouter;
    }

    public void doLayout(LayoutGraph layoutGraph) {
        boolean bl = false;
        if (layoutGraph.getDataProvider(km) == null) {
            this.m(layoutGraph);
            layoutGraph.addDataProvider(km, DataProviders.createConstantDataProvider(Boolean.TRUE));
            bl = true;
        }
        Layouter layouter = this.oc();
        layouter.doLayout(layoutGraph);
        if (bl) {
            layoutGraph.removeDataProvider(km);
        }
    }

    public void doLayout(GraphInterface graphInterface, GraphLayout graphLayout) {
        boolean bl = false;
        if (graphInterface.getDataProvider(km) == null) {
            this.b(graphInterface, graphLayout);
            if (graphInterface instanceof Graph) {
                ((Graph)graphInterface).addDataProvider(km, DataProviders.createConstantDataProvider(Boolean.TRUE));
                bl = true;
            }
        }
        new BufferedLayouter(this.oc()).doLayout(graphInterface, graphLayout);
        if (bl) {
            ((Graph)graphInterface).removeDataProvider(km);
        }
    }

    public GraphLayout calcLayout(LayoutGraph layoutGraph) {
        return this.calcLayout(layoutGraph, layoutGraph);
    }

    public GraphLayout calcLayout(GraphInterface graphInterface, GraphLayout graphLayout) {
        boolean bl = false;
        if (graphInterface.getDataProvider(km) == null) {
            this.b(graphInterface, graphLayout);
            if (graphInterface instanceof Graph) {
                ((Graph)graphInterface).addDataProvider(km, DataProviders.createConstantDataProvider(Boolean.TRUE));
                bl = true;
            }
        }
        GraphLayout graphLayout2 = new BufferedLayouter(this.oc()).calcLayout(graphInterface, graphLayout);
        if (bl) {
            ((Graph)graphInterface).removeDataProvider(km);
        }
        return graphLayout2;
    }

    public boolean canLayout(LayoutGraph layoutGraph) {
        if (layoutGraph.getDataProvider(km) == null) {
            try {
                this.m(layoutGraph);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }
        Layouter layouter = this.oc();
        return layouter.canLayout(layoutGraph);
    }

    class _b
    implements Layouter {
        _b() {
        }

        public void doLayout(LayoutGraph layoutGraph) {
            boolean bl = false;
            if (layoutGraph.getDataProvider(CanonicMultiStageLayouter.km) == null) {
                CanonicMultiStageLayouter.this.m(layoutGraph);
                layoutGraph.addDataProvider(CanonicMultiStageLayouter.km, DataProviders.createConstantDataProvider(Boolean.TRUE));
                bl = true;
            }
            CanonicMultiStageLayouter.this.doLayoutCore(layoutGraph);
            if (bl) {
                layoutGraph.removeDataProvider(CanonicMultiStageLayouter.km);
            }
        }

        public boolean canLayout(LayoutGraph layoutGraph) {
            if (layoutGraph.getDataProvider(CanonicMultiStageLayouter.km) == null) {
                try {
                    CanonicMultiStageLayouter.this.m(layoutGraph);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            return CanonicMultiStageLayouter.this.canLayoutCore(layoutGraph);
        }
    }
}

