/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.layout;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.base.Graph;
import y.geom.YDimension;
import y.geom.YPoint;
import y.io.graphml.layout.LayoutGraphMLHandler;
import y.io.graphml.output.XmlWriter;
import y.layout.EdgeLayout;
import y.layout.NodeLayout;

public class LayoutSerializationToolkit {
    private LayoutSerializationToolkit() {
    }

    public static void parseNodeLayout(Node node, NodeLayout nodeLayout) {
        int n2 = LayoutGraphMLHandler.z;
        double d2 = nodeLayout.getX();
        double d3 = nodeLayout.getY();
        double d4 = nodeLayout.getWidth();
        double d5 = nodeLayout.getHeight();
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("x");
        if (node2 != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
            d3 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("width")) != null) {
            d4 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("height")) != null) {
            d5 = Double.parseDouble(node2.getNodeValue());
        }
        if (d4 != nodeLayout.getWidth() || d5 != nodeLayout.getHeight()) {
            nodeLayout.setSize(d4, d5);
        }
        if (d2 != nodeLayout.getX() || d3 != nodeLayout.getY()) {
            nodeLayout.setLocation(d2, d3);
        }
        if (n2 != 0) {
            int n3 = Graph.z;
            Graph.z = ++n3;
        }
    }

    public static void parsePath(Node node, EdgeLayout edgeLayout) {
        int n2 = LayoutGraphMLHandler.z;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("sx");
        if (node2 != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("sy")) != null) {
            d3 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("tx")) != null) {
            d4 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("ty")) != null) {
            d5 = Double.parseDouble(node2.getNodeValue());
        }
        edgeLayout.setSourcePoint(new YPoint(d2, d3));
        edgeLayout.setTargetPoint(new YPoint(d4, d5));
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                String string;
                Node node3 = nodeList.item(i2);
                if (node3.getNodeType() != 1 || !"Point".equals(string = node3.getLocalName())) continue;
                YPoint yPoint = LayoutSerializationToolkit.b(node3);
                edgeLayout.addPoint(yPoint.getX(), yPoint.getY());
                if (n2 == 0) continue;
            }
        }
        if (Graph.z != 0) {
            LayoutGraphMLHandler.z = ++n2;
        }
    }

    static YPoint b(Node node) {
        double d2 = 0.0;
        double d3 = 0.0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("x");
        if (node2 != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
            d3 = Double.parseDouble(node2.getNodeValue());
        }
        return new YPoint(d2, d3);
    }

    public static void writeNodeLayout(XmlWriter xmlWriter, NodeLayout nodeLayout) {
        xmlWriter.writeStartElement("Geometry", "http://www.yworks.com/xml/graphml");
        LayoutSerializationToolkit.b(new YPoint(nodeLayout.getX(), nodeLayout.getY()), xmlWriter);
        LayoutSerializationToolkit.b(new YDimension(nodeLayout.getWidth(), nodeLayout.getHeight()), xmlWriter);
        xmlWriter.writeEndElement();
    }

    public static void writePath(XmlWriter xmlWriter, EdgeLayout edgeLayout) {
        block3: {
            int n2 = LayoutGraphMLHandler.z;
            if (edgeLayout == null) {
                return;
            }
            YPoint yPoint = edgeLayout.getSourcePoint();
            YPoint yPoint2 = edgeLayout.getTargetPoint();
            xmlWriter.writeStartElement("Path", "http://www.yworks.com/xml/graphml");
            xmlWriter.writeAttribute("sx", yPoint.getX());
            xmlWriter.writeAttribute("sy", yPoint.getY());
            xmlWriter.writeAttribute("tx", yPoint2.getX());
            xmlWriter.writeAttribute("ty", yPoint2.getY());
            for (int i2 = 0; i2 < edgeLayout.pointCount(); ++i2) {
                LayoutSerializationToolkit.b(xmlWriter, "Point", edgeLayout.getPoint(i2));
                if (n2 == 0) {
                    if (n2 == 0) continue;
                }
                break block3;
            }
            xmlWriter.writeEndElement();
        }
    }

    private static void b(XmlWriter xmlWriter, String string, YPoint yPoint) {
        if (yPoint == null) {
            return;
        }
        xmlWriter.writeStartElement(string, "http://www.yworks.com/xml/graphml");
        LayoutSerializationToolkit.b(yPoint, xmlWriter);
        xmlWriter.writeEndElement();
    }

    private static void b(YPoint yPoint, XmlWriter xmlWriter) {
        if (yPoint != null) {
            xmlWriter.writeAttribute("x", yPoint.getX());
            xmlWriter.writeAttribute("y", yPoint.getY());
        }
    }

    private static void b(YDimension yDimension, XmlWriter xmlWriter) {
        if (yDimension != null) {
            xmlWriter.writeAttribute("width", yDimension.getWidth());
            xmlWriter.writeAttribute("height", yDimension.getHeight());
        }
    }
}

