/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.layout;

import y.base.Edge;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.HierarchySupport;
import y.layout.grouping.Grouping;

public class GroupingBasedHierarchySupport
implements HierarchySupport {
    private final Grouping b;

    public GroupingBasedHierarchySupport(Grouping grouping) {
        this.b = grouping;
    }

    public boolean isLeafNode(GraphMLWriteContext graphMLWriteContext, Node node) {
        return !this.b.isGroupNode(node);
    }

    public NodeList getChildren(GraphMLWriteContext graphMLWriteContext, Node node) {
        return new NodeList(this.b.getChildren(node));
    }

    public Node getRoot(GraphMLWriteContext graphMLWriteContext) {
        return null;
    }

    public Node getParent(GraphMLWriteContext graphMLWriteContext, Node node) {
        return this.b.getParent(node);
    }

    public Node getNearestCommonAncestor(GraphMLWriteContext graphMLWriteContext, Node node, Node node2) {
        return this.b.getNearestCommonAncestor(node, node2);
    }

    public EdgeList getSubgraphEdges(GraphMLWriteContext graphMLWriteContext, Graph graph) {
        if (graphMLWriteContext.getObjectStack().size() < 3) {
            return new EdgeList(graph.edges());
        }
        return new EdgeList();
    }

    public Graph getSubgraph(GraphMLWriteContext graphMLWriteContext, Node node) {
        return graphMLWriteContext.getGraph();
    }

    public Node getSourceNode(GraphMLWriteContext graphMLWriteContext, Edge edge) {
        return edge.source();
    }

    public Node getTargetNode(GraphMLWriteContext graphMLWriteContext, Edge edge) {
        return edge.target();
    }

    public static GroupingBasedHierarchySupport newInstance(Graph graph) {
        if (Grouping.isGrouped(graph)) {
            return new GroupingBasedHierarchySupport(new Grouping(graph));
        }
        return null;
    }
}

