/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.io.gml.NodeGraphicsParser;
import y.io.gml.NodeRealizerObjectEncoder;
import y.io.graphml.graph2d.AbstractNodeRealizerSerializer;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.input.GraphMLParseContext;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.GraphMLWriteException;
import y.io.graphml.output.XmlWriter;
import y.view.NodeRealizer;
import y.view.ShapeNodeRealizer;

public class ShapeNodeRealizerSerializer
extends AbstractNodeRealizerSerializer {
    static /* synthetic */ Class class$y$view$ShapeNodeRealizer;

    public String getName() {
        return "ShapeNode";
    }

    public String getNamespaceURI() {
        return "http://www.yworks.com/xml/graphml";
    }

    public Class getRealizerClass() {
        return class$y$view$ShapeNodeRealizer == null ? (class$y$view$ShapeNodeRealizer = ShapeNodeRealizerSerializer.class$("y.view.ShapeNodeRealizer")) : class$y$view$ShapeNodeRealizer;
    }

    public void write(NodeRealizer nodeRealizer, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        super.write(nodeRealizer, xmlWriter, graphMLWriteContext);
        ShapeNodeRealizer shapeNodeRealizer = (ShapeNodeRealizer)nodeRealizer;
        xmlWriter.writeStartElement("Shape", "http://www.yworks.com/xml/graphml").writeAttribute("type", this.encodeShapeType(shapeNodeRealizer, graphMLWriteContext)).writeEndElement();
        if (shapeNodeRealizer.isDropShadowVisible()) {
            xmlWriter.writeStartElement("DropShadow", "http://www.yworks.com/xml/graphml").writeAttribute("offsetX", shapeNodeRealizer.getDropShadowOffsetX()).writeAttribute("offsetY", shapeNodeRealizer.getDropShadowOffsetY());
            GraphicsSerializationToolkit.b(xmlWriter, "color", shapeNodeRealizer.getDropShadowColor());
            xmlWriter.writeEndElement();
        }
    }

    protected String encodeShapeType(ShapeNodeRealizer shapeNodeRealizer, GraphMLWriteContext graphMLWriteContext) {
        return NodeRealizerObjectEncoder.encodeShape(shapeNodeRealizer.getShapeType());
    }

    public void parse(NodeRealizer nodeRealizer, Node node, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        int n2 = AbstractNodeRealizerSerializer.z;
        ShapeNodeRealizer shapeNodeRealizer = (ShapeNodeRealizer)nodeRealizer;
        super.parse(shapeNodeRealizer, node, graphMLParseContext);
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node node2;
                NamedNodeMap namedNodeMap;
                Node node3 = nodeList.item(i2);
                if (node3.getNodeType() != 1) continue;
                String string = node3.getLocalName();
                if ("Shape".equals(string)) {
                    namedNodeMap = node3.getAttributes();
                    node2 = namedNodeMap.getNamedItem("type");
                    if (node2 == null) continue;
                    shapeNodeRealizer.setShapeType(this.decodeShapeType(node2.getNodeValue(), graphMLParseContext));
                    if (n2 == 0) continue;
                }
                if (!"DropShadow".equals(string)) continue;
                namedNodeMap = node3.getAttributes();
                node2 = namedNodeMap.getNamedItem("offsetX");
                if (node2 != null) {
                    shapeNodeRealizer.setDropShadowOffsetX(Byte.parseByte(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("offsetY")) != null) {
                    shapeNodeRealizer.setDropShadowOffsetY(Byte.parseByte(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("color")) == null) continue;
                shapeNodeRealizer.setDropShadowColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
                if (n2 == 0) continue;
            }
        }
    }

    protected byte decodeShapeType(String string, GraphMLParseContext graphMLParseContext) {
        return NodeGraphicsParser.getShape(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

