/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import java.util.Map;
import y.io.gml.NodeLabelGraphicsEncoder;
import y.io.graphml.graph2d.AbstractNodeRealizerSerializer;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.GraphMLWriteException;
import y.io.graphml.output.SerializationEvent;
import y.io.graphml.output.SerializationHandler;
import y.io.graphml.output.XmlWriter;
import y.view.NodeLabel;
import y.view.SmartNodeLabelModel;

public class NodeLabelSerializer
implements SerializationHandler {
    static final Map rc = NodeLabelGraphicsEncoder.anchorEncoding;
    static final Map qc = NodeLabelGraphicsEncoder.modelEncoding;

    public void onHandleSerialization(SerializationEvent serializationEvent) throws GraphMLWriteException {
        Object object = serializationEvent.getItem();
        if (object instanceof NodeLabel) {
            NodeLabel nodeLabel = (NodeLabel)object;
            serializationEvent.getWriter().writeStartElement("NodeLabel", "http://www.yworks.com/xml/graphml");
            this.serializeContent(nodeLabel, serializationEvent.getWriter(), serializationEvent.getContext());
            serializationEvent.getWriter().writeEndElement();
            serializationEvent.setHandled(true);
        }
    }

    protected void serializeContent(NodeLabel nodeLabel, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        block7: {
            block6: {
                String string;
                String string2 = this.getModelName(nodeLabel, graphMLWriteContext);
                if (string2 != null) {
                    xmlWriter.writeAttribute("modelName", string2);
                }
                if (127 != nodeLabel.getModel() && (string = this.getModelPosition(nodeLabel, graphMLWriteContext)) != null) {
                    xmlWriter.writeAttribute("modelPosition", string);
                }
                xmlWriter.writeAttribute("autoSizePolicy", NodeLabelGraphicsEncoder.encodeAutoSizePolicy(nodeLabel.getAutoSizePolicy()));
                if (nodeLabel.getDistance() != 4.0) {
                    xmlWriter.writeAttribute("borderDistance", nodeLabel.getDistance());
                }
                GraphicsSerializationToolkit.b(xmlWriter, nodeLabel, graphMLWriteContext);
                string = nodeLabel.getText();
                if (string == null || string.length() <= 0) break block6;
                xmlWriter.writeText(string);
                if (AbstractNodeRealizerSerializer.z == 0) break block7;
            }
            xmlWriter.writeAttribute("hasText", false);
        }
        this.writeCustomModelElements(nodeLabel, xmlWriter, graphMLWriteContext);
    }

    protected void writeCustomModelElements(NodeLabel nodeLabel, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        if (127 == nodeLabel.getModel()) {
            xmlWriter.writeStartElement("LabelModel", "http://www.yworks.com/xml/graphml");
            graphMLWriteContext.serialize(nodeLabel.getLabelModel());
            xmlWriter.writeEndElement();
            xmlWriter.writeStartElement("ModelParameter", "http://www.yworks.com/xml/graphml");
            graphMLWriteContext.serialize(nodeLabel.getModelParameter());
            xmlWriter.writeEndElement();
        }
    }

    protected String getModelName(NodeLabel nodeLabel, GraphMLWriteContext graphMLWriteContext) {
        if (127 == nodeLabel.getModel()) {
            return "custom";
        }
        return (String)qc.get(new Byte(nodeLabel.getModel()));
    }

    protected String getModelPosition(NodeLabel nodeLabel, GraphMLWriteContext graphMLWriteContext) {
        return (String)rc.get(new Byte(nodeLabel.getPosition()));
    }

    public static class SmartNodeLabelModelSerializer
    implements SerializationHandler {
        public void onHandleSerialization(SerializationEvent serializationEvent) throws GraphMLWriteException {
            block5: {
                Object object;
                block4: {
                    object = serializationEvent.getItem();
                    if (!(object instanceof SmartNodeLabelModel)) break block4;
                    this.serializeModel((SmartNodeLabelModel)object, serializationEvent.getWriter(), serializationEvent.getContext());
                    serializationEvent.setHandled(true);
                    if (AbstractNodeRealizerSerializer.z == 0) break block5;
                }
                if (object instanceof SmartNodeLabelModel.ModelParameter) {
                    this.serializeParameter((SmartNodeLabelModel.ModelParameter)object, serializationEvent.getWriter(), serializationEvent.getContext());
                    serializationEvent.setHandled(true);
                }
            }
        }

        protected void serializeParameter(SmartNodeLabelModel.ModelParameter modelParameter, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) {
            xmlWriter.writeStartElement("SmartNodeLabelModelParameter", "http://www.yworks.com/xml/graphml");
            xmlWriter.writeAttribute("nodeRatioX", modelParameter.getNodeRatioX());
            xmlWriter.writeAttribute("nodeRatioY", modelParameter.getNodeRatioY());
            xmlWriter.writeAttribute("labelRatioX", modelParameter.getLabelRatioX());
            xmlWriter.writeAttribute("labelRatioY", modelParameter.getLabelRatioY());
            xmlWriter.writeAttribute("offsetX", modelParameter.getOffsetX());
            xmlWriter.writeAttribute("offsetY", modelParameter.getOffsetY());
            xmlWriter.writeAttribute("upX", modelParameter.getUpX());
            xmlWriter.writeAttribute("upY", modelParameter.getUpY());
            xmlWriter.writeEndElement();
        }

        protected void serializeModel(SmartNodeLabelModel smartNodeLabelModel, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) {
            xmlWriter.writeStartElement("SmartNodeLabelModel", "http://www.yworks.com/xml/graphml");
            xmlWriter.writeAttribute("distance", smartNodeLabelModel.getDistance());
            xmlWriter.writeEndElement();
        }
    }
}

