/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import java.util.Iterator;
import y.base.Edge;
import y.base.EdgeList;
import y.base.Graph;
import y.base.Node;
import y.base.NodeList;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.HierarchySupport;
import y.view.hierarchy.HierarchyManager;

public class HierarchyManagerBasedHierarchySupport
implements HierarchySupport {
    private HierarchyManager d;
    private Graph c;

    public HierarchyManagerBasedHierarchySupport(HierarchyManager hierarchyManager) {
        this(hierarchyManager, hierarchyManager.getRootGraph());
    }

    public HierarchyManagerBasedHierarchySupport(HierarchyManager hierarchyManager, Graph graph) {
        this.d = hierarchyManager;
        this.c = graph;
    }

    public boolean isLeafNode(GraphMLWriteContext graphMLWriteContext, Node node) {
        return this.d.isNormalNode(node);
    }

    public NodeList getChildren(GraphMLWriteContext graphMLWriteContext, Node node) {
        return new NodeList(this.d.getChildren(node));
    }

    public Node getRoot(GraphMLWriteContext graphMLWriteContext) {
        return this.d.getAnchorNode(this.c);
    }

    public Node getParent(GraphMLWriteContext graphMLWriteContext, Node node) {
        return this.d.getParentNode(node);
    }

    public Node getNearestCommonAncestor(GraphMLWriteContext graphMLWriteContext, Node node, Node node2) {
        NodeList nodeList = new NodeList();
        nodeList.add(node);
        nodeList.add(node2);
        return this.d.getNearestCommonAncestor(nodeList);
    }

    public EdgeList getSubgraphEdges(GraphMLWriteContext graphMLWriteContext, Graph graph) {
        HierarchyManager hierarchyManager = HierarchyManager.getInstance(graph);
        if (graphMLWriteContext.getObjectStack().size() > 2) {
            Iterator iterator = graphMLWriteContext.getObjectStack().iterator();
            iterator.next();
            Node node = (Node)iterator.next();
            if (hierarchyManager.isFolderNode(node)) {
                return new EdgeList(graph.edges());
            }
            return new EdgeList();
        }
        return new EdgeList(graphMLWriteContext.getGraph().edges());
    }

    public Graph getSubgraph(GraphMLWriteContext graphMLWriteContext, Node node) {
        if (this.d.isFolderNode(node)) {
            return this.d.getInnerGraph(node);
        }
        return graphMLWriteContext.getGraph();
    }

    public Node getSourceNode(GraphMLWriteContext graphMLWriteContext, Edge edge) {
        if (this.d.isInterEdge(edge)) {
            return this.d.getRealSource(edge);
        }
        return edge.source();
    }

    public Node getTargetNode(GraphMLWriteContext graphMLWriteContext, Edge edge) {
        if (this.d.isInterEdge(edge)) {
            return this.d.getRealTarget(edge);
        }
        return edge.target();
    }
}

