/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.font.TextAttribute;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.base.Graph;
import y.base.ListCell;
import y.base.YList;
import y.geom.OrientedRectangle;
import y.geom.YInsets;
import y.geom.YRectangle;
import y.io.gml.EdgeGraphicsParser;
import y.io.gml.EdgeRealizerObjectEncoder;
import y.io.gml.LabelGraphicsEncoder;
import y.io.gml.LabelGraphicsParser;
import y.io.gml.NodeLabelGraphicsEncoder;
import y.io.graphml.graph2d.AbstractNodeRealizerSerializer;
import y.io.graphml.graph2d.Graph2DGraphMLHandler;
import y.io.graphml.graph2d.ResourceDescriptor;
import y.io.graphml.graph2d.ResourceDeserializationHandler;
import y.io.graphml.graph2d.ResourceSerializationHandler;
import y.io.graphml.graph2d.c;
import y.io.graphml.graph2d.d;
import y.io.graphml.graph2d.e;
import y.io.graphml.input.GraphMLParseContext;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.input.GraphMLParser;
import y.io.graphml.layout.LayoutSerializationToolkit;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.GraphMLWriter;
import y.io.graphml.output.XmlWriter;
import y.layout.EdgeLayout;
import y.layout.NodeLayout;
import y.util.D;
import y.util.ObjectStringConversion;
import y.view.Arrow;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.LineType;
import y.view.YLabel;

public class GraphicsSerializationToolkit {
    static final String c = "y.io.graphml.output.ImageIconSerializer.ACCEPT_SUBCLASSES";
    private static final YList b = new YList();
    private static final int d = 32;
    static /* synthetic */ Class class$javax$swing$ImageIcon;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$y$io$graphml$graph2d$ResourceSerializationHandler;
    static /* synthetic */ Class class$y$io$graphml$graph2d$ResourceDeserializationHandler;

    private GraphicsSerializationToolkit() {
    }

    public static void writePath(XmlWriter xmlWriter, EdgeLayout edgeLayout) {
        block3: {
            block2: {
                if (!(edgeLayout instanceof EdgeRealizer) || !((EdgeRealizer)edgeLayout).isReversedPathRenderingEnabled()) break block2;
                LayoutSerializationToolkit.writePath(new _b(xmlWriter), edgeLayout);
                if (AbstractNodeRealizerSerializer.z == 0) break block3;
            }
            LayoutSerializationToolkit.writePath(xmlWriter, edgeLayout);
        }
    }

    public static void writeNodeLayout(XmlWriter xmlWriter, NodeLayout nodeLayout) {
        LayoutSerializationToolkit.writeNodeLayout(xmlWriter, nodeLayout);
    }

    static void b(XmlWriter xmlWriter, String string, LineType lineType, Color color) {
        block10: {
            int n2;
            block12: {
                block11: {
                    n2 = AbstractNodeRealizerSerializer.z;
                    String string2 = GraphicsSerializationToolkit.d(lineType.getLineStyle());
                    xmlWriter.writeStartElement(string, "http://www.yworks.com/xml/graphml");
                    xmlWriter.writeAttribute("type", string2);
                    xmlWriter.writeAttribute("width", lineType.getLineWidth());
                    if (color == null) break block11;
                    GraphicsSerializationToolkit.b(xmlWriter, "color", color);
                    if (n2 == 0) break block12;
                }
                xmlWriter.writeAttribute("hasColor", "false");
            }
            if (lineType.getLineStyle() == 127) {
                xmlWriter.writeAttribute("cap", lineType.getEndCap());
                xmlWriter.writeAttribute("join", lineType.getLineJoin());
                xmlWriter.writeAttribute("miterLimit", lineType.getMiterLimit());
                xmlWriter.writeAttribute("dashPhase", lineType.getDashPhase());
                float[] fArray = lineType.getDashArray();
                if (fArray != null && fArray.length > 0) {
                    String string3 = "";
                    for (int i2 = 0; i2 < fArray.length; ++i2) {
                        float f2 = fArray[i2];
                        if (n2 == 0) {
                            if (i2 > 0) {
                                string3 = string3 + ", ";
                            }
                            string3 = string3 + f2;
                            if (n2 == 0) continue;
                        }
                        break block10;
                    }
                    xmlWriter.writeAttribute("dash", string3);
                }
            }
            xmlWriter.writeEndElement();
        }
    }

    static String d(byte by) {
        switch (by) {
            case 0: {
                return "line";
            }
            case 1: {
                return "dashed";
            }
            case 2: {
                return "dotted";
            }
            case 3: {
                return "dashed_dotted";
            }
            case 127: {
                return "custom";
            }
        }
        return "line";
    }

    static void b(XmlWriter xmlWriter, String string, Arrow arrow, Arrow arrow2) {
        xmlWriter.writeStartElement(string, "http://www.yworks.com/xml/graphml").writeAttribute("source", EdgeRealizerObjectEncoder.encodeArrowType(arrow)).writeAttribute("target", EdgeRealizerObjectEncoder.encodeArrowType(arrow2)).writeEndElement();
    }

    public static String valueOf(Color color) {
        int n2 = AbstractNodeRealizerSerializer.z;
        if (color != null) {
            StringBuffer stringBuffer;
            block13: {
                int n3;
                String string;
                block12: {
                    block11: {
                        block10: {
                            stringBuffer = new StringBuffer(9);
                            stringBuffer.append('#');
                            string = Integer.toHexString(color.getRed()).toUpperCase(Locale.US);
                            for (n3 = 2 - string.length(); n3 > 0; --n3) {
                                stringBuffer.append('0');
                                if (n2 == 0) {
                                    if (n2 == 0) continue;
                                }
                                break block10;
                            }
                            stringBuffer.append(string);
                            string = Integer.toHexString(color.getGreen()).toUpperCase(Locale.US);
                        }
                        for (n3 = 2 - string.length(); n3 > 0; --n3) {
                            stringBuffer.append('0');
                            if (n2 == 0) {
                                if (n2 == 0) continue;
                            }
                            break block11;
                        }
                        stringBuffer.append(string);
                        string = Integer.toHexString(color.getBlue()).toUpperCase(Locale.US);
                    }
                    for (n3 = 2 - string.length(); n3 > 0; --n3) {
                        stringBuffer.append('0');
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block12;
                    }
                    stringBuffer.append(string);
                }
                if (color.getAlpha() != 255) {
                    string = Integer.toHexString(color.getAlpha()).toUpperCase(Locale.US);
                    for (n3 = 2 - string.length(); n3 > 0; --n3) {
                        stringBuffer.append('0');
                        if (n2 == 0) {
                            if (n2 == 0) continue;
                        }
                        break block13;
                    }
                    stringBuffer.append(string);
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    static void b(XmlWriter xmlWriter, String string, Color color) {
        String string2 = GraphicsSerializationToolkit.valueOf(color);
        if (string2 != null) {
            xmlWriter.writeAttribute(string, string2);
        }
    }

    static void b(XmlWriter xmlWriter, YLabel yLabel, GraphMLWriteContext graphMLWriteContext) {
        Icon icon;
        Insets insets;
        block21: {
            block20: {
                int n2;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                n2 = AbstractNodeRealizerSerializer.z;
                                OrientedRectangle orientedRectangle = yLabel.getOffset();
                                YRectangle yRectangle = orientedRectangle.getBoundingBox();
                                xmlWriter.writeAttribute("x", yRectangle.getX());
                                xmlWriter.writeAttribute("y", yRectangle.getY());
                                xmlWriter.writeAttribute("width", yLabel.getContentWidth());
                                xmlWriter.writeAttribute("height", yLabel.getContentHeight());
                                if (orientedRectangle.getUpY() != -1.0) {
                                    xmlWriter.writeAttribute("anchorX", orientedRectangle.getAnchorX());
                                    xmlWriter.writeAttribute("anchorY", orientedRectangle.getAnchorY());
                                    xmlWriter.writeAttribute("upX", orientedRectangle.getUpX());
                                    xmlWriter.writeAttribute("upY", orientedRectangle.getUpY());
                                }
                                xmlWriter.writeAttribute("visible", yLabel.isVisible());
                                xmlWriter.writeAttribute("alignment", LabelGraphicsEncoder.encodeAlignment(yLabel.getAlignment()));
                                Font font = yLabel.getFont();
                                if (!GraphicsSerializationToolkit.b(font)) break block16;
                                GraphicsSerializationToolkit.writeSharedReference(font, xmlWriter, "fontResource", graphMLWriteContext);
                                if (n2 == 0) break block17;
                            }
                            xmlWriter.writeAttribute("fontFamily", yLabel.getFontName());
                            xmlWriter.writeAttribute("fontSize", yLabel.getFontSize());
                            xmlWriter.writeAttribute("fontStyle", LabelGraphicsEncoder.encodeFontStyle(yLabel.getFontStyle()));
                        }
                        GraphicsSerializationToolkit.b(xmlWriter, "textColor", yLabel.getTextColor());
                        if (yLabel.getBackgroundColor() == null) break block18;
                        GraphicsSerializationToolkit.b(xmlWriter, "backgroundColor", yLabel.getBackgroundColor());
                        if (n2 == 0) break block19;
                    }
                    xmlWriter.writeAttribute("hasBackgroundColor", "false");
                }
                if (yLabel.getLineColor() == null) break block20;
                GraphicsSerializationToolkit.b(xmlWriter, "lineColor", yLabel.getLineColor());
                if (n2 == 0) break block21;
            }
            xmlWriter.writeAttribute("hasLineColor", "false");
        }
        if (yLabel.getConfiguration() != null) {
            xmlWriter.writeAttribute("configuration", yLabel.getConfiguration());
        }
        if (yLabel.getAutoSizePolicy() != 0) {
            xmlWriter.writeAttribute("autoSizePolicy", NodeLabelGraphicsEncoder.encodeAutoSizePolicy(yLabel.getAutoSizePolicy()));
        }
        if ((insets = yLabel.getInsets()) != null) {
            GraphicsSerializationToolkit.b(xmlWriter, insets, graphMLWriteContext);
        }
        if ((icon = yLabel.getIcon()) != null) {
            GraphicsSerializationToolkit.b(xmlWriter, "icon", icon, graphMLWriteContext);
            xmlWriter.writeAttribute("horizontalTextPosition", GraphicsSerializationToolkit.c(yLabel.getHorizontalTextPosition()));
            xmlWriter.writeAttribute("verticalTextPosition", GraphicsSerializationToolkit.b(yLabel.getVerticalTextPosition()));
            xmlWriter.writeAttribute("iconTextGap", yLabel.getIconTextGap());
        }
        if (yLabel.getRotationAngle() != 0.0) {
            xmlWriter.writeAttribute("rotationAngle", yLabel.getRotationAngle());
        }
        if (yLabel.isUnderlinedTextEnabled()) {
            xmlWriter.writeAttribute("underlinedText", "true");
        }
    }

    private static boolean b(Font font) {
        boolean bl;
        block2: {
            int n2 = AbstractNodeRealizerSerializer.z;
            Map<TextAttribute, ?> map = font.getAttributes();
            Iterator<Map.Entry<TextAttribute, ?>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TextAttribute, ?> entry = iterator.next();
                Object obj = entry.getValue();
                if (obj == null) continue;
                bl = y.io.graphml.graph2d.c.b(entry.getKey(), obj);
                if (n2 == 0) {
                    if (!bl) continue;
                    return true;
                }
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    static void b(XmlWriter xmlWriter, String string, Icon icon, GraphMLWriteContext graphMLWriteContext) {
        block3: {
            block4: {
                int n2;
                block2: {
                    n2 = AbstractNodeRealizerSerializer.z;
                    if (!(icon instanceof d)) break block2;
                    xmlWriter.writeAttribute(string, ((d)icon).b());
                    if (n2 == 0) break block3;
                }
                if (!GraphicsSerializationToolkit.b(icon, graphMLWriteContext)) break block4;
                GraphicsSerializationToolkit.writeSharedImageReference(((ImageIcon)icon).getImage(), xmlWriter, "image", graphMLWriteContext);
                if (n2 == 0) break block3;
            }
            GraphicsSerializationToolkit.writeSharedReference(icon, xmlWriter, "iconData", graphMLWriteContext);
        }
    }

    private static boolean b(Icon icon, GraphMLWriteContext graphMLWriteContext) {
        return icon instanceof ImageIcon && (GraphicsSerializationToolkit.getBooleanSerializationProperty(graphMLWriteContext, c) || icon.getClass() == (class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = GraphicsSerializationToolkit.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon));
    }

    private static void b(XmlWriter xmlWriter, Insets insets, GraphMLWriteContext graphMLWriteContext) {
        xmlWriter.writeAttribute("topInset", insets.top).writeAttribute("bottomInset", insets.bottom).writeAttribute("leftInset", insets.left).writeAttribute("rightInset", insets.right);
    }

    private static void b(YLabel yLabel, Element element, GraphMLParseContext graphMLParseContext) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        String string = element.getAttribute("topInset");
        if (!"".equals(string)) {
            bl = true;
            n2 = Integer.parseInt(string);
        }
        if (!"".equals(string = element.getAttribute("bottomInset"))) {
            bl = true;
            n3 = Integer.parseInt(string);
        }
        if (!"".equals(string = element.getAttribute("leftInset"))) {
            bl = true;
            n4 = Integer.parseInt(string);
        }
        if (!"".equals(string = element.getAttribute("rightInset"))) {
            bl = true;
            n5 = Integer.parseInt(string);
        }
        if (bl) {
            yLabel.setInsets(new Insets(n2, n4, n3, n5));
        }
    }

    static void b(XmlWriter xmlWriter, String string, YInsets yInsets) {
        xmlWriter.writeStartElement(string, "http://www.yworks.com/xml/graphml").writeAttribute("top", Math.round(yInsets.top)).writeAttribute("bottom", Math.round(yInsets.bottom)).writeAttribute("left", Math.round(yInsets.left)).writeAttribute("right", Math.round(yInsets.right)).writeAttribute("topF", yInsets.top).writeAttribute("bottomF", yInsets.bottom).writeAttribute("leftF", yInsets.left).writeAttribute("rightF", yInsets.right).writeEndElement();
    }

    private static URL b(GraphMLParseContext graphMLParseContext) {
        if (graphMLParseContext == null) {
            return null;
        }
        Graph graph = graphMLParseContext.getGraph();
        if (graph instanceof Graph2D) {
            return ((Graph2D)graph).getURL();
        }
        return null;
    }

    static Icon b(String string, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        URL uRL;
        block5: {
            uRL = null;
            URL uRL2 = GraphicsSerializationToolkit.b(graphMLParseContext);
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL(uRL2, string);
                }
                catch (MalformedURLException malformedURLException2) {
                    String string2 = "Cannot load image from path: " + malformedURLException2.getMessage();
                    if (GraphicsSerializationToolkit.getBooleanDeserializationProperty(graphMLParseContext, "y.io.graphml.input.DeserializationProperties.IGNORE_RESOURCE_ERRORS")) {
                        D.bug(string2 + ", ignoring Postprocessor");
                        if (AbstractNodeRealizerSerializer.z == 0) break block5;
                    }
                    throw new GraphMLParseException(string2, malformedURLException2);
                }
            }
        }
        return new d(uRL, string);
    }

    public static String parseText(Node node) {
        int n2 = AbstractNodeRealizerSerializer.z;
        NodeList nodeList = node.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        if (nodeList != null) {
            Node node2;
            for (int i2 = 0; i2 < nodeList.getLength() && (3 == (node2 = nodeList.item(i2)).getNodeType() || 4 == node2.getNodeType()); ++i2) {
                stringBuffer.append(node2.getNodeValue());
                if (n2 == 0) continue;
            }
        }
        return stringBuffer.toString();
    }

    static YInsets c(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        double d2 = 0.0;
        Node node2 = namedNodeMap.getNamedItem("topF");
        if (node2 == null) {
            node2 = namedNodeMap.getNamedItem("top");
        }
        if (node2 != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        double d3 = 0.0;
        node2 = namedNodeMap.getNamedItem("bottomF");
        if (node2 == null) {
            node2 = namedNodeMap.getNamedItem("bottom");
        }
        if (node2 != null) {
            d3 = Double.parseDouble(node2.getNodeValue());
        }
        double d4 = 0.0;
        node2 = namedNodeMap.getNamedItem("leftF");
        if (node2 == null) {
            node2 = namedNodeMap.getNamedItem("left");
        }
        if (node2 != null) {
            d4 = Double.parseDouble(node2.getNodeValue());
        }
        double d5 = 0.0;
        node2 = namedNodeMap.getNamedItem("rightF");
        if (node2 == null) {
            node2 = namedNodeMap.getNamedItem("right");
        }
        if (node2 != null) {
            d5 = Double.parseDouble(node2.getNodeValue());
        }
        return new YInsets(d2, d4, d3, d5);
    }

    public static void parseNodeLayout(Node node, NodeLayout nodeLayout) {
        LayoutSerializationToolkit.parseNodeLayout(node, nodeLayout);
    }

    public static void parsePath(Node node, EdgeLayout edgeLayout) {
        NamedNodeMap namedNodeMap;
        Node node2;
        if (edgeLayout instanceof EdgeRealizer && (node2 = (namedNodeMap = node.getAttributes()).getNamedItem("reversedPathRendering")) != null) {
            ((EdgeRealizer)edgeLayout).setReversedPathRenderingEnabled(Boolean.valueOf(node2.getNodeValue()));
        }
        LayoutSerializationToolkit.parsePath(node, edgeLayout);
    }

    static LineType b(Node node) {
        byte by;
        int n2 = AbstractNodeRealizerSerializer.z;
        String string = "line";
        double d2 = 1.0;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("type");
        if (node2 != null) {
            string = node2.getNodeValue();
        }
        if ((node2 = namedNodeMap.getNamedItem("width")) != null) {
            d2 = Double.parseDouble(node2.getNodeValue());
        }
        if ((by = GraphicsSerializationToolkit.b(string)) != 127) {
            return LineType.createLineType((int)d2, by);
        }
        int n3 = 2;
        node2 = namedNodeMap.getNamedItem("cap");
        if (node2 != null) {
            n3 = Integer.parseInt(node2.getNodeValue());
        }
        int n4 = 1;
        node2 = namedNodeMap.getNamedItem("join");
        if (node2 != null) {
            n4 = Integer.parseInt(node2.getNodeValue());
        }
        float f2 = 1.0f;
        node2 = namedNodeMap.getNamedItem("miterLimit");
        if (node2 != null) {
            f2 = Float.parseFloat(node2.getNodeValue());
        }
        float f3 = 0.0f;
        node2 = namedNodeMap.getNamedItem("dashPhase");
        if (node2 != null) {
            f3 = Float.parseFloat(node2.getNodeValue());
        }
        float[] fArray = null;
        node2 = namedNodeMap.getNamedItem("dash");
        if (node2 != null) {
            String[] stringArray = node2.getNodeValue().split(",");
            fArray = new float[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                fArray[i2] = Float.parseFloat(stringArray[i2]);
                if (n2 == 0) continue;
            }
        }
        return LineType.createLineType((int)d2, n3, n4, f2, fArray, f3);
    }

    static byte b(String string) {
        if ("line".equals(string)) {
            return 0;
        }
        if ("dashed".equals(string)) {
            return 1;
        }
        if ("dotted".equals(string)) {
            return 2;
        }
        if ("dashed_dotted".equals(string)) {
            return 3;
        }
        if ("custom".equals(string)) {
            return 127;
        }
        return 0;
    }

    static Arrow b(Node node, String string) {
        Arrow arrow = null;
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 != null) {
            arrow = EdgeGraphicsParser.decodeArrow(node2.getNodeValue());
        }
        if (arrow == null) {
            arrow = Arrow.NONE;
        }
        return arrow;
    }

    static OrientedRectangle b(Node node, double d2, double d3) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        double d6 = Double.NaN;
        double d7 = Double.NaN;
        double d8 = Double.NaN;
        double d9 = Double.NaN;
        double d10 = Double.NaN;
        double d11 = Double.NaN;
        double d12 = Double.NaN;
        Node node2 = namedNodeMap.getNamedItem("x");
        if (node2 != null) {
            d4 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
            d5 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("width")) == null) {
            node2 = namedNodeMap.getNamedItem("w");
        }
        if (node2 != null) {
            d6 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("height")) == null) {
            node2 = namedNodeMap.getNamedItem("h");
        }
        if (node2 != null) {
            d7 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("anchorX")) != null) {
            d8 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("anchorY")) != null) {
            d9 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("upX")) != null) {
            d10 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("upY")) != null) {
            d11 = Double.parseDouble(node2.getNodeValue());
        }
        if ((node2 = namedNodeMap.getNamedItem("rotationAngle")) != null) {
            d12 = Double.parseDouble(node2.getNodeValue());
        }
        if (!Double.isNaN(d6) && !Double.isNaN(d7)) {
            if (!Double.isNaN(d12) && d12 != 0.0) {
                OrientedRectangle orientedRectangle = new OrientedRectangle(0.0, 0.0, d6, d7);
                orientedRectangle.setAngle(-Math.toRadians(d12));
                YRectangle yRectangle = orientedRectangle.getBoundingBox();
                d6 = yRectangle.getWidth();
                d7 = yRectangle.getHeight();
            }
            if (!(Double.isNaN(d8) || Double.isNaN(d9) || Double.isNaN(d10) || Double.isNaN(d11))) {
                if (d10 == 0.0 && d11 == 0.0) {
                    d11 = -1.0;
                }
                return new OrientedRectangle(d2 + d8, d3 + d9, d6, d7, d10, d11);
            }
            if (!Double.isNaN(d4) && !Double.isNaN(d5)) {
                return new OrientedRectangle(d2 + d4, d3 + d5 + d7, d6, d7, 0.0, -1.0);
            }
        }
        return null;
    }

    static void b(Node node, YLabel yLabel, _c _c2, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        block59: {
            Object object;
            NamedNodeMap namedNodeMap;
            int n2;
            block58: {
                Icon icon;
                Node node2;
                block67: {
                    block66: {
                        block65: {
                            block64: {
                                block63: {
                                    block62: {
                                        block61: {
                                            double d2;
                                            double d3;
                                            block60: {
                                                n2 = AbstractNodeRealizerSerializer.z;
                                                namedNodeMap = node.getAttributes();
                                                node2 = namedNodeMap.getNamedItem("hasText");
                                                if (node2 == null || !"false".equalsIgnoreCase(node2.getNodeValue())) {
                                                    yLabel.setText(GraphicsSerializationToolkit.parseText(node));
                                                }
                                                d3 = Double.NaN;
                                                d2 = Double.NaN;
                                                double d4 = Double.NaN;
                                                double d5 = Double.NaN;
                                                double d6 = Double.NaN;
                                                double d7 = Double.NaN;
                                                double d8 = Double.NaN;
                                                double d9 = Double.NaN;
                                                node2 = namedNodeMap.getNamedItem("x");
                                                if (node2 != null) {
                                                    d3 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("y")) != null) {
                                                    d2 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("w")) != null) {
                                                    d4 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("h")) != null) {
                                                    d5 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("autoSizePolicy")) != null) {
                                                    yLabel.setAutoSizePolicy(LabelGraphicsParser.decodeAutoSizePolicy(node2.getNodeValue()));
                                                }
                                                if (!Double.isNaN(d4) && !Double.isNaN(d5)) {
                                                    yLabel.setContentHeight(d5);
                                                    yLabel.setContentWidth(d4);
                                                    yLabel.setContentSize(d4, d5);
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("width")) != null) {
                                                    d4 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("height")) != null) {
                                                    d5 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if (!Double.isNaN(d4) && !Double.isNaN(d5)) {
                                                    yLabel.setContentSize(d4, d5);
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("anchorX")) != null) {
                                                    d6 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("anchorY")) != null) {
                                                    d7 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("upX")) != null) {
                                                    d8 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if ((node2 = namedNodeMap.getNamedItem("upY")) != null) {
                                                    d9 = Double.parseDouble(node2.getNodeValue());
                                                }
                                                if (Double.isNaN(d8) || Double.isNaN(d9) || Double.isNaN(d6) || Double.isNaN(d7) || Double.isNaN(d4) || Double.isNaN(d5)) break block60;
                                                if (d8 == 0.0 && d9 == 0.0) {
                                                    d9 = -1.0;
                                                }
                                                yLabel.setOffset(new OrientedRectangle(d6, d7, d4, d5, d8, d9));
                                                if (n2 == 0) break block61;
                                            }
                                            if (!Double.isNaN(d3) && !Double.isNaN(d2)) {
                                                yLabel.setOffset(d3, d2);
                                            }
                                        }
                                        if ((node2 = namedNodeMap.getNamedItem("visible")) != null) {
                                            yLabel.setVisible(Boolean.valueOf(node2.getNodeValue()));
                                        }
                                        if ((node2 = namedNodeMap.getNamedItem("alignment")) != null) {
                                            yLabel.setAlignment(LabelGraphicsParser.decodeAlignment(node2.getNodeValue()));
                                        }
                                        if ((node2 = namedNodeMap.getNamedItem("textColor")) != null) {
                                            yLabel.setTextColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
                                        }
                                        if ((node2 = namedNodeMap.getNamedItem("backgroundColor")) != null) {
                                            yLabel.setBackgroundColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
                                        }
                                        if ((node2 = namedNodeMap.getNamedItem("hasBackgroundColor")) == null || !Boolean.valueOf(node2.getNodeValue()).equals(Boolean.FALSE)) break block62;
                                        yLabel.setBackgroundColor(null);
                                        if (n2 == 0) break block63;
                                    }
                                    if ((node2 = namedNodeMap.getNamedItem("backgroundColor")) != null) {
                                        yLabel.setBackgroundColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
                                    }
                                }
                                if ((node2 = namedNodeMap.getNamedItem("hasLineColor")) == null || !Boolean.valueOf(node2.getNodeValue()).equals(Boolean.FALSE)) break block64;
                                yLabel.setLineColor(null);
                                if (n2 == 0) break block65;
                            }
                            if ((node2 = namedNodeMap.getNamedItem("lineColor")) != null) {
                                yLabel.setLineColor(GraphicsSerializationToolkit.parseColor(node2.getNodeValue()));
                            }
                        }
                        if ((node2 = namedNodeMap.getNamedItem("fontResource")) == null) break block66;
                        yLabel.setFont((Font)GraphicsSerializationToolkit.readSharedReference(node2.getNodeValue(), graphMLParseContext, class$java$awt$Font == null ? (class$java$awt$Font = GraphicsSerializationToolkit.class$("java.awt.Font")) : class$java$awt$Font));
                        if (n2 == 0) break block67;
                    }
                    if ((node2 = namedNodeMap.getNamedItem("fontFamily")) != null) {
                        yLabel.setFontName(node2.getNodeValue());
                    }
                    if ((node2 = namedNodeMap.getNamedItem("fontSize")) != null) {
                        yLabel.setFontSize(Integer.parseInt(node2.getNodeValue()));
                    }
                    if ((node2 = namedNodeMap.getNamedItem("fontStyle")) != null) {
                        yLabel.setFontStyle(LabelGraphicsParser.decodeFontStyle(node2.getNodeValue()));
                    }
                }
                if ((icon = GraphicsSerializationToolkit.b(node, "icon", graphMLParseContext)) != null) {
                    yLabel.setIcon(icon);
                }
                if ((node2 = namedNodeMap.getNamedItem("horizontalTextPosition")) != null) {
                    yLabel.setHorizontalTextPosition(GraphicsSerializationToolkit.d(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("verticalTextPosition")) != null) {
                    yLabel.setVerticalTextPosition(GraphicsSerializationToolkit.c(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("iconTextGap")) != null) {
                    yLabel.setIconTextGap(Byte.parseByte(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("rotationAngle")) != null) {
                    yLabel.setRotationAngle(Double.parseDouble(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("underlinedText")) != null) {
                    yLabel.setUnderlinedTextEnabled(Boolean.valueOf(node2.getNodeValue()));
                }
                if ((node2 = namedNodeMap.getNamedItem("configuration")) != null && (object = node2.getNodeValue()) != null && ((String)object).length() > 0) {
                    try {
                        yLabel.setConfiguration(node2.getNodeValue());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (_c2.b(yLabel, node, graphMLParseContext)) break block58;
                        throw new GraphMLParseException("Unknown configuration " + (String)object, illegalArgumentException);
                    }
                }
            }
            if (node instanceof Element) {
                GraphicsSerializationToolkit.b(yLabel, (Element)node, graphMLParseContext);
            }
            object = namedNodeMap.getNamedItem("userdata");
            Node node3 = namedNodeMap.getNamedItem("userdataclass");
            if (object != null && node3 != null) {
                String string = object.getNodeValue();
                String string2 = node3.getNodeValue();
                try {
                    Object object2 = ObjectStringConversion.getInstance().convertToObject(string, Class.forName(string2));
                    yLabel.setUserData(object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    String string3 = "Could not parse userdata " + string + ": " + illegalArgumentException.getMessage();
                    if (GraphicsSerializationToolkit.getBooleanDeserializationProperty(graphMLParseContext, "y.io.graphml.graph2d.UserDataSupport.IGNORE_STRING_CONVERSION_ERRORS")) {
                        D.bug(string3);
                        if (n2 == 0) break block59;
                    }
                    throw new GraphMLParseException(string3, illegalArgumentException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string4 = "Could not parse userdata " + string + ": " + classNotFoundException.getMessage();
                    if (GraphicsSerializationToolkit.getBooleanDeserializationProperty(graphMLParseContext, "y.io.graphml.graph2d.UserDataSupport.IGNORE_STRING_CONVERSION_ERRORS")) {
                        D.bug(string4);
                        if (n2 == 0) break block59;
                    }
                    throw new GraphMLParseException(string4, classNotFoundException);
                }
            }
        }
    }

    static Icon b(Node node, String string, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(string);
        if (node2 != null) {
            return GraphicsSerializationToolkit.b(node2.getNodeValue(), graphMLParseContext);
        }
        node2 = namedNodeMap.getNamedItem("image");
        if (node2 != null) {
            Image image = GraphicsSerializationToolkit.readSharedImageReference(node2.getNodeValue(), graphMLParseContext);
            if (image != null) {
                return new ImageIcon(image);
            }
        } else {
            node2 = namedNodeMap.getNamedItem("iconData");
            if (node2 != null) {
                return (Icon)GraphicsSerializationToolkit.readSharedReference(node2.getNodeValue(), graphMLParseContext, class$javax$swing$Icon == null ? (class$javax$swing$Icon = GraphicsSerializationToolkit.class$("javax.swing.Icon")) : class$javax$swing$Icon);
            }
        }
        return null;
    }

    public static Color parseColor(String string) {
        return GraphicsSerializationToolkit.parseColor(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color parseColor(String string, boolean bl) {
        int n2 = AbstractNodeRealizerSerializer.z;
        YList yList = b;
        synchronized (yList) {
            Object object;
            block19: {
                block18: {
                    Object object2;
                    block14: {
                        Object object3;
                        int n3;
                        block17: {
                            int n4;
                            block15: {
                                block16: {
                                    if (string.length() < 1 || string.charAt(0) != '#') {
                                        return Color.BLACK;
                                    }
                                    if (string.length() <= 7) break block15;
                                    if (!bl) break block16;
                                    n3 = Integer.parseInt(string.substring(1, 7), 16);
                                    n4 = Integer.parseInt(string.substring(7), 16);
                                    n3 += (n4 & 0xFF) << 24;
                                    if (n2 == 0) break block17;
                                }
                                n3 = Integer.parseInt(string.substring(3), 16);
                                n4 = Integer.parseInt(string.substring(1, 3), 16);
                                n3 += (n4 & 0xFF) << 24;
                                if (n2 == 0) break block17;
                            }
                            n4 = Integer.parseInt(string.substring(1), 16);
                            n3 = n4 + -16777216;
                        }
                        for (object = b.firstCell(); object != null; object = ((ListCell)object).succ()) {
                            object2 = (Color)((ListCell)object).getInfo();
                            object3 = object2;
                            if (n2 == 0) {
                                if (((Color)object3).getRGB() != n3) continue;
                                b.removeCell((ListCell)object);
                                b.addFirstCell((ListCell)object);
                                return object2;
                            }
                            break block14;
                        }
                        object3 = object = new Color(n3, true);
                    }
                    if (b.size() < 32) break block18;
                    object2 = b.lastCell();
                    b.removeCell((ListCell)object2);
                    ((ListCell)object2).setInfo(object);
                    b.addFirstCell((ListCell)object2);
                    if (n2 == 0) break block19;
                }
                b.addFirst(object);
            }
            return object;
        }
    }

    private static byte d(String string) {
        if ("left".equals(string)) {
            return 8;
        }
        if ("right".equals(string)) {
            return 16;
        }
        if ("left_aligned".equals(string)) {
            return 32;
        }
        if ("right_aligned".equals(string)) {
            return 64;
        }
        return 2;
    }

    private static byte c(String string) {
        if ("top".equals(string)) {
            return 1;
        }
        if ("center".equals(string)) {
            return 2;
        }
        return 4;
    }

    private static String c(byte by) {
        switch (by) {
            case 8: {
                return "left";
            }
            case 16: {
                return "right";
            }
            case 2: {
                return "center";
            }
            case 32: {
                return "left_aligned";
            }
            case 64: {
                return "right_aligned";
            }
        }
        return "center";
    }

    private static String b(byte by) {
        switch (by) {
            case 1: {
                return "top";
            }
            case 4: {
                return "bottom";
            }
            case 2: {
                return "center";
            }
        }
        return "bottom";
    }

    public static void writeSharedReference(Object object, XmlWriter xmlWriter, String string, GraphMLWriteContext graphMLWriteContext) {
        ResourceDescriptor resourceDescriptor;
        if (graphMLWriteContext == null || object == null) {
            return;
        }
        ResourceSerializationHandler resourceSerializationHandler = (ResourceSerializationHandler)graphMLWriteContext.lookup(class$y$io$graphml$graph2d$ResourceSerializationHandler == null ? (class$y$io$graphml$graph2d$ResourceSerializationHandler = GraphicsSerializationToolkit.class$("y.io.graphml.graph2d.ResourceSerializationHandler")) : class$y$io$graphml$graph2d$ResourceSerializationHandler);
        if (resourceSerializationHandler != null && (resourceDescriptor = resourceSerializationHandler.registerResource(object, null)) != null) {
            xmlWriter.writeAttribute(string, resourceDescriptor.getId());
        }
    }

    public static void writeSharedImageReference(Image image, XmlWriter xmlWriter, String string, GraphMLWriteContext graphMLWriteContext) {
        ResourceDescriptor resourceDescriptor;
        if (graphMLWriteContext == null || image == null) {
            return;
        }
        ResourceSerializationHandler resourceSerializationHandler = (ResourceSerializationHandler)graphMLWriteContext.lookup(class$y$io$graphml$graph2d$ResourceSerializationHandler == null ? (class$y$io$graphml$graph2d$ResourceSerializationHandler = GraphicsSerializationToolkit.class$("y.io.graphml.graph2d.ResourceSerializationHandler")) : class$y$io$graphml$graph2d$ResourceSerializationHandler);
        if (resourceSerializationHandler != null && (resourceDescriptor = resourceSerializationHandler.registerResource(image, Graph2DGraphMLHandler._h.d(), image.getClass().getName())) != null) {
            xmlWriter.writeAttribute(string, resourceDescriptor.getId());
        }
    }

    public static Object readSharedReference(String string, GraphMLParseContext graphMLParseContext, Class clazz) throws GraphMLParseException {
        if (graphMLParseContext == null) {
            return null;
        }
        ResourceDeserializationHandler resourceDeserializationHandler = (ResourceDeserializationHandler)graphMLParseContext.lookup(class$y$io$graphml$graph2d$ResourceDeserializationHandler == null ? (class$y$io$graphml$graph2d$ResourceDeserializationHandler = GraphicsSerializationToolkit.class$("y.io.graphml.graph2d.ResourceDeserializationHandler")) : class$y$io$graphml$graph2d$ResourceDeserializationHandler);
        if (resourceDeserializationHandler != null) {
            return resourceDeserializationHandler.getResourceForID(string, null, clazz, graphMLParseContext);
        }
        return null;
    }

    public static Image readSharedImageReference(String string, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        if (graphMLParseContext == null) {
            return null;
        }
        ResourceDeserializationHandler resourceDeserializationHandler = (ResourceDeserializationHandler)graphMLParseContext.lookup(class$y$io$graphml$graph2d$ResourceDeserializationHandler == null ? (class$y$io$graphml$graph2d$ResourceDeserializationHandler = GraphicsSerializationToolkit.class$("y.io.graphml.graph2d.ResourceDeserializationHandler")) : class$y$io$graphml$graph2d$ResourceDeserializationHandler);
        if (resourceDeserializationHandler != null) {
            return (Image)resourceDeserializationHandler.getResourceForID(string, Graph2DGraphMLHandler._c.c(), null, graphMLParseContext);
        }
        return null;
    }

    public static boolean getBooleanSerializationProperty(GraphMLWriteContext graphMLWriteContext, Object object) {
        return GraphMLWriter.getBooleanSerializationProperty(graphMLWriteContext, object);
    }

    public static boolean getBooleanDeserializationProperty(GraphMLParseContext graphMLParseContext, Object object) {
        return GraphMLParser.getBooleanDeserializationProperty(graphMLParseContext, object);
    }

    public static String getInnerText(Node node) {
        return GraphMLParser.getInnerText(node);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        b.add(Color.BLACK);
        b.add(Color.RED);
        b.add(Color.BLUE);
        b.add(Color.YELLOW);
        b.add(Color.GREEN);
        b.add(Color.WHITE);
    }

    private static final class _b
    extends e {
        private boolean l = true;

        _b(XmlWriter xmlWriter) {
            super(xmlWriter);
        }

        void b(String string, String string2, String string3) {
            if (this.l) {
                this.l = false;
                this.i.writeAttribute("reversedPathRendering", "true");
            }
        }
    }

    static interface _c {
        public boolean b(YLabel var1, Node var2, GraphMLParseContext var3);
    }
}

