/*
 * Decompiled with CFR 0.152.
 */
package y.io.graphml.graph2d;

import org.w3c.dom.Node;
import y.base.Graph;
import y.io.graphml.graph2d.AbstractEdgeRealizerSerializer;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.input.GraphMLParseContext;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.GraphMLWriteException;
import y.io.graphml.output.XmlWriter;
import y.util.D;
import y.view.EdgeRealizer;
import y.view.Graph2D;

public final class FallbackEdgeRealizerSerializer
extends AbstractEdgeRealizerSerializer {
    private static final FallbackEdgeRealizerSerializer d = new FallbackEdgeRealizerSerializer();

    private FallbackEdgeRealizerSerializer() {
    }

    public static FallbackEdgeRealizerSerializer getInstance() {
        return d;
    }

    public String getName() {
        return "FallbackEdgeRealizer";
    }

    public String getNamespaceURI() {
        return "http://www.yworks.com/xml/graphml";
    }

    public Class getRealizerClass() {
        return null;
    }

    public void parse(EdgeRealizer edgeRealizer, Node node, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        D.bug("Using FallbackEdgeRealizerSerializer for unknown element " + node.getNamespaceURI() + ":" + node.getLocalName());
        super.parse(edgeRealizer, node, graphMLParseContext);
    }

    public void write(EdgeRealizer edgeRealizer, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        super.write(edgeRealizer, xmlWriter, graphMLWriteContext);
        xmlWriter.writeComment("FallbackEdgeRealizerSerializer for unknown EdgeRealizer " + edgeRealizer.getClass());
        D.bug("Using FallbackEdgeRealizerSerializer for unknown EdgeRealizer " + edgeRealizer.getClass());
    }

    public boolean canHandle(EdgeRealizer edgeRealizer, GraphMLWriteContext graphMLWriteContext) {
        return GraphicsSerializationToolkit.getBooleanSerializationProperty(graphMLWriteContext, "y.io.graphml.output.SerializationProperties.IGNORE_UNKNOWN_REALIZERS");
    }

    public EdgeRealizer createRealizerInstance(Node node, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        Graph graph = graphMLParseContext.getGraph();
        if (graph instanceof Graph2D) {
            return ((Graph2D)graph).getDefaultEdgeRealizer().createCopy();
        }
        return super.createRealizerInstance(node, graphMLParseContext);
    }
}

