/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import y.io.gml.GMLEncoder;
import y.io.gml.ItemParser;
import y.util.D;

public class GMLTokenizer {
    private Callback b;
    protected static final int OPEN = 0;
    protected static final int CLOSE = 1;
    protected static final int AMPERSAND = 2;
    protected static final int QUOTE = 3;
    protected static final int WHITESPACE = 4;
    protected static final int LETTER = 5;
    protected static final int DIGIT = 6;
    protected static final int EOF = 7;
    protected static final int NEWLINE = 8;
    protected static final int COMMENT = 9;
    protected static final int UNKNOWN = -1;

    public GMLTokenizer() {
        this(null);
    }

    public GMLTokenizer(Callback callback) {
        this.setCallback(callback);
    }

    public void parse(Reader reader) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        PushbackReader pushbackReader = new PushbackReader(lineNumberReader);
        try {
            this.parse(pushbackReader);
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Parse error at line " + (lineNumberReader.getLineNumber() + 1) + ": " + iOException.getMessage());
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    protected int lookAhead(PushbackReader pushbackReader) throws IOException {
        int n2 = pushbackReader.read();
        if (n2 == -1) {
            return 7;
        }
        pushbackReader.unread(n2);
        return this.classify((char)n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void parse(PushbackReader pushbackReader) throws IOException {
        int n2;
        block11: {
            boolean bl = ItemParser.z;
            n2 = this.lookAhead(pushbackReader);
            while (n2 == 9) {
                this.parseComment(pushbackReader);
                n2 = this.lookAhead(pushbackReader);
                if (bl) return;
                if (!bl) continue;
            }
            block1: while (n2 != 7) {
                n2 = this.lookAhead(pushbackReader);
                if (n2 == 4) {
                    this.parseWhiteSpace(pushbackReader);
                    if (!bl) continue;
                }
                if (n2 == 8) {
                    this.parseWhiteSpace(pushbackReader);
                    n2 = this.lookAhead(pushbackReader);
                    do {
                        if (n2 != 9) continue block1;
                        this.parseComment(pushbackReader);
                        n2 = this.lookAhead(pushbackReader);
                        if (bl) return;
                    } while (!bl);
                }
                if (n2 == 5) {
                    Object object;
                    String string = this.parseKey(pushbackReader);
                    this.parseWhiteSpace(pushbackReader);
                    n2 = this.lookAhead(pushbackReader);
                    if (n2 == 0) {
                        this.b.beginScope(string);
                        pushbackReader.read();
                        this.parse(pushbackReader);
                        this.b.endScope(string);
                        if (!bl) continue;
                    }
                    if ((object = this.parseValue(pushbackReader)) instanceof String) {
                        this.b.attribute(string, (String)object);
                        if (!bl) continue;
                    }
                    if (!(object instanceof Number)) continue;
                    this.b.attribute(string, (Number)object);
                    if (!bl) {
                        continue;
                    }
                }
                break block11;
            }
            return;
        }
        if (n2 == 1) {
            pushbackReader.read();
            return;
        }
        if (n2 == -1) {
            throw new IOException("ParseException, did not find LETTER, EOF or ] but '" + (char)pushbackReader.read() + '\'');
        }
        if (n2 != 7) throw new IOException("Malformed GML! Did not find LETTER, EOF or ] but '" + (char)pushbackReader.read() + '\'');
    }

    protected int classify(char c2) {
        switch (c2) {
            case '[': {
                return 0;
            }
            case ']': {
                return 1;
            }
            case '&': {
                return 2;
            }
            case '\"': {
                return 3;
            }
            case '#': {
                return 9;
            }
            case '+': 
            case '-': 
            case '.': {
                return 6;
            }
            case '\n': 
            case '\f': 
            case '\r': {
                return 8;
            }
        }
        if (Character.isWhitespace(c2)) {
            return 4;
        }
        if (Character.isDigit(c2)) {
            return 6;
        }
        if (Character.isLetter(c2)) {
            return 5;
        }
        return -1;
    }

    protected void parseWhiteSpace(PushbackReader pushbackReader) throws IOException {
        boolean bl = ItemParser.z;
        int n2 = pushbackReader.read();
        while (n2 != -1) {
            int n3;
            block7: {
                n3 = this.classify((char)n2);
                if (n3 == 4) {
                    n2 = pushbackReader.read();
                    if (!bl) continue;
                }
                if (n3 == 8) {
                    while (n3 == 8) {
                        n2 = pushbackReader.read();
                        n3 = this.classify((char)n2);
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block7;
                    }
                    if (n3 == 9) {
                        pushbackReader.unread(n2);
                        this.parseComment(pushbackReader);
                        n2 = pushbackReader.read();
                        if (!bl) continue;
                    }
                }
            }
            if (n3 == 4) continue;
        }
        if (n2 != -1) {
            pushbackReader.unread(n2);
        }
    }

    protected void parseComment(PushbackReader pushbackReader) throws IOException {
        boolean bl = ItemParser.z;
        int n2 = pushbackReader.read();
        if ((char)n2 != '#') {
            throw new IOException("ParseException: expected # but found: " + n2);
        }
        n2 = pushbackReader.read();
        int n3 = this.classify((char)n2);
        while (n3 != 8 && n3 != 7) {
            n2 = pushbackReader.read();
            n3 = this.classify((char)n2);
            if (!bl) continue;
        }
        pushbackReader.unread(n2);
    }

    protected String parseKey(PushbackReader pushbackReader) throws IOException {
        int n2;
        int n3;
        StringBuffer stringBuffer;
        block3: {
            boolean bl = ItemParser.z;
            stringBuffer = new StringBuffer(20);
            n3 = pushbackReader.read();
            while (n3 != -1) {
                n2 = Character.isWhitespace((char)n3) ? 1 : 0;
                if (!bl) {
                    if (n2 != 0) break;
                    stringBuffer.append((char)n3);
                    n3 = pushbackReader.read();
                    if (!bl) continue;
                }
                break block3;
            }
            n2 = n3;
        }
        if (n2 != -1) {
            pushbackReader.unread(n3);
        }
        return stringBuffer.toString();
    }

    protected Object parseValue(PushbackReader pushbackReader) throws IOException {
        int n2 = this.lookAhead(pushbackReader);
        if (n2 == 3) {
            return this.parseString(pushbackReader);
        }
        if (n2 == 0) {
            return this.parseList(pushbackReader);
        }
        if (n2 == 6) {
            return this.parseNumber(pushbackReader);
        }
        throw new IOException("ParseException, did not find QUOTE, OPEN or DIGIT but '" + Character.toString((char)pushbackReader.read()) + "'");
    }

    protected Number parseNumber(PushbackReader pushbackReader) throws IOException {
        boolean bl;
        StringBuffer stringBuffer;
        block7: {
            boolean bl2 = ItemParser.z;
            stringBuffer = new StringBuffer(10);
            int n2 = pushbackReader.read();
            boolean bl3 = true;
            while (!Character.isWhitespace((char)n2)) {
                bl = bl3;
                if (!bl2) {
                    if (bl) {
                        switch (n2) {
                            case 43: 
                            case 46: 
                            case 69: 
                            case 101: {
                                bl3 = false;
                            }
                        }
                    }
                    stringBuffer.append((char)n2);
                    n2 = pushbackReader.read();
                    if (!bl2) continue;
                }
                break block7;
            }
            pushbackReader.unread(n2);
            bl = bl3;
        }
        if (bl) {
            return new Integer(stringBuffer.toString());
        }
        return new Double(stringBuffer.toString());
    }

    protected String parseString(PushbackReader pushbackReader) throws IOException {
        int n2 = pushbackReader.read();
        if ((char)n2 != '\"') {
            throw new IOException("Expected \" but found " + n2);
        }
        String string = this.parseInString(pushbackReader);
        n2 = pushbackReader.read();
        if ((char)n2 != '\"') {
            throw new IOException("Expected \" but found " + n2);
        }
        return string;
    }

    protected String parseInString(PushbackReader pushbackReader) throws IOException {
        boolean bl = ItemParser.z;
        StringBuffer stringBuffer = new StringBuffer(20);
        int n2 = pushbackReader.read();
        while ((char)n2 != '\"' && n2 != -1) {
            if ((char)n2 == '&') {
                pushbackReader.unread(n2);
                n2 = this.parseEntity(pushbackReader);
            }
            stringBuffer.append((char)n2);
            n2 = pushbackReader.read();
            if (!bl) continue;
        }
        pushbackReader.unread(n2);
        return stringBuffer.toString();
    }

    protected char parseEntity(PushbackReader pushbackReader) throws IOException {
        boolean bl = ItemParser.z;
        int n2 = pushbackReader.read();
        if ((char)n2 != '&') {
            throw new IOException("Expected & but found " + n2);
        }
        n2 = pushbackReader.read();
        StringBuffer stringBuffer = new StringBuffer(20);
        while ((char)n2 != ';' && n2 != -1) {
            if (Character.isLetterOrDigit((char)n2) || (char)n2 == '#') {
                stringBuffer.append((char)n2);
                n2 = pushbackReader.read();
                if (!bl) continue;
            }
            throw new IOException("Expected #, letter, digit or ; but found '" + (char)n2 + "'");
        }
        String string = stringBuffer.toString();
        if (string.equals("#13")) {
            return '\n';
        }
        if (string.equals("para")) {
            return '\n';
        }
        if (string.equals("amp")) {
            return '&';
        }
        if (string.equals("quot")) {
            return '\"';
        }
        if (string.startsWith("#x")) {
            String string2 = string.substring(2);
            return (char)Integer.parseInt(string2, 16);
        }
        if (string.startsWith("#0x")) {
            String string3 = string.substring(3);
            return (char)Integer.parseInt(string3, 16);
        }
        if (string.startsWith("#")) {
            String string4 = string.substring(1);
            return (char)Integer.parseInt(string4);
        }
        return '?';
    }

    protected List parseList(PushbackReader pushbackReader) throws IOException {
        return new ArrayList(0);
    }

    public Callback getCallback() {
        return this.b;
    }

    public void setCallback(Callback callback) {
        this.b = callback;
    }

    public static final class EncoderCallback
    implements Callback {
        private GMLEncoder b;

        public EncoderCallback(GMLEncoder gMLEncoder) {
            this.b = gMLEncoder;
        }

        public void beginScope(String string) {
            try {
                this.b.beginSection(string);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void endScope(String string) {
            try {
                this.b.endSection();
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void attribute(String string, String string2) {
            try {
                this.b.addAttribute(string, string2);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }

        public void attribute(String string, Number number) {
            try {
                this.b.addAttribute(string, number);
            }
            catch (IOException iOException) {
                D.trace(iOException);
            }
        }
    }

    public static final class DebugCallback
    implements Callback {
        public void beginScope(String string) {
            System.out.println("begin scope " + string);
        }

        public void endScope(String string) {
            System.out.println("end scope " + string);
        }

        public void attribute(String string, String string2) {
            System.out.println("string attribute " + string + " => " + string2);
        }

        public void attribute(String string, Number number) {
            System.out.println("Number attribute " + string + " => " + number);
        }
    }

    public static interface Callback {
        public void beginScope(String var1);

        public void endScope(String var1);

        public void attribute(String var1, String var2);

        public void attribute(String var1, Number var2);
    }
}

