/*
 * Decompiled with CFR 0.152.
 */
package y.io.gml;

import y.io.gml.EdgeParser;
import y.io.gml.GMLTokenizer;
import y.io.gml.GraphParser;
import y.io.gml.HierarchicGraphParser;
import y.io.gml.HierarchyNodeParser;
import y.io.gml.InterEdgeParser;
import y.io.gml.ItemParser;
import y.io.gml.ParserFactory;
import y.view.Graph2D;

public class DefaultHierarchicParserFactory
implements ParserFactory {
    public GMLTokenizer.Callback createEdgeParser(Graph2D graph2D, GMLTokenizer.Callback callback) {
        GraphParser graphParser = (GraphParser)callback;
        EdgeParser edgeParser = new EdgeParser(graph2D, graphParser.id2Node, graphParser.id2Edge);
        return edgeParser;
    }

    public GMLTokenizer.Callback createGMLParser(Graph2D graph2D) {
        ItemParser itemParser = new ItemParser();
        itemParser.addChild("graph", (ItemParser)this.createGraphParser(graph2D, itemParser));
        return itemParser;
    }

    public GMLTokenizer.Callback createGraphParser(Graph2D graph2D, GMLTokenizer.Callback callback) {
        HierarchicGraphParser hierarchicGraphParser = new HierarchicGraphParser(graph2D);
        hierarchicGraphParser.addChild("node", (ItemParser)this.createNodeParser(graph2D, hierarchicGraphParser));
        hierarchicGraphParser.addChild("edge", (ItemParser)this.createEdgeParser(graph2D, hierarchicGraphParser));
        hierarchicGraphParser.addChild("interedge", (ItemParser)this.createInterEdgeParser(graph2D, hierarchicGraphParser));
        return hierarchicGraphParser;
    }

    public GMLTokenizer.Callback createInterEdgeParser(Graph2D graph2D, HierarchicGraphParser hierarchicGraphParser) {
        InterEdgeParser interEdgeParser = new InterEdgeParser(graph2D, hierarchicGraphParser.id2Edge, hierarchicGraphParser);
        return interEdgeParser;
    }

    public GMLTokenizer.Callback createNodeParser(Graph2D graph2D, GMLTokenizer.Callback callback) {
        HierarchicGraphParser hierarchicGraphParser = (HierarchicGraphParser)callback;
        HierarchyNodeParser hierarchyNodeParser = new HierarchyNodeParser(graph2D, hierarchicGraphParser.id2Node, hierarchicGraphParser, this);
        return hierarchyNodeParser;
    }
}

