/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import y.io.GraphMLIOHandler;
import y.io.IOHandler;
import y.view.Graph2D;

public class XmlXslIOHandler
extends IOHandler {
    private GraphMLIOHandler b;
    private Source c;

    public XmlXslIOHandler() {
        this(new GraphMLIOHandler());
    }

    public XmlXslIOHandler(GraphMLIOHandler graphMLIOHandler) {
        this.setReaderDelegate(graphMLIOHandler);
    }

    public String getFileFormatString() {
        return "XML + XSL";
    }

    public String getFileNameExtension() {
        return "";
    }

    public boolean canWrite() {
        return false;
    }

    public void setXslSource(Source source) {
        this.c = source;
    }

    public Source getXslSource() {
        return this.c;
    }

    public void setReaderDelegate(GraphMLIOHandler graphMLIOHandler) {
        this.b = graphMLIOHandler;
    }

    public IOHandler getReaderDelegate() {
        return this.b;
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("Write not supported");
    }

    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        if (this.b == null) {
            throw new IllegalStateException("No reader delegate set.");
        }
        if (this.c == null) {
            throw new IllegalStateException("No XSL source set.");
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(this.c);
            StreamSource streamSource = new StreamSource(inputStream);
            DOMResult dOMResult = new DOMResult();
            transformer.transform(streamSource, dOMResult);
            this.b.read(graph2D, (Document)dOMResult.getNode());
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException("TransformerConfigurationException:" + transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new IOException("TransformerException:" + transformerException.getMessage());
        }
    }
}

