/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.InputSource;
import y.io.GMLIOHandler;
import y.io.gml.EncoderFactory;
import y.io.gml.GMLEncoder;
import y.io.gml.GMLTokenizer;
import y.io.gml.ObjectEncoder;
import y.io.gml.XGMLEncoder;
import y.io.gml.XGMLTokenizer;
import y.util.D;
import y.view.Graph2D;

public class XGMLIOHandler
extends GMLIOHandler {
    public String getFileFormatString() {
        return "GML/XML Format";
    }

    public String getFileNameExtension() {
        return "xgml";
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        XGMLEncoder xGMLEncoder = new XGMLEncoder(printWriter);
        EncoderFactory encoderFactory = XGMLIOHandler.getEncoderFactory();
        ObjectEncoder objectEncoder = encoderFactory.createGMLEncoder();
        D.bug(this, (Object)"saving in xgml format....");
        ((GMLEncoder)xGMLEncoder).beginSection("xgml");
        objectEncoder.encode(graph2D, xGMLEncoder);
        ((GMLEncoder)xGMLEncoder).endSection();
        printWriter.flush();
    }

    protected void read(Graph2D graph2D, Reader reader) throws IOException {
        GMLTokenizer.Callback callback = XGMLIOHandler.getParserFactory().createGMLParser(graph2D);
        XGMLTokenizer xGMLTokenizer = new XGMLTokenizer(callback);
        xGMLTokenizer.parse(new InputSource(reader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        graph2D.firePreEvent();
        try {
            this.b(graph2D, new InputSource(inputStream));
        }
        finally {
            graph2D.firePostEvent();
        }
    }

    private void b(Graph2D graph2D, InputSource inputSource) throws IOException {
        GMLTokenizer.Callback callback = XGMLIOHandler.getParserFactory().createGMLParser(graph2D);
        XGMLTokenizer xGMLTokenizer = new XGMLTokenizer(callback);
        xGMLTokenizer.parse(inputSource);
    }

    public void read(Graph2D graph2D, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        URL uRL = graph2D.getURL();
        graph2D.setURL(new File(string).toURL());
        try {
            this.read(graph2D, fileInputStream);
        }
        catch (IOException iOException) {
            graph2D.setURL(uRL);
            throw iOException;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }
}

