/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import y.base.Graph;
import y.io.IOHandler;
import y.view.Graph2D;
import y.view.Graph2DView;

public class TiledImageOutputHandler
extends IOHandler {
    private IOHandler gb;
    private int jb = 1;
    private int kb = 1;
    private int ib = Integer.MAX_VALUE;
    private int hb = Integer.MAX_VALUE;
    private boolean fb = false;
    private boolean eb = false;

    public TiledImageOutputHandler(IOHandler iOHandler) {
        this.gb = iOHandler;
    }

    public String getFileFormatString() {
        return this.gb.getFileFormatString();
    }

    public void setHTMLTableGenerationActive(boolean bl) {
        this.eb = bl;
    }

    public boolean isHTMLTableGenerationActive() {
        return this.eb;
    }

    public void setMaximumTileSize(int n2, int n3) {
        this.ib = n2;
        this.hb = n3;
        this.fb = true;
    }

    public void setRowCount(int n2) {
        this.jb = n2;
        this.fb = false;
    }

    public void setColumnCount(int n2) {
        this.kb = n2;
        this.fb = false;
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return this.gb.canWrite();
    }

    public void write(Graph2D graph2D, String string) throws IOException {
        int n2;
        String string2;
        block10: {
            int n3;
            int n4;
            double d2;
            int n5;
            int n6;
            int n7;
            int n8;
            Graph2DView graph2DView;
            URL uRL;
            int n9;
            block12: {
                block11: {
                    n9 = IOHandler.z;
                    uRL = graph2D.getURL();
                    graph2DView = (Graph2DView)graph2D.getCurrentView();
                    if (graph2DView == null) {
                        throw new IllegalArgumentException("graph has no associated Graph2DView");
                    }
                    n8 = graph2DView.getViewPoint().x;
                    n7 = graph2DView.getViewPoint().y;
                    n6 = graph2DView.getWidth();
                    n5 = graph2DView.getHeight();
                    d2 = graph2DView.getZoom();
                    if (this.fb) break block11;
                    this.ib = (int)Math.ceil((double)n6 / (double)this.kb);
                    this.hb = (int)Math.ceil((double)n5 / (double)this.jb);
                    n4 = this.ib;
                    n3 = this.hb;
                    if (n9 == 0) break block12;
                    int n10 = Graph.z;
                    Graph.z = ++n10;
                }
                this.kb = (int)Math.ceil((double)n6 / (double)this.ib);
                this.jb = (int)Math.ceil((double)n5 / (double)this.hb);
                n4 = Math.min(this.ib, (int)Math.ceil((double)n6 / (double)this.kb));
                n3 = Math.min(this.hb, (int)Math.ceil((double)n5 / (double)this.jb));
            }
            graph2DView.setSize(n4, n3);
            int n11 = this.gb != null ? string.lastIndexOf(this.gb.getFileNameExtension()) - 1 : string.length();
            string2 = string.substring(0, n11).replace(File.separatorChar, '/');
            int n12 = 0;
            int n13 = 0;
            int n14 = this.kb - (this.kb * n4 - n6);
            int n15 = this.jb - (this.jb * n3 - n5);
            int n16 = n4;
            double d3 = (double)n8 * d2;
            block0: while (true) {
                int n17 = n12;
                block1: while (n17 < this.kb) {
                    n13 = 0;
                    n2 = n14;
                    if (n9 != 0) break block10;
                    if (n2 == 0 && n16 > 1) {
                        graph2DView.setSize(--n16, n3);
                    }
                    int n18 = n15;
                    int n19 = n3;
                    double d4 = (double)n7 * d2;
                    while (n13 < this.jb) {
                        n17 = n18;
                        if (n9 != 0) continue block1;
                        if (n17 == 0 && n19 > 1) {
                            graph2DView.setSize(n16, --n19);
                        }
                        graph2DView.setViewPoint2D(d3 / d2, d4 / d2);
                        String string3 = this.createTileFileName(graph2D, this.gb, string2, n13, n12);
                        this.writeTile(graph2D, this.gb, string3, n13, n12);
                        d4 += (double)n19;
                        ++n13;
                        --n18;
                        if (n9 == 0) continue;
                    }
                    graph2DView.setSize(n16, n3);
                    d3 += (double)n16;
                    ++n12;
                    --n14;
                    if (n9 == 0) continue block0;
                }
                break;
            }
            graph2DView.setSize(n6, n5);
            graph2DView.setViewPoint(n8, n7);
            graph2D.setURL(uRL);
            n2 = this.isHTMLTableGenerationActive() ? 1 : 0;
        }
        if (n2 != 0) {
            this.b(this.jb, this.kb, string2, this.gb.getFileNameExtension());
        }
    }

    protected void writeTile(Graph2D graph2D, IOHandler iOHandler, String string, int n2, int n3) throws IOException {
        if (iOHandler != null) {
            iOHandler.write(graph2D, string);
        }
    }

    protected String createTileFileName(Graph2D graph2D, IOHandler iOHandler, String string, int n2, int n3) {
        if (iOHandler != null) {
            return string + (1 + n3) + '_' + (1 + n2) + '.' + iOHandler.getFileNameExtension();
        }
        return string + (1 + n3) + '_' + (1 + n2);
    }

    private void b(int n2, int n3, String string, String string2) throws IOException {
        block3: {
            int n4 = IOHandler.z;
            PrintWriter printWriter = new PrintWriter(new FileWriter(string + ".html"));
            string = string.substring(string.lastIndexOf(47) + 1);
            printWriter.println("<html>");
            printWriter.println("  <head></head>");
            printWriter.println("  <body>");
            printWriter.println("    <table cellspacing=0 cellpadding=0 border=0>");
            int n5 = 0;
            while (n5 < n2) {
                block4: {
                    printWriter.println("      <tr>");
                    printWriter.print("    ");
                    if (n4 != 0) break block3;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        printWriter.println("        <td><img src=\"" + string + (1 + i2) + '_' + (1 + n5) + '.' + string2 + "\"></td>");
                        if (n4 == 0) {
                            if (n4 == 0) continue;
                        }
                        break block4;
                    }
                    printWriter.println("      </tr>");
                    ++n5;
                }
                if (n4 == 0) continue;
            }
            printWriter.println("    </table>");
            printWriter.println("  </body>");
            printWriter.println("</html>");
            printWriter.close();
        }
    }

    public String getFileNameExtension() {
        return this.gb.getFileNameExtension();
    }

    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        this.gb.read(graph2D, inputStream);
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        this.gb.write(graph2D, outputStream);
    }
}

