/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import y.io.ImageOutputHandler;

public class ImageIoOutputHandler
extends ImageOutputHandler {
    private ImageWriter sb;
    private ImageWriteParam qb;
    private boolean rb;

    public ImageIoOutputHandler(ImageWriter imageWriter) {
        this.setImageWriter(imageWriter);
    }

    public boolean isTransparencyEnabled() {
        return this.rb;
    }

    public void setTransparencyEnabled(boolean bl) {
        this.rb = bl;
    }

    public void setImageWriter(ImageWriter imageWriter) {
        if (imageWriter == null) {
            throw new NullPointerException();
        }
        if (this.sb != imageWriter) {
            this.sb = imageWriter;
            this.qb = imageWriter.getDefaultWriteParam();
        }
    }

    public ImageWriter getImageWriter() {
        return this.sb;
    }

    protected void encode(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        ImageIoOutputHandler.b(this.sb, bufferedImage, outputStream, this.getImageWriteParam());
    }

    public String getFileNameExtension() {
        String[] stringArray = this.sb.getOriginatingProvider().getFileSuffixes();
        return stringArray == null || stringArray.length < 1 ? "bin" : stringArray[0];
    }

    public String getFileFormatString() {
        return this.sb.getOriginatingProvider().getDescription(Locale.getDefault());
    }

    protected BufferedImage createImage(int n2, int n3) {
        if (this.isTransparencyEnabled()) {
            return new BufferedImage(n2, n3, 2);
        }
        return new BufferedImage(n2, n3, 1);
    }

    public ImageWriteParam getImageWriteParam() {
        return this.qb;
    }

    public void setImageWriteParam(ImageWriteParam imageWriteParam) {
        if (imageWriteParam == null) {
            throw new NullPointerException();
        }
        this.qb = imageWriteParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void b(ImageWriter imageWriter, BufferedImage bufferedImage, OutputStream outputStream, ImageWriteParam imageWriteParam) throws IOException {
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        try {
            imageWriter.setOutput(imageOutputStream);
            imageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        }
        finally {
            imageOutputStream.close();
        }
    }

    static ImageWriter d(String string) {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    static String c(String string) {
        return System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " for Java " + System.getProperty("java.version") + " does not support writing " + string + " format.";
    }
}

