/*
 * Decompiled with CFR 0.152.
 */
package y.io;

import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import y.base.ListCell;
import y.base.YList;
import y.io.IOHandler;
import y.io.gml.DefaultHierarchicParserFactory;
import y.io.gml.EncoderFactory;
import y.io.gml.GMLEncoder;
import y.io.gml.GMLTokenizer;
import y.io.gml.HierarchicGraphEncoderFactory;
import y.io.gml.ObjectEncoder;
import y.io.gml.ParserFactory;
import y.util.D;
import y.view.Graph2D;

public class GMLIOHandler
extends IOHandler {
    private static ParserFactory x;
    private static EncoderFactory y;
    private static final YList v;
    private static final int w = 32;

    public String getFileFormatString() {
        return "GML Format";
    }

    public String getFileNameExtension() {
        return "gml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        graph2D.firePreEvent();
        try {
            this.read(graph2D, new InputStreamReader(inputStream));
        }
        finally {
            graph2D.firePostEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Graph2D graph2D, String string) throws IOException {
        graph2D.firePreEvent();
        try {
            this.b(graph2D, string);
        }
        finally {
            graph2D.firePostEvent();
        }
    }

    private void b(Graph2D graph2D, String string) throws IOException {
        URL uRL = graph2D.getURL();
        graph2D.setURL(new File(string).toURL());
        FileReader fileReader = new FileReader(string);
        try {
            this.read(graph2D, fileReader);
        }
        catch (IOException iOException) {
            graph2D.setURL(uRL);
            throw iOException;
        }
        finally {
            ((Reader)fileReader).close();
        }
    }

    protected void read(Graph2D graph2D, Reader reader) throws IOException {
        GMLTokenizer.Callback callback = GMLIOHandler.getParserFactory().createGMLParser(graph2D);
        GMLTokenizer gMLTokenizer = new GMLTokenizer(callback);
        gMLTokenizer.parse(reader);
    }

    public static synchronized ParserFactory getParserFactory() {
        if (x == null) {
            x = new DefaultHierarchicParserFactory();
        }
        return x;
    }

    public static synchronized void setParserFactory(ParserFactory parserFactory) {
        x = parserFactory;
    }

    public static synchronized EncoderFactory getEncoderFactory() {
        if (y == null) {
            y = new HierarchicGraphEncoderFactory();
        }
        return y;
    }

    public static synchronized void setEncoderFactory(EncoderFactory encoderFactory) {
        y = encoderFactory;
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        GMLEncoder gMLEncoder = new GMLEncoder(printWriter);
        EncoderFactory encoderFactory = GMLIOHandler.getEncoderFactory();
        ObjectEncoder objectEncoder = encoderFactory.createGMLEncoder();
        D.bug(this, (Object)"saving in gml format....");
        objectEncoder.encode(graph2D, gMLEncoder);
        printWriter.flush();
    }

    public static String convertColor(Color color) {
        StringBuffer stringBuffer;
        block12: {
            int n2;
            String string;
            int n3;
            block11: {
                block10: {
                    block9: {
                        n3 = IOHandler.z;
                        stringBuffer = new StringBuffer(9);
                        stringBuffer.append('#');
                        string = Integer.toHexString(color.getRed()).toUpperCase();
                        for (n2 = 2 - string.length(); n2 > 0; --n2) {
                            stringBuffer.append('0');
                            if (n3 == 0) {
                                if (n3 == 0) continue;
                            }
                            break block9;
                        }
                        stringBuffer.append(string);
                        string = Integer.toHexString(color.getGreen()).toUpperCase();
                    }
                    for (n2 = 2 - string.length(); n2 > 0; --n2) {
                        stringBuffer.append('0');
                        if (n3 == 0) {
                            if (n3 == 0) continue;
                        }
                        break block10;
                    }
                    stringBuffer.append(string);
                    string = Integer.toHexString(color.getBlue()).toUpperCase();
                }
                for (n2 = 2 - string.length(); n2 > 0; --n2) {
                    stringBuffer.append('0');
                    if (n3 == 0) {
                        if (n3 == 0) continue;
                    }
                    break block11;
                }
                stringBuffer.append(string);
            }
            if (color.getAlpha() != 255) {
                string = Integer.toHexString(color.getAlpha()).toUpperCase();
                for (n2 = 2 - string.length(); n2 > 0; --n2) {
                    stringBuffer.append('0');
                    if (n3 == 0) {
                        if (n3 == 0) continue;
                    }
                    break block12;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Color decodeColor(String string) {
        int n2 = IOHandler.z;
        YList yList = v;
        synchronized (yList) {
            Object object;
            block18: {
                block17: {
                    Object object2;
                    block14: {
                        Object object3;
                        int n3;
                        block16: {
                            int n4;
                            block15: {
                                if (string.length() < 1 || string.charAt(0) != '#') {
                                    return Color.black;
                                }
                                if (string.length() <= 7) break block15;
                                n3 = Integer.parseInt(string.substring(1, 7), 16);
                                n4 = Integer.parseInt(string.substring(7), 16);
                                n3 += (n4 & 0xFF) << 24;
                                if (n2 == 0) break block16;
                            }
                            n4 = Integer.parseInt(string.substring(1), 16);
                            n3 = n4 + -16777216;
                        }
                        for (object = v.firstCell(); object != null; object = ((ListCell)object).succ()) {
                            object2 = (Color)((ListCell)object).getInfo();
                            object3 = object2;
                            if (n2 == 0) {
                                if (((Color)object3).getRGB() != n3) continue;
                                v.removeCell((ListCell)object);
                                v.addFirstCell((ListCell)object);
                                return object2;
                            }
                            break block14;
                        }
                        object3 = object = new Color(n3, true);
                    }
                    if (v.size() < 32) break block17;
                    object2 = v.lastCell();
                    v.removeCell((ListCell)object2);
                    ((ListCell)object2).setInfo(object);
                    v.addFirstCell((ListCell)object2);
                    if (n2 == 0) break block18;
                }
                v.addFirst(object);
            }
            return object;
        }
    }

    static {
        v = new YList();
        v.add(Color.black);
        v.add(Color.red);
        v.add(Color.blue);
        v.add(Color.yellow);
        v.add(Color.green);
        v.add(Color.white);
    }
}

