/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import y.geom.YPoint;

public class YVector {
    private double c;
    private double b;

    public YVector(double d2, double d3) {
        this.c = d2;
        this.b = d3;
    }

    public YVector(YVector yVector) {
        this.c = yVector.getX();
        this.b = yVector.getY();
    }

    public YVector(YPoint yPoint, YPoint yPoint2) {
        this.c = yPoint.getX() - yPoint2.getX();
        this.b = yPoint.getY() - yPoint2.getY();
    }

    public YVector(YPoint yPoint) {
        this.c = yPoint.getX();
        this.b = yPoint.getY();
    }

    public YVector(double d2, double d3, double d4, double d5) {
        this.c = d2 - d4;
        this.b = d3 - d5;
    }

    public double getX() {
        return this.c;
    }

    public double getY() {
        return this.b;
    }

    public void norm() {
        if (this.c == 0.0 && this.b == 0.0) {
            return;
        }
        double d2 = this.length();
        this.c /= d2;
        this.b /= d2;
    }

    public YVector rotate(double d2) {
        double d3 = Math.cos(d2) * this.c - Math.sin(d2) * this.b;
        double d4 = Math.sin(d2) * this.c + Math.cos(d2) * this.b;
        return new YVector(d3, d4);
    }

    public void add(YVector yVector) {
        this.c += yVector.getX();
        this.b += yVector.getY();
    }

    public static YVector add(YVector yVector, YVector yVector2) {
        YVector yVector3 = new YVector(yVector);
        yVector3.add(yVector2);
        return yVector3;
    }

    public static YPoint add(YPoint yPoint, YVector yVector) {
        return new YPoint(yPoint.getX() + yVector.getX(), yPoint.getY() + yVector.getY());
    }

    public void scale(double d2) {
        this.c *= d2;
        this.b *= d2;
    }

    public double length() {
        return Math.sqrt(this.c * this.c + this.b * this.b);
    }

    public static boolean rightOf(YVector yVector, YVector yVector2) {
        return yVector.getX() * yVector2.getY() - yVector.getY() * yVector2.getX() > 0.0;
    }

    public static YVector getNormal(YVector yVector) {
        YVector yVector2 = new YVector(yVector.getX(), yVector.getY());
        yVector2.norm();
        return yVector2;
    }

    public static YVector orthoNormal(YVector yVector) {
        double d2 = yVector.length();
        return new YVector(-yVector.getY() / d2, yVector.getX() / d2);
    }

    public static double scalarProduct(YVector yVector, YVector yVector2) {
        return yVector.getX() * yVector2.getX() + yVector.getY() * yVector2.getY();
    }

    public static double angle(YVector yVector, YVector yVector2) {
        double d2;
        block5: {
            double d3;
            block6: {
                boolean bl;
                block4: {
                    bl = YPoint.z;
                    d3 = YVector.scalarProduct(yVector, yVector2) / (yVector.length() * yVector2.length());
                    if (!(d3 > 1.0)) break block4;
                    d2 = Math.acos(1.0);
                    if (!bl) break block5;
                }
                if (!(d3 < -1.0)) break block6;
                d2 = Math.acos(-1.0);
                if (!bl) break block5;
            }
            d2 = Math.acos(Math.min(1.0, d3));
        }
        if (!YVector.rightOf(yVector, yVector2)) {
            d2 = Math.PI * 2 - d2;
        }
        return d2;
    }

    public String toString() {
        return "X: " + this.getX() + " Y: " + this.getY();
    }
}

