/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import y.geom.PlaneObject;
import y.geom.YDimension;
import y.geom.YPoint;

public class YRectangle
extends YDimension
implements PlaneObject {
    public final double x;
    public final double y;
    private YPoint ne;

    public YRectangle() {
        super(0.0, 0.0);
        this.y = 0.0;
        this.x = 0.0;
    }

    public YRectangle(YPoint yPoint, YDimension yDimension) {
        super(yDimension.width, yDimension.height);
        this.x = yPoint.x;
        this.y = yPoint.y;
        this.ne = yPoint;
    }

    public YRectangle(double d2, double d3, double d4, double d5) {
        super(d4, d5);
        this.x = d2;
        this.y = d3;
    }

    public double getManhattanDistance(YRectangle yRectangle) {
        double d2;
        block11: {
            YPoint yPoint;
            YPoint yPoint2;
            block10: {
                YPoint yPoint3;
                YPoint yPoint4;
                boolean bl;
                block9: {
                    block8: {
                        bl = YPoint.z;
                        d2 = 0.0;
                        yPoint2 = new YPoint(this.getX(), this.getY());
                        yPoint4 = new YPoint(this.getX() + this.getWidth(), this.getY() + this.getHeight());
                        yPoint3 = new YPoint(yRectangle.getX(), yRectangle.getY());
                        yPoint = new YPoint(yRectangle.getX() + yRectangle.getWidth(), yRectangle.getY() + yRectangle.getHeight());
                        if (!(yPoint4.getX() < yPoint3.getX())) break block8;
                        d2 += Math.abs(yPoint3.getX() - yPoint4.getX());
                        if (!bl) break block9;
                    }
                    if (yPoint2.getX() > yPoint.getX()) {
                        d2 += Math.abs(yPoint.getX() - yPoint2.getX());
                    }
                }
                if (!(yPoint4.getY() < yPoint3.getY())) break block10;
                d2 += Math.abs(yPoint3.getY() - yPoint4.getY());
                if (!bl) break block11;
            }
            if (yPoint2.getY() > yPoint.getY()) {
                d2 += Math.abs(yPoint.getY() - yPoint2.getY());
            }
        }
        return d2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final YPoint getLocation() {
        if (this.ne == null) {
            this.ne = new YPoint(this.x, this.y);
        }
        return this.ne;
    }

    public YRectangle getBoundingBox() {
        return this;
    }

    public boolean contains(double d2, double d3) {
        return YRectangle.contains(this.x, this.y, this.width, this.height, d2, d3, false);
    }

    public static boolean contains(double d2, double d3, double d4, double d5, double d6, double d7) {
        return YRectangle.contains(d2, d3, d4, d5, d6, d7, false);
    }

    public static boolean contains(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        if (bl) {
            return d6 >= d2 && d6 - d2 <= d4 && d7 >= d3 && d7 - d3 <= d5;
        }
        return d6 >= d2 && d6 - d2 < d4 && d7 >= d3 && d7 - d3 < d5;
    }

    public boolean contains(YPoint yPoint) {
        return this.contains(yPoint.x, yPoint.y);
    }

    public boolean contains(YRectangle yRectangle) {
        return this.contains(yRectangle.x, yRectangle.y, yRectangle.width, yRectangle.height);
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.contains(d2, d3) && this.contains(d2 + d4, d3 + d5);
    }

    public static boolean intersects(YRectangle yRectangle, YRectangle yRectangle2) {
        return yRectangle.x + yRectangle.width > yRectangle2.x && yRectangle.y + yRectangle.height > yRectangle2.y && yRectangle.x < yRectangle2.x + yRectangle2.width && yRectangle.y < yRectangle2.y + yRectangle2.height;
    }

    public String toString() {
        return "[" + this.x + ',' + this.y + ',' + this.width + ',' + this.height + ']';
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.x) >> 1 ^ Double.doubleToLongBits(this.y);
        return super.hashCode() << 1 ^ (int)(l2 ^ l2 >> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof YRectangle)) {
            return false;
        }
        YRectangle yRectangle = (YRectangle)object;
        return yRectangle.x == this.x && yRectangle.y == this.y && yRectangle.width == this.width && yRectangle.height == this.height;
    }

    public int compareTo(Object object) {
        YRectangle yRectangle = (YRectangle)object;
        if (this.x < yRectangle.x) {
            return -1;
        }
        if (this.x > yRectangle.x) {
            return 1;
        }
        if (this.y < yRectangle.y) {
            return -1;
        }
        if (this.y > yRectangle.y) {
            return 1;
        }
        return super.compareTo(object);
    }
}

