/*
 * Decompiled with CFR 0.152.
 */
package y.geom;

import y.geom.YPoint;
import y.geom.YVector;

public class AffineLine {
    private static final double d = 1.0E-5;
    private double c;
    private double b;
    private double e;

    public AffineLine(YPoint yPoint, YVector yVector) {
        this(yPoint, YVector.add(yPoint, yVector));
    }

    public AffineLine(YPoint yPoint, YPoint yPoint2) {
        if (AffineLine.b(yPoint.getX(), yPoint2.getX())) {
            this.c = 1.0;
            this.b = 0.0;
            this.e = -yPoint.getX();
            return;
        }
        this.b = -1.0;
        double d2 = (yPoint2.getY() - yPoint.getY()) / (yPoint2.getX() - yPoint.getX());
        double d3 = yPoint.getY() - yPoint.getX() * d2;
        this.c = d2;
        this.e = d3;
    }

    public double getA() {
        return this.c;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.e;
    }

    public String toString() {
        return "a: " + this.c + " b: " + this.b + " c: " + this.e;
    }

    public YPoint getXProjection(YPoint yPoint) {
        if (AffineLine.b(this.b)) {
            return null;
        }
        double d2 = (-this.c * yPoint.getX() - this.e) / this.b;
        return new YPoint(yPoint.getX(), d2);
    }

    public YPoint getYProjection(YPoint yPoint) {
        if (AffineLine.b(this.c)) {
            return null;
        }
        double d2 = (-this.b * yPoint.getY() - this.e) / this.c;
        return new YPoint(d2, yPoint.getY());
    }

    public static YPoint getCrossing(AffineLine affineLine, AffineLine affineLine2) {
        if (AffineLine.b(affineLine.getA()) && AffineLine.b(affineLine2.getA())) {
            return null;
        }
        if (AffineLine.b(affineLine.getB()) && AffineLine.b(affineLine2.getB())) {
            return null;
        }
        if (AffineLine.b(affineLine2.getB())) {
            AffineLine affineLine3 = affineLine;
            affineLine = affineLine2;
            affineLine2 = affineLine3;
        }
        double d2 = affineLine.getA();
        double d3 = affineLine.getB();
        double d4 = -affineLine.getC();
        if (!AffineLine.b(d2)) {
            double d5 = affineLine2.getB() - affineLine2.getA() / d2 * d3;
            double d6 = -affineLine2.getC() - affineLine2.getA() / d2 * d4;
            double d7 = d6 / d5;
            double d8 = (d4 - d7 * d3) / d2;
            return new YPoint(d8, d7);
        }
        double d9 = d4 / d3;
        double d10 = (affineLine2.getC() + affineLine2.getB() * d9) / -affineLine2.getA();
        return new YPoint(d10, d9);
    }

    private static boolean b(double d2) {
        return AffineLine.b(d2, 0.0);
    }

    private static boolean b(double d2, double d3) {
        return Math.abs(d2 - d3) < 1.0E-5;
    }
}

