/*
 * Decompiled with CFR 0.152.
 */
package y.algo;

import y.algo.AbortHandler;
import y.algo.Bipartitions;
import y.algo.GraphConnectivity;
import y.algo.NodeOrders;
import y.algo.Trees;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.layout.planar.PlanarityTest;

public final class GraphChecker {
    private GraphChecker() {
    }

    public static boolean isAcyclic(Graph graph) {
        return NodeOrders.topological(graph, new int[graph.nodeCount()]);
    }

    public static boolean isCyclic(Graph graph) {
        return !GraphChecker.isAcyclic(graph);
    }

    public static boolean isPlanar(Graph graph) {
        return new PlanarityTest().isPlanar(graph);
    }

    public static boolean isConnected(Graph graph) {
        return GraphConnectivity.isConnected(graph);
    }

    public static boolean isStronglyConnected(Graph graph) {
        return GraphConnectivity.isStronglyConnected(graph);
    }

    public static boolean isBiconnected(Graph graph) {
        return GraphConnectivity.isBiconnected(graph);
    }

    public static boolean isBipartite(Graph graph) {
        return Bipartitions.isBipartite(graph);
    }

    public static boolean isNaryTree(Graph graph, int n2) {
        return Trees.isNaryTree(graph, n2);
    }

    public static boolean isRootedTree(Graph graph) {
        return Trees.isRootedTree(graph);
    }

    public static boolean isTree(Graph graph) {
        return Trees.isTree(graph);
    }

    public static boolean isForest(Graph graph) {
        return Trees.isForest(graph);
    }

    public static boolean isSelfLoopFree(Graph graph) {
        boolean bl;
        block3: {
            int n2 = AbortHandler.z;
            EdgeCursor edgeCursor = graph.edges();
            while (edgeCursor.ok()) {
                bl = edgeCursor.edge().isSelfLoop();
                if (n2 == 0) {
                    if (bl) {
                        return false;
                    }
                    edgeCursor.next();
                    if (n2 == 0) continue;
                }
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isSimple(Graph graph) {
        int n2 = AbortHandler.z;
        int[] nArray = new int[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        do {
            if (!nodeCursor.ok()) return 1 != 0;
            Node node = nodeCursor.node();
            int n3 = node.index();
            int n4 = 1;
            block1: while (true) {
                int n5 = n3 + n4;
                if (n2 != 0) return n5 != 0;
                int n6 = n5;
                NodeCursor nodeCursor2 = node.successors();
                while (nodeCursor2.ok()) {
                    Node node2 = nodeCursor2.node();
                    int n7 = node2.index();
                    n3 = nArray[n7];
                    n4 = n6;
                    if (n2 != 0) continue block1;
                    if (n3 == n4) {
                        return false;
                    }
                    nArray[n7] = n6;
                    nodeCursor2.next();
                    if (n2 == 0) continue;
                }
                break;
            }
            nodeCursor.next();
        } while (n2 == 0);
        return 1 != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMultipleEdgeFree(Graph graph) {
        int n2 = AbortHandler.z;
        int[] nArray = new int[graph.N()];
        NodeCursor nodeCursor = graph.nodes();
        do {
            if (!nodeCursor.ok()) return 1 != 0;
            Node node = nodeCursor.node();
            int n3 = node.index();
            int n4 = 1;
            block1: while (true) {
                int n5 = n3 + n4;
                if (n2 != 0) return n5 != 0;
                int n6 = n5;
                NodeCursor nodeCursor2 = node.neighbors();
                while (nodeCursor2.ok()) {
                    Node node2 = nodeCursor2.node();
                    int n7 = node2.index();
                    n3 = nArray[n7];
                    n4 = n6;
                    if (n2 != 0) continue block1;
                    if (n3 == n4) {
                        return false;
                    }
                    nArray[n7] = n6;
                    nodeCursor2.next();
                    if (n2 == 0) continue;
                }
                break;
            }
            nodeCursor.next();
        } while (n2 == 0);
        return 1 != 0;
    }
}

