/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.startpage;

import com.paterva.maltego.licensing.ApiKeyProvider;
import com.paterva.maltego.licensing.C;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.ui.BusySpinnerPanel;
import com.paterva.maltego.util.ui.fonts.FontUtils;
import com.paterva.maltego.welcome.startpage.HtmlRenderListener;
import com.paterva.maltego.welcome.startpage.StartPageRenderContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public final class StartPageTopComponent
extends TopComponent
implements HtmlRenderListener {
    private static final Logger LOG = Logger.getLogger(StartPageTopComponent.class.getName());
    private static final Logger _cobraLogger = Logger.getLogger("org.lobobrowser");
    private final HtmlPanel _htmlPanel;
    private StartPageRenderContext _renderContext;
    private final JLabel _statusLabel;
    private final JPanel _centerPanel;
    private final BusySpinnerPanel _busyPanel = new BusySpinnerPanel();

    public StartPageTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(StartPageTopComponent.class, (String)"CTL_StartPageTopComponent"));
        this.setToolTipText(NbBundle.getMessage(StartPageTopComponent.class, (String)"HINT_StartPageTopComponent"));
        _cobraLogger.setLevel(Level.WARNING);
        Color bg = UIManager.getLookAndFeelDefaults().getColor("home-main-bg");
        this.setBackground(bg);
        this._centerPanel = new JPanel(new BorderLayout());
        this._centerPanel.setBackground(bg);
        this._htmlPanel = new HtmlPanel();
        this._htmlPanel.setBackground(bg);
        this._statusLabel = new JLabel();
        this._statusLabel.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-description-foreground"));
        this._statusLabel.setHorizontalAlignment(0);
        this._statusLabel.setVerticalAlignment(0);
        this.add(this._centerPanel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public void componentOpened() {
        String url = this.getStartPageURL();
        LOG.log(Level.FINE, "Start Page URL: {0}", url);
        try {
            this._centerPanel.removeAll();
            this._centerPanel.add((Component)this._busyPanel);
            if (this._renderContext != null) {
                this._renderContext.removeListener(this);
            }
            AllowPatervaScriptsUserAgentContext context = new AllowPatervaScriptsUserAgentContext();
            this._renderContext = new StartPageRenderContext(this._htmlPanel, (UserAgentContext)context);
            this._renderContext.addListener(this);
            this._renderContext.showURL(url);
        }
        catch (MalformedURLException ex) {
            this.onError(ex);
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
    }

    @Override
    public void onError(Exception ex) {
        this._statusLabel.setText("<html><center>Could not connect to the Maltego site.<br>Please check your network and proxy settings.</center></html>");
        this._centerPanel.removeAll();
        this._centerPanel.add(this._statusLabel);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void onSuccess() {
        this._centerPanel.removeAll();
        this._centerPanel.add((Component)this._htmlPanel);
        this.increaseFontSizeIfNeeded();
        this.revalidate();
        this.repaint();
    }

    private void increaseFontSizeIfNeeded() {
        String html = this._renderContext.getSourceCode();
        int sizeDiff = FontUtils.getSizeDiff();
        if (html != null && sizeDiff > 0) {
            boolean fontSizeFound = false;
            String pixels = "px";
            Pattern p = Pattern.compile("\\d+" + pixels);
            Matcher m = p.matcher(html);
            while (m.find()) {
                try {
                    String group = m.group();
                    Integer size = Integer.parseInt(group.replace(pixels, ""));
                    if (size >= 40) continue;
                    fontSizeFound = true;
                    html = html.replaceFirst(size + pixels, size + sizeDiff + pixels);
                }
                catch (Exception exception) {}
            }
            if (fontSizeFound) {
                this._htmlPanel.setHtml(html, this.getStartPageURL(), (HtmlRendererContext)this._renderContext);
            }
        }
    }

    private String getStartPageURL() {
        LicenseManager licMan = LicenseManager.A();
        A licMode = licMan.A(false);
        C capabilityValidity = licMode.I();
        String branding = licMan.B(licMode);
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String capabilityStr = "";
        String subscriptionPlan = "";
        String apiKey = ApiKeyProvider.get((A)licMode).orElse("");
        if (capabilityValidity != null) {
            E capability = capabilityValidity.J();
            capabilityStr = Integer.toString(capability.F());
            subscriptionPlan = capability.H();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("https://start-page.paterva.com/maltego/start-page");
        Version.getCurrent().appendToUrl(sb, branding);
        sb.append("&osName=").append(this.encode(osName));
        sb.append("&osVersion=").append(this.encode(osVersion));
        sb.append("&capability=").append(this.encode(capabilityStr));
        sb.append("&subscriptionPlan=").append(this.encode(subscriptionPlan));
        sb.append("&apiKey=").append(this.encode(apiKey));
        String url = sb.toString();
        return url;
    }

    private String encode(String queryParamValue) {
        try {
            return URLEncoder.encode(queryParamValue, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return queryParamValue;
        }
    }

    private static class AllowPatervaScriptsUserAgentContext
    extends SimpleUserAgentContext {
        private AllowPatervaScriptsUserAgentContext() {
        }

        protected Proxy getProxy() {
            return null;
        }

        public String[] getAllowedScriptURIs() {
            return new String[]{"http://www.paterva.com/"};
        }

        public String[] getAllowedScriptFunctions() {
            return null;
        }

        public String[] getAllowedScriptEvents() {
            return null;
        }

        public String[] getAllowedScriptEventFuntionCalls() {
            return null;
        }
    }
}

