/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.reset;

import com.paterva.maltego.util.ui.actions.ActionSupplemental;
import com.pinkmatter.modules.flamingo.Installer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;

@ActionSupplemental(key="description", value="Reset Maltego to a 'freshly installed'/'first run' state.")
public final class FactoryResetAction
implements ActionListener {
    private static boolean _reset = false;

    public static boolean isReset() {
        return _reset;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String msg = "Are you sure you want to reset Maltego to its initial, freshly installed, state?\n\nDoing a Factory Reset will remove all customizations you made after Maltego was installed. It is advisable that you first export your configuration before doing this.\n\nContinue with Factory Reset?";
        if (!this.showConfirmation(msg)) {
            return;
        }
        msg = "Things you will lose when doing a Factory Reset include:\n\t- Installed Transforms (Transform Hub & Local) and their settings\n\t- Window positions and visibility states\n\t- Additions & modifications to\n\t\t* Entities\n\t\t* Machines\n\t\t* Icons\n\t\t* Viewlets\n\t\t* Certificates\n\n(ie. ALL customizations made after installation)\n\nContinue with the Factory Reset?";
        if (!this.showConfirmation(msg)) {
            return;
        }
        _reset = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LifecycleManager lifeCycleManager = LifecycleManager.getDefault();
                lifeCycleManager.markForRestart();
                lifeCycleManager.exit();
            }
        });
    }

    private boolean showConfirmation(String msg) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg);
        nd.setTitle("Factory Reset");
        nd.setMessageType(2);
        nd.setOptionType(1);
        return NotifyDescriptor.Confirmation.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd));
    }

    static {
        Installer.setResetAction((ActionListener)new FactoryResetAction());
    }
}

