/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.home;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.util.ui.actions.ActionSupplemental;
import com.paterva.maltego.welcome.home.HomePanel;
import com.paterva.maltego.welcome.home.HomeSettings;
import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="HomeTopComponent", iconBase="com/paterva/maltego/welcome/resources/StartPage.png", persistenceType=2)
@ActionSupplemental(key="description", value="View the latest Maltego developments and Transform Hub")
public class HomeTopComponent
extends TopComponent {
    private static HomeTopComponent _instance;
    private final JPanel _innerPanel;
    private final JToolBar _toolbar;
    private final Collection<? extends HomePanel> _panels = Lookup.getDefault().lookupAll(HomePanel.class);
    private final HomeSettings _settings = new HomeSettings();
    private List<JSplitPane> _splitPanes;
    private Map<HomePanel, JToggleButton> _toggleButtons;
    private boolean _updatingDividers = false;
    private final DividerListener _dividerListener = new DividerListener();
    private boolean _hasOpened = false;

    public HomeTopComponent() {
        this.setInstance();
        this.setName(NbBundle.getMessage(HomeTopComponent.class, (String)"CTL_HomeTopComponent"));
        this.setToolTipText(NbBundle.getMessage(HomeTopComponent.class, (String)"HINT_HomeTopComponent"));
        this.setLayout(new BorderLayout());
        this._innerPanel = new JPanel(new BorderLayout());
        this._innerPanel.setBackground(UIManager.getLookAndFeelDefaults().getColor("home-main-bg"));
        this._toolbar = new JToolBar();
        this._toolbar.setFloatable(false);
        this._toolbar.setBackground(UIManager.getLookAndFeelDefaults().getColor("editor-tab-selected-bg"));
        this.add(this._innerPanel);
        this.add(this._toolbar, "North");
        this.restoreVisible();
        this.updateToolbar();
        this.update();
        LicenseManager.A().A(ignored -> SwingUtilities.invokeLater(() -> {
            this.updateToolbar();
            this.update();
        }));
    }

    public void open() {
        super.openAtTabPosition(0);
    }

    public void requestActive() {
        super.requestActive();
    }

    public static synchronized HomeTopComponent getInstance() {
        if (_instance == null) {
            return new HomeTopComponent();
        }
        return _instance;
    }

    private void setInstance() {
        if (_instance == null) {
            _instance = this;
        }
    }

    public Image getIcon() {
        return null;
    }

    public final void update() {
        this.updateHomePanels();
        this.restoreSizes();
        this.revalidate();
    }

    public void openTab(String tabName) {
        for (HomePanel homePanel : this._panels) {
            if (!homePanel.getTabName().equals(tabName) || !homePanel.isAllowedToShow() || homePanel.isVisible()) continue;
            this._toggleButtons.get(homePanel).setSelected(true);
            homePanel.setVisible(true);
            this.updateHomePanels();
            this.revalidate();
        }
    }

    public boolean hasOpened() {
        return this._hasOpened;
    }

    public void addNotify() {
        super.addNotify();
        this._hasOpened = true;
    }

    public void removeNotify() {
        this.saveVisible();
        super.removeNotify();
    }

    private void restoreVisible() {
        int panelNum = 0;
        for (HomePanel homePanel : this._panels) {
            homePanel.setVisible(homePanel.isAllowedToShow() && this._settings.isPanelVisible(panelNum++));
        }
    }

    private void saveVisible() {
        int panelNum = 0;
        for (HomePanel homePanel : this._panels) {
            if (!homePanel.isAllowedToShow()) continue;
            this._settings.setPanelVisible(panelNum++, homePanel.isVisible());
        }
    }

    private void saveSizes() {
        if (this._splitPanes != null) {
            int splitPaneNum = 0;
            for (JSplitPane splitPane : this._splitPanes) {
                this._settings.setPanelSize(splitPaneNum++, splitPane.getDividerLocation());
            }
        }
    }

    private void updateToolbar() {
        this._toggleButtons = new HashMap<HomePanel, JToggleButton>(this._panels.size());
        this._toolbar.removeAll();
        for (HomePanel homePanel : this._panels) {
            JToggleButton button = this.createToolbarButton(homePanel);
            button.setEnabled(homePanel.isAllowedToShow());
            button.setSelected(homePanel.isAllowedToShow() && homePanel.isVisible());
            this._toolbar.add(button);
            this._toolbar.add(Box.createHorizontalStrut(1));
            this._toggleButtons.put(homePanel, button);
        }
    }

    private void updateHomePanels() {
        if (this._splitPanes != null) {
            for (JSplitPane splitPane : this._splitPanes) {
                splitPane.removePropertyChangeListener("dividerLocation", this._dividerListener);
            }
        }
        this._innerPanel.removeAll();
        JSplitPane previousSplitter = null;
        HomePanel previousPanel = null;
        this._splitPanes = new ArrayList<JSplitPane>();
        for (HomePanel homePanel : this._panels) {
            if (!homePanel.isAllowedToShow() || !homePanel.isVisible()) continue;
            if (previousPanel != null) {
                JSplitPane splitPane = new JSplitPane(){

                    @Override
                    public void layout() {
                        HomeTopComponent.this._updatingDividers = true;
                        super.layout();
                        HomeTopComponent.this._updatingDividers = false;
                    }
                };
                splitPane.setResizeWeight(0.0);
                this._splitPanes.add(splitPane);
                if (previousSplitter != null) {
                    previousSplitter.setRightComponent(splitPane);
                } else {
                    splitPane.setDividerLocation(previousPanel.getPreferredWidth());
                    this._innerPanel.add(splitPane);
                }
                splitPane.setLeftComponent(previousPanel);
                previousSplitter = splitPane;
            }
            previousPanel = homePanel;
        }
        if (previousPanel != null) {
            if (previousSplitter != null) {
                previousSplitter.setRightComponent(previousPanel);
            } else {
                this._innerPanel.add(previousPanel);
            }
        }
        for (JSplitPane jSplitPane : this._splitPanes) {
            jSplitPane.addPropertyChangeListener("dividerLocation", this._dividerListener);
        }
        this.invalidate();
        this.repaint();
        this._innerPanel.invalidate();
        this._innerPanel.repaint();
    }

    private void restoreSizes() {
        this._updatingDividers = true;
        int splitPaneNum = 0;
        for (JSplitPane splitPane : this._splitPanes) {
            int size;
            if ((size = this._settings.getPanelSize(splitPaneNum++)) <= 0) continue;
            splitPane.setDividerLocation(size);
        }
        this._updatingDividers = false;
    }

    private JToggleButton createToolbarButton(final HomePanel panel) {
        final JToggleButton button = new JToggleButton(panel.getTabName());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                panel.setVisible(button.getModel().isSelected());
                HomeTopComponent.this.updateHomePanels();
                HomeTopComponent.this.revalidate();
            }
        });
        button.setSelected(true);
        return button;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
    }

    private class DividerListener
    implements PropertyChangeListener {
        private DividerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if (!HomeTopComponent.this._updatingDividers && HomeTopComponent.this.isVisible()) {
                HomeTopComponent.this.saveSizes();
            }
        }
    }
}

