/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository.serializer;

import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorSerializer;
import com.paterva.maltego.transform.repository.serializer.TransformSeedStub;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsPropertyStub;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsSerializer;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.serializer.UnresolvedReferenceException;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class TransformSeedSerializer {
    public static TransformSeedSerializer getDefault() {
        TransformSeedSerializer serializer = (TransformSeedSerializer)Lookup.getDefault().lookup(TransformSeedSerializer.class);
        if (serializer == null) {
            serializer = new DefaultTransformSeedSerializer();
        }
        return serializer;
    }

    public abstract void write(TransformSeed var1, OutputStream var2, boolean var3) throws XmlSerializationException;

    public abstract TransformSeed read(InputStream var1) throws XmlSerializationException;

    private static class DefaultTransformSeedSerializer
    extends TransformSeedSerializer {
        private DefaultTransformSeedSerializer() {
        }

        @Override
        public void write(TransformSeed seed, OutputStream stream, boolean isExport) throws XmlSerializationException {
            XmlSerializer serializer = new XmlSerializer();
            TransformSeedStub stub = this.translate(seed, isExport);
            serializer.write((Object)stub, stream);
        }

        @Override
        public TransformSeed read(InputStream stream) throws XmlSerializationException {
            XmlSerializer serializer = new XmlSerializer();
            TransformSeedStub stub = (TransformSeedStub)serializer.read(TransformSeedStub.class, stream);
            return this.translate(stub);
        }

        private TransformSeedStub translate(TransformSeed seed, boolean isExport) {
            TransformSeedStub stub = new TransformSeedStub();
            try {
                stub.setUrl(seed.getUrl().getURL());
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            stub.setName(seed.getName());
            stub.setDescription(seed.getDescription());
            stub.setEnabled(seed.isEnabled());
            DisplayDescriptorCollection globalTxProperties = seed.getGlobalTxProperties();
            try {
                stub.setGlobalTxProperties(TransformDescriptorSerializer.translate(globalTxProperties));
            }
            catch (UnresolvedReferenceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            stub.setGlobalTxSettings(this.translateGlobalTxSettings(seed, isExport));
            return stub;
        }

        private ArrayList<TransformSettingsPropertyStub> translateGlobalTxSettings(TransformSeed seed, boolean isExport) {
            DataSources.Map settings = seed.getGlobalTxSettings();
            ArrayList<TransformSettingsPropertyStub> propertyStubs = new ArrayList<TransformSettingsPropertyStub>();
            DisplayDescriptorCollection globalTxProps = seed.getGlobalTxProperties();
            if (globalTxProps != null) {
                for (DisplayDescriptor dd : globalTxProps) {
                    boolean persistValue = TransformSettingsSerializer.shouldPersistValue(dd, isExport);
                    TransformSettingsPropertyStub propStub = new TransformSettingsPropertyStub(dd.getName(), dd.getTypeDescriptor().getTypeName());
                    if (settings != null) {
                        Object fromValue;
                        Object object = fromValue = persistValue ? settings.getValue((PropertyDescriptor)dd) : null;
                        if (fromValue != null && !fromValue.equals(dd.getDefaultValue())) {
                            String toValue = dd.getTypeDescriptor().convert(fromValue);
                            propStub.setValue(toValue);
                        }
                    }
                    propertyStubs.add(propStub);
                }
            }
            return propertyStubs;
        }

        private TransformSeed translate(TransformSeedStub stub) {
            FastURL url = new FastURL(stub.getUrl().toString());
            String name = stub.getName();
            String description = stub.getDescription();
            DisplayDescriptorCollection globalTxProps = null;
            try {
                globalTxProps = TransformDescriptorSerializer.translate(stub.getGlobalTxProperties());
            }
            catch (UnresolvedReferenceException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            DataSource globalTxSettings = this.translateGlobalTxSettings(globalTxProps, stub.getGlobalTxSettings());
            TransformSeed seed = new TransformSeed(url, name, description, globalTxProps, globalTxSettings);
            seed.setEnabled(stub.isEnabled());
            return seed;
        }

        private DataSource translateGlobalTxSettings(DisplayDescriptorCollection globalTxProps, List<TransformSettingsPropertyStub> globalTxSettings) {
            if (globalTxSettings == null) {
                return DataSources.empty();
            }
            DataSources.Map dataSource = new DataSources.Map();
            for (TransformSettingsPropertyStub propStub : globalTxSettings) {
                Object value = Converter.convertFrom((String)propStub.getValue(), (String)propStub.getType());
                DisplayDescriptor dd = globalTxProps.get(propStub.getName());
                if (dd == null) continue;
                dataSource.put((Object)dd, value);
            }
            return dataSource;
        }
    }
}

