/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.repository;

import com.paterva.maltego.transform.descriptor.Popup;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformFilter;
import com.paterva.maltego.transform.descriptor.TransformRepository;
import com.paterva.maltego.transform.descriptor.TransformSettings;
import com.paterva.maltego.transform.repository.ListMapTransformSettings;
import com.paterva.maltego.transform.repository.TransformDefinitionCookie;
import com.paterva.maltego.transform.repository.TransformRepositoriesLock;
import com.paterva.maltego.transform.repository.serializer.TransformDescriptorSerializer;
import com.paterva.maltego.transform.repository.serializer.TransformSettingsSerializer;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class FSTransformRepository
extends TransformRepository {
    private final String _name;
    private final FileObject _folder;
    private Map<String, TransformDefinition> _transforms;
    private static final String TRANSFORM_EXT = "transform";
    private static final String SETTINGS_EXT = "transformsettings";

    public FSTransformRepository(String name, FileObject folder) {
        this._folder = folder;
        this._name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, TransformDefinition> transforms() {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (this._transforms == null) {
                this._transforms = new HashMap<String, TransformDefinition>();
                for (FileObject fo : this._folder.getChildren()) {
                    TransformDefinition td;
                    if (fo.isFolder() || (td = this.get(fo)) == null) continue;
                    this._transforms.put(td.getName(), td);
                }
            }
            return this._transforms;
        }
    }

    public Set<TransformDefinition> getAll() {
        return Collections.unmodifiableSet(new HashSet<TransformDefinition>(this.transforms().values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransformDefinition get(String uniqueName) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            return this.transforms().get(uniqueName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransformDefinition get(FileObject fo) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (fo != null) {
                try {
                    TransformDefinitionCookie cookie;
                    DataObject obj = DataObject.find((FileObject)fo);
                    if (obj != null && (cookie = (TransformDefinitionCookie)obj.getLookup().lookup(TransformDefinitionCookie.class)) != null) {
                        TransformDefinition td = cookie.getTransformDefinition();
                        td.setRepositoryName(this._name);
                        td.markClean();
                        return td;
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TransformDefinition> find(TransformFilter filter) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            HashSet<TransformDefinition> set = new HashSet<TransformDefinition>();
            this.find(filter, set);
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void find(TransformFilter filter, Set<TransformDefinition> set) {
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            for (Map.Entry<String, TransformDefinition> entry : this.transforms().entrySet()) {
                TransformDefinition def = entry.getValue();
                if (!filter.matches(def)) continue;
                set.add(def);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TransformDescriptor descriptor) {
        OutputStream os = null;
        try {
            TransformDefinition definition;
            TransformDefinition oldDef = null;
            Object object = TransformRepositoriesLock.LOCK;
            synchronized (object) {
                boolean transferPopup;
                oldDef = this.get(descriptor.getName());
                if (descriptor.isCopy((TransformDescriptor)oldDef)) {
                    oldDef.markClean();
                    return;
                }
                FileObject transformFile = this._folder.getFileObject(descriptor.getName(), TRANSFORM_EXT);
                try {
                    if (transformFile == null) {
                        transformFile = this._folder.createData(descriptor.getName(), TRANSFORM_EXT);
                    }
                    os = new BufferedOutputStream(transformFile.getOutputStream());
                    TransformDescriptorSerializer serializer = new TransformDescriptorSerializer();
                    serializer.write(descriptor, os);
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                Object settings = oldDef == null && descriptor instanceof TransformDefinition ? (TransformDefinition)descriptor : this.get(transformFile);
                if (settings == null) {
                    settings = new ListMapTransformSettings();
                }
                boolean bl = transferPopup = oldDef == null;
                if (transferPopup) {
                    Iterator iterator = descriptor.getProperties().iterator();
                    while (iterator.hasNext()) {
                        DisplayDescriptor property;
                        settings.setPopup((PropertyDescriptor)property, (property = (DisplayDescriptor)iterator.next()).isPopup() ? Popup.Yes : Popup.No);
                    }
                }
                definition = new TransformDefinition(descriptor, (TransformSettings)settings);
                if (oldDef != null) {
                    this.transforms().remove(oldDef.getName());
                }
                definition.setRepositoryName(this._name);
                definition.markClean();
                this.transforms().put(definition.getName(), definition);
                if (transferPopup) {
                    this.saveSettings(definition);
                }
            }
            if (oldDef != null) {
                this.fireItemRemoved(oldDef);
            }
            this.fireItemAdded(definition);
        }
        catch (FileAlreadyLockedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSettings(TransformDefinition definition) {
        boolean fireChanged = false;
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            if (definition.isDirty() && this.get(definition.getName()) != null) {
                fireChanged = this.saveSettings(definition);
            }
        }
        if (fireChanged) {
            definition.markClean();
            this.fireItemChanged(definition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveSettings(TransformDefinition definition) {
        boolean fireChanged = false;
        OutputStream os = null;
        try {
            FileObject settingsFile = this._folder.getFileObject(definition.getName(), SETTINGS_EXT);
            if (settingsFile == null) {
                settingsFile = this._folder.createData(definition.getName(), SETTINGS_EXT);
            }
            os = new BufferedOutputStream(settingsFile.getOutputStream());
            TransformSettingsSerializer serializer = new TransformSettingsSerializer();
            serializer.write(definition, os, false);
            fireChanged = true;
        }
        catch (FileAlreadyLockedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                os.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return fireChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String uniqueName) {
        TransformDefinition definition;
        boolean found = false;
        Object object = TransformRepositoriesLock.LOCK;
        synchronized (object) {
            FileObject transformFile = this._folder.getFileObject(uniqueName, TRANSFORM_EXT);
            FileObject settingsFile = this._folder.getFileObject(uniqueName, SETTINGS_EXT);
            if (transformFile != null) {
                try {
                    transformFile.delete();
                    found = true;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (settingsFile != null) {
                try {
                    settingsFile.delete();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((definition = this.get(uniqueName)) != null) {
                this.transforms().remove(definition.getName());
            }
        }
        if (definition != null) {
            this.fireItemRemoved(definition);
        }
        return found;
    }
}

