/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.Address;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.MACAddressString;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.util.Iterator;

public class MACAddress
extends Address
implements Iterable<MACAddress> {
    private static final long serialVersionUID = 3L;
    public static final char COLON_SEGMENT_SEPARATOR = ':';
    public static final char DASH_SEGMENT_SEPARATOR = '-';
    public static final char SPACE_SEGMENT_SEPARATOR = ' ';
    public static final char DOTTED_SEGMENT_SEPARATOR = '.';
    public static final char DASHED_SEGMENT_RANGE_SEPARATOR = '|';
    public static final String DASHED_SEGMENT_RANGE_SEPARATOR_STR = String.valueOf('|');
    public static final int BITS_PER_SEGMENT = 8;
    public static final int BYTES_PER_SEGMENT = 1;
    public static final int MEDIA_ACCESS_CONTROL_SEGMENT_COUNT = 6;
    public static final int MEDIA_ACCESS_CONTROL_DOTTED_SEGMENT_COUNT = 3;
    public static final int MEDIA_ACCESS_CONTROL_DOTTED_64_SEGMENT_COUNT = 4;
    public static final int MEDIA_ACCESS_CONTROL_DOTTED_BITS_PER_SEGMENT = 16;
    public static final int MEDIA_ACCESS_CONTROL_SINGLE_DASHED_SEGMENT_COUNT = 2;
    public static final int EXTENDED_UNIQUE_IDENTIFIER_48_SEGMENT_COUNT = 6;
    public static final int EXTENDED_UNIQUE_IDENTIFIER_64_SEGMENT_COUNT = 8;
    public static final int DEFAULT_TEXTUAL_RADIX = 16;
    public static final int MAX_VALUE_PER_SEGMENT = 255;
    public static final int MAX_VALUE_PER_DOTTED_SEGMENT = 65535;
    public static final int ORGANIZATIONAL_UNIQUE_IDENTIFIER_SEGMENT_COUNT = 3;
    public static final int ORGANIZATIONAL_UNIQUE_IDENTIFIER_BIT_COUNT = 24;
    protected static MACAddressNetwork network = new MACAddressNetwork();
    transient MACAddressSection.AddressCache sectionCache;

    public MACAddress(MACAddressSegment[] segments) {
        this(segments, null);
    }

    public MACAddress(MACAddressSegment[] segments, Integer prefixLength) {
        this(MACAddress.getAddressCreator().createSection(segments, segments.length == 8, prefixLength));
    }

    public MACAddress(MACAddressSection section) {
        super(section);
        int segCount = section.getSegmentCount();
        if (segCount != 6 && segCount != 8) {
            throw new IllegalArgumentException(String.valueOf(MACAddress.getMessage("ipaddress.error.mac.invalid.segment.count")) + ' ' + segCount);
        }
    }

    public MACAddress(long address) {
        this(address, false, null);
    }

    public MACAddress(long address, boolean extended) {
        this(address, extended, null);
    }

    public MACAddress(long address, Integer prefixLength) {
        this(address, false, prefixLength);
    }

    public MACAddress(long address, boolean extended, Integer prefixLength) {
        super(MACAddress.getAddressCreator().createSection(address, 0, extended, prefixLength));
    }

    public MACAddress(byte[] bytes) {
        this(bytes, null);
    }

    public MACAddress(byte[] bytes, Integer prefixLength) {
        super(MACAddress.getAddressCreator().createSection(bytes, 0, bytes.length == 8, prefixLength));
        if (bytes.length != 6 && bytes.length != 8) {
            throw new IllegalArgumentException(String.valueOf(MACAddress.getMessage("ipaddress.error.mac.invalid.byte.count")) + ' ' + bytes.length);
        }
    }

    public MACAddress(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, boolean extended, Integer prefixLength) {
        super(MACAddress.getAddressCreator().createSection(lowerValueProvider, upperValueProvider, 0, extended, prefixLength));
    }

    public MACAddress(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength) {
        super(MACAddress.getAddressCreator().createSection(lowerValueProvider, upperValueProvider, 0, false, prefixLength));
    }

    public MACAddress(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, boolean extended) {
        super(MACAddress.getAddressCreator().createSection(lowerValueProvider, upperValueProvider, 0, extended, null));
    }

    public MACAddress(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider) {
        this(lowerValueProvider, upperValueProvider, null);
    }

    protected static String getMessage(String key) {
        return Address.getMessage(key);
    }

    public static MACAddressNetwork network() {
        return network;
    }

    public static MACAddressNetwork.MACAddressCreator getAddressCreator() {
        return MACAddress.network().getAddressCreator();
    }

    public boolean isExtended() {
        return this.getSection().isExtended();
    }

    public boolean isAllAddresses() {
        return this.getSection().isFullRange();
    }

    @Override
    public MACAddressSection getSection() {
        return (MACAddressSection)super.getSection();
    }

    @Override
    public MACAddressSegment getSegment(int index) {
        return (MACAddressSegment)super.getSegment(index);
    }

    public MACAddressSegment[] getSegments() {
        return this.getSection().getSegments();
    }

    public static int maxSegmentValue() {
        return 255;
    }

    @Override
    public int getMaxSegmentValue() {
        return 255;
    }

    @Override
    public int getByteCount() {
        return this.getSection().getByteCount();
    }

    @Override
    public int getBitCount() {
        return this.getSection().getBitCount();
    }

    @Override
    public int getBytesPerSegment() {
        return 1;
    }

    @Override
    public int getBitsPerSegment() {
        return 8;
    }

    @Override
    protected boolean isFromSameString(HostIdentifierString other) {
        if (this.fromString != null && other instanceof MACAddressString) {
            MACAddressString fromString = (MACAddressString)this.fromString;
            MACAddressString otherString = (MACAddressString)other;
            return fromString == otherString || fromString.toString().equals(otherString.toString()) && fromString.getValidationOptions().equals(otherString.getValidationOptions());
        }
        return false;
    }

    @Override
    public boolean contains(Address other) {
        if (other instanceof MACAddress) {
            return this.contains((MACAddress)other);
        }
        return false;
    }

    public boolean contains(MACAddress other) {
        if (other == this) {
            return true;
        }
        return this.getSection().contains(other.getSection());
    }

    public Iterable<MACAddress> getIterable() {
        return this;
    }

    @Override
    public Iterator<MACAddress> iterator() {
        return this.getSection().iterator(this);
    }

    public Iterator<MACAddressSegment[]> segmentsIterator() {
        return this.getSection().segmentsIterator();
    }

    @Override
    public MACAddress getLower() {
        return this.getLowestOrHighest(true);
    }

    @Override
    public MACAddress getUpper() {
        return this.getLowestOrHighest(false);
    }

    private MACAddress getLowestOrHighest(boolean lowest) {
        return this.getSection().getLowestOrHighest(this, lowest);
    }

    @Override
    public MACAddress reverseBits(boolean perByte) {
        return this.checkIdentity(this.getSection().reverseBits(perByte));
    }

    @Override
    public MACAddress reverseBytes() {
        return this.checkIdentity(this.getSection().reverseBytes());
    }

    @Override
    public MACAddress reverseBytesPerSegment() {
        return this;
    }

    @Override
    public MACAddress reverseSegments() {
        return this.checkIdentity(this.getSection().reverseSegments());
    }

    private MACAddress checkIdentity(MACAddressSection newSection) {
        MACAddressSection section = this.getSection();
        if (newSection == section) {
            return this;
        }
        return MACAddress.getAddressCreator().createAddress(newSection);
    }

    @Override
    public MACAddress removePrefixLength() {
        return this.checkIdentity(this.getSection().removePrefixLength());
    }

    @Override
    public MACAddress applyPrefixLength(int networkPrefixLength) {
        return this.checkIdentity(this.getSection().applyPrefixLength(networkPrefixLength));
    }

    @Override
    public MACAddress adjustPrefixBySegment(boolean nextSegment) {
        return this.checkIdentity(this.getSection().adjustPrefixBySegment(nextSegment));
    }

    @Override
    public MACAddress adjustPrefixLength(int adjustment) {
        return this.checkIdentity(this.getSection().adjustPrefixLength(adjustment));
    }

    @Override
    public MACAddress setPrefixLength(int prefixLength) {
        return this.checkIdentity(this.getSection().setPrefixLength(prefixLength));
    }

    @Override
    public MACAddressSection getSection(int index) {
        return this.getSection().getSection(index);
    }

    @Override
    public MACAddressSection getSection(int index, int endIndex) {
        return this.getSection().getSection(index, endIndex);
    }

    public MACAddressSection getODISection() {
        return this.getSection().getODISection();
    }

    public MACAddressSection getOUISection() {
        return this.getSection().getOUISection();
    }

    public MACAddress toOUIPrefixed() {
        return MACAddress.getAddressCreator().createAddress(this.getSection().toOUIPrefixed());
    }

    public IPv6Address toLinkLocalIPv6() {
        return IPv6Address.network().getAddressCreator().createAddress(IPv6AddressSection.LINK_LOCAL_PREFIX.append(this.toEUI64IPv6()));
    }

    public IPv6AddressSection toEUI64IPv6() {
        return IPv6Address.network().getAddressCreator().createSection(this);
    }

    public boolean isEUI64(boolean asMAC) {
        if (this.isExtended()) {
            MACAddressSection section = this.getSection();
            MACAddressSegment seg3 = section.getSegment(3);
            MACAddressSegment seg4 = section.getSegment(4);
            return seg3.matches(255) && seg4.matches(asMAC ? 255 : 254);
        }
        return false;
    }

    public MACAddress toEUI64(boolean asMAC) {
        if (!this.isExtended()) {
            MACAddressNetwork.MACAddressCreator creator = MACAddress.getAddressCreator();
            AddressSegment[] segs = creator.createSegmentArray(8);
            MACAddressSection section = this.getSection();
            section.getSegments(0, 3, segs, 0);
            segs[3] = MACAddressSegment.FF_SEGMENT;
            segs[4] = asMAC ? MACAddressSegment.FF_SEGMENT : MACAddressSegment.FE_SEGMENT;
            section.getSegments(3, 6, segs, 5);
            return creator.createAddressInternal((MACAddressSegment[])segs);
        }
        MACAddressSection section = this.getSection();
        MACAddressSegment seg3 = section.getSegment(3);
        MACAddressSegment seg4 = section.getSegment(4);
        if (seg3.matches(255) && seg4.matches(asMAC ? 255 : 254)) {
            return this;
        }
        throw new AddressTypeException(this, "ipaddress.mac.error.not.eui.convertible");
    }

    public AddressDivisionGrouping getDottedAddress() {
        return this.getSection().getDottedGrouping();
    }

    void cache(HostIdentifierString string) {
        if (this.fromString instanceof MACAddressString) {
            this.fromString = string;
        }
    }

    @Override
    public MACAddressString toAddressString() {
        if (this.fromString == null) {
            this.fromString = new MACAddressString(this);
        }
        return (MACAddressString)this.fromString;
    }

    public String toNormalizedString(AddressDivisionGrouping.StringOptions stringOptions) {
        return this.getSection().toNormalizedString(stringOptions);
    }

    public String toDottedString() {
        return this.getSection().toDottedString();
    }

    public String toDashedString() {
        return this.toCanonicalString();
    }

    public String toColonDelimitedString() {
        return this.toNormalizedString();
    }

    public String toSpaceDelimitedString() {
        return this.getSection().toSpaceDelimitedString();
    }

    @Override
    public boolean isMulticast() {
        return this.getSegment(0).matchesWithMask(1, 1);
    }

    public boolean isUniversal() {
        return this.getSegment(0).matchesWithMask(0, 2);
    }

    @Override
    public boolean isLocal() {
        return this.getSegment(0).matchesWithMask(1, 2);
    }
}

