/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.AddressStringParameters;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostName;
import inet.ipaddr.HostNameException;
import inet.ipaddr.HostNameParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.MACAddressString;
import inet.ipaddr.MACAddressStringParameters;
import inet.ipaddr.format.AddressLargeDivision;
import inet.ipaddr.format.validate.AddressParseData;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.MACAddressProvider;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import inet.ipaddr.format.validate.ParsedIPAddress;
import inet.ipaddr.format.validate.ParsedMACAddress;
import inet.ipaddr.ipv4.IPv4AddressStringParameters;
import inet.ipaddr.ipv6.IPv6AddressStringParameters;
import java.math.BigInteger;

public class Validator
implements HostIdentifierStringValidator {
    private static final int[] extendedChars = new int[128];
    private static final int[] chars;
    private static final int MAX_HOST_LENGTH = 253;
    private static final int MAX_HOST_SEGMENTS = 127;
    private static final int MAX_LABEL_LENGTH = 63;
    private static final long MAC_MAX_TRIPLE = 0xFFFFFFL;
    private static final long MAC_MAX_QUINTUPLE = 0xFFFFFFFFFFL;
    private static final int MAC_DOUBLE_SEGMENT_DIGIT_COUNT = 6;
    private static final int MAC_EXTENDED_DOUBLE_SEGMENT_DIGIT_COUNT = 10;
    private static final int MAC_SINGLE_SEGMENT_DIGIT_COUNT = 12;
    private static final int MAC_EXTENDED_SINGLE_SEGMENT_DIGIT_COUNT = 16;
    private static final int IPV6_SINGLE_SEGMENT_DIGIT_COUNT = 32;
    private static final int IPV6_BASE85_SINGLE_SEGMENT_DIGIT_COUNT = 20;
    private static final int IPV4_SINGLE_SEGMENT_OCTAL_DIGIT_COUNT = 11;
    private static final int LONG_HEX_DIGITS = 16;
    private static final char IPvFUTURE_UPPERCASE;
    private static final int[] EMPTY_INDICES;
    private static final ParsedHostIdentifierStringQualifier[] PREFIX_CACHE;
    private static final ParsedHost DEFAULT_EMPTY_HOST;
    private static final IPAddressStringParameters DEFAULT_PREFIX_OPTIONS;
    public static final HostIdentifierStringValidator VALIDATOR;
    private static final IPAddressStringParameters DEFAULT_UNC_OPTS;
    private static final IPAddressStringParameters REVERSE_DNS_IPV4_OPTS;
    private static final IPAddressStringParameters REVERSE_DNS_IPV6_OPTS;
    private static final BigInteger[] BASE_85_POWERS;
    private static final BigInteger LOW_BITS_MASK;

    static {
        char[] extendedDigits = AddressLargeDivision.EXTENDED_DIGITS;
        int i = 0;
        while (i < extendedDigits.length) {
            Validator.extendedChars[extendedDigits[i]] = i;
            ++i;
        }
        int[] charArray = chars = new int[128];
        i = 0;
        int c = 48;
        while (i < 10) {
            charArray[c] = i++;
            c = (char)(c + 1);
        }
        c = 97;
        int c2 = 65;
        while (i < 26) {
            charArray[c] = charArray[c2] = i++;
            c = (char)(c + 1);
            c2 = (char)(c2 + 1);
        }
        IPvFUTURE_UPPERCASE = Character.toUpperCase('v');
        EMPTY_INDICES = new int[0];
        PREFIX_CACHE = new ParsedHostIdentifierStringQualifier[129];
        DEFAULT_EMPTY_HOST = new ParsedHost("", EMPTY_INDICES, null, ParsedHost.NO_QUALIFIER);
        DEFAULT_PREFIX_OPTIONS = new IPAddressStringParameters.Builder().toParams();
        VALIDATOR = new Validator();
        DEFAULT_UNC_OPTS = new IPAddressStringParameters.Builder().allowIPv4(false).allowEmpty(false).allowMask(false).allowPrefixOnly(false).allowPrefix(false).toParams();
        REVERSE_DNS_IPV4_OPTS = new IPAddressStringParameters.Builder().allowIPv6(false).allowEmpty(false).allowMask(false).allowPrefixOnly(false).allowPrefix(false).getIPv4AddressParametersBuilder().allow_inet_aton(false).getParentBuilder().toParams();
        REVERSE_DNS_IPV6_OPTS = new IPAddressStringParameters.Builder().allowIPv4(false).allowEmpty(false).allowMask(false).allowPrefixOnly(false).allowPrefix(false).getIPv6AddressParametersBuilder().allowMixed(false).allowZone(false).getParentBuilder().toParams();
        BASE_85_POWERS = new BigInteger[10];
        LOW_BITS_MASK = BigInteger.valueOf(-1L);
        BigInteger eightyFive = BigInteger.valueOf(85L);
        Validator.BASE_85_POWERS[0] = BigInteger.ONE;
        i = 1;
        while (i < BASE_85_POWERS.length) {
            Validator.BASE_85_POWERS[i] = BASE_85_POWERS[i - 1].multiply(eightyFive);
            ++i;
        }
    }

    private Validator() {
    }

    @Override
    public ParsedHost validateHost(HostName fromHost) throws HostNameException {
        return Validator.validateHostImpl(fromHost);
    }

    @Override
    public IPAddressProvider validateAddress(IPAddressString fromString) throws AddressStringException {
        return Validator.validateAddressImpl(fromString);
    }

    @Override
    public MACAddressProvider validateAddress(MACAddressString fromString) throws AddressStringException {
        String str = fromString.toString();
        MACAddressStringParameters validationOptions = fromString.getValidationOptions();
        ParsedMACAddress.MACAddressParseData macAddressParseData = new ParsedMACAddress.MACAddressParseData();
        Validator.validateMACAddress(validationOptions, str, 0, str.length(), macAddressParseData);
        AddressParseData addressParseData = macAddressParseData.addressParseData;
        if (addressParseData.isEmpty) {
            return MACAddressProvider.EMPTY_PROVIDER;
        }
        if (addressParseData.isAll) {
            MACAddressStringParameters.AddressSize allAddresses = validationOptions.addressSize;
            return allAddresses == MACAddressStringParameters.AddressSize.EUI64 ? MACAddressProvider.ALL_EUI_64 : MACAddressProvider.ALL_MAC;
        }
        ParsedMACAddress parsedAddress = Validator.createParsedMACAddress(fromString, fromString.toString(), fromString.getValidationOptions(), macAddressParseData);
        return new MACAddressProvider(parsedAddress);
    }

    static IPAddressProvider validateAddressImpl(IPAddressString fromString) throws AddressStringException {
        String str = fromString.toString();
        IPAddressStringParameters validationOptions = fromString.getValidationOptions();
        ParsedIPAddress.IPAddressParseData ipAddressParseData = new ParsedIPAddress.IPAddressParseData();
        Validator.validateIPAddress(validationOptions, str, 0, str.length(), ipAddressParseData);
        return Validator.createProvider(fromString, str, validationOptions, ipAddressParseData, Validator.parseQualifier(str, validationOptions, null, ipAddressParseData, str.length()));
    }

    private static void validateIPAddress(IPAddressStringParameters validationOptions, CharSequence str, int strStartIndex, int strEndIndex, ParsedIPAddress.IPAddressParseData parseData) throws AddressStringException {
        Validator.validateIPAddress(validationOptions, str, strStartIndex, strEndIndex, parseData, false);
    }

    private static void validateIPAddress(IPAddressStringParameters validationOptions, CharSequence str, int strStartIndex, int strEndIndex, ParsedIPAddress.IPAddressParseData parseData, boolean isEmbeddedIPv4) throws AddressStringException {
        Validator.validateAddress(validationOptions, null, str, strStartIndex, strEndIndex, parseData, null, isEmbeddedIPv4);
    }

    private static ParsedMACAddress createParsedMACAddress(MACAddressString originator, String fullAddr, MACAddressStringParameters validationOptions, ParsedMACAddress.MACAddressParseData parseData) throws AddressStringException {
        if (parseData.format != null) {
            int segCount = parseData.addressParseData.segmentCount;
            if (parseData.format == ParsedMACAddress.MACAddressParseData.MACFormat.DOTTED) {
                if (segCount <= 3 && validationOptions.addressSize != MACAddressStringParameters.AddressSize.EUI64) {
                    if (segCount != 3 && !parseData.addressParseData.anyWildcard) {
                        throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                    }
                } else {
                    if (segCount < 4 && !parseData.addressParseData.anyWildcard) {
                        throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                    }
                    parseData.isExtended = true;
                }
            } else if (segCount > 2) {
                if (segCount <= 6 && validationOptions.addressSize != MACAddressStringParameters.AddressSize.EUI64) {
                    if (segCount != 6 && !parseData.addressParseData.anyWildcard) {
                        throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                    }
                } else {
                    if (segCount < 8 && !parseData.addressParseData.anyWildcard) {
                        throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                    }
                    parseData.isExtended = true;
                }
                if (parseData.format == ParsedMACAddress.MACAddressParseData.MACFormat.DASHED) {
                    int max = 255;
                    int maxChars = 2;
                    int i = 0;
                    while (i < segCount) {
                        Validator.checkMaxValues(fullAddr, parseData.addressParseData, i, validationOptions.getFormatParameters(), max, maxChars, maxChars);
                        ++i;
                    }
                }
            } else {
                if (parseData.format == ParsedMACAddress.MACAddressParseData.MACFormat.DASHED) {
                    if (parseData.isDoubleSegment) {
                        MACAddressStringParameters.MACAddressStringFormatParameters params = validationOptions.getFormatParameters();
                        AddressParseData data = parseData.addressParseData;
                        Validator.checkMaxValues(fullAddr, data, 0, params, 0xFFFFFFL, 6L, 6L);
                        if (parseData.isExtended) {
                            Validator.checkMaxValues(fullAddr, data, 1, params, 0xFFFFFFFFFFL, 10L, 10L);
                        } else {
                            Validator.checkMaxValues(fullAddr, data, 1, params, 0xFFFFFFL, 6L, 6L);
                        }
                    }
                } else if (!parseData.addressParseData.anyWildcard) {
                    throw new AddressStringException((CharSequence)fullAddr, "ipaddress.error.too.few.segments");
                }
                if (validationOptions.addressSize == MACAddressStringParameters.AddressSize.EUI64) {
                    parseData.isExtended = true;
                }
            }
        }
        ParsedMACAddress parsedAddress = new ParsedMACAddress(originator, fullAddr, parseData);
        return parsedAddress;
    }

    private static void validateMACAddress(MACAddressStringParameters validationOptions, String str, int strStartIndex, int strEndIndex, ParsedMACAddress.MACAddressParseData parseData) throws AddressStringException {
        Validator.validateAddress(null, validationOptions, str, strStartIndex, strEndIndex, null, parseData, false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void validateAddress(IPAddressStringParameters validationOptions, MACAddressStringParameters macOptions, CharSequence str, int strStartIndex, int strEndIndex, ParsedIPAddress.IPAddressParseData ipAddressParseData, ParsedMACAddress.MACAddressParseData macAddressParseData, boolean isEmbeddedIPv4) throws AddressStringException {
        isMac = macAddressParseData != null;
        ipv6SpecificOptions = null;
        ipv4SpecificOptions = null;
        macSpecificOptions = null;
        macFormat = null;
        if (isMac) {
            baseOptions /* !! */  = macOptions;
            stringFormatParams /* !! */  = macSpecificOptions = macOptions.getFormatParameters();
            parseData = macAddressParseData.addressParseData;
            isBase85 = false;
        } else {
            baseOptions /* !! */  = validationOptions;
            stringFormatParams /* !! */  = null;
            parseData = ipAddressParseData.addressParseData;
            ipv6SpecificOptions = validationOptions.getIPv6Parameters();
            isBase85 = ipv6SpecificOptions.allowBase85;
            ipv4SpecificOptions = validationOptions.getIPv4Parameters();
        }
        index = strStartIndex;
        frontWildcardCount = 0;
        wildcardCount = 0;
        singleWildcardCount = 0;
        leadingZeroCount = 0;
        digitCount = 0;
        frontSingleWildcardCount = 0;
        frontLeadingZeroCount = 0;
        frontDigitCount = 0;
        frontHexDelimiterIndex = -1;
        hexDelimiterIndex = -1;
        rangeWildcardIndex = -1;
        lastSeparatorIndex = -1;
        extendedRangeWildcardIndex = -1;
        extendedCharacterIndex = -1;
        isDoubleSegment = false;
        isSingleSegment = false;
        isSingleIPv6Hex = false;
        uppercase = false;
        notDecimal = false;
        notOctal = false;
        frontUppercase = false;
        frontNotDecimal = false;
        frontNotOctal = false;
        firstSegmentDashedRange = false;
        atEnd = false;
        countedCharacters = false;
        countingCharsLater = false;
        frontIsStandardRange = false;
        while (index < strEndIndex || (atEnd = index == strEndIndex)) {
            block259: {
                block256: {
                    block257: {
                        block258: {
                            block255: {
                                block254: {
                                    block253: {
                                        if (!atEnd) ** GOTO lbl193
                                        parseData.addressEndIndex = index;
                                        totalDigits = leadingZeroCount + digitCount;
                                        v0 = isMac ? macFormat != null : (isSegmented = ipAddressParseData.ipVersion != null);
                                        if (!isSegmented) break block253;
                                        if (isMac) {
                                            currentChar = macFormat.getSeparator();
                                            macAddressParseData.isDoubleSegment = parseData.segmentCount == 1 && currentChar == 45;
                                            isDoubleSegment = macAddressParseData.isDoubleSegment;
                                            if (isDoubleSegment) {
                                                macAddressParseData.isExtended = totalDigits == 10;
                                            }
                                        } else {
                                            version = ipAddressParseData.ipVersion;
                                            if (version.isIPv4()) {
                                                currentChar = 46;
                                            } else {
                                                if (index == lastSeparatorIndex + 1) {
                                                    if (index == parseData.consecutiveSepIndex + 2) break;
                                                    throw new AddressStringException(str, "ipaddress.error.cannot.end.with.single.separator");
                                                }
                                                if (ipAddressParseData.mixedParsedAddress != null) break;
                                                currentChar = 58;
                                            }
                                        }
                                        break block254;
                                    }
                                    totalCharacterCount = index - strStartIndex;
                                    if (totalCharacterCount == 0) {
                                        if (!isMac && ipAddressParseData.isPrefixed) {
                                            if (!validationOptions.allowPrefixOnly) {
                                                throw new AddressStringException(str, "ipaddress.error.prefix.only");
                                            }
                                        } else if (!baseOptions /* !! */ .allowEmpty) {
                                            throw new AddressStringException(str, "ipaddress.error.empty");
                                        }
                                        parseData.isEmpty = true;
                                        break;
                                    }
                                    if (wildcardCount == totalCharacterCount) {
                                        if (singleWildcardCount > 0 || rangeWildcardIndex >= 0 || leadingZeroCount > 0 || digitCount > 0 || hexDelimiterIndex >= 0) {
                                            throw new AddressStringException(str, index, true);
                                        }
                                        if (!baseOptions /* !! */ .allowAll) {
                                            throw new AddressStringException(str, "ipaddress.error.all");
                                        }
                                        parseData.anyWildcard = true;
                                        parseData.isAll = true;
                                        break;
                                    }
                                    if (!isMac) ** GOTO lbl123
                                    frontTotalDigits = frontLeadingZeroCount + frontDigitCount;
                                    if (((totalDigits == 6 || totalDigits == 10) && (frontTotalDigits == 6 || frontWildcardCount > 0) || frontTotalDigits == 6 && wildcardCount > 0 || frontWildcardCount > 0 && wildcardCount > 0) && !firstSegmentDashedRange) {
                                        addressSize = macOptions.addressSize;
                                        if (addressSize == MACAddressStringParameters.AddressSize.EUI64 && totalDigits == 6) {
                                            throw new AddressStringException(str, "ipaddress.error.too.few.segments");
                                        }
                                        if (addressSize == MACAddressStringParameters.AddressSize.MAC && totalDigits == 10) {
                                            throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                                        }
                                        if (!macOptions.allowSingleDashed) {
                                            throw new AddressStringException(str, "ipaddress.mac.error.format");
                                        }
                                        macAddressParseData.isDoubleSegment = true;
                                        isDoubleSegment = true;
                                        macAddressParseData.isExtended = totalDigits == 10;
                                        currentChar = 45;
                                        countedCharacters = true;
                                    } else if (frontWildcardCount > 0 || wildcardCount > 0) {
                                        if (!macOptions.allowSingleDashed) {
                                            throw new AddressStringException(str, "ipaddress.mac.error.format");
                                        }
                                        currentChar = 45;
                                    } else {
                                        if (!baseOptions /* !! */ .allowSingleSegment) {
                                            throw new AddressStringException(str, "ipaddress.error.single.segment");
                                        }
                                        v1 = is12Digits = totalDigits == 12;
                                        if (is12Digits || totalDigits == 16) {
                                            if (rangeWildcardIndex >= 0 && frontTotalDigits != (is12Digits != false ? 12 : 16)) {
                                                throw new AddressStringException("ipaddress.error.front.digit.count");
                                            }
                                            isSingleSegment = true;
                                            parseData.isSingleSegment = true;
                                            macAddressParseData.isExtended = is12Digits == false;
                                            currentChar = 58;
                                            countedCharacters = true;
                                        } else {
                                            throw new AddressStringException("ipaddress.error.too.few.segments.digit.count");
lbl123:
                                            // 1 sources

                                            if (!baseOptions /* !! */ .allowSingleSegment) {
                                                throw new AddressStringException(str, "ipaddress.error.single.segment");
                                            }
                                            if (totalDigits == 32) {
                                                if (rangeWildcardIndex >= 0 && (frontTotalDigits = frontLeadingZeroCount + frontDigitCount) != 32) {
                                                    throw new AddressStringException("ipaddress.error.front.digit.count");
                                                }
                                                isSingleIPv6Hex = true;
                                                isSingleSegment = true;
                                                parseData.isSingleSegment = true;
                                                currentChar = 58;
                                                countedCharacters = true;
                                            } else {
                                                if (isBase85) {
                                                    if (extendedRangeWildcardIndex < 0) {
                                                        if (totalCharacterCount == 20) {
                                                            if (!validationOptions.allowIPv6) {
                                                                throw new AddressStringException(str, "ipaddress.error.ipv6");
                                                            }
                                                            ipAddressParseData.ipVersion = IPAddress.IPVersion.IPV6;
                                                            val = Validator.parseBig85(str, strStartIndex, strEndIndex);
                                                            value = val.and(Validator.LOW_BITS_MASK).longValue();
                                                            shift64 = val.shiftRight(64);
                                                            extendedValue = shift64.longValue();
                                                            shiftMore = shift64.shiftRight(64);
                                                            if (!shiftMore.equals(BigInteger.ZERO)) {
                                                                throw new AddressStringException(str, "ipaddress.error.address.too.large");
                                                            }
                                                            parseData.initSegmentData(1);
                                                            parseData.segmentCount = 1;
                                                            vals = parseData.values[0];
                                                            indices = parseData.indices[0];
                                                            Validator.assignAttributes(strStartIndex, strEndIndex, indices, 16, strStartIndex);
                                                            vals[0] = vals[1] = value;
                                                            vals[2] = vals[3] = extendedValue;
                                                            ipAddressParseData.isBase85 = true;
                                                            break;
                                                        }
                                                    } else if (totalCharacterCount == 41) {
                                                        if (!validationOptions.allowIPv6) {
                                                            throw new AddressStringException(str, "ipaddress.error.ipv6");
                                                        }
                                                        ipAddressParseData.ipVersion = IPAddress.IPVersion.IPV6;
                                                        frontEndIndex = strStartIndex + 20;
                                                        val = Validator.parseBig85(str, strStartIndex, frontEndIndex);
                                                        val2 = Validator.parseBig85(str, frontEndIndex + 1, strEndIndex);
                                                        value = val.and(Validator.LOW_BITS_MASK).longValue();
                                                        shift64 = val.shiftRight(64);
                                                        extendedValue = shift64.longValue();
                                                        shiftMore = shift64.shiftRight(64);
                                                        value2 = val2.and(Validator.LOW_BITS_MASK).longValue();
                                                        shift64 = val2.shiftRight(64);
                                                        extendedValue2 = shift64.longValue();
                                                        shiftMore = shift64.shiftRight(64);
                                                        if (!shiftMore.equals(BigInteger.ZERO)) {
                                                            throw new AddressStringException(str, "ipaddress.error.address.too.large");
                                                        }
                                                        if (val.compareTo(val2) > 0) {
                                                            throw new AddressStringException(str, "ipaddress.error.invalidRange");
                                                        }
                                                        parseData.segmentCount = 1;
                                                        parseData.initSegmentData(1);
                                                        vals = parseData.values[0];
                                                        indices = parseData.indices[0];
                                                        Validator.assignAttributes(strStartIndex, frontEndIndex, frontEndIndex + 1, strEndIndex, indices, strStartIndex, frontEndIndex + 1, 16, 16);
                                                        vals[0] = value;
                                                        vals[1] = value2;
                                                        vals[2] = extendedValue;
                                                        vals[3] = extendedValue2;
                                                        ipAddressParseData.isBase85 = true;
                                                        break;
                                                    }
                                                }
                                                if (digitCount <= 11) {
                                                    if (rangeWildcardIndex >= 0 && frontDigitCount > 11) {
                                                        throw new AddressStringException("ipaddress.error.front.digit.count");
                                                    }
                                                    currentChar = 46;
                                                } else {
                                                    throw new AddressStringException("ipaddress.error.too.few.segments.digit.count");
lbl193:
                                                    // 1 sources

                                                    currentChar = str.charAt(index);
                                                }
                                            }
                                        }
                                    }
                                }
                                if (currentChar >= 49 && currentChar <= 55) {
                                    ++digitCount;
                                    ++index;
                                    continue;
                                }
                                if (currentChar == 48) {
                                    if (digitCount > 0) {
                                        ++digitCount;
                                    } else {
                                        ++leadingZeroCount;
                                    }
                                    ++index;
                                    continue;
                                }
                                if (currentChar == 56 || currentChar == 57) {
                                    ++digitCount;
                                    ++index;
                                    notOctal = true;
                                    continue;
                                }
                                if (currentChar >= 97 && currentChar <= 102) {
                                    ++digitCount;
                                    ++index;
                                    notDecimal = true;
                                    notOctal = true;
                                    continue;
                                }
                                if (currentChar >= 65 && currentChar <= 70) {
                                    ++digitCount;
                                    ++index;
                                    uppercase = true;
                                    notDecimal = true;
                                    notOctal = true;
                                    continue;
                                }
                                if (currentChar == 46) {
                                    segCount = parseData.segmentCount;
                                    if (!isMac && ipAddressParseData.ipVersion != null && ipAddressParseData.ipVersion.isIPv6()) {
                                        if (extendedCharacterIndex >= 0) {
                                            throw new AddressStringException(str, extendedCharacterIndex);
                                        }
                                        isBase85 = false;
                                        if (!ipv6SpecificOptions.allowMixed) {
                                            throw new AddressStringException(str, "ipaddress.error.no.mixed");
                                        }
                                        totalSegmentCount = parseData.segmentCount + 2;
                                        if (totalSegmentCount > 8) {
                                            throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                                        }
                                        if (wildcardCount > 0) {
                                            parseData.anyWildcard = true;
                                        }
                                        v2 = isNotExpandable = wildcardCount > 0 && parseData.consecutiveSepIndex < 0;
                                        if (isNotExpandable && totalSegmentCount < 8 && ipv6SpecificOptions.allowWildcardedSeparator) {
                                            parseData.values[segCount][1] = 65535L;
                                            parseData.flags[segCount][0] = true;
                                            ++parseData.segmentCount;
                                        }
                                        mixedOptions = ipv6SpecificOptions.getMixedParameters();
                                        mixedAddressParseData = new ParsedIPAddress.IPAddressParseData();
                                        Validator.validateIPAddress(mixedOptions, str, lastSeparatorIndex + 1, strEndIndex, mixedAddressParseData, true);
                                        ipAddressParseData.mixedParsedAddress = Validator.createIPAddressProvider(null, str, mixedOptions, mixedAddressParseData, ParsedHost.NO_QUALIFIER);
                                        index = mixedAddressParseData.addressParseData.addressEndIndex;
                                        continue;
                                    }
                                    if (isMac) {
                                        if (segCount == 0) {
                                            if (!macOptions.allowDotted) {
                                                throw new AddressStringException(str, "ipaddress.mac.error.format");
                                            }
                                            macAddressParseData.format = macFormat = ParsedMACAddress.MACAddressParseData.MACFormat.DOTTED;
                                            parseData.initSegmentData(4);
                                        } else {
                                            if (macFormat != ParsedMACAddress.MACAddressParseData.MACFormat.DOTTED) {
                                                throw new AddressStringException(str, "ipaddress.mac.error.mix.format.characters.at.index", index);
                                            }
                                            if (segCount >= (macOptions.addressSize == MACAddressStringParameters.AddressSize.MAC ? 3 : 4)) {
                                                throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                                            }
                                        }
                                        maxChars = 4;
                                    } else {
                                        if (extendedCharacterIndex >= 0) {
                                            throw new AddressStringException(str, extendedCharacterIndex);
                                        }
                                        isBase85 = false;
                                        if (!validationOptions.allowIPv4) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4");
                                        }
                                        ipAddressParseData.ipVersion = IPAddress.IPVersion.IPV4;
                                        stringFormatParams /* !! */  = ipv4SpecificOptions;
                                        if (segCount == 0) {
                                            parseData.initSegmentData(4);
                                        } else if (segCount >= 4) {
                                            throw new AddressStringException(str, "ipaddress.error.ipv4.too.many.segments");
                                        }
                                        maxChars = Validator.getMaxIPv4StringLength(3, 8);
                                    }
                                    vals = parseData.values[segCount];
                                    indices = parseData.indices[segCount];
                                    flags = parseData.flags[segCount];
                                    if (wildcardCount > 0) {
                                        if (!stringFormatParams /* !! */ .rangeOptions.allowsWildcard()) {
                                            throw new AddressStringException(str, "ipaddress.error.no.wildcard");
                                        }
                                        if (singleWildcardCount > 0 || rangeWildcardIndex >= 0 || leadingZeroCount > 0 || digitCount > 0 || hexDelimiterIndex >= 0) {
                                            throw new AddressStringException(str, index, true);
                                        }
                                        parseData.anyWildcard = true;
                                        flags[0] = true;
                                        vals[1] = isMac != false ? 65535 : 255;
                                        startIndex = index - wildcardCount;
                                        Validator.assignAttributes(startIndex, index, indices, startIndex);
                                    } else {
                                        value = 0L;
                                        isStandard = false;
                                        startIndex = index - digitCount;
                                        leadingZeroStartIndex = startIndex - leadingZeroCount;
                                        totalDigits = digitCount + leadingZeroCount;
                                        endIndex = index;
                                        if (digitCount == 0) {
                                            v3 = noLeadingZeros = leadingZeroCount == 0;
                                            if (noLeadingZeros && rangeWildcardIndex >= 0 && hexDelimiterIndex < 0) {
                                                if (isMac) {
                                                    value = 65535L;
                                                    radix = 16;
                                                } else {
                                                    value = 255L;
                                                    radix = 10;
                                                }
                                                isJustZero = false;
                                                isSingleWildcard = false;
                                            } else {
                                                if (noLeadingZeros) {
                                                    throw new AddressStringException(str, "ipaddress.error.empty.segment.at.index", index);
                                                }
                                                isSingleWildcard = false;
                                                isJustZero = true;
                                                --startIndex;
                                                ++digitCount;
                                                v4 = illegalLeadingZeros = --leadingZeroCount > 0 && stringFormatParams /* !! */ .allowLeadingZeros == false;
                                                if (hexDelimiterIndex >= 0) {
                                                    if (isMac) {
                                                        throw new AddressStringException(str, hexDelimiterIndex);
                                                    }
                                                    if (!ipv4SpecificOptions.inet_aton_hex) {
                                                        throw new AddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                                                    }
                                                    radix = 16;
                                                } else if (isMac) {
                                                    if (illegalLeadingZeros) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                                    }
                                                    if (!stringFormatParams /* !! */ .allowUnlimitedLeadingZeros && totalDigits > maxChars) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                                                    }
                                                    if (!macSpecificOptions.allowShortSegments && totalDigits < 2) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", leadingZeroStartIndex);
                                                    }
                                                    radix = 16;
                                                } else if (leadingZeroCount > 0 && ipv4SpecificOptions.inet_aton_octal) {
                                                    radix = 8;
                                                } else {
                                                    if (illegalLeadingZeros) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                                    }
                                                    radix = 10;
                                                }
                                                flags[2] = true;
                                                Validator.assignAttributes(startIndex, endIndex, indices, radix, leadingZeroStartIndex);
                                            }
                                        } else {
                                            if (digitCount > maxChars) {
                                                throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                                            }
                                            isJustZero = false;
                                            v5 = isSingleWildcard = singleWildcardCount > 0;
                                            if (isMac || hexDelimiterIndex >= 0) {
                                                if (isMac) {
                                                    if (hexDelimiterIndex >= 0) {
                                                        throw new AddressStringException(str, hexDelimiterIndex);
                                                    }
                                                    if (leadingZeroCount > 0 && !stringFormatParams /* !! */ .allowLeadingZeros) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                                    }
                                                    if (!stringFormatParams /* !! */ .allowUnlimitedLeadingZeros && totalDigits > maxChars) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                                                    }
                                                    if (!macSpecificOptions.allowShortSegments && totalDigits < 2) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", leadingZeroStartIndex);
                                                    }
                                                } else if (!ipv4SpecificOptions.inet_aton_hex) {
                                                    throw new AddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                                                }
                                                radix = 16;
                                                if (isSingleWildcard) {
                                                    if (rangeWildcardIndex >= 0) {
                                                        throw new AddressStringException(str, index, true);
                                                    }
                                                    Validator.parseSingleWildcard16(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, stringFormatParams /* !! */ );
                                                } else {
                                                    value = Validator.parseLong16(str, startIndex, endIndex);
                                                }
                                            } else {
                                                v6 = isOctal = leadingZeroCount > 0 && ipv4SpecificOptions.inet_aton_octal != false;
                                                if (isOctal) {
                                                    if (notOctal) {
                                                        throw new AddressStringException(str, "ipaddress.error.ipv4.invalid.octal.digit");
                                                    }
                                                    radix = 8;
                                                    if (isSingleWildcard) {
                                                        if (rangeWildcardIndex >= 0) {
                                                            throw new AddressStringException(str, index, true);
                                                        }
                                                        Validator.parseSingleWildcard8(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, stringFormatParams /* !! */ );
                                                    } else {
                                                        value = Validator.parseLong8(str, startIndex, endIndex);
                                                    }
                                                } else {
                                                    if (notDecimal) {
                                                        throw new AddressStringException(str, "ipaddress.error.ipv4.invalid.decimal.digit");
                                                    }
                                                    if (leadingZeroCount > 0 && !stringFormatParams /* !! */ .allowLeadingZeros) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                                    }
                                                    radix = 10;
                                                    if (isSingleWildcard) {
                                                        if (rangeWildcardIndex >= 0) {
                                                            throw new AddressStringException(str, index, true);
                                                        }
                                                        Validator.parseSingleWildcard10(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, ipv4SpecificOptions);
                                                    } else {
                                                        value = Validator.parseLong10(str, startIndex, endIndex);
                                                        isStandard = true;
                                                    }
                                                }
                                            }
                                        }
                                        if (rangeWildcardIndex >= 0) {
                                            frontStartIndex = rangeWildcardIndex - frontDigitCount;
                                            frontEndIndex = rangeWildcardIndex;
                                            frontLeadingZeroStartIndex = frontStartIndex - frontLeadingZeroCount;
                                            if (!stringFormatParams /* !! */ .rangeOptions.allowsRangeSeparator()) {
                                                throw new AddressStringException(str, "ipaddress.error.no.range");
                                            }
                                            if (!stringFormatParams /* !! */ .allowLeadingZeros && frontLeadingZeroCount > 0) {
                                                throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                            }
                                            if (frontDigitCount > maxChars) {
                                                throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", frontLeadingZeroStartIndex);
                                            }
                                            v7 = frontEmpty = frontStartIndex == frontEndIndex;
                                            if (isMac || frontHexDelimiterIndex >= 0) {
                                                if (isMac) {
                                                    if (frontHexDelimiterIndex >= 0) {
                                                        throw new AddressStringException(str, frontHexDelimiterIndex);
                                                    }
                                                    if (!macSpecificOptions.allowShortSegments && totalDigits < 2) {
                                                        throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", frontLeadingZeroStartIndex);
                                                    }
                                                    front = !frontEmpty ? Validator.parseLong16(str, frontStartIndex, frontEndIndex) : 0L;
                                                } else {
                                                    if (!ipv4SpecificOptions.inet_aton_hex) {
                                                        throw new AddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                                                    }
                                                    front = frontEmpty == false ? Validator.parseLong16(str, frontStartIndex, frontEndIndex) : 0L;
                                                }
                                                frontRadix = 16;
                                            } else {
                                                v8 = frontIsOctal = frontLeadingZeroCount > 0 && frontHexDelimiterIndex < 0 && ipv4SpecificOptions.inet_aton_octal != false;
                                                if (frontIsOctal) {
                                                    if (frontNotOctal) {
                                                        throw new AddressStringException(str, "ipaddress.error.ipv4.invalid.octal.digit");
                                                    }
                                                    front = Validator.parseLong8(str, frontStartIndex, frontEndIndex);
                                                    frontRadix = 8;
                                                } else {
                                                    if (frontNotDecimal) {
                                                        throw new AddressStringException(str, "ipaddress.error.ipv4.invalid.decimal.digit");
                                                    }
                                                    if (frontLeadingZeroCount == 0 && !frontEmpty) {
                                                        flags[2] = true;
                                                        if (isStandard && leadingZeroCount == 0) {
                                                            flags[3] = true;
                                                        }
                                                    }
                                                    front = frontEmpty == false ? Validator.parseLong10(str, frontStartIndex, frontEndIndex) : 0L;
                                                    frontRadix = 10;
                                                }
                                            }
                                            if (front > value) {
                                                throw new AddressStringException(str, "ipaddress.error.invalidRange");
                                            }
                                            if (!isJustZero) {
                                                Validator.assignAttributes(frontStartIndex, frontEndIndex, startIndex, endIndex, indices, frontLeadingZeroStartIndex, leadingZeroStartIndex, frontRadix, radix);
                                                vals[0] = front;
                                                vals[1] = value;
                                            }
                                            frontSingleWildcardCount = 0;
                                            frontWildcardCount = 0;
                                            frontLeadingZeroCount = 0;
                                            frontDigitCount = 0;
                                            frontUppercase = false;
                                            frontNotDecimal = false;
                                            frontNotOctal = false;
                                            frontHexDelimiterIndex = -1;
                                        } else if (!isSingleWildcard && !isJustZero) {
                                            if (isStandard) {
                                                flags[2] = true;
                                            }
                                            Validator.assignAttributes(startIndex, endIndex, indices, radix, leadingZeroStartIndex);
                                            vals[0] = vals[1] = value;
                                        }
                                    }
                                    ++parseData.segmentCount;
                                    lastSeparatorIndex = index++;
                                    leadingZeroCount = 0;
                                    wildcardCount = 0;
                                    singleWildcardCount = 0;
                                    digitCount = 0;
                                    rangeWildcardIndex = -1;
                                    hexDelimiterIndex = -1;
                                    uppercase = false;
                                    notDecimal = false;
                                    notOctal = false;
                                    continue;
                                }
                                isZoneChar = false;
                                isDashedRangeChar = false;
                                isRangeChar = false;
                                isSpace = false;
                                endOfSegment = currentChar == 58;
                                if (endOfSegment || (isRangeChar = currentChar == 45) || isMac && (isDashedRangeChar = currentChar == 124)) break block255;
                                isSpace = currentChar == 32;
                                endOfSegment = isSpace;
                                if (!isSpace) break block256;
                            }
                            if (endOfSegment) break block257;
                            if ((isRangeChar || isDashedRangeChar) && isMac) {
                                if (macFormat == null) {
                                    if (rangeWildcardIndex >= 0 && !firstSegmentDashedRange) {
                                        if (frontHexDelimiterIndex >= 0) {
                                            throw new AddressStringException(str, frontHexDelimiterIndex);
                                        }
                                        if (hexDelimiterIndex >= 0) {
                                            throw new AddressStringException(str, hexDelimiterIndex);
                                        }
                                        if (!macOptions.allowDashed) {
                                            throw new AddressStringException(str, "ipaddress.mac.error.format");
                                        }
                                        macAddressParseData.format = macFormat = ParsedMACAddress.MACAddressParseData.MACFormat.DASHED;
                                        countingCharsLater = true;
                                        parseData.initSegmentData(8);
                                        vals = parseData.values[0];
                                        flags = parseData.flags[0];
                                        indices = parseData.indices[0];
                                        if (frontWildcardCount > 0) {
                                            if (!stringFormatParams /* !! */ .rangeOptions.allowsWildcard()) {
                                                throw new AddressStringException(str, "ipaddress.error.no.wildcard");
                                            }
                                            if (frontSingleWildcardCount > 0 || frontLeadingZeroCount > 0 || frontDigitCount > 0 || frontHexDelimiterIndex >= 0) {
                                                throw new AddressStringException(str, rangeWildcardIndex, true);
                                            }
                                            parseData.anyWildcard = true;
                                            flags[0] = true;
                                            vals[1] = isDoubleSegment != false || digitCount + leadingZeroCount == 6 ? 0xFFFFFFL : 255L;
                                            startIndex = rangeWildcardIndex - frontWildcardCount;
                                            Validator.assignAttributes(startIndex, rangeWildcardIndex, indices, startIndex);
                                            frontWildcardCount = 0;
                                            rangeWildcardIndex = -1;
                                        } else {
                                            if (!stringFormatParams /* !! */ .allowLeadingZeros && frontLeadingZeroCount > 0) {
                                                throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                                            }
                                            value = 0L;
                                            startIndex = rangeWildcardIndex - frontDigitCount;
                                            leadingZeroStartIndex = startIndex - frontLeadingZeroCount;
                                            endIndex = rangeWildcardIndex;
                                            if (frontSingleWildcardCount > 0) {
                                                Validator.parseSingleWildcard16(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, stringFormatParams /* !! */ );
                                            } else {
                                                value = Validator.parseLong16(str, startIndex, endIndex);
                                                if (!uppercase) {
                                                    flags[2] = true;
                                                }
                                                Validator.assignAttributes(startIndex, endIndex, indices, 16, leadingZeroStartIndex);
                                                vals[0] = vals[1] = value;
                                            }
                                            frontSingleWildcardCount = 0;
                                            frontWildcardCount = 0;
                                            frontLeadingZeroCount = 0;
                                            frontDigitCount = 0;
                                            frontUppercase = false;
                                            frontNotDecimal = false;
                                            frontNotOctal = false;
                                            rangeWildcardIndex = -1;
                                            frontHexDelimiterIndex = -1;
                                        }
                                        ++parseData.segmentCount;
                                        endOfSegment = isRangeChar;
                                    } else if (isDashedRangeChar) {
                                        firstSegmentDashedRange = true;
                                    } else {
                                        endOfSegment = firstSegmentDashedRange;
                                    }
                                } else if (macFormat == ParsedMACAddress.MACAddressParseData.MACFormat.DASHED) {
                                    endOfSegment = isRangeChar;
                                } else if (isDashedRangeChar) {
                                    throw new AddressStringException(str, index);
                                }
                            }
                            if (endOfSegment) break block257;
                            if (extendedCharacterIndex >= 0) break block258;
                            if (rangeWildcardIndex < 0) ** GOTO lbl541
                            if (isBase85) {
                                if (extendedCharacterIndex < 0) {
                                    extendedCharacterIndex = index;
                                }
                            } else {
                                throw new AddressStringException(str, index, true);
lbl541:
                                // 1 sources

                                rangeWildcardIndex = index;
                                frontIsStandardRange = isRangeChar;
                                frontDigitCount = digitCount;
                                frontLeadingZeroCount = leadingZeroCount;
                                if (frontDigitCount == 0 && frontLeadingZeroCount != 0) {
                                    ++frontDigitCount;
                                    --frontLeadingZeroCount;
                                }
                                frontNotOctal = notOctal;
                                frontNotDecimal = notDecimal;
                                frontUppercase = uppercase;
                                frontHexDelimiterIndex = hexDelimiterIndex;
                                frontWildcardCount = wildcardCount;
                                frontSingleWildcardCount = singleWildcardCount;
                                digitCount = 0;
                                leadingZeroCount = 0;
                                uppercase = false;
                                notDecimal = false;
                                notOctal = false;
                                hexDelimiterIndex = -1;
                                singleWildcardCount = 0;
                                wildcardCount = 0;
                            }
                        }
                        ++index;
                    }
                    if (!endOfSegment) continue;
                    if (hexDelimiterIndex >= 0 && !isSingleSegment) {
                        throw new AddressStringException(str, hexDelimiterIndex);
                    }
                    segCount = parseData.segmentCount;
                    if (isMac) {
                        if (segCount == 0) {
                            if (isSingleSegment) {
                                parseData.initSegmentData(1);
                            } else {
                                if (isRangeChar != false ? macOptions.allowDashed == false : (isSpace != false ? macOptions.allowSpaceDelimited == false : macOptions.allowColonDelimited == false)) {
                                    throw new AddressStringException(str, "ipaddress.mac.error.format");
                                }
                                if (isRangeChar) {
                                    macAddressParseData.format = macFormat = ParsedMACAddress.MACAddressParseData.MACFormat.DASHED;
                                    countingCharsLater = true;
                                } else {
                                    macFormat = isSpace != false ? ParsedMACAddress.MACAddressParseData.MACFormat.SPACE_DELIMITED : ParsedMACAddress.MACAddressParseData.MACFormat.COLON_DELIMITED;
                                    macAddressParseData.format = macFormat;
                                }
                                parseData.initSegmentData(8);
                            }
                        } else {
                            if (isRangeChar != false ? macFormat != ParsedMACAddress.MACAddressParseData.MACFormat.DASHED : macFormat != (isSpace != false ? ParsedMACAddress.MACAddressParseData.MACFormat.SPACE_DELIMITED : ParsedMACAddress.MACAddressParseData.MACFormat.COLON_DELIMITED)) {
                                throw new AddressStringException(str, "ipaddress.mac.error.mix.format.characters.at.index", index);
                            }
                            if (segCount >= (macOptions.addressSize == MACAddressStringParameters.AddressSize.MAC ? 6 : 8)) {
                                throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                            }
                        }
                        maxChars = 2;
                    } else {
                        if (extendedCharacterIndex >= 0) {
                            throw new AddressStringException(str, extendedCharacterIndex);
                        }
                        isBase85 = false;
                        if (segCount == 0) {
                            parseData.initSegmentData(isSingleSegment != false ? 1 : 8);
                        } else {
                            if (segCount >= 8) {
                                throw new AddressStringException(str, "ipaddress.error.too.many.segments");
                            }
                            if (ipAddressParseData.ipVersion == null || ipAddressParseData.ipVersion.isIPv4()) {
                                throw new AddressStringException(str, "ipaddress.error.ipv6.separator");
                            }
                        }
                        if (!validationOptions.allowIPv6) {
                            throw new AddressStringException(str, "ipaddress.error.ipv6");
                        }
                        ipAddressParseData.ipVersion = IPAddress.IPVersion.IPV6;
                        stringFormatParams /* !! */  = ipv6SpecificOptions;
                        maxChars = 4;
                    }
                    vals = parseData.values[segCount];
                    flags = parseData.flags[segCount];
                    indices = parseData.indices[segCount];
                    if (wildcardCount > 0) {
                        if (!stringFormatParams /* !! */ .rangeOptions.allowsWildcard()) {
                            throw new AddressStringException(str, "ipaddress.error.no.wildcard");
                        }
                        if (singleWildcardCount > 0 || rangeWildcardIndex >= 0 || leadingZeroCount > 0 || digitCount > 0) {
                            throw new AddressStringException(str, index, true);
                        }
                        parseData.anyWildcard = true;
                        flags[0] = true;
                        vals[1] = isMac ? (isDoubleSegment ? 0xFFFFFFL : 255L) : 65535L;
                        startIndex = index - wildcardCount;
                        Validator.assignAttributes(startIndex, index, indices, startIndex);
                        ++parseData.segmentCount;
                    } else if (index == strStartIndex) {
                        if (isMac) {
                            throw new AddressStringException(str, "ipaddress.error.empty.segment.at.index", index);
                        }
                        if (index + 1 == strEndIndex) {
                            throw new AddressStringException(str, "ipaddress.error.too.few.segments");
                        }
                        if (str.charAt(index + 1) != ':') {
                            throw new AddressStringException(str, "ipaddress.error.ipv6.cannot.start.with.single.separator");
                        }
                    } else if (index == lastSeparatorIndex + 1) {
                        if (isMac) {
                            throw new AddressStringException(str, "ipaddress.error.empty.segment.at.index", index);
                        }
                        if (parseData.consecutiveSepIndex >= 0) {
                            throw new AddressStringException(str, "ipaddress.error.ipv6.ambiguous");
                        }
                        parseData.consecutiveSepIndex = index - 1;
                        Validator.assignAttributes(index, index, indices, index);
                        ++parseData.segmentCount;
                    } else {
                        if (!stringFormatParams /* !! */ .allowLeadingZeros && leadingZeroCount > 0) {
                            throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                        }
                        extendedValue = 0L;
                        value = 0L;
                        isStandard = false;
                        startIndex = index - digitCount;
                        totalDigits = digitCount + leadingZeroCount;
                        leadingZeroStartIndex = startIndex - leadingZeroCount;
                        endIndex = index;
                        v9 = checkCharCounts = countedCharacters == false && countingCharsLater == false;
                        if (checkCharCounts && !stringFormatParams /* !! */ .allowUnlimitedLeadingZeros && totalDigits > maxChars) {
                            throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                        }
                        if (isMac && !macSpecificOptions.allowShortSegments && totalDigits < 2) {
                            throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", leadingZeroStartIndex);
                        }
                        if (digitCount == 0) {
                            if (rangeWildcardIndex >= 0 && leadingZeroCount == 0) {
                                value = isMac != false ? 255 : 65535;
                                isJustZero = false;
                            } else {
                                ++digitCount;
                                --leadingZeroCount;
                                isJustZero = true;
                                flags[2] = true;
                                Validator.assignAttributes(--startIndex, endIndex, indices, leadingZeroStartIndex);
                            }
                        } else {
                            if (checkCharCounts && digitCount > maxChars) {
                                throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", leadingZeroStartIndex);
                            }
                            if (singleWildcardCount > 0) {
                                if (rangeWildcardIndex >= 0) {
                                    throw new AddressStringException(str, index, true);
                                }
                                isJustZero = false;
                                if (isSingleIPv6Hex) {
                                    Validator.parseSingleSegmentSingleWildcard16(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, stringFormatParams /* !! */ );
                                } else {
                                    Validator.parseSingleWildcard16(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, stringFormatParams /* !! */ );
                                }
                            } else {
                                isJustZero = false;
                                if (isSingleIPv6Hex) {
                                    midIndex = endIndex - 16;
                                    if (startIndex < midIndex) {
                                        extendedValue = Validator.parseLong16(str, startIndex, midIndex);
                                        value = Validator.parseLong16(str, midIndex, endIndex);
                                    } else {
                                        value = Validator.parseLong16(str, startIndex, endIndex);
                                    }
                                } else {
                                    value = Validator.parseLong16(str, startIndex, endIndex);
                                }
                                v10 = isStandard = uppercase == false;
                            }
                        }
                        if (rangeWildcardIndex >= 0) {
                            frontStartIndex = rangeWildcardIndex - frontDigitCount;
                            frontEndIndex = rangeWildcardIndex;
                            frontLeadingZeroStartIndex = frontStartIndex - frontLeadingZeroCount;
                            frontTotalDigitCount = frontDigitCount + frontLeadingZeroCount;
                            if (!stringFormatParams /* !! */ .rangeOptions.allowsRangeSeparator()) {
                                throw new AddressStringException(str, "ipaddress.error.no.range");
                            }
                            if (frontHexDelimiterIndex >= 0 && !isSingleSegment) {
                                throw new AddressStringException(str, frontHexDelimiterIndex);
                            }
                            if (!stringFormatParams /* !! */ .allowLeadingZeros && frontLeadingZeroCount > 0) {
                                throw new AddressStringException(str, "ipaddress.error.segment.leading.zeros");
                            }
                            if (isMac && !macSpecificOptions.allowShortSegments && frontTotalDigitCount < 2) {
                                throw new AddressStringException(str, "ipaddress.error.segment.too.short.at.index", frontLeadingZeroStartIndex);
                            }
                            if (checkCharCounts) {
                                if (frontDigitCount > maxChars) {
                                    throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", frontLeadingZeroStartIndex);
                                }
                                if (!stringFormatParams /* !! */ .allowUnlimitedLeadingZeros && frontTotalDigitCount > maxChars) {
                                    throw new AddressStringException(str, "ipaddress.error.segment.too.long.at.index", frontLeadingZeroStartIndex);
                                }
                            }
                            if (isSingleIPv6Hex) {
                                frontEmpty = false;
                                frontMidIndex = frontEndIndex - 16;
                                extendedFront = Validator.parseLong16(str, frontStartIndex, frontMidIndex);
                                front = Validator.parseLong16(str, frontMidIndex, frontEndIndex);
                            } else {
                                frontEmpty = frontStartIndex == frontEndIndex;
                                front = frontEmpty == false ? Validator.parseLong16(str, frontStartIndex, frontEndIndex) : 0L;
                                extendedFront = 0L;
                                if (front > value) {
                                    throw new AddressStringException(str, "ipaddress.error.invalidRange");
                                }
                            }
                            if (!isJustZero) {
                                if (!frontUppercase && frontLeadingZeroCount == 0 && !frontEmpty) {
                                    flags[2] = true;
                                    if (isStandard && leadingZeroCount == 0 && frontIsStandardRange) {
                                        flags[3] = true;
                                    }
                                }
                                Validator.assignAttributes(frontStartIndex, frontEndIndex, startIndex, endIndex, indices, frontLeadingZeroStartIndex, leadingZeroStartIndex, 16, 16);
                                vals[0] = front;
                                vals[1] = value;
                                if (isSingleIPv6Hex) {
                                    vals[2] = extendedFront;
                                    vals[3] = extendedValue;
                                }
                            }
                            frontSingleWildcardCount = 0;
                            frontWildcardCount = 0;
                            frontLeadingZeroCount = 0;
                            frontDigitCount = 0;
                            frontUppercase = false;
                            frontNotDecimal = false;
                            frontNotOctal = false;
                            frontHexDelimiterIndex = -1;
                        } else if (singleWildcardCount == 0 && !isJustZero) {
                            if (isStandard) {
                                flags[2] = true;
                            }
                            Validator.assignAttributes(startIndex, endIndex, indices, 16, leadingZeroStartIndex);
                            vals[0] = vals[1] = value;
                            if (isSingleIPv6Hex) {
                                vals[2] = vals[3] = extendedValue;
                            }
                        }
                        ++parseData.segmentCount;
                    }
                    lastSeparatorIndex = index++;
                    rangeWildcardIndex = -1;
                    hexDelimiterIndex = -1;
                    leadingZeroCount = 0;
                    wildcardCount = 0;
                    singleWildcardCount = 0;
                    digitCount = 0;
                    uppercase = false;
                    notDecimal = false;
                    notOctal = false;
                    continue;
                }
                if (currentChar == 47) {
                    if (isMac) {
                        throw new AddressStringException(str, index);
                    }
                    ipAddressParseData.isPrefixed = true;
                    strEndIndex = index;
                    ipAddressParseData.qualifierIndex = index + 1;
                    continue;
                }
                if (currentChar == 42 || (isZoneChar = currentChar == 37)) {
                    if (isZoneChar && !isMac && ipv6SpecificOptions.allowZone && (parseData.segmentCount > 0 && (isEmbeddedIPv4 || ipAddressParseData.ipVersion == IPAddress.IPVersion.IPV6) || leadingZeroCount + digitCount == 32 && (rangeWildcardIndex < 0 || frontLeadingZeroCount + frontDigitCount == 32) || wildcardCount == index)) {
                        if (extendedCharacterIndex >= 0) {
                            throw new AddressStringException(str, extendedCharacterIndex);
                        }
                        isBase85 = false;
                        ipAddressParseData.isZoned = true;
                        strEndIndex = index;
                        ipAddressParseData.qualifierIndex = index + 1;
                        continue;
                    }
                    ++wildcardCount;
                    ++index;
                    continue;
                }
                if (currentChar == 95) {
                    ++digitCount;
                    ++index;
                    ++singleWildcardCount;
                    continue;
                }
                if (currentChar != 120) break block259;
                if (digitCount <= 0 && leadingZeroCount == 1 && hexDelimiterIndex < 0 && singleWildcardCount <= 0) ** GOTO lbl784
                if (isBase85) {
                    if (extendedCharacterIndex < 0) {
                        extendedCharacterIndex = index;
                    }
                } else {
                    throw new AddressStringException(str, index, true);
lbl784:
                    // 1 sources

                    hexDelimiterIndex = index;
                    leadingZeroCount = 0;
                }
                ++index;
                continue;
            }
            if (currentChar == 8250) {
                if (isBase85) {
                    if (extendedCharacterIndex < 0) {
                        extendedCharacterIndex = index;
                    }
                    if ((base85TotalDigits = index - strStartIndex) == 20) {
                        extendedRangeWildcardIndex = index++;
                        continue;
                    }
                    throw new AddressStringException(str, extendedCharacterIndex);
                }
                throw new AddressStringException(str, index);
            }
            if (currentChar == 167) {
                if (isBase85 && !isMac && ipv6SpecificOptions.allowZone) {
                    ipAddressParseData.isBase85Zoned = true;
                    ipAddressParseData.isZoned = true;
                    strEndIndex = index;
                    ipAddressParseData.qualifierIndex = index + 1;
                    continue;
                }
                throw new AddressStringException(str, index);
            }
            if (isBase85) {
                if (currentChar < 0 || currentChar > Validator.extendedChars.length - 1) {
                    throw new AddressStringException(str, index);
                }
                val = Validator.extendedChars[currentChar];
                if (val == 0) {
                    throw new AddressStringException(str, index);
                }
                if (extendedCharacterIndex < 0) {
                    extendedCharacterIndex = index;
                }
            } else {
                throw new AddressStringException(str, index);
            }
            ++index;
        }
    }

    private static IPAddressProvider createProvider(HostIdentifierString originator, CharSequence fullAddr, IPAddressStringParameters validationOptions, ParsedIPAddress.IPAddressParseData parseData, ParsedHostIdentifierStringQualifier qualifier) throws AddressStringException {
        IPAddress.IPVersion version = parseData.ipVersion;
        if (version == null) {
            version = qualifier.inferVersion(validationOptions);
            IPAddress.IPVersion optionsVersion = validationOptions.inferVersion();
            if (version == null) {
                parseData.ipVersion = version = optionsVersion;
            } else if (optionsVersion != null && !version.equals((Object)optionsVersion)) {
                throw new AddressStringException(fullAddr, version == IPAddress.IPVersion.IPV6 ? "ipaddress.error.ipv6" : "ipaddress.error.ipv4");
            }
            if (parseData.addressParseData.isEmpty) {
                if (qualifier.getNetworkPrefixLength() != null) {
                    return new IPAddressProvider.MaskCreator(qualifier, version);
                }
                if (validationOptions.emptyIsLoopback) {
                    return IPAddressProvider.LOOPBACK_CREATOR;
                }
                return IPAddressProvider.EMPTY_PROVIDER;
            }
            if (qualifier == ParsedHost.NO_QUALIFIER && version == null) {
                return IPAddressProvider.ALL_ADDRESSES_CREATOR;
            }
            return new IPAddressProvider.AllCreator(qualifier, version, originator);
        }
        if (parseData.isZoned && parseData.ipVersion.isIPv4()) {
            throw new AddressStringException(fullAddr, "ipaddress.error.only.ipv6.has.zone");
        }
        ParsedIPAddress valueCreator = Validator.createIPAddressProvider(originator, fullAddr, validationOptions, parseData, qualifier);
        return new IPAddressProvider.ParsedAddressProvider(valueCreator);
    }

    private static void checkMaxValues(CharSequence fullAddr, AddressParseData parseData, int segmentIndex, AddressStringParameters.AddressStringFormatParameters params, long maxValue, long maxDigitCount, long maxUpperDigitCount) throws AddressStringException {
        boolean[] flags = parseData.flags[segmentIndex];
        long[] values = parseData.values[segmentIndex];
        int[] indices = parseData.indices[segmentIndex];
        int lowerRadix = indices[0];
        if (flags[1]) {
            if (values[0] > maxValue) {
                throw new AddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.large");
            }
            if (values[1] > maxValue) {
                values[1] = maxValue;
            }
            if (!params.allowUnlimitedLeadingZeros && (long)(indices[4] - indices[2] - Validator.getStringPrefixCharCount(lowerRadix)) > maxDigitCount) {
                throw new AddressStringException(fullAddr, "ipaddress.error.segment.too.long");
            }
        } else {
            if (values[1] > maxValue) {
                throw new AddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.large");
            }
            int upperRadix = indices[1];
            if (!params.allowUnlimitedLeadingZeros) {
                if ((long)(indices[4] - indices[2] - Validator.getStringPrefixCharCount(lowerRadix)) > maxDigitCount) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.segment.too.long");
                }
                if ((long)(indices[7] - indices[5] - Validator.getStringPrefixCharCount(upperRadix)) > maxUpperDigitCount) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.segment.too.long");
                }
            }
        }
    }

    private static ParsedIPAddress createIPAddressProvider(HostIdentifierString originator, CharSequence fullAddr, IPAddressStringParameters validationOptions, ParsedIPAddress.IPAddressParseData parseData, ParsedHostIdentifierStringQualifier qualifier) throws AddressStringException {
        int segCount = parseData.addressParseData.segmentCount;
        IPAddress.IPVersion version = parseData.ipVersion;
        if (version.isIPv4()) {
            int missingCount = 4 - segCount;
            IPv4AddressStringParameters ipv4Options = validationOptions.getIPv4Parameters();
            if (missingCount > 0 && !parseData.addressParseData.anyWildcard && segCount > 1 && !ipv4Options.inet_aton_joinedSegments) {
                throw new AddressStringException(fullAddr, "ipaddress.error.ipv4.too.few.segments");
            }
            long oneSegmentMax = Validator.getMaxIPv4Value(0);
            int i = 0;
            while (i < segCount) {
                int maxUpperDigits;
                int maxDigits;
                long max;
                int[] indices = parseData.addressParseData.indices[i];
                int lowerRadix = indices[0];
                int upperRadix = indices[1];
                if (i == segCount - 1 && missingCount > 0) {
                    max = Validator.getMaxIPv4Value(missingCount);
                    maxDigits = Validator.getMaxIPv4StringLength(missingCount, lowerRadix);
                    maxUpperDigits = upperRadix != lowerRadix ? Validator.getMaxIPv4StringLength(missingCount, upperRadix) : maxDigits;
                } else {
                    max = oneSegmentMax;
                    maxDigits = Validator.getMaxIPv4StringLength(0, lowerRadix);
                    maxUpperDigits = upperRadix != lowerRadix ? Validator.getMaxIPv4StringLength(0, upperRadix) : maxDigits;
                }
                Validator.checkMaxValues(fullAddr, parseData.addressParseData, i, ipv4Options, max, maxDigits, maxUpperDigits);
                ++i;
            }
        } else {
            int totalSegmentCount = segCount;
            if (parseData.mixedParsedAddress != null) {
                totalSegmentCount += 2;
            }
            if (totalSegmentCount != 1 && totalSegmentCount < 8 && !parseData.addressParseData.anyWildcard && !parseData.isCompressed()) {
                throw new AddressStringException(fullAddr, "ipaddress.error.too.few.segments");
            }
        }
        ParsedIPAddress valueCreator = new ParsedIPAddress(originator, fullAddr, parseData, version, qualifier);
        return valueCreator;
    }

    @Override
    public int validatePrefix(CharSequence fullAddr, IPAddress.IPVersion version) throws AddressStringException {
        return Validator.validatePrefixImpl(fullAddr, version);
    }

    static int validatePrefixImpl(CharSequence fullAddr, IPAddress.IPVersion version) throws AddressStringException {
        ParsedHostIdentifierStringQualifier qualifier = Validator.validatePrefix(fullAddr, DEFAULT_PREFIX_OPTIONS, 0, fullAddr.length(), version);
        if (qualifier == null) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.invalidCIDRPrefix");
        }
        return qualifier.getNetworkPrefixLength();
    }

    private static ParsedHostIdentifierStringQualifier validatePort(CharSequence fullAddr, HostNameParameters validationOptions, int index, int endIndex) throws AddressStringException {
        if (!validationOptions.allowPort) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.host.error.port");
        }
        boolean isPort = true;
        int digitCount = 0;
        int i = index;
        while (isPort && i < endIndex) {
            char c = fullAddr.charAt(i);
            if (c >= '1' && c <= '9') {
                ++digitCount;
            } else if (c == '0') {
                if (digitCount > 0) {
                    ++digitCount;
                }
            } else {
                isPort = false;
            }
            ++i;
        }
        if (!isPort || digitCount > 5) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.invalidPort");
        }
        int result = Validator.parse10(fullAddr, index, endIndex);
        if (result > 65535) {
            throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.invalidPort");
        }
        return new ParsedHostIdentifierStringQualifier(null, result);
    }

    private static ParsedHostIdentifierStringQualifier validatePrefix(CharSequence fullAddr, IPAddressStringParameters validationOptions, int index, int endIndex, IPAddress.IPVersion ipVersion) throws AddressStringException {
        if (index == fullAddr.length()) {
            return null;
        }
        boolean isPrefix = true;
        int leadingZeros = 0;
        int digitCount = 0;
        int i = index;
        while (isPrefix && i < endIndex) {
            char c = fullAddr.charAt(i);
            if (c >= '1' && c <= '9') {
                ++digitCount;
            } else if (c == '0') {
                if (digitCount > 0) {
                    ++digitCount;
                } else {
                    ++leadingZeros;
                }
            } else {
                isPrefix = false;
            }
            ++i;
        }
        if (isPrefix) {
            boolean allowPrefixesBeyondAddressSize;
            boolean asIPv4;
            boolean bl = asIPv4 = ipVersion != null && ipVersion.isIPv4();
            if (digitCount == 0) {
                --leadingZeros;
                ++digitCount;
            }
            if (leadingZeros > 0) {
                if (asIPv4) {
                    if (!validationOptions.getIPv4Parameters().allowPrefixLengthLeadingZeros) {
                        throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.ipv4.prefix.leading.zeros");
                    }
                } else if (!validationOptions.getIPv6Parameters().allowPrefixLengthLeadingZeros) {
                    throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.ipv6.prefix.leading.zeros");
                }
            }
            if (!(allowPrefixesBeyondAddressSize = (asIPv4 ? validationOptions.getIPv4Parameters() : validationOptions.getIPv6Parameters()).allowPrefixesBeyondAddressSize) && digitCount > (asIPv4 ? 2 : 3)) {
                if (asIPv4 && validationOptions.allowSingleSegment) {
                    return null;
                }
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.prefixSize");
            }
            int result = Validator.parse10(fullAddr, index, endIndex);
            if (!allowPrefixesBeyondAddressSize && result > (asIPv4 ? 32 : 128)) {
                if (asIPv4 && validationOptions.allowSingleSegment) {
                    return null;
                }
                throw new AddressStringException((CharSequence)fullAddr.toString(), "ipaddress.error.prefixSize");
            }
            if (result < PREFIX_CACHE.length) {
                ParsedHostIdentifierStringQualifier qual = PREFIX_CACHE[result];
                if (qual == null) {
                    qual = Validator.PREFIX_CACHE[result] = new ParsedHostIdentifierStringQualifier(result, null);
                }
                return qual;
            }
            return new ParsedHostIdentifierStringQualifier(result, null);
        }
        return null;
    }

    private static ParsedHostIdentifierStringQualifier parseQualifier(CharSequence fullAddr, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, ParsedIPAddress.IPAddressParseData ipAddressParseData, int endIndex) throws AddressStringException {
        if (ipAddressParseData.isBase85Zoned && !ipAddressParseData.isBase85) {
            throw new AddressStringException(fullAddr, ipAddressParseData.qualifierIndex - 1);
        }
        return Validator.parseQualifier(fullAddr, validationOptions, hostValidationOptions, ipAddressParseData.isPrefixed, ipAddressParseData.isZoned, ipAddressParseData.hasPort, ipAddressParseData.addressParseData.isEmpty, ipAddressParseData.qualifierIndex, endIndex, ipAddressParseData.ipVersion);
    }

    private static ParsedHostIdentifierStringQualifier parseQualifier(CharSequence fullAddr, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, boolean isPrefixed, boolean hasPort, ParsedIPAddress.IPAddressParseData ipAddressParseData, int qualifierIndex, int endIndex) throws AddressStringException {
        return Validator.parseQualifier(fullAddr, validationOptions, hostValidationOptions, isPrefixed, ipAddressParseData.isZoned, hasPort, ipAddressParseData.addressParseData.isEmpty, qualifierIndex, endIndex, ipAddressParseData.ipVersion);
    }

    private static ParsedHostIdentifierStringQualifier parseQualifier(CharSequence fullAddr, IPAddressStringParameters validationOptions, HostNameParameters hostValidationOptions, boolean isPrefixed, boolean isZoned, boolean isPort, boolean addressIsEmpty, int index, int endIndex, IPAddress.IPVersion ipVersion) throws AddressStringException {
        if (isPrefixed) {
            ParsedHostIdentifierStringQualifier qualifier;
            if (validationOptions.allowPrefix && (qualifier = Validator.validatePrefix(fullAddr, validationOptions, index, fullAddr.length(), ipVersion)) != null) {
                return qualifier;
            }
            if (addressIsEmpty) {
                throw new AddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefix");
            }
            if (validationOptions.allowMask) {
                try {
                    IPAddressStringParameters maskOptions = Validator.toMaskOptions(validationOptions, ipVersion);
                    ParsedIPAddress.IPAddressParseData ipAddressParseData = new ParsedIPAddress.IPAddressParseData();
                    Validator.validateIPAddress(maskOptions, fullAddr, index, endIndex, ipAddressParseData);
                    AddressParseData maskParseData = ipAddressParseData.addressParseData;
                    if (maskParseData.isEmpty || maskParseData.isAll) {
                        throw new AddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefixOrMask");
                    }
                    ParsedIPAddress maskAddress = Validator.createIPAddressProvider(null, fullAddr, maskOptions, ipAddressParseData, ParsedHost.NO_QUALIFIER);
                    if (maskParseData.addressEndIndex != fullAddr.length()) {
                        throw new AddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefixOrMask");
                    }
                    IPAddress.IPVersion maskVersion = ipAddressParseData.ipVersion;
                    if (maskVersion.isIPv4() && maskParseData.segmentCount == 1 && !maskParseData.anyWildcard && !validationOptions.getIPv4Parameters().inet_aton_single_segment_mask) {
                        throw new AddressStringException(fullAddr, "ipaddress.error.mask.single.segment");
                    }
                    if (ipVersion != null && (maskVersion.isIPv4() != ipVersion.isIPv4() || maskVersion.isIPv6() != ipVersion.isIPv6())) {
                        throw new AddressStringException(fullAddr, "ipaddress.error.ipMismatch");
                    }
                    return new ParsedHostIdentifierStringQualifier(maskAddress);
                }
                catch (AddressStringException e) {
                    throw new AddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefixOrMask", e);
                }
            }
            throw new AddressStringException(fullAddr, "ipaddress.error.CIDRNotAllowed");
        }
        if (isZoned) {
            if (addressIsEmpty) {
                throw new AddressStringException(fullAddr, "ipaddress.error.only.zone");
            }
            CharSequence zone = fullAddr.subSequence(index, endIndex);
            return new ParsedHostIdentifierStringQualifier(zone);
        }
        if (isPort) {
            ParsedHostIdentifierStringQualifier qualifier = Validator.validatePort(fullAddr, hostValidationOptions, index, fullAddr.length());
            if (qualifier != null) {
                return qualifier;
            }
            throw new AddressStringException(fullAddr, "ipaddress.error.invalidPort");
        }
        return ParsedHost.NO_QUALIFIER;
    }

    private static IPAddressStringParameters toMaskOptions(IPAddressStringParameters validationOptions, IPAddress.IPVersion ipVersion) {
        IPAddressStringParameters.Builder builder = null;
        if (ipVersion == null || ipVersion.isIPv6()) {
            IPv6AddressStringParameters ipv6Options = validationOptions.getIPv6Parameters();
            if (!ipv6Options.rangeOptions.isNoRange()) {
                builder = validationOptions.toBuilder();
                builder.getIPv6AddressParametersBuilder().setRangeOptions(AddressStringParameters.RangeParameters.NO_RANGE);
            }
            if (ipv6Options.allowMixed && !ipv6Options.getMixedParameters().getIPv4Parameters().rangeOptions.isNoRange()) {
                if (builder == null) {
                    builder = validationOptions.toBuilder();
                }
                builder.getIPv6AddressParametersBuilder().setRangeOptions(AddressStringParameters.RangeParameters.NO_RANGE);
            }
        }
        if (ipVersion == null || ipVersion.isIPv4()) {
            IPv4AddressStringParameters ipv4Options = validationOptions.getIPv4Parameters();
            if (!ipv4Options.rangeOptions.isNoRange()) {
                if (builder == null) {
                    builder = validationOptions.toBuilder();
                }
                builder.getIPv4AddressParametersBuilder().setRangeOptions(AddressStringParameters.RangeParameters.NO_RANGE);
            }
        }
        if (validationOptions.allowAll) {
            if (builder == null) {
                builder = validationOptions.toBuilder();
            }
            builder.allowAll(false);
        }
        IPAddressStringParameters maskOptions = builder == null ? validationOptions : builder.toParams();
        return maskOptions;
    }

    private static void assignAttributes(int frontStart, int frontEnd, int start, int end, int[] indices, int frontLeadingZeroStartIndex, int leadingZeroStartIndex) {
        indices[2] = frontLeadingZeroStartIndex;
        indices[3] = frontStart;
        indices[4] = frontEnd;
        indices[5] = leadingZeroStartIndex;
        indices[6] = start;
        indices[7] = end;
    }

    private static void assignAttributes(int frontStart, int frontEnd, int start, int end, int[] indices, int frontLeadingZeroStartIndex, int leadingZeroStartIndex, int frontRadix, int radix) {
        indices[0] = frontRadix;
        indices[1] = radix;
        Validator.assignAttributes(frontStart, frontEnd, start, end, indices, frontLeadingZeroStartIndex, leadingZeroStartIndex);
    }

    private static void assignAttributes(int start, int end, int[] indices, int leadingZeroStartIndex) {
        indices[5] = indices[2] = leadingZeroStartIndex;
        indices[6] = indices[3] = start;
        indices[7] = indices[4] = end;
    }

    private static void assignAttributes(int start, int end, int[] indices, int radix, int leadingZeroStartIndex) {
        indices[1] = indices[0] = radix;
        Validator.assignAttributes(start, end, indices, leadingZeroStartIndex);
    }

    private static void assignSingleWildcardAttributes(CharSequence str, int start, int end, int digitsEnd, int numSingleWildcards, int[] indices, boolean[] flags, int radix, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        if (!options.rangeOptions.allowsSingleWildcard()) {
            throw new AddressStringException(str, "ipaddress.error.no.single.wildcard");
        }
        int k = digitsEnd;
        while (k < end) {
            if (str.charAt(k) != '_') {
                throw new AddressStringException(str, "ipaddress.error.single.wildcard.order");
            }
            ++k;
        }
        flags[1] = true;
        Validator.assignAttributes(start, end, indices, radix, leadingZeroStartIndex);
    }

    private static void parseSingleWildcard10(CharSequence s, int start, int end, int numSingleWildcards, int[] indices, long[] vals, boolean[] flags, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        long upper;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, indices, flags, 10, leadingZeroStartIndex, options);
        long lower = start < digitsEnd ? Validator.parseLong10(s, start, digitsEnd) : 0L;
        switch (numSingleWildcards) {
            case 1: {
                upper = (lower *= 10L) + 9L;
                break;
            }
            case 2: {
                upper = (lower *= 100L) + 99L;
                break;
            }
            case 3: {
                upper = (lower *= 1000L) + 999L;
                break;
            }
            default: {
                long power = (long)Math.pow(10.0, numSingleWildcards);
                upper = (lower *= power) + power - 1L;
            }
        }
        vals[0] = lower;
        vals[1] = upper;
    }

    private static void parseSingleWildcard8(CharSequence s, int start, int end, int numSingleWildcards, int[] indices, long[] vals, boolean[] flags, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        long upper;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, indices, flags, 8, leadingZeroStartIndex, options);
        long lower = start < digitsEnd ? Validator.parseLong8(s, start, digitsEnd) : 0L;
        switch (numSingleWildcards) {
            case 1: {
                upper = (lower <<= 3) | 7L;
                break;
            }
            case 2: {
                upper = (lower <<= 6) | 0x3FL;
                break;
            }
            case 3: {
                upper = (lower <<= 9) | 0x1FFL;
                break;
            }
            default: {
                int shift = numSingleWildcards * 3;
                upper = (lower <<= shift) | -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        vals[0] = lower;
        vals[1] = upper;
    }

    private static void parseSingleWildcard16(CharSequence s, int start, int end, int numSingleWildcards, int[] indices, long[] vals, boolean[] flags, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, indices, flags, 16, leadingZeroStartIndex, options);
        long lower = start < digitsEnd ? Validator.parseLong16(s, start, digitsEnd) : 0L;
        int shift = numSingleWildcards << 2;
        long upper = (lower <<= shift) | -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        vals[0] = lower;
        vals[1] = upper;
    }

    private static void parseSingleSegmentSingleWildcard16(CharSequence s, int start, int end, int numSingleWildcards, int[] indices, long[] vals, boolean[] flags, int leadingZeroStartIndex, AddressStringParameters.AddressStringFormatParameters options) throws AddressStringException {
        long extendedUpper;
        long extendedLower;
        long upper;
        long lower;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, indices, flags, 16, leadingZeroStartIndex, options);
        if (numSingleWildcards < 16) {
            int midIndex = end - 16;
            lower = Validator.parseLong16(s, midIndex, digitsEnd);
            int shift = numSingleWildcards << 2;
            upper = (lower <<= shift) | -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
            extendedUpper = extendedLower = Validator.parseLong16(s, start, midIndex);
        } else if (numSingleWildcards == 16) {
            lower = 0L;
            upper = -1L;
            extendedUpper = extendedLower = Validator.parseLong16(s, start, digitsEnd);
        } else {
            lower = 0L;
            upper = -1L;
            extendedLower = Validator.parseLong16(s, start, digitsEnd);
            int shift = numSingleWildcards - 16 << 2;
            extendedUpper = (extendedLower <<= shift) | -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        }
        vals[0] = lower;
        vals[1] = upper;
        vals[2] = extendedLower;
        vals[3] = extendedUpper;
    }

    private static long getMaxIPv4Value(int additionalSegmentsCovered) {
        if (additionalSegmentsCovered == 0) {
            return 255L;
        }
        if (additionalSegmentsCovered == 1) {
            return 65535L;
        }
        if (additionalSegmentsCovered == 2) {
            return 0xFFFFFFL;
        }
        return 0xFFFFFFFFL;
    }

    private static int getStringPrefixCharCount(int radix) {
        if (radix == 10) {
            return 0;
        }
        if (radix == 16) {
            return 2;
        }
        return 1;
    }

    private static int getMaxIPv4StringLength(int additionalSegmentsCovered, int radix) {
        if (radix == 10) {
            if (additionalSegmentsCovered == 0) {
                return 3;
            }
            if (additionalSegmentsCovered == 1) {
                return 5;
            }
            if (additionalSegmentsCovered == 2) {
                return 8;
            }
            return 10;
        }
        if (radix == 16) {
            if (additionalSegmentsCovered == 0) {
                return 2;
            }
            if (additionalSegmentsCovered == 1) {
                return 4;
            }
            if (additionalSegmentsCovered == 2) {
                return 6;
            }
            return 8;
        }
        if (additionalSegmentsCovered == 0) {
            return 3;
        }
        if (additionalSegmentsCovered == 1) {
            return 6;
        }
        if (additionalSegmentsCovered == 2) {
            return 8;
        }
        return 11;
    }

    private static int parse8(CharSequence s, int start, int end) {
        int[] charArray = chars;
        int result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result << 3 | charArray[s.charAt(start)];
        }
        return result;
    }

    private static long parseLong8(CharSequence s, int start, int end) {
        if (end - start <= 10) {
            return Validator.parse8(s, start, end);
        }
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result << 3 | (long)charArray[s.charAt(start)];
        }
        return result;
    }

    private static int parse10(CharSequence s, int start, int end) {
        int[] charArray = chars;
        int result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result * 10 + charArray[s.charAt(start)];
        }
        return result;
    }

    private static long parseLong10(CharSequence s, int start, int end) {
        if (end - start <= 9) {
            return Validator.parse10(s, start, end);
        }
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result * 10L + (long)charArray[s.charAt(start)];
        }
        return result;
    }

    private static int parse16(CharSequence s, int start, int end) {
        int[] charArray = chars;
        int result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result << 4 | charArray[s.charAt(start)];
        }
        return result;
    }

    private static long parseLong16(CharSequence s, int start, int end) {
        if (end - start <= 7) {
            return Validator.parse16(s, start, end);
        }
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result << 4 | (long)charArray[s.charAt(start)];
        }
        return result;
    }

    private static BigInteger parseBig85(CharSequence s, int start, int end) {
        boolean last;
        int[] charArray = extendedChars;
        BigInteger result = BigInteger.ZERO;
        do {
            int power;
            int partialEnd;
            int left;
            if (last = (left = end - start) <= 9) {
                partialEnd = end;
                power = left;
            } else {
                partialEnd = start + 9;
                power = 9;
            }
            long partialResult = charArray[s.charAt(start)];
            while (++start < partialEnd) {
                int next = charArray[s.charAt(start)];
                partialResult = partialResult * 85L + (long)next;
            }
            result = result.multiply(BASE_85_POWERS[power]).add(BigInteger.valueOf(partialResult));
            start = partialEnd;
        } while (!last);
        return result;
    }

    static ParsedHost validateHostImpl(HostName fromHost) throws HostNameException {
        String str = fromHost.toString();
        HostNameParameters validationOptions = fromHost.getValidationOptions();
        return Validator.validateHost(fromHost, str, validationOptions);
    }

    private static ParsedHost validateHost(HostName fromHost, String str, HostNameParameters validationOptions) throws HostNameException {
        int addrLen = str.length();
        if (addrLen > 253) {
            throw new HostNameException(str, "ipaddress.host.error.invalid.length");
        }
        int lastSeparatorIndex = -1;
        int index = -1;
        int qualifierIndex = -1;
        int isSpecialOnlyIndex = -1;
        int labelCount = 0;
        int maxLocalLabels = 6;
        int[] separatorIndices = null;
        boolean[] normalizedFlags = null;
        boolean addressIsEmpty = false;
        boolean hasPort = false;
        boolean isPrefixed = false;
        boolean tryIPv4 = false;
        boolean tryIPv6 = false;
        boolean squareBracketed = false;
        boolean isNotNormalized = false;
        boolean segmentUppercase = false;
        boolean isPossiblyIPv4 = true;
        boolean isPossiblyIPv6 = true;
        boolean isAllDigits = true;
        int sep5 = -1;
        int sep4 = -1;
        int sep3 = -1;
        int sep2 = -1;
        int sep1 = -1;
        int sep0 = -1;
        boolean upper5 = false;
        boolean upper4 = false;
        boolean upper3 = false;
        boolean upper2 = false;
        boolean upper1 = false;
        boolean upper0 = false;
        while (++index <= addrLen) {
            int currentChar;
            if (index == addrLen) {
                boolean segmentCountMatchesIPv4;
                if (index == 0) {
                    addressIsEmpty = true;
                    break;
                }
                boolean bl = segmentCountMatchesIPv4 = isPossiblyIPv4 && labelCount + 1 == 4 || labelCount + 1 < 4 && isSpecialOnlyIndex >= 0 || labelCount + 1 < 4 && validationOptions.addressOptions.getIPv4Parameters().inet_aton_joinedSegments || labelCount == 0 && validationOptions.addressOptions.allowSingleSegment;
                if (isAllDigits) {
                    if (isPossiblyIPv4 && segmentCountMatchesIPv4) {
                        tryIPv4 = true;
                        break;
                    }
                    isPossiblyIPv4 = false;
                    if (hasPort && isPossiblyIPv6) {
                        tryIPv6 = true;
                        break;
                    }
                    throw new HostNameException(str, "ipaddress.host.error.invalid");
                }
                isPossiblyIPv4 &= segmentCountMatchesIPv4;
                currentChar = 46;
            } else {
                currentChar = str.charAt(index);
            }
            if (currentChar >= 97 && currentChar <= 122) {
                if (currentChar > 102) {
                    isPossiblyIPv6 = false;
                    isPossiblyIPv4 &= currentChar == 120 && validationOptions.addressOptions.getIPv4Parameters().inet_aton_hex;
                } else {
                    isPossiblyIPv4 = false;
                }
                isAllDigits = false;
                continue;
            }
            if (currentChar >= 48 && currentChar <= 57) continue;
            if (currentChar >= 65 && currentChar <= 90) {
                if (currentChar > 70) {
                    isPossiblyIPv6 = false;
                }
                segmentUppercase = true;
                isPossiblyIPv4 = false;
                isAllDigits = false;
                continue;
            }
            if (currentChar == 46) {
                int len = index - lastSeparatorIndex - 1;
                if (len > 63) {
                    throw new HostNameException(str, "ipaddress.error.segment.too.long");
                }
                if (len == 0) {
                    throw new HostNameException(str, "ipaddress.host.error.segment.too.short");
                }
                if (labelCount < maxLocalLabels) {
                    if (labelCount < 3) {
                        if (labelCount == 0) {
                            sep0 = index;
                            upper0 = segmentUppercase;
                        } else if (labelCount == 1) {
                            sep1 = index;
                            upper1 = segmentUppercase;
                        } else {
                            sep2 = index;
                            upper2 = segmentUppercase;
                        }
                    } else if (labelCount == 3) {
                        sep3 = index;
                        upper3 = segmentUppercase;
                    } else if (labelCount == 4) {
                        sep4 = index;
                        upper4 = segmentUppercase;
                    } else {
                        sep5 = index;
                        upper5 = segmentUppercase;
                    }
                    ++labelCount;
                } else if (labelCount == maxLocalLabels) {
                    separatorIndices = new int[128];
                    separatorIndices[labelCount] = index;
                    if (validationOptions.normalizeToLowercase) {
                        normalizedFlags = new boolean[128];
                        normalizedFlags[labelCount] = !segmentUppercase;
                        isNotNormalized |= segmentUppercase;
                    }
                    ++labelCount;
                } else {
                    separatorIndices[labelCount] = index;
                    if (normalizedFlags != null) {
                        normalizedFlags[labelCount] = !segmentUppercase;
                        isNotNormalized |= segmentUppercase;
                    }
                    if (++labelCount > 127) {
                        throw new HostNameException(str, "ipaddress.host.error.too.many.segments");
                    }
                }
                lastSeparatorIndex = index;
                segmentUppercase = false;
                isPossiblyIPv6 &= index == addrLen;
                continue;
            }
            if (currentChar == 95) {
                isAllDigits = false;
                continue;
            }
            if (currentChar == 45) {
                if (index == lastSeparatorIndex + 1 || index == addrLen - 1 || str.charAt(index + 1) == '.') {
                    throw new HostNameException(str, index);
                }
                isAllDigits = false;
                continue;
            }
            if (currentChar == 91) {
                if (index == 0 && labelCount == 0 && addrLen > 2) {
                    squareBracketed = true;
                    break;
                }
                throw new HostNameException(str, index);
            }
            if (currentChar == 47) {
                isPrefixed = true;
                qualifierIndex = index + 1;
                addrLen = index--;
                isNotNormalized = true;
                continue;
            }
            boolean b = false;
            if (currentChar == 42 || (b = currentChar == 37)) {
                IPAddressStringParameters addressOptions = validationOptions.addressOptions;
                if (b && addressOptions.getIPv6Parameters().allowZone) {
                    if (isPossiblyIPv6 && labelCount < 8) {
                        tryIPv6 = true;
                        isPossiblyIPv4 = false;
                        break;
                    }
                    throw new HostNameException(str, index);
                }
                if (isPossiblyIPv4 && addressOptions.getIPv4Parameters().rangeOptions.allowsWildcard()) {
                    if (isSpecialOnlyIndex < 0) {
                        isSpecialOnlyIndex = index;
                    }
                } else {
                    isPossiblyIPv4 = false;
                }
                if (isPossiblyIPv6 && addressOptions.getIPv6Parameters().rangeOptions.allowsWildcard()) {
                    if (isSpecialOnlyIndex < 0) {
                        isSpecialOnlyIndex = index;
                    }
                } else {
                    if (!isPossiblyIPv4) {
                        throw new HostNameException(str, index);
                    }
                    isPossiblyIPv6 = false;
                }
                isAllDigits = false;
                continue;
            }
            if (currentChar == 58) {
                if (validationOptions.allowPort) {
                    hasPort = true;
                    qualifierIndex = index + 1;
                    addrLen = index--;
                    isNotNormalized = true;
                    continue;
                }
                isPossiblyIPv4 = false;
                if (isPossiblyIPv6) {
                    tryIPv6 = true;
                    break;
                }
                throw new HostNameException(str, index);
            }
            throw new HostNameException(str, index);
        }
        IPAddressStringParameters addressOptions = validationOptions.addressOptions;
        try {
            ParsedHost parsedHost;
            block113: {
                boolean isIPAddress;
                boolean bl = isIPAddress = squareBracketed || tryIPv4 || tryIPv6;
                if (!validationOptions.allowIPAddress) {
                    if (isIPAddress) {
                        throw new HostNameException(str, "ipaddress.host.error.ipaddress");
                    }
                } else if (isIPAddress || isPossiblyIPv4 || isPossiblyIPv6) {
                    try {
                        ParsedHostIdentifierStringQualifier addrQualifier;
                        ParsedIPAddress.IPAddressParseData ipAddressParseData = new ParsedIPAddress.IPAddressParseData();
                        ParsedHostIdentifierStringQualifier hostQualifier = ParsedHost.NO_QUALIFIER;
                        if (squareBracketed) {
                            boolean endsWithQualifier;
                            int endIndex = addrLen - 1;
                            boolean bl2 = endsWithQualifier = str.charAt(endIndex) != ']';
                            if (endsWithQualifier) {
                                while (str.charAt(--endIndex) != ']') {
                                    if (endIndex != 1) continue;
                                    throw new HostNameException(str, "ipaddress.host.error.bracketed.missing.end");
                                }
                            }
                            int startIndex = 1;
                            if (str.startsWith("IPv6:", 1)) {
                                startIndex = 6;
                            } else {
                                char firstChar = str.charAt(1);
                                if (firstChar == 'v' || firstChar == IPvFUTURE_UPPERCASE) {
                                    throw new HostNameException(str, "ipaddress.host.error.invalid.mechanism");
                                }
                            }
                            Validator.validateIPAddress(addressOptions, str, startIndex, endIndex, ipAddressParseData);
                            if (endsWithQualifier) {
                                int prefixIndex = endIndex + 1;
                                char prefixChar = str.charAt(prefixIndex);
                                if (prefixChar == '/') {
                                    if (ipAddressParseData.isZoned) {
                                        throw new HostNameException(str, "ipaddress.error.zoneAndCIDRPrefix");
                                    }
                                    isPrefixed = true;
                                } else if (prefixChar == ':') {
                                    hasPort = true;
                                } else {
                                    throw new HostNameException(str, prefixIndex);
                                }
                                qualifierIndex = prefixIndex + 1;
                                endIndex = str.length();
                                ParsedHostIdentifierStringQualifier parsedQualifier = Validator.parseQualifier(str, addressOptions, validationOptions, isPrefixed, false, hasPort, ipAddressParseData.addressParseData.isEmpty, qualifierIndex, endIndex, ipAddressParseData.ipVersion);
                                if (isPrefixed) {
                                    addrQualifier = parsedQualifier;
                                } else {
                                    hostQualifier = parsedQualifier;
                                    addrQualifier = Validator.parseQualifier(str, addressOptions, null, false, false, ipAddressParseData, ipAddressParseData.qualifierIndex, prefixIndex - 1);
                                }
                            } else {
                                qualifierIndex = ipAddressParseData.qualifierIndex;
                                isPrefixed = ipAddressParseData.isPrefixed;
                                hasPort = ipAddressParseData.hasPort;
                                if (ipAddressParseData.isZoned && str.charAt(ipAddressParseData.qualifierIndex) == '2' && str.charAt(ipAddressParseData.qualifierIndex + 1) == '5') {
                                    qualifierIndex += 2;
                                }
                                addrQualifier = Validator.parseQualifier(str, addressOptions, validationOptions, isPrefixed, hasPort, ipAddressParseData, qualifierIndex, endIndex);
                            }
                            IPAddress.IPVersion version = ipAddressParseData.ipVersion;
                            if (version != IPAddress.IPVersion.IPV6 && !validationOptions.allowBracketedIPv4) {
                                throw new HostNameException(str, "ipaddress.host.error.bracketed.not.ipv6");
                            }
                        } else {
                            int endIndex;
                            boolean isPotentiallyIPv6;
                            boolean isPotentiallyIPv4 = isPossiblyIPv4 || tryIPv4;
                            boolean bl3 = isPotentiallyIPv6 = isPossiblyIPv6 || tryIPv6;
                            if (isPotentiallyIPv4) {
                                if (!hasPort) {
                                    int j = index;
                                    while (j < addrLen) {
                                        char c = str.charAt(j);
                                        if (c == ':') {
                                            qualifierIndex = j + 1;
                                            hasPort = true;
                                        }
                                        ++j;
                                    }
                                }
                                if (hasPort) {
                                    try {
                                        hostQualifier = Validator.validatePort(str, validationOptions, qualifierIndex, str.length());
                                        endIndex = qualifierIndex - 1;
                                    }
                                    catch (AddressStringException e) {
                                        if (isPotentiallyIPv6) {
                                            hostQualifier = ParsedHost.NO_QUALIFIER;
                                            endIndex = str.length();
                                        }
                                        throw e;
                                    }
                                } else {
                                    endIndex = str.length();
                                }
                            } else {
                                endIndex = str.length();
                            }
                            Validator.validateIPAddress(addressOptions, str, 0, endIndex, ipAddressParseData);
                            addrQualifier = Validator.parseQualifier(str, addressOptions, validationOptions, ipAddressParseData, endIndex);
                        }
                        IPAddressProvider provider = Validator.createProvider(fromHost, str, addressOptions, ipAddressParseData, addrQualifier);
                        return new ParsedHost(str, provider, hostQualifier);
                    }
                    catch (AddressStringException e) {
                        if (!isIPAddress) break block113;
                        throw e;
                    }
                }
            }
            ParsedHostIdentifierStringQualifier qualifier = Validator.parseQualifier(str, addressOptions, validationOptions, isPrefixed, false, hasPort, addressIsEmpty, qualifierIndex, str.length(), null);
            if (addressIsEmpty) {
                if (!validationOptions.allowEmpty) {
                    throw new HostNameException(str, "ipaddress.host.error.empty");
                }
                parsedHost = qualifier == ParsedHost.NO_QUALIFIER ? DEFAULT_EMPTY_HOST : new ParsedHost(str, EMPTY_INDICES, null, qualifier);
            } else {
                ParsedHostIdentifierStringQualifier hostQualifier;
                ParsedHostIdentifierStringQualifier addrQualifier;
                if (labelCount <= maxLocalLabels) {
                    maxLocalLabels = labelCount;
                    separatorIndices = new int[maxLocalLabels];
                    if (validationOptions.normalizeToLowercase) {
                        normalizedFlags = new boolean[labelCount];
                    }
                } else if (labelCount != separatorIndices.length) {
                    int[] trimmedSeparatorIndices = new int[labelCount];
                    System.arraycopy(separatorIndices, maxLocalLabels, trimmedSeparatorIndices, maxLocalLabels, labelCount - maxLocalLabels);
                    separatorIndices = trimmedSeparatorIndices;
                    if (normalizedFlags != null) {
                        boolean[] trimmedNormalizedFlags = new boolean[labelCount];
                        System.arraycopy(normalizedFlags, maxLocalLabels, trimmedNormalizedFlags, maxLocalLabels, labelCount - maxLocalLabels);
                        normalizedFlags = trimmedNormalizedFlags;
                    }
                }
                int i = 0;
                while (i < maxLocalLabels) {
                    boolean isUpper;
                    int nextSep;
                    if (i < 2) {
                        if (i == 0) {
                            nextSep = sep0;
                            isUpper = upper0;
                        } else {
                            nextSep = sep1;
                            isUpper = upper1;
                        }
                    } else if (i < 4) {
                        if (i == 2) {
                            nextSep = sep2;
                            isUpper = upper2;
                        } else {
                            nextSep = sep3;
                            isUpper = upper3;
                        }
                    } else if (i == 4) {
                        nextSep = sep4;
                        isUpper = upper4;
                    } else {
                        nextSep = sep5;
                        isUpper = upper5;
                    }
                    separatorIndices[i] = nextSep;
                    if (normalizedFlags != null) {
                        normalizedFlags[i] = !isUpper;
                        isNotNormalized |= isUpper;
                    }
                    ++i;
                }
                if (isPrefixed) {
                    addrQualifier = qualifier;
                    hostQualifier = ParsedHost.NO_QUALIFIER;
                } else {
                    hostQualifier = qualifier;
                    addrQualifier = ParsedHost.NO_QUALIFIER;
                }
                ParsedHost.EmbeddedAddress addr = Validator.checkSpecialHosts(str, addrLen, addrQualifier);
                AddressStringException embeddedException = null;
                if (isSpecialOnlyIndex >= 0 && (addr == null || (embeddedException = addr.addressStringException) != null)) {
                    if (embeddedException != null) {
                        throw new HostNameException(str, isSpecialOnlyIndex, embeddedException);
                    }
                    throw new HostNameException(str, isSpecialOnlyIndex);
                }
                parsedHost = new ParsedHost(str, separatorIndices, normalizedFlags, addr == null ? qualifier : hostQualifier, addr);
                if (!isNotNormalized && addr == null) {
                    parsedHost.host = str;
                }
            }
            return parsedHost;
        }
        catch (AddressStringException e) {
            throw new HostNameException(str, e, "ipaddress.host.error.invalid");
        }
    }

    private static ParsedHost.EmbeddedAddress checkSpecialHosts(String str, int addrLen, ParsedHostIdentifierStringQualifier hostQualifier) {
        ParsedHost.EmbeddedAddress emb = null;
        try {
            String suffix3;
            int suffixStartIndex;
            String suffix = ".ipv6-literal.net";
            if (addrLen > suffix.length() && str.regionMatches(true, suffixStartIndex = addrLen - suffix.length(), suffix, 0, suffix.length())) {
                IPAddressProvider provider;
                StringBuilder builder = new StringBuilder(str.substring(0, suffixStartIndex));
                int i = 0;
                while (i < builder.length()) {
                    char c = builder.charAt(i);
                    switch (c) {
                        case '-': {
                            builder.setCharAt(i, ':');
                            break;
                        }
                        case '\u203a': {
                            builder.setCharAt(i, '-');
                            break;
                        }
                        case 's': {
                            builder.setCharAt(i, '%');
                        }
                    }
                    ++i;
                }
                emb = new ParsedHost.EmbeddedAddress();
                emb.isUNCIPv6Literal = true;
                ParsedIPAddress.IPAddressParseData ipAddressParseData = new ParsedIPAddress.IPAddressParseData();
                IPAddressStringParameters params = DEFAULT_UNC_OPTS;
                Validator.validateIPAddress(params, builder, 0, builder.length(), ipAddressParseData);
                emb.addressProvider = provider = Validator.createProvider(null, builder, params, ipAddressParseData, hostQualifier != null && hostQualifier != ParsedHost.NO_QUALIFIER ? hostQualifier : Validator.parseQualifier(builder, DEFAULT_UNC_OPTS, null, ipAddressParseData, builder.length()));
            }
            if (addrLen > (suffix3 = ".ip6.int").length()) {
                suffix = ".in-addr.arpa";
                String suffix2 = ".ip6.arpa";
                suffixStartIndex = addrLen - suffix.length();
                boolean isIPv4 = str.regionMatches(true, suffixStartIndex, suffix, 0, suffix.length());
                if (isIPv4 || addrLen > suffix2.length() && str.regionMatches(true, suffixStartIndex = addrLen - suffix2.length(), suffix2, 0, suffix2.length()) || addrLen > suffix3.length() && str.regionMatches(true, suffixStartIndex = addrLen - suffix3.length(), suffix3, 0, suffix3.length())) {
                    emb = new ParsedHost.EmbeddedAddress();
                    emb.isReverseDNS = true;
                    if (isIPv4) {
                        IPAddressProvider provider;
                        ParsedIPAddress.IPAddressParseData ipAddressParseData = new ParsedIPAddress.IPAddressParseData();
                        IPAddressStringParameters params = REVERSE_DNS_IPV4_OPTS;
                        Validator.validateIPAddress(params, str, 0, suffixStartIndex, ipAddressParseData);
                        ipAddressParseData.reverseSegments();
                        emb.addressProvider = provider = Validator.createProvider(null, str, params, ipAddressParseData, hostQualifier != null ? hostQualifier : ParsedHost.NO_QUALIFIER);
                    } else {
                        IPAddressProvider provider;
                        CharSequence sequence = Validator.convertReverseDNSIPv6(str, suffixStartIndex);
                        ParsedIPAddress.IPAddressParseData ipAddressParseData = new ParsedIPAddress.IPAddressParseData();
                        IPAddressStringParameters params = REVERSE_DNS_IPV6_OPTS;
                        Validator.validateIPAddress(params, sequence, 0, sequence.length(), ipAddressParseData);
                        emb.addressProvider = provider = Validator.createProvider(null, sequence, params, ipAddressParseData, hostQualifier != null ? hostQualifier : ParsedHost.NO_QUALIFIER);
                    }
                }
            }
        }
        catch (AddressStringException e) {
            emb.addressStringException = e;
        }
        return emb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CharSequence convertReverseDNSIPv6(String str, int suffixStartIndex) throws AddressStringException {
        StringBuilder builder = new StringBuilder(suffixStartIndex);
        StringBuilder low = new StringBuilder();
        StringBuilder high = new StringBuilder();
        int segCount = 0;
        int i = suffixStartIndex - 1;
        while (i >= 0) {
            boolean isRange = false;
            int j = 0;
            while (j < 4) {
                char c1 = str.charAt(i--);
                if (i >= 0) {
                    char c2;
                    if ((c2 = str.charAt(i--)) == '.') {
                        if (c1 == '*') {
                            isRange = true;
                            low.append('0');
                            high.append('f');
                        } else {
                            if (isRange) {
                                throw new AddressStringException((CharSequence)str, i + 1);
                            }
                            low.append(c1);
                            high.append(c1);
                        }
                    } else {
                        boolean isFullRange;
                        if (c2 != '-') throw new AddressStringException((CharSequence)str, i + 1);
                        high.append(c1);
                        if (i < 1) throw new AddressStringException((CharSequence)str, i);
                        c2 = str.charAt(i--);
                        low.append(c2);
                        boolean bl = isFullRange = c2 == '0' && c1 == 'f';
                        if (isRange && !isFullRange) {
                            throw new AddressStringException((CharSequence)str, i + 1);
                        }
                        if ((c2 = str.charAt(i--)) != '.') {
                            throw new AddressStringException((CharSequence)str, i + 1);
                        }
                        isRange = true;
                    }
                } else {
                    if (j < 3) {
                        throw new AddressStringException((CharSequence)str, i + 1);
                    }
                    if (c1 == '*') {
                        isRange = true;
                        low.append('0');
                        high.append('f');
                    } else {
                        if (isRange) {
                            throw new AddressStringException((CharSequence)str, 0);
                        }
                        low.append(c1);
                        high.append(c1);
                    }
                }
                ++j;
            }
            ++segCount;
            if (builder.length() > 0) {
                builder.append(':');
            }
            builder.append((CharSequence)low);
            if (isRange) {
                builder.append('-').append((CharSequence)high);
            }
            low.setLength(0);
            high.setLength(0);
        }
        if (segCount == 8) return builder;
        throw new AddressStringException((CharSequence)str, 0);
    }
}

