/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import java.io.Serializable;

class AddressParseData
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final int LOWER_INDEX = 0;
    public static final int UPPER_INDEX = 1;
    public static final int EXTENDED_LOWER_INDEX = 2;
    public static final int EXTENDED_UPPER_INDEX = 3;
    public static final int LOWER_RADIX_INDEX = 0;
    public static final int UPPER_RADIX_INDEX = 1;
    public static final int LOWER_STR_DIGITS_INDEX = 2;
    public static final int LOWER_STR_START_INDEX = 3;
    public static final int LOWER_STR_END_INDEX = 4;
    public static final int UPPER_STR_DIGITS_INDEX = 5;
    public static final int UPPER_STR_START_INDEX = 6;
    public static final int UPPER_STR_END_INDEX = 7;
    public static final int WILDCARD_INDEX = 0;
    public static final int SINGLE_WILDCARD_INDEX = 1;
    public static final int STANDARD_STR_INDEX = 2;
    public static final int STANDARD_RANGE_STR_INDEX = 3;
    boolean[][] flags;
    int[][] indices;
    long[][] values;
    int segmentCount;
    boolean anyWildcard;
    boolean isEmpty;
    boolean isAll;
    boolean isSingleSegment;
    int consecutiveSepIndex = -1;
    int addressEndIndex;

    AddressParseData() {
    }

    void initSegmentData(int segmentCapacity) {
        this.flags = new boolean[segmentCapacity][4];
        this.indices = new int[segmentCapacity][8];
        this.values = new long[segmentCapacity][4];
    }

    boolean isWildcard(int index) {
        return this.flags[index][0];
    }

    void reverseSegments() {
        int mid = this.segmentCount >>> 1;
        int i = 0;
        int reverseIndex = this.segmentCount - 1;
        while (i < mid) {
            boolean[] tmpb = this.flags[i];
            int[] tmpi = this.indices[i];
            long[] tmpl = this.values[i];
            this.flags[i] = this.flags[reverseIndex];
            this.indices[i] = this.indices[reverseIndex];
            this.values[i] = this.values[reverseIndex];
            this.flags[reverseIndex] = tmpb;
            this.indices[reverseIndex] = tmpi;
            this.values[reverseIndex] = tmpl;
            ++i;
            --reverseIndex;
        }
    }
}

