/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostName;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.format.AddressCreator;
import inet.ipaddr.format.IPAddressDivisionGrouping;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class IPAddressTypeNetwork<T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment>
extends IPAddressNetwork {
    private final T[] subnets;
    private final T[] subnetMasks;
    private final T[] hostMasks;
    private final long[][] networkSegmentMasks;
    private final long[][] hostSegmentMasks;
    private T loopback;
    private String[] loopbackStrings;
    private IPAddressCreator<T, R, ?, S> creator;

    protected IPAddressTypeNetwork(Class<T> addressType) {
        IPAddress.IPVersion version = this.getIPVersion();
        int bitSize = IPAddress.bitCount(version);
        this.subnets = (IPAddress[])Array.newInstance(addressType, bitSize + 1);
        this.subnetMasks = (IPAddress[])this.subnets.clone();
        this.hostMasks = (IPAddress[])this.subnets.clone();
        this.creator = this.createAddressCreator();
        int segmentBitSize = IPAddressSegment.getBitCount(version);
        int segmentCount = IPAddress.segmentCount(version);
        this.networkSegmentMasks = new long[segmentCount][];
        this.hostSegmentMasks = (long[][])this.networkSegmentMasks.clone();
        int h = 0;
        int allBitSize = segmentBitSize;
        while (h < segmentCount && allBitSize < 64) {
            long fullMask = -1L << allBitSize ^ 0xFFFFFFFFFFFFFFFFL;
            this.networkSegmentMasks[h] = new long[allBitSize + 1];
            this.hostSegmentMasks[h] = (long[])this.networkSegmentMasks[h].clone();
            int i = 0;
            while (i <= allBitSize) {
                long l = fullMask & fullMask << allBitSize - i;
                this.networkSegmentMasks[h][i] = l;
                long networkMask = l;
                this.hostSegmentMasks[h][i] = (networkMask ^ 0xFFFFFFFFFFFFFFFFL) & fullMask;
                ++i;
            }
            ++h;
            allBitSize += segmentBitSize;
        }
    }

    protected abstract BiFunction<T, Integer, S> getSegmentProducer();

    protected abstract Function<T, R> getSectionProducer();

    protected abstract IPAddressCreator<T, R, ?, S> createAddressCreator();

    protected IPAddressCreator<T, R, ?, S> getAddressCreator() {
        return this.creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLoopback() {
        if (this.loopback == null) {
            IPAddressTypeNetwork iPAddressTypeNetwork = this;
            synchronized (iPAddressTypeNetwork) {
                if (this.loopback == null) {
                    this.loopback = this.createLoopback();
                }
            }
        }
        return this.loopback;
    }

    protected abstract T createLoopback();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getStandardLoopbackStrings() {
        if (this.loopbackStrings == null) {
            IPAddressTypeNetwork iPAddressTypeNetwork = this;
            synchronized (iPAddressTypeNetwork) {
                if (this.loopbackStrings == null) {
                    this.loopbackStrings = ((IPAddress)this.getLoopback()).toStandardStrings();
                }
            }
        }
        return this.loopbackStrings;
    }

    @Override
    public int getSegmentNetworkMask(int segmentPrefixLength) {
        return (int)this.networkSegmentMasks[0][segmentPrefixLength];
    }

    @Override
    public int getSegmentHostMask(int segmentPrefixLength) {
        return (int)this.hostSegmentMasks[0][segmentPrefixLength];
    }

    @Override
    public long getSegmentNetworkMask(int segmentPrefixLength, int joinedSegments) {
        return this.networkSegmentMasks[joinedSegments][segmentPrefixLength];
    }

    @Override
    public long getSegmentHostMask(int segmentPrefixLength, int joinedSegments) {
        return this.hostSegmentMasks[joinedSegments][segmentPrefixLength];
    }

    public T getNetworkMask(int networkPrefixLength) {
        return this.getNetworkMask(networkPrefixLength, true);
    }

    public T getNetworkMask(int networkPrefixLength, boolean withPrefixLength) {
        return (T)this.getMask(networkPrefixLength, (IPAddress[])(withPrefixLength ? this.subnets : this.subnetMasks), true, withPrefixLength);
    }

    public R getNetworkMaskSection(int networkPrefixLength) {
        return (R)((IPAddressSection)this.getSectionProducer().apply(this.getNetworkMask(networkPrefixLength, true)));
    }

    public T getHostMask(int networkPrefixLength) {
        return (T)this.getMask(networkPrefixLength, (IPAddress[])this.hostMasks, false, false);
    }

    public R getHostMaskSection(int networkPrefixLength) {
        return (R)((IPAddressSection)this.getSectionProducer().apply(this.getHostMask(networkPrefixLength)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private T getMask(int networkPrefixLength, T[] cache, boolean network, boolean withPrefixLength) {
        block20: {
            bits = networkPrefixLength;
            version = this.getIPVersion();
            addressBitLength = IPAddress.bitCount(version);
            if (bits < 0) throw new AddressTypeException(bits, version, "ipaddress.error.prefixSize");
            if (bits > addressBitLength) {
                throw new AddressTypeException(bits, version, "ipaddress.error.prefixSize");
            }
            cacheIndex = bits;
            subnet /* !! */  = cache[cacheIndex];
            if (subnet /* !! */  != null) return subnet /* !! */ ;
            if (network) {
                onesSubnetIndex = addressBitLength;
                zerosSubnetIndex = 0;
            } else {
                onesSubnetIndex = 0;
                zerosSubnetIndex = addressBitLength;
            }
            onesSubnet = cache[onesSubnetIndex];
            zerosSubnet = cache[zerosSubnetIndex];
            if (onesSubnet == null || zerosSubnet == null) {
                var14_14 = cache;
                // MONITORENTER : cache
                segmentCount = IPAddress.segmentCount(version);
                bitsPerSegment = IPAddress.bitsPerSegment(version);
                onesSubnet = cache[onesSubnetIndex];
                if (onesSubnet == null) {
                    creator = this.getAddressCreator();
                    newSegments = (IPAddressSegment[])creator.createSegmentArray(segmentCount);
                    maxSegmentValue = IPAddress.maxSegmentValue(version);
                    if (network && withPrefixLength) {
                        segment = (IPAddressSegment)creator.createSegment(maxSegmentValue, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, addressBitLength));
                        Arrays.fill(newSegments, 0, newSegments.length - 1, segment);
                        lastSegment = (IPAddressSegment)creator.createSegment(maxSegmentValue, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, bitsPerSegment));
                        newSegments[newSegments.length - 1] = lastSegment;
                    } else {
                        segment = (IPAddressSegment)creator.createSegment(maxSegmentValue);
                        Arrays.fill(newSegments, segment);
                    }
                    onesSubnet = creator.createAddressInternal((IPAddressSegment[])newSegments);
                    this.initMaskCachedValues(onesSubnet.getSection(), network, withPrefixLength, addressBitLength, onesSubnetIndex, segmentCount, bitsPerSegment);
                    cache[onesSubnetIndex] = onesSubnet;
                }
                if ((zerosSubnet = cache[zerosSubnetIndex]) == null) {
                    creator = this.getAddressCreator();
                    newSegments = (IPAddressSegment[])creator.createSegmentArray(segmentCount);
                    seg = network != false && withPrefixLength != false ? (IPAddressSegment)creator.createSegment(0, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, 0)) : (IPAddressSegment)creator.createSegment(0);
                    Arrays.fill(newSegments, seg);
                    zerosSubnet = creator.createAddressInternal((IPAddressSegment[])newSegments);
                    this.initMaskCachedValues(zerosSubnet.getSection(), network, withPrefixLength, addressBitLength, zerosSubnetIndex, segmentCount, bitsPerSegment);
                    cache[zerosSubnetIndex] = zerosSubnet;
                }
                // MONITOREXIT : var14_14
            }
            var14_14 = cache;
            // MONITORENTER : cache
            subnet /* !! */  = cache[cacheIndex];
            if (subnet /* !! */  != null) break block20;
            segProducer = this.getSegmentProducer();
            segmentCount = IPAddress.segmentCount(version);
            bitsPerSegment = IPAddress.bitsPerSegment(version);
            prefix = bits;
            onesSegment = (IPAddressSegment)segProducer.apply(onesSubnet, 1);
            zerosSegment = (IPAddressSegment)segProducer.apply(zerosSubnet, 1);
            creator = this.getAddressCreator();
            segmentList = new ArrayList<IPAddressSegment>(segmentCount);
            i = 0;
            block6: while (bits > 0) {
                block21: {
                    if (bits > bitsPerSegment) break block21;
                    segment = null;
                    offset = (bits - 1) % bitsPerSegment + 1;
                    j = 0;
                    entry = offset;
                    if (true) ** GOTO lbl91
                }
                segmentList.add(network != false ? onesSegment : zerosSegment);
lbl77:
                // 2 sources

                while (true) {
                    ++i;
                    bits -= bitsPerSegment;
                    continue block6;
                    break;
                }
            }
            if (true) ** GOTO lbl102
            do {
                if (entry != cacheIndex && (prev = cache[entry]) != null) {
                    segment = (IPAddressSegment)segProducer.apply(prev, j);
                    break;
                }
                ++j;
                entry += bitsPerSegment;
lbl91:
                // 2 sources

            } while (j < segmentCount);
            if (segment == null) {
                mask = this.getSegmentNetworkMask(bits);
                segment = network ? (withPrefixLength ? (IPAddressSegment)creator.createSegment(mask, IPAddressSection.getSegmentPrefixLength(bitsPerSegment, bits)) : (IPAddressSegment)creator.createSegment(mask)) : (IPAddressSegment)creator.createSegment(this.getSegmentHostMask(bits));
            }
            segmentList.add(segment);
            ** while (true)
            do {
                segmentList.add(network != false ? zerosSegment : onesSegment);
                ++i;
lbl102:
                // 2 sources

            } while (i < segmentCount);
            newSegments = (IPAddressSegment[])creator.createSegmentArray(segmentList.size());
            segmentList.toArray(newSegments);
            subnet /* !! */  = creator.createAddressInternal(newSegments);
            this.initMaskCachedValues(subnet /* !! */ .getSection(), network, withPrefixLength, addressBitLength, prefix, segmentCount, bitsPerSegment);
            cache[cacheIndex] = subnet /* !! */ ;
        }
        // MONITOREXIT : var14_14
        return subnet /* !! */ ;
    }

    private void initMaskCachedValues(IPAddressSection section, boolean network, boolean withPrefixLength, int addressBitLength, int networkPrefixLength, int segmentCount, int bitsPerSegment) {
        BigInteger cachedCount;
        Integer cachedEquivalentPrefix;
        Integer cachedMinPrefix;
        Integer cachedNetworkPrefix;
        IPAddressDivisionGrouping.RangeList zeroSegments;
        IPAddressDivisionGrouping.RangeList zeroRanges;
        boolean hasZeroRanges = network ? addressBitLength - networkPrefixLength >= bitsPerSegment : networkPrefixLength >= bitsPerSegment;
        IPAddressDivisionGrouping.RangeList noZeros = IPAddressSection.getNoZerosRange();
        if (hasZeroRanges) {
            int rangeLen;
            int rangeIndex;
            if (network) {
                int segmentIndex;
                rangeIndex = segmentIndex = (networkPrefixLength + bitsPerSegment - 1) / bitsPerSegment;
                rangeLen = segmentCount - segmentIndex;
            } else {
                rangeIndex = 0;
                rangeLen = networkPrefixLength / bitsPerSegment;
            }
            zeroRanges = IPAddressSection.getSingleRange(rangeIndex, rangeLen);
            zeroSegments = network && withPrefixLength ? noZeros : zeroRanges;
        } else {
            zeroSegments = zeroRanges = noZeros;
        }
        if (network && withPrefixLength) {
            cachedMinPrefix = cachedNetworkPrefix = Integer.valueOf(networkPrefixLength);
            cachedEquivalentPrefix = cachedNetworkPrefix;
            cachedCount = BigInteger.valueOf(2L).pow(addressBitLength - networkPrefixLength);
        } else {
            cachedEquivalentPrefix = cachedMinPrefix = Integer.valueOf(addressBitLength);
            cachedNetworkPrefix = -1;
            cachedCount = BigInteger.ONE;
        }
        section.initCachedValues(networkPrefixLength, network, cachedNetworkPrefix, cachedMinPrefix, cachedEquivalentPrefix, cachedCount, zeroSegments, zeroRanges);
    }

    protected static abstract class IPAddressCreator<T extends IPAddress, R extends IPAddressSection, E extends IPAddressSection, S extends IPAddressSegment>
    extends AddressCreator<T, R, E, S> {
        protected IPAddressCreator() {
        }

        @Override
        protected S createSegmentInternal(int value, Integer segmentPrefixLength, CharSequence addressStr, int originalVal, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex) {
            IPAddressSegment segment = (IPAddressSegment)this.createSegment(value, segmentPrefixLength);
            segment.setStandardString(addressStr, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            segment.setWildcardString(addressStr, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            return (S)segment;
        }

        @Override
        protected S createSegmentInternal(int lower, int upper, Integer segmentPrefixLength, CharSequence addressStr, int originalLower, int originalUpper, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex) {
            IPAddressSegment segment = (IPAddressSegment)this.createSegment(lower, upper, segmentPrefixLength);
            segment.setStandardString(addressStr, isStandardString, isStandardRangeString, lowerStringStartIndex, lowerStringEndIndex, upperStringEndIndex, originalLower, originalUpper);
            segment.setWildcardString(addressStr, isStandardRangeString, lowerStringStartIndex, upperStringEndIndex, originalLower, originalUpper);
            return (S)segment;
        }

        protected abstract R[] createSectionArray(int var1);

        @Override
        protected abstract R createSectionInternal(S[] var1);

        protected abstract R createSection(Address.SegmentValueProvider var1, Address.SegmentValueProvider var2, Integer var3);

        protected abstract R createSectionInternal(byte[] var1, Integer var2);

        @Override
        protected T createAddressInternal(S[] segments) {
            return this.createAddress(this.createSectionInternal((IPAddressSegment[])segments), null);
        }

        protected T createAddressInternal(S[] segments, CharSequence zone) {
            return this.createAddress(this.createSectionInternal((IPAddressSegment[])segments), zone);
        }

        protected T createAddressInternal(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefix) {
            return this.createAddress(this.createSection(lowerValueProvider, upperValueProvider, prefix));
        }

        protected T createAddressInternal(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefix, CharSequence zone) {
            return this.createAddress(this.createSection(lowerValueProvider, upperValueProvider, prefix), zone);
        }

        protected T createAddressInternal(byte[] bytes, Integer prefix) {
            return this.createAddress(this.createSectionInternal(bytes, prefix));
        }

        protected T createAddressInternal(byte[] bytes, Integer prefix, CharSequence zone) {
            return this.createAddress(this.createSectionInternal(bytes, prefix), zone);
        }

        protected T createAddressInternal(byte[] bytes, Integer prefix, CharSequence zone, HostName fromHost) {
            return this.createAddressInternal(this.createSectionInternal(bytes, prefix), zone, (HostIdentifierString)fromHost);
        }

        protected T createAddressInternal(byte[] bytes, Integer prefix, HostName fromHost) {
            return this.createAddressInternal(this.createSectionInternal(bytes, prefix), (HostIdentifierString)fromHost);
        }

        @Override
        protected T createAddressInternal(R section, CharSequence zone, HostIdentifierString from) {
            T result = this.createAddress(section, zone);
            ((IPAddress)result).cache(from);
            return result;
        }

        @Override
        protected T createAddressInternal(R section, HostIdentifierString from) {
            T result = this.createAddress(section);
            ((IPAddress)result).cache(from);
            return result;
        }

        protected abstract T createAddress(R var1, CharSequence var2);

        @Override
        public abstract T createAddress(R var1);
    }
}

