/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.HostIdentifierException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.IPAddressBitsDivision;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressDivisionGrouping;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartConfiguredString;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.util.sql.MySQLTranslator;
import inet.ipaddr.format.util.sql.SQLStringMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;

public abstract class IPAddressSection
extends IPAddressDivisionGrouping
implements AddressSection {
    private static final long serialVersionUID = 3L;
    private static final IPAddressStringDivisionSeries[] EMPTY_PARTS = new IPAddressStringDivisionSeries[0];
    protected transient PrefixCache prefixCache;

    protected IPAddressSection(IPAddressSegment[] segments, byte[] bytes, boolean cloneSegments, boolean cloneBytes) {
        super(cloneSegments ? (IPAddressDivision[])segments.clone() : segments);
        Integer previousSegmentPrefix = null;
        IPAddressSegment[] iPAddressSegmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            IPAddressSegment segment = iPAddressSegmentArray[n2];
            if (segment == null) {
                throw new NullPointerException("null segment");
            }
            Integer segPrefix = segment.getSegmentPrefixLength();
            if (previousSegmentPrefix != null && (segPrefix == null || segPrefix != 0)) {
                throw new IllegalArgumentException("Segments invalid due to inconsistent prefix values");
            }
            previousSegmentPrefix = segPrefix;
            ++n2;
        }
        if (bytes != null) {
            this.setBytes(cloneBytes ? (byte[])bytes.clone() : bytes);
        }
    }

    protected static String getMessage(String key) {
        return HostIdentifierException.getMessage(key);
    }

    protected void initCachedValues(Integer prefixLen, boolean network, Integer cachedNetworkPrefix, Integer cachedMinPrefix, Integer cachedEquivalentPrefix, BigInteger cachedCount, IPAddressDivisionGrouping.RangeList zeroSegments, IPAddressDivisionGrouping.RangeList zeroRanges) {
        if (this.prefixCache == null) {
            this.prefixCache = new PrefixCache();
        }
        if (network) {
            this.setNetworkMaskPrefix(prefixLen);
        } else {
            this.setHostMaskPrefix(prefixLen);
        }
        super.initCachedValues(cachedNetworkPrefix, cachedCount);
        this.prefixCache.cachedMinPrefix = cachedMinPrefix;
        this.prefixCache.cachedEquivalentPrefix = cachedEquivalentPrefix;
    }

    protected static IPAddressDivisionGrouping.RangeList getNoZerosRange() {
        return IPAddressDivisionGrouping.getNoZerosRange();
    }

    protected static IPAddressDivisionGrouping.RangeList getSingleRange(int index, int len) {
        return IPAddressDivisionGrouping.getSingleRange(index, len);
    }

    @Override
    public int getBitCount() {
        return this.getSegmentCount() * this.getBitsPerSegment();
    }

    @Override
    public int getByteCount() {
        return this.getSegmentCount() * this.getBytesPerSegment();
    }

    public static int bitsPerSegment(IPAddress.IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    public static int bytesPerSegment(IPAddress.IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    public abstract IPAddress.IPVersion getIPVersion();

    protected static int getSegmentIndex(Integer networkPrefixLength, int byteLength, int bytesPerSegment) {
        int byteIndex = IPAddressSection.getByteIndex(networkPrefixLength, byteLength);
        if (bytesPerSegment > 1) {
            if (bytesPerSegment == 2) {
                return byteIndex >>> 1;
            }
            return byteIndex / bytesPerSegment;
        }
        return byteIndex;
    }

    protected static int getByteIndex(Integer networkPrefixLength, int byteLength) {
        if (networkPrefixLength == null) {
            return byteLength;
        }
        if (networkPrefixLength < 0 || networkPrefixLength > byteLength << 3) {
            throw new AddressTypeException(networkPrefixLength, "ipaddress.error.prefixSize");
        }
        if (networkPrefixLength == 0) {
            return 0;
        }
        return networkPrefixLength - 1 >>> 3;
    }

    public abstract int getByteIndex(int var1);

    public abstract int getSegmentIndex(int var1);

    public abstract IPAddressSection getNetworkSection(int var1, boolean var2);

    public abstract IPAddressSection getNetworkSection(int var1);

    protected boolean isNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return true;
        }
        int prefixedSegment = this.getSegmentIndex(networkPrefixLength);
        if (prefixedSegment + 1 < segmentCount) {
            return false;
        }
        int lastSegmentIndex = segmentCount - 1;
        int bitsPerSegment = this.getBitsPerSegment();
        int segmentPrefixLength = networkPrefixLength - lastSegmentIndex * bitsPerSegment;
        return !this.getSegment(lastSegmentIndex).isNetworkChangedByPrefix(IPAddressSection.getSegmentPrefixLength(bitsPerSegment, segmentPrefixLength), withPrefixLength);
    }

    protected boolean isHostSection(int networkPrefixLength) {
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return true;
        }
        if (networkPrefixLength >= this.getBitsPerSegment()) {
            return false;
        }
        return !this.getSegment(0).isHostChangedByPrefix(networkPrefixLength);
    }

    public abstract IPAddressSection getHostSection(int var1);

    private Integer checkForPrefixMask(boolean network) {
        int back;
        int front;
        if (network) {
            front = this.getSegment(0).getMaxSegmentValue();
            back = 0;
        } else {
            back = this.getSegment(0).getMaxSegmentValue();
            front = 0;
        }
        int prefixLen = 0;
        int i = 0;
        while (i < this.getSegmentCount()) {
            IPAddressSegment seg = this.getSegment(i);
            int value = seg.getLowerSegmentValue();
            if (value != front) {
                Integer segmentPrefixLen = seg.getMaskPrefixLength(network);
                if (segmentPrefixLen == null) {
                    return null;
                }
                prefixLen += segmentPrefixLen.intValue();
                ++i;
                while (i < this.getSegmentCount()) {
                    value = this.getSegment(i).getLowerSegmentValue();
                    if (value != back) {
                        return null;
                    }
                    ++i;
                }
            } else {
                prefixLen += seg.getBitCount();
            }
            ++i;
        }
        return prefixLen;
    }

    public Integer getMaskPrefixLength(boolean network) {
        Integer prefixLen;
        if (network) {
            if (this.hasNoPrefixCache() || (prefixLen = this.prefixCache.networkMaskPrefixLen) == null) {
                prefixLen = this.setNetworkMaskPrefix(this.checkForPrefixMask(network));
            }
        } else if (this.hasNoPrefixCache() || (prefixLen = this.prefixCache.hostMaskPrefixLen) == null) {
            prefixLen = this.setHostMaskPrefix(this.checkForPrefixMask(network));
        }
        if (prefixLen < 0) {
            return null;
        }
        return prefixLen;
    }

    private Integer setHostMaskPrefix(Integer prefixLen) {
        if (prefixLen == null) {
            Integer n = -1;
            this.prefixCache.hostMaskPrefixLen = n;
            prefixLen = n;
        } else {
            this.prefixCache.hostMaskPrefixLen = prefixLen;
            this.prefixCache.networkMaskPrefixLen = -1;
        }
        return prefixLen;
    }

    private Integer setNetworkMaskPrefix(Integer prefixLen) {
        if (prefixLen == null) {
            Integer n = -1;
            this.prefixCache.networkMaskPrefixLen = n;
            prefixLen = n;
        } else {
            this.prefixCache.networkMaskPrefixLen = prefixLen;
            this.prefixCache.hostMaskPrefixLen = -1;
        }
        return prefixLen;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R getNetworkSection(R original, int networkPrefixLength, int networkSegmentCount, boolean withPrefixLength, IPAddressTypeNetwork.IPAddressCreator<T, R, ?, S> creator, BiFunction<Integer, Integer, S> segProducer) {
        if (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount()) {
            throw new AddressTypeException(original, networkPrefixLength, "ipaddress.error.prefixSize");
        }
        if (original.isNetworkSection(networkPrefixLength, withPrefixLength)) {
            return original;
        }
        int bitsPerSegment = original.getBitsPerSegment();
        IPAddressSegment[] result = (IPAddressSegment[])creator.createSegmentArray(networkSegmentCount);
        if (networkSegmentCount > 0) {
            int i = 0;
            while (i < networkSegmentCount) {
                Integer prefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
                result[i] = (IPAddressSegment)segProducer.apply(i, prefix);
                ++i;
            }
        }
        return (R)creator.createSectionInternal(result);
    }

    protected int getNetworkSegmentCount(int networkPrefixLength) {
        int segmentCount;
        if (networkPrefixLength <= 0) {
            return 0;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int result = (networkPrefixLength + (bitsPerSegment - 1)) / bitsPerSegment;
        if (result > (segmentCount = this.getSegmentCount())) {
            return segmentCount;
        }
        return result;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R getHostSection(R original, int networkPrefixLength, int hostSegmentCount, IPAddressTypeNetwork.IPAddressCreator<T, R, ?, S> creator, BiFunction<Integer, Integer, S> segProducer) {
        if (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount()) {
            throw new AddressTypeException(original, networkPrefixLength, "ipaddress.error.prefixSize");
        }
        if (original.isHostSection(networkPrefixLength)) {
            return original;
        }
        int segmentCount = original.getSegmentCount();
        IPAddressSegment[] result = (IPAddressSegment[])creator.createSegmentArray(hostSegmentCount);
        if (hostSegmentCount > 0) {
            int bitsPerSegment = original.getBitsPerSegment();
            int i = hostSegmentCount - 1;
            int j = segmentCount - 1;
            while (i >= 0) {
                Integer prefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, j);
                result[i] = (IPAddressSegment)segProducer.apply(j, prefix);
                --i;
                --j;
            }
        }
        return (R)creator.createSectionInternal(result);
    }

    protected int getHostSegmentCount(int networkPrefixLength) {
        if (networkPrefixLength <= 0) {
            return this.getSegmentCount();
        }
        int hostBits = this.getHostBits(networkPrefixLength);
        if (hostBits <= 0) {
            return 0;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        return (hostBits + bitsPerSegment - 1) / bitsPerSegment;
    }

    public Integer getHostBits() {
        if (this.isPrefixed()) {
            return this.getHostBits(this.getNetworkPrefixLength());
        }
        return null;
    }

    private int getHostBits(int networkPrefixLength) {
        return this.getSegmentCount() * this.getBitsPerSegment() - networkPrefixLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static <R extends IPAddressSection, S extends IPAddressSegment> R setPrefixLength(R original, IPAddressTypeNetwork.IPAddressCreator<?, R, ?, S> creator, int networkPrefixLength, boolean withZeros, boolean noShrink, IPAddressTypeNetwork<?, R, S> network, SegFunction<R, S> segProducer) {
        int maskBits;
        original.checkSubnet(networkPrefixLength);
        Integer existingPrefixLength = original.getNetworkPrefixLength();
        if (existingPrefixLength != null) {
            if (networkPrefixLength > existingPrefixLength) {
                if (noShrink) {
                    return original;
                }
                maskBits = withZeros ? existingPrefixLength : networkPrefixLength;
            } else {
                if (networkPrefixLength >= existingPrefixLength) return original;
                maskBits = networkPrefixLength;
            }
        } else {
            maskBits = networkPrefixLength;
        }
        Object mask = network.getNetworkMaskSection(maskBits);
        return IPAddressSection.getSubnetSegments(original, networkPrefixLength, creator, false, i -> (IPAddressSegment)segProducer.apply(original, i), i -> (IPAddressSegment)segProducer.apply(mask, i));
    }

    protected static <R extends IPAddressSection, S extends IPAddressSegment> R getSubnetSegments(R original, Integer networkPrefixLength, IPAddressTypeNetwork.IPAddressCreator<?, R, ?, S> creator, boolean verifyMask, IntFunction<S> segProducer, IntFunction<S> maskSegProducer) {
        if (networkPrefixLength != null && (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount())) {
            throw new AddressTypeException(original, (int)networkPrefixLength, "ipaddress.error.prefixSize");
        }
        int bitsPerSegment = original.getBitsPerSegment();
        int count = original.getSegmentCount();
        int i = 0;
        while (i < count) {
            IPAddressSegment mask;
            int maskValue;
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i);
            if (seg.isChangedByMask(maskValue = (mask = (IPAddressSegment)maskSegProducer.apply(i)).getLowerSegmentValue(), segmentPrefixLength)) {
                if (verifyMask && !seg.isMaskCompatibleWithRange(maskValue, segmentPrefixLength)) {
                    throw new AddressTypeException(seg, mask, "ipaddress.error.maskMismatch");
                }
                AddressSegment[] newSegments = (IPAddressSegment[])creator.createSegmentArray(original.getSegmentCount());
                original.getSegments(0, i, newSegments, 0);
                newSegments[i] = (IPAddressSegment)creator.createSegment(seg.getLowerSegmentValue() & maskValue, seg.getUpperSegmentValue() & maskValue, segmentPrefixLength);
                if (segmentPrefixLength == null) {
                    ++i;
                    while (i < count) {
                        segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
                        seg = (IPAddressSegment)segProducer.apply(i);
                        if (!seg.isChangedByMask(maskValue = (mask = (IPAddressSegment)maskSegProducer.apply(i)).getLowerSegmentValue(), segmentPrefixLength)) {
                            newSegments[i] = seg;
                        } else {
                            if (verifyMask && !seg.isMaskCompatibleWithRange(maskValue, segmentPrefixLength)) {
                                throw new AddressTypeException(seg, mask, "ipaddress.error.maskMismatch");
                            }
                            newSegments[i] = (IPAddressSegment)creator.createSegment(seg.getLowerSegmentValue() & maskValue, seg.getUpperSegmentValue() & maskValue, segmentPrefixLength);
                        }
                        if (segmentPrefixLength != null) break;
                        ++i;
                    }
                }
                if (++i < count) {
                    IPAddressSegment zeroSeg = (IPAddressSegment)creator.createSegment(0, 0);
                    do {
                        newSegments[i] = zeroSeg;
                    } while (++i < count);
                }
                return (R)creator.createSectionInternal((IPAddressSegment[])newSegments);
            }
            ++i;
        }
        return original;
    }

    protected static <R extends IPAddressSection, S extends IPAddressSegment> R getOredSegments(R original, Integer networkPrefixLength, IPAddressTypeNetwork.IPAddressCreator<?, R, ?, S> creator, IntFunction<S> segProducer, IntFunction<S> maskSegProducer) {
        if (networkPrefixLength != null && (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount())) {
            throw new AddressTypeException(original, (int)networkPrefixLength, "ipaddress.error.prefixSize");
        }
        int bitsPerSegment = original.getBitsPerSegment();
        int count = original.getSegmentCount();
        int i = 0;
        while (i < count) {
            IPAddressSegment mask;
            int maskValue;
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i);
            if (seg.isChangedByOr(maskValue = (mask = (IPAddressSegment)maskSegProducer.apply(i)).getLowerSegmentValue(), segmentPrefixLength)) {
                if (!seg.isBitwiseOrCompatibleWithRange(maskValue, segmentPrefixLength)) {
                    throw new AddressTypeException(seg, mask, "ipaddress.error.maskMismatch");
                }
                AddressSegment[] newSegments = (IPAddressSegment[])creator.createSegmentArray(original.getSegmentCount());
                original.getSegments(0, i, newSegments, 0);
                newSegments[i] = (IPAddressSegment)creator.createSegment(seg.getLowerSegmentValue() | maskValue, seg.getUpperSegmentValue() | maskValue, segmentPrefixLength);
                if (segmentPrefixLength == null) {
                    ++i;
                    while (i < count) {
                        segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
                        seg = (IPAddressSegment)segProducer.apply(i);
                        if (!seg.isChangedByOr(maskValue = (mask = (IPAddressSegment)maskSegProducer.apply(i)).getLowerSegmentValue(), segmentPrefixLength)) {
                            newSegments[i] = seg;
                        } else {
                            if (!seg.isBitwiseOrCompatibleWithRange(maskValue, segmentPrefixLength)) {
                                throw new AddressTypeException(seg, mask, "ipaddress.error.maskMismatch");
                            }
                            newSegments[i] = (IPAddressSegment)creator.createSegment(seg.getLowerSegmentValue() | maskValue, seg.getUpperSegmentValue() | maskValue, segmentPrefixLength);
                        }
                        if (segmentPrefixLength != null) break;
                        ++i;
                    }
                }
                if (++i < count) {
                    IPAddressSegment zeroSeg = (IPAddressSegment)creator.createSegment(0, 0);
                    do {
                        newSegments[i] = zeroSeg;
                    } while (++i < count);
                }
                return (R)creator.createSectionInternal((IPAddressSegment[])newSegments);
            }
            if (seg.isPrefixed()) break;
            ++i;
        }
        return original;
    }

    static Integer getSplitSegmentPrefixLength(int bitsPerSegment, Integer networkPrefixLength, int segmentIndex) {
        if (networkPrefixLength != null) {
            int segmentPrefixLength = networkPrefixLength - segmentIndex * bitsPerSegment;
            return IPAddressSection.getSegmentPrefixLength(bitsPerSegment, segmentPrefixLength);
        }
        return null;
    }

    public static Integer getSegmentPrefixLength(int bitsPerSegment, Integer prefixLength, int segmentIndex) {
        return AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
    }

    public static Integer getSegmentPrefixLength(int bitsPerSegment, int segmentPrefixedBits) {
        return AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, segmentPrefixedBits);
    }

    static Integer getJoinedSegmentPrefixLength(int bitsPerSegment, Integer highBits, Integer lowBits) {
        if (lowBits == null) {
            return null;
        }
        if (lowBits == 0) {
            return highBits;
        }
        return lowBits + bitsPerSegment;
    }

    public abstract IPAddressNetwork getNetwork();

    @Override
    public int getSegmentCount() {
        return this.getDivisionCount();
    }

    @Override
    public IPAddressSegment getSegment(int index) {
        return (IPAddressSegment)this.divisions[index];
    }

    public boolean contains(IPAddressSection other) {
        if (this.getSegmentCount() != other.getSegmentCount()) {
            return false;
        }
        int i = 0;
        while (i < this.getSegmentCount()) {
            IPAddressSegment seg = this.getSegment(i);
            if (!seg.contains(other.getSegment(i))) {
                return false;
            }
            if (seg.isPrefixed()) break;
            ++i;
        }
        return true;
    }

    @Override
    public boolean isFullRange() {
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            IPAddressSegment div = this.getSegment(i);
            if (!div.isFullRange()) {
                return false;
            }
            Integer prefix = div.getSegmentPrefixLength();
            if (prefix != null) break;
            ++i;
        }
        return true;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R[] subtract(R first, R other, IPAddressTypeNetwork.IPAddressCreator<T, R, ?, S> addrCreator, IntFunction<S> segProducer, BiFunction<R, Integer, R> prefixApplier) {
        int segCount = first.getSegmentCount();
        if (segCount != other.getSegmentCount()) {
            throw new AddressTypeException(first, other, "ipaddress.error.sizeMismatch");
        }
        if (!first.isMultiple()) {
            if (other.contains(first)) {
                return null;
            }
            IPAddressSection[] result = addrCreator.createSectionArray(1);
            result[0] = first;
            return result;
        }
        int i = 0;
        while (i < segCount) {
            IPAddressSegment seg = first.getSegment(i);
            IPAddressSegment otherSeg = other.getSegment(i);
            int lower = seg.getLowerSegmentValue();
            int higher = seg.getUpperSegmentValue();
            int otherLower = otherSeg.getLowerSegmentValue();
            int otherHigher = otherSeg.getUpperSegmentValue();
            if (otherLower > higher || lower > otherHigher) {
                IPAddressSection[] result = addrCreator.createSectionArray(1);
                result[0] = first;
                return result;
            }
            ++i;
        }
        IPAddressSegment[] intersections = (IPAddressSegment[])addrCreator.createSegmentArray(segCount);
        ArrayList<IPAddressSection> sections = new ArrayList<IPAddressSection>();
        int i2 = 0;
        while (i2 < segCount) {
            IPAddressSection section;
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i2);
            IPAddressSegment otherSeg = other.getSegment(i2);
            int lower = seg.getLowerSegmentValue();
            int higher = seg.getUpperSegmentValue();
            int otherLower = otherSeg.getLowerSegmentValue();
            int otherHigher = otherSeg.getUpperSegmentValue();
            if (lower >= otherLower) {
                if (higher <= otherHigher) {
                    intersections[i2] = seg.isPrefixed() ? (IPAddressSegment)addrCreator.createSegment(lower, higher, null) : seg;
                } else {
                    intersections[i2] = (IPAddressSegment)addrCreator.createSegment(lower, otherHigher, null);
                    section = IPAddressSection.createDiffSection(first, (int)(otherHigher + 1), (int)higher, (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                    sections.add(section);
                }
            } else {
                section = IPAddressSection.createDiffSection(first, (int)lower, (int)(otherLower - 1), (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                sections.add(section);
                if (higher <= otherHigher) {
                    intersections[i2] = (IPAddressSegment)addrCreator.createSegment(otherLower, higher, null);
                } else {
                    intersections[i2] = (IPAddressSegment)addrCreator.createSegment(otherLower, otherHigher, null);
                    section = IPAddressSection.createDiffSection(first, (int)(otherHigher + 1), (int)higher, (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                    sections.add(section);
                }
            }
            ++i2;
        }
        if (first.isPrefixed()) {
            int thisPrefix = first.getNetworkPrefixLength();
            int i3 = 0;
            while (i3 < sections.size()) {
                int bitCount;
                IPAddressSection section = (IPAddressSection)sections.get(i3);
                int totalPrefix = bitCount = section.getBitCount();
                int j = first.getSegmentCount() - 1;
                while (j >= 0) {
                    IPAddressSegment seg = section.getSegment(j);
                    int segBitCount = seg.getBitCount();
                    int segPrefix = seg.getMinPrefix();
                    if (segPrefix == segBitCount) break;
                    totalPrefix -= segBitCount;
                    if (segPrefix != 0) {
                        totalPrefix += segPrefix;
                        break;
                    }
                    --j;
                }
                if (totalPrefix != bitCount) {
                    if (totalPrefix < thisPrefix) {
                        totalPrefix = thisPrefix;
                    }
                    section = (IPAddressSection)prefixApplier.apply(section, totalPrefix);
                    sections.set(i3, section);
                }
                ++i3;
            }
        }
        IPAddressSection[] result = addrCreator.createSectionArray(sections.size());
        sections.toArray(result);
        return result;
    }

    private static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R createDiffSection(R original, int lower, int upper, int diffIndex, IPAddressTypeNetwork.IPAddressCreator<T, R, ?, S> addrCreator, IntFunction<S> segProducer, S[] intersectingValues) {
        IPAddressSegment diff;
        int segCount = original.getSegmentCount();
        IPAddressSegment[] segments = (IPAddressSegment[])addrCreator.createSegmentArray(segCount);
        int j = 0;
        while (j < diffIndex) {
            segments[j] = intersectingValues[j];
            ++j;
        }
        segments[diffIndex] = diff = (IPAddressSegment)addrCreator.createSegment(lower, upper, null);
        int j2 = diffIndex + 1;
        while (j2 < segCount) {
            segments[j2] = (IPAddressSegment)segProducer.apply(j2);
            ++j2;
        }
        IPAddressSection section = addrCreator.createSectionInternal(segments);
        return (R)section;
    }

    public boolean isMaskCompatibleWithRange(IPAddressSection mask, Integer networkPrefixLength) {
        IPAddress.IPVersion version = this.getIPVersion();
        if (!version.equals((Object)mask.getIPVersion())) {
            throw new AddressTypeException((AddressSection)this, mask, "ipaddress.error.typeMismatch");
        }
        int segmentCount = this.getSegmentCount();
        if (mask.getSegmentCount() != segmentCount) {
            throw new AddressTypeException((AddressSection)this, mask, "ipaddress.error.sizeMismatch");
        }
        if (networkPrefixLength != null && (networkPrefixLength < 0 || networkPrefixLength > this.getBitCount())) {
            throw new AddressTypeException(this, (int)networkPrefixLength, "ipaddress.error.prefixSize");
        }
        if (this.isMultiple() && (networkPrefixLength == null || networkPrefixLength > 0)) {
            int bitsPerSegment = this.getBitsPerSegment();
            if (networkPrefixLength == null) {
                networkPrefixLength = segmentCount * bitsPerSegment;
            }
            int i = 0;
            while (i < segmentCount) {
                IPAddressSegment maskSegment;
                Integer segmentPrefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength);
                IPAddressSegment segment = this.getSegment(i);
                if (!segment.isMaskCompatibleWithRange((maskSegment = mask.getSegment(i)).getLowerSegmentValue(), segmentPrefix)) {
                    return false;
                }
                ++i;
                networkPrefixLength = networkPrefixLength - bitsPerSegment;
            }
        }
        return true;
    }

    @Override
    public abstract IPAddressSection applyPrefixLength(int var1) throws AddressTypeException;

    protected void checkSubnet(int networkPrefixLength) throws AddressTypeException {
        if (networkPrefixLength < 0 || networkPrefixLength > this.getBitCount()) {
            throw new AddressTypeException(this, networkPrefixLength, "ipaddress.error.prefixSize");
        }
    }

    protected void checkSectionCount(IPAddressSection mask) throws AddressTypeException {
        if (mask.getSegmentCount() != this.getSegmentCount()) {
            throw new AddressTypeException((AddressSection)this, mask, "ipaddress.error.sizeMismatch");
        }
    }

    public IPAddressSection toPrefixedEquivalent() {
        if (!this.isMultiple()) {
            return this;
        }
        Integer newPrefix = this.getEquivalentPrefix();
        return newPrefix == null ? null : this.applyPrefixLength(newPrefix);
    }

    public IPAddressSection toMinPrefixedEquivalent() {
        return this.applyPrefixLength(this.getMinPrefix());
    }

    public abstract IPAddressSection removePrefixLength(boolean var1);

    @Override
    public abstract IPAddressSection removePrefixLength();

    protected static <R extends IPAddressSection, S extends IPAddressSegment> R removePrefixLength(R original, boolean zeroed, boolean onlyPrefixZeroed, IPAddressTypeNetwork.IPAddressCreator<?, R, ?, S> creator, IPAddressTypeNetwork<?, R, S> network, SegFunction<R, S> segProducer) {
        int maskBitCount;
        if (!original.isPrefixed()) {
            return original;
        }
        if (zeroed) {
            int segmentIndex;
            IPAddressSegment seg;
            Integer pref = original.getPrefixLength();
            maskBitCount = onlyPrefixZeroed ? ((seg = original.getSegment(segmentIndex = original.getSegmentIndex(pref))).isRangeEquivalentToPrefix() ? pref : (segmentIndex + 1) * seg.getBitCount()) : pref;
        } else {
            maskBitCount = original.getBitCount();
        }
        Object mask = network.getNetworkMaskSection(maskBitCount);
        return IPAddressSection.getSubnetSegments(original, null, creator, false, i -> (IPAddressSegment)segProducer.apply(original, i), i -> (IPAddressSegment)segProducer.apply(mask, i));
    }

    @Override
    public IPAddressSection adjustPrefixBySegment(boolean nextSegment) {
        int prefix = this.getAdjustedPrefix(nextSegment, this.getBitsPerSegment(), false);
        Integer existing = this.getNetworkPrefixLength();
        if (existing == null) {
            if (nextSegment ? prefix == this.getBitCount() : prefix == 0) {
                return this;
            }
        } else if (existing != null && existing == prefix) {
            return this.removePrefixLength();
        }
        return this.setPrefixLength(prefix);
    }

    @Override
    public abstract IPAddressSection adjustPrefixLength(int var1);

    protected static <R extends IPAddressSection, S extends IPAddressSegment> IPAddressSection adjustPrefixLength(R original, int adjustment, IPAddressTypeNetwork.IPAddressCreator<?, R, ?, S> creator, IPAddressTypeNetwork<?, R, S> network, SegFunction<R, S> segProducer) {
        if (adjustment == 0) {
            return original;
        }
        int prefix = original.getAdjustedPrefix(adjustment, false, false);
        if (prefix < 0 || prefix > original.getBitCount()) {
            if (!original.isPrefixed()) {
                return original;
            }
            int maskBitCount = prefix < 0 ? 0 : original.getPrefixLength();
            Object mask = network.getNetworkMaskSection(maskBitCount);
            return IPAddressSection.getSubnetSegments(original, null, creator, false, i -> (IPAddressSegment)segProducer.apply(original, i), i -> (IPAddressSegment)segProducer.apply(mask, i));
        }
        return original.setPrefixLength(prefix);
    }

    @Override
    public abstract IPAddressSection setPrefixLength(int var1);

    public abstract IPAddressSection setPrefixLength(int var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNoPrefixCache() {
        if (this.prefixCache == null) {
            IPAddressSection iPAddressSection = this;
            synchronized (iPAddressSection) {
                block5: {
                    if (this.prefixCache != null) break block5;
                    this.prefixCache = new PrefixCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getMinPrefix() {
        Integer result;
        if (this.hasNoPrefixCache() || (result = this.prefixCache.cachedMinPrefix) == null) {
            result = super.getMinPrefix();
            this.prefixCache.cachedMinPrefix = result;
        }
        return result;
    }

    @Override
    public Integer getEquivalentPrefix() {
        Integer result;
        if (!this.hasNoPrefixCache() && (result = this.prefixCache.cachedEquivalentPrefix) != null) {
            if (result < 0) {
                return null;
            }
            return result;
        }
        Integer res = super.getEquivalentPrefix();
        if (res == null) {
            this.prefixCache.cachedEquivalentPrefix = -1;
            return null;
        }
        Integer n = res;
        this.prefixCache.cachedEquivalentPrefix = n;
        return n;
    }

    @Override
    public abstract IPAddressSection getLower();

    @Override
    public abstract IPAddressSection getUpper();

    @Override
    public abstract IPAddressSection reverseSegments();

    @Override
    public abstract IPAddressSection reverseBits(boolean var1);

    @Override
    public abstract IPAddressSection reverseBytes();

    @Override
    public abstract IPAddressSection reverseBytesPerSegment();

    public abstract IPAddressSegment[] getSegments();

    @Override
    public abstract IPAddressSection getSection(int var1);

    @Override
    public abstract IPAddressSection getSection(int var1, int var2);

    @Override
    public void getSegments(AddressSegment[] segs) {
        this.getSegments(0, this.getDivisionCount(), segs, 0);
    }

    @Override
    public void getSegments(int start, int end, AddressSegment[] segs, int destIndex) {
        System.arraycopy(this.divisions, start, segs, destIndex, end - start);
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R createSection(IPAddressTypeNetwork.IPAddressCreator<T, R, ?, S> creator, S[] segs) {
        return (R)creator.createSectionInternal((IPAddressSegment[])segs);
    }

    public abstract Iterable<? extends IPAddressSection> getIterable();

    public abstract Iterator<? extends IPAddressSection> iterator();

    public abstract Iterator<? extends IPAddressSegment[]> segmentsIterator();

    public boolean isEntireAddress() {
        return this.getSegmentCount() == IPAddress.segmentCount(this.getIPVersion());
    }

    static void checkLengths(int length, StringBuilder builder) {
        IPAddressDivisionGrouping.IPAddressStringParams.checkLengths(length, builder);
    }

    public String[] getSegmentStrings() {
        String[] result = new String[this.getSegmentCount()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getSegment(i).getWildcardString();
            ++i;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.toNormalizedString();
    }

    public abstract String toFullString();

    protected abstract void cacheNormalizedString(String var1);

    @Override
    public abstract String toCompressedString();

    public abstract String toPrefixLengthString();

    public abstract String toSubnetString();

    public abstract String toNormalizedWildcardString();

    public abstract String toCanonicalWildcardString();

    public abstract String toCompressedWildcardString();

    public abstract String toSQLWildcardString();

    protected abstract IPStringCache getStringCache();

    protected abstract boolean hasNoStringCache();

    public abstract String toReverseDNSLookupString();

    public String toBinaryString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().binaryString) == null) {
            IPStringCache stringCache = this.getStringCache();
            stringCache.binaryString = result = this.toBinaryString(null);
        }
        return result;
    }

    protected String toBinaryString(CharSequence zone) {
        if (this.isDualString()) {
            return IPAddressSection.toNormalizedStringRange(IPAddressSection.toIPParams(IPStringCache.binaryParams), this.getLower(), this.getUpper(), zone);
        }
        return IPAddressSection.toIPParams(IPStringCache.binaryParams).toString((IPAddressStringDivisionSeries)this, zone);
    }

    public String toOctalString(boolean with0Prefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0Prefix ? this.getStringCache().octalStringPrefixed : this.getStringCache().octalString) == null) {
            IPStringCache stringCache = this.getStringCache();
            result = this.toOctalString(with0Prefix, null);
            if (with0Prefix) {
                stringCache.octalStringPrefixed = result;
            } else {
                stringCache.octalString = result;
            }
        }
        return result;
    }

    protected String toOctalString(boolean with0Prefix, CharSequence zone) {
        if (this.isDualString()) {
            IPAddressSection lower = this.getLower();
            IPAddressSection upper = this.getUpper();
            IPAddressDivision[] lowerDivs = (IPAddressBitsDivision[])lower.createNewDivisions(3, IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
            IPAddressDivisionGrouping lowerPart = new IPAddressDivisionGrouping(lowerDivs);
            IPAddressDivision[] upperDivs = (IPAddressBitsDivision[])upper.createNewDivisions(3, IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
            IPAddressDivisionGrouping upperPart = new IPAddressDivisionGrouping(upperDivs);
            return IPAddressSection.toNormalizedStringRange(IPAddressSection.toIPParams(with0Prefix ? IPStringCache.octalPrefixedParams : IPStringCache.octalParams), lowerPart, upperPart, zone);
        }
        IPAddressDivision[] divs = (IPAddressBitsDivision[])this.createNewPrefixedDivisions(3, this.getNetworkPrefixLength(), IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
        IPAddressDivisionGrouping part = new IPAddressDivisionGrouping(divs);
        return IPAddressSection.toIPParams(with0Prefix ? IPStringCache.octalPrefixedParams : IPStringCache.octalParams).toString((IPAddressStringDivisionSeries)part, zone);
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0xPrefix ? this.getStringCache().hexStringPrefixed : this.getStringCache().hexString) == null) {
            IPStringCache stringCache = this.getStringCache();
            result = this.toHexString(with0xPrefix, null);
            if (with0xPrefix) {
                stringCache.hexStringPrefixed = result;
            } else {
                stringCache.hexString = result;
            }
        }
        return result;
    }

    protected String toHexString(boolean with0xPrefix, CharSequence zone) {
        if (this.isDualString()) {
            return IPAddressSection.toNormalizedStringRange(IPAddressSection.toIPParams(with0xPrefix ? IPStringCache.hexPrefixedParams : IPStringCache.hexParams), this.getLower(), this.getUpper(), zone);
        }
        return IPAddressSection.toIPParams(with0xPrefix ? IPStringCache.hexPrefixedParams : IPStringCache.hexParams).toString((IPAddressStringDivisionSeries)this, zone);
    }

    public String toNormalizedString(IPStringOptions stringOptions) {
        return IPAddressSection.toNormalizedString(stringOptions, this);
    }

    public static String toNormalizedString(IPStringOptions opts, IPAddressStringDivisionSeries section) {
        return IPAddressSection.toIPParams(opts).toString(section);
    }

    protected static AddressDivisionGrouping.AddressStringParams<IPAddressStringDivisionSeries> toParams(IPStringOptions opts) {
        IPAddressDivisionGrouping.IPAddressStringParams result = (IPAddressDivisionGrouping.IPAddressStringParams)IPAddressSection.getCachedParams(opts);
        if (result == null) {
            result = new IPAddressDivisionGrouping.IPAddressStringParams(opts.base, opts.separator, opts.uppercase);
            result.expandSegments(opts.expandSegments);
            result.setWildcards(opts.wildcards);
            result.setSegmentStrPrefix(opts.segmentStrPrefix);
            result.setAddressLabel(opts.addrLabel);
            result.setReverse(opts.reverse);
            result.setSplitDigits(opts.splitDigits);
            result.setRadix(opts.base);
            result.setUppercase(opts.uppercase);
            result.setSeparator(opts.separator);
            result.setZoneSeparator(opts.zoneSeparator);
            IPAddressSection.setCachedParams(opts, result);
        }
        return result;
    }

    protected static IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> toIPParams(IPStringOptions opts) {
        IPAddressDivisionGrouping.IPAddressStringParams result = (IPAddressDivisionGrouping.IPAddressStringParams)IPAddressSection.getCachedParams(opts);
        if (result == null) {
            result = new IPAddressDivisionGrouping.IPAddressStringParams(opts.base, opts.separator, opts.uppercase);
            result.expandSegments(opts.expandSegments);
            result.setWildcards(opts.wildcards);
            result.setWildcardOption(opts.wildcardOption);
            result.setSegmentStrPrefix(opts.segmentStrPrefix);
            result.setAddressSuffix(opts.addrSuffix);
            result.setAddressLabel(opts.addrLabel);
            result.setReverse(opts.reverse);
            result.setSplitDigits(opts.splitDigits);
            result.setZoneSeparator(opts.zoneSeparator);
            IPAddressSection.setCachedParams(opts, result);
        }
        return result;
    }

    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions(16));
    }

    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions(48));
    }

    public IPAddressPartStringCollection toDatabaseSearchStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions());
    }

    public abstract IPAddressPartStringCollection toStringCollection(IPStringBuilderOptions var1);

    public IPAddressStringDivisionSeries[] getParts(IPStringBuilderOptions options) {
        if (options.includes(1)) {
            return new IPAddressStringDivisionSeries[]{this};
        }
        return EMPTY_PARTS;
    }

    public void getStartsWithSQLClause(StringBuilder builder, String expression) {
        this.getStartsWithSQLClause(builder, expression, new MySQLTranslator());
    }

    public void getStartsWithSQLClause(StringBuilder builder, String expression, IPAddressSQLTranslator translator) {
        this.getStartsWithSQLClause(builder, expression, true, translator);
    }

    private void getStartsWithSQLClause(StringBuilder builder, String expression, boolean isFirstCall, IPAddressSQLTranslator translator) {
        if (isFirstCall && this.isMultiple()) {
            Iterator<? extends IPAddressSection> sectionIterator = this.iterator();
            builder.append('(');
            boolean isNotFirst = false;
            while (sectionIterator.hasNext()) {
                if (isNotFirst) {
                    builder.append(" OR ");
                } else {
                    isNotFirst = true;
                }
                IPAddressSection next = sectionIterator.next();
                next.getStartsWithSQLClause(builder, expression, false, translator);
            }
            builder.append(')');
        } else if (this.getSegmentCount() > 0) {
            IPAddressPartStringCollection createdStringCollection = this.toDatabaseSearchStringCollection();
            boolean isNotFirst = false;
            if (createdStringCollection.size() > 1) {
                builder.append('(');
            }
            boolean isEntireAddress = this.isEntireAddress();
            for (IPAddressPartConfiguredString<?, ?> createdStr : createdStringCollection) {
                if (isNotFirst) {
                    builder.append(" OR ");
                } else {
                    isNotFirst = true;
                }
                SQLStringMatcher matcher = createdStr.getNetworkStringMatcher(isEntireAddress, translator);
                matcher.getSQLCondition(builder.append('('), expression).append(')');
            }
            if (createdStringCollection.size() > 1) {
                builder.append(')');
            }
        }
    }

    public static class IPStringBuilderOptions {
        public static final int BASIC = 1;
        public static final int LEADING_ZEROS_FULL_ALL_SEGMENTS = 16;
        public static final int LEADING_ZEROS_FULL_SOME_SEGMENTS = 48;
        public static final int LEADING_ZEROS_PARTIAL_SOME_SEGMENTS = 112;
        public final int options;

        public IPStringBuilderOptions() {
            this(1);
        }

        public IPStringBuilderOptions(int options) {
            this.options = options;
        }

        public boolean includes(int option) {
            return (option & this.options) == option;
        }

        public boolean includesAny(int option) {
            return (option & this.options) != 0;
        }

        public String toString() {
            TreeMap<Integer, String> options = new TreeMap<Integer, String>();
            Field[] fields = this.getClass().getFields();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int modifiers = field.getModifiers();
                if (Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers)) {
                    try {
                        int constant = field.getInt(null);
                        String option = String.valueOf(field.getName()) + ": " + this.includes(constant) + System.lineSeparator();
                        options.put(constant, option);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            Collection values = options.values();
            StringBuilder builder = new StringBuilder();
            for (String val : values) {
                builder.append(val);
            }
            return builder.toString();
        }
    }

    protected static class IPStringCache
    extends AddressDivisionGrouping.StringCache {
        public static final IPStringOptions hexParams;
        public static final IPStringOptions hexPrefixedParams;
        public static final IPStringOptions octalParams;
        public static final IPStringOptions octalPrefixedParams;
        public static final IPStringOptions binaryParams;
        public static final IPStringOptions canonicalSegmentParams;
        public String normalizedWildcardString;
        public String fullString;
        public String sqlWildcardString;
        public String reverseDNSString;
        public String octalStringPrefixed;
        public String octalString;
        public String binaryString;

        static {
            WildcardOptions wildcardsRangeOnlyNetworkOnly = new WildcardOptions(WildcardOptions.WildcardOption.NETWORK_ONLY);
            hexParams = new IPStringOptions.Builder(16).setSeparator(null).setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).toParams();
            hexPrefixedParams = new IPStringOptions.Builder(16).setSeparator(null).setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).setAddressLabel("0x").toParams();
            octalParams = new IPStringOptions.Builder(8).setSeparator(null).setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).toParams();
            octalPrefixedParams = new IPStringOptions.Builder(8).setSeparator(null).setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).setAddressLabel("0").toParams();
            binaryParams = new IPStringOptions.Builder(2).setSeparator(null).setExpandedSegments(true).setWildcardOptions(wildcardsRangeOnlyNetworkOnly).toParams();
            canonicalSegmentParams = new IPStringOptions.Builder(10, ' ').toParams();
        }

        protected IPStringCache() {
        }
    }

    public static class IPStringOptions
    extends AddressDivisionGrouping.StringOptions {
        public final String addrSuffix;
        public final WildcardOptions.WildcardOption wildcardOption;
        public final char zoneSeparator;

        protected IPStringOptions(int base, boolean expandSegments, WildcardOptions.WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, Character separator, char zoneSeparator, String label, String suffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            super(base, expandSegments, wildcards, segmentStrPrefix, separator, label, reverse, splitDigits, uppercase);
            this.addrSuffix = suffix;
            this.wildcardOption = wildcardOption;
            this.zoneSeparator = zoneSeparator;
        }

        public static class Builder
        extends AddressDivisionGrouping.StringOptions.Builder {
            protected String addrSuffix = "";
            protected WildcardOptions.WildcardOption wildcardOption;
            protected char zoneSeparator = (char)37;

            public Builder(int base) {
                this(base, ' ');
            }

            protected Builder(int base, char separator) {
                super(base, separator);
            }

            @Override
            public Builder setWildcards(AddressDivisionGrouping.StringOptions.Wildcards wildcards) {
                return (Builder)super.setWildcards(wildcards);
            }

            public Builder setAddressSuffix(String suffix) {
                this.addrSuffix = suffix;
                return this;
            }

            public Builder setWildcardOptions(WildcardOptions wildcardOptions) {
                this.setWildcardOption(wildcardOptions.wildcardOption);
                return this.setWildcards(wildcardOptions.wildcards);
            }

            public Builder setWildcardOption(WildcardOptions.WildcardOption wildcardOption) {
                this.wildcardOption = wildcardOption;
                return this;
            }

            @Override
            public Builder setReverse(boolean reverse) {
                return (Builder)super.setReverse(reverse);
            }

            @Override
            public Builder setUppercase(boolean uppercase) {
                return (Builder)super.setUppercase(uppercase);
            }

            @Override
            public Builder setSplitDigits(boolean splitDigits) {
                return (Builder)super.setSplitDigits(splitDigits);
            }

            @Override
            public Builder setExpandedSegments(boolean expandSegments) {
                return (Builder)super.setExpandedSegments(expandSegments);
            }

            @Override
            public Builder setRadix(int base) {
                return (Builder)super.setRadix(base);
            }

            @Override
            public Builder setSeparator(Character separator) {
                return (Builder)super.setSeparator(separator);
            }

            public Builder setZoneSeparator(char separator) {
                this.zoneSeparator = separator;
                return this;
            }

            @Override
            public Builder setAddressLabel(String label) {
                return (Builder)super.setAddressLabel(label);
            }

            @Override
            public Builder setSegmentStrPrefix(String prefix) {
                return (Builder)super.setSegmentStrPrefix(prefix);
            }

            @Override
            public IPStringOptions toParams() {
                return new IPStringOptions(this.base, this.expandSegments, this.wildcardOption, this.wildcards, this.segmentStrPrefix, this.separator, this.zoneSeparator, this.addrLabel, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    protected static class PrefixCache {
        private Integer networkMaskPrefixLen;
        private Integer hostMaskPrefixLen;
        private Integer cachedMinPrefix;
        private Integer cachedEquivalentPrefix;

        protected PrefixCache() {
        }
    }

    @FunctionalInterface
    public static interface SegFunction<R, S> {
        public S apply(R var1, int var2);
    }

    public static class WildcardOptions {
        public final WildcardOption wildcardOption;
        public final AddressDivisionGrouping.StringOptions.Wildcards wildcards;

        public WildcardOptions() {
            this(WildcardOption.NETWORK_ONLY);
        }

        public WildcardOptions(WildcardOption wildcardOption) {
            this(wildcardOption, new AddressDivisionGrouping.StringOptions.Wildcards());
        }

        public WildcardOptions(WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards) {
            this.wildcardOption = wildcardOption;
            this.wildcards = wildcards;
        }

        public static enum WildcardOption {
            NETWORK_ONLY,
            ALL;

        }
    }
}

