/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.error.reporting.ui;

import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.error.reporting.ui.NotificationUtility;
import com.paterva.maltego.error.reporting.ui.ProblemDtoBuilder;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProblemSender {
    private static final Logger LOG = Logger.getLogger(ProblemSender.class.getName());
    private final ProblemDtoBuilder problemBuilder;

    public ProblemSender(ProblemDtoBuilder problemBuilder) {
        this.problemBuilder = problemBuilder;
    }

    public void send(boolean notify) {
        block3: {
            try {
                HttpAgent agent = new HttpAgent(new URL("https://errors.paterva.com"));
                String problemJson = this.problemBuilder.buildJsonString();
                LOG.log(Level.FINE, "Problem JSON:\n{0}", problemJson);
                agent.doPostString("application/json", problemJson);
                if (notify) {
                    NotificationUtility.showNotification("Problem Reported");
                }
            }
            catch (Exception ex) {
                String msg = "Failed to Report Problem";
                LOG.warning(() -> msg + ": " + ex.getMessage());
                if (!notify) break block3;
                NotificationUtility.showNotification(msg);
            }
        }
    }
}

