/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.DefaultGraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphStructureWrapper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import y.base.Graph;
import y.view.Graph2D;

public class MaltegoGraphManager {
    private MaltegoGraphManager() {
    }

    public static GraphWrapper createWrapper(GraphID graphID) {
        DefaultGraphStoreView view = null;
        try {
            view = new DefaultGraphStoreView(graphID);
        }
        catch (GraphStoreException ex) {
            throw new IllegalArgumentException("Failed to create default graph store for graphID '" + graphID + "'", ex);
        }
        return MaltegoGraphManager.createWrapper(graphID, (GraphStoreView)view);
    }

    public static GraphWrapper createWrapper(GraphID graphID, GraphStoreView view) {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        GraphWrapper wrapper = (GraphWrapper)gud.get((Object)(key = GraphWrapper.class.getName()));
        if (wrapper != null) {
            throw new IllegalArgumentException("Wrapper already created for graph " + graphID);
        }
        GraphStoreViewRegistry.getDefault().register("Main", graphID, view);
        Graph2D graph = GraphViewManager.getDefault().createViewGraph(graphID);
        wrapper = new GraphWrapper(graphID, (Graph)graph, view);
        gud.put((Object)key, (Object)wrapper);
        return wrapper;
    }

    public static GraphWrapper getWrapper(Graph graph) {
        GraphID graphID = GraphViewManager.getDefault().getGraphID((Graph2D)graph);
        return MaltegoGraphManager.getWrapper(graphID);
    }

    public static GraphWrapper getWrapper(GraphID graphID) {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        GraphWrapper wrapper = (GraphWrapper)gud.get((Object)(key = GraphWrapper.class.getName()));
        if (wrapper == null) {
            throw new IllegalArgumentException("Wrapper does not exist for graph " + graphID);
        }
        return wrapper;
    }

    public static boolean exists(GraphID graphID) {
        GraphWrapper wrapper = null;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID, (boolean)false);
        if (gud != null) {
            String key = GraphWrapper.class.getName();
            wrapper = (GraphWrapper)gud.get((Object)key);
        }
        return wrapper != null;
    }

    public static Graph get(GraphWrapper graph) {
        if (graph instanceof GraphStructureWrapper) {
            GraphWrapper gsw = graph;
            return gsw.getGraph();
        }
        return null;
    }
}

