/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.UserDataHolder;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutMods;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.wrapper.GraphStructureWrapper;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeMap;
import y.geom.YPoint;
import y.geom.YPointPath;
import y.view.EdgeRealizer;
import y.view.GenericNodeRealizer;
import y.view.Graph2D;
import y.view.NodeRealizer;

public class GraphWrapper
extends GraphStructureWrapper {
    private static final Logger LOG = Logger.getLogger(GraphWrapper.class.getName());
    private final GraphID _graphID;
    private final List<EventListener> _propertyChangeListeners = Collections.synchronizedList(new LinkedList());
    private final GraphStoreView _graphStoreView;
    private GraphLayoutListener _layoutListener;
    private GraphStructureListener _structureListener;
    private boolean _isSyncing = false;

    protected GraphWrapper(GraphID graphID, Graph graph, GraphStoreView view) {
        super(graph);
        this._graphID = graphID;
        this._graphStoreView = view;
        this._structureListener = new GraphStructureListener();
        this._layoutListener = new GraphLayoutListener();
        this._graphStoreView.getGraphStructureStore().addPropertyChangeListener((PropertyChangeListener)this._structureListener);
        this._graphStoreView.getGraphLayoutStore().addPropertyChangeListener((PropertyChangeListener)this._layoutListener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("graphClosing".equals(evt.getPropertyName()) && evt.getNewValue().equals(GraphWrapper.this._graphID)) {
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    GraphWrapper.this._graphStoreView.getGraphStructureStore().removePropertyChangeListener((PropertyChangeListener)GraphWrapper.this._structureListener);
                    GraphWrapper.this._graphStoreView.getGraphLayoutStore().removePropertyChangeListener((PropertyChangeListener)GraphWrapper.this._layoutListener);
                    GraphWrapper.this._structureListener = null;
                    GraphWrapper.this._layoutListener = null;
                }
            }
        });
    }

    public void beginUpdate() {
        this.graph().firePreEvent();
        this.getGraphStoreView().beginUpdate();
    }

    public void endUpdate() {
        this.getGraphStoreView().endUpdate(null);
        this.graph().firePostEvent();
    }

    private GenericNodeRealizer getRealizer(Node node) {
        Graph2D g2d;
        NodeRealizer nr;
        Graph graph = this.getGraph();
        if (graph instanceof Graph2D && (nr = (g2d = (Graph2D)graph).getRealizer(node)) instanceof GenericNodeRealizer) {
            return (GenericNodeRealizer)nr;
        }
        return null;
    }

    private EdgeRealizer getRealizer(Edge edge) {
        Graph graph = this.getGraph();
        if (graph instanceof Graph2D) {
            Graph2D g2d = (Graph2D)graph;
            return g2d.getRealizer(edge);
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._propertyChangeListeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._propertyChangeListeners.remove(pcl);
    }

    public boolean isCollectionNode(EntityID entityID) {
        try {
            return this.getGraphStoreView().getModelViewMappings().isOnlyViewEntity(entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public boolean isCollectionNodeLink(LinkID linkID) {
        try {
            return this.getGraphStoreView().getModelViewMappings().isOnlyViewLink(linkID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    protected void firePropertyChange(String propertyName, Object old, Object nue) {
        PropertyChangeListener[] pcls = this._propertyChangeListeners.toArray(new PropertyChangeListener[0]);
        for (int i = 0; i < pcls.length; ++i) {
            pcls[i].propertyChange(new PropertyChangeEvent(this, propertyName, old, nue));
        }
    }

    private void yFilesMemLeakWorkaround(Graph graph, Node node) {
        NodeMap nodeMap;
        Object modelNode;
        DataProvider view2Model = graph.getDataProvider((Object)"y.view.ModelViewManager.VIEW_2_MODEL_NODES");
        if (view2Model instanceof NodeMap && (modelNode = (nodeMap = (NodeMap)view2Model).get((Object)node)) != null) {
            nodeMap.set((Object)node, null);
            DataProvider model2View = graph.getDataProvider((Object)"y.view.ModelViewManager.MODEL_2_VIEW_NODES");
            if (model2View instanceof NodeMap) {
                nodeMap = (NodeMap)model2View;
                nodeMap.set(modelNode, null);
            }
        }
    }

    private void yFilesMemLeakWorkaround(Graph graph, Edge edge) {
        EdgeMap edgeMap;
        Object modelEdge;
        DataProvider view2Model = graph.getDataProvider((Object)"y.view.ModelViewManager.VIEW_2_MODEL_EDGES");
        if (view2Model instanceof EdgeMap && (modelEdge = (edgeMap = (EdgeMap)view2Model).get((Object)edge)) != null) {
            edgeMap.set((Object)edge, null);
            DataProvider model2View = graph.getDataProvider((Object)"y.view.ModelViewManager.MODEL_2_VIEW_EDGES");
            if (model2View instanceof EdgeMap) {
                edgeMap = (EdgeMap)model2View;
                edgeMap.set(modelEdge, null);
            }
        }
    }

    private void cleanupRemovedNode(Node node) {
        Graph2D g2d;
        NodeRealizer realizer;
        Graph graph = this.getGraph();
        if (graph instanceof Graph2D && (realizer = (g2d = (Graph2D)graph).getRealizer(node)) instanceof GenericNodeRealizer) {
            ((GenericNodeRealizer)realizer).setUserData(null);
        }
        this.yFilesMemLeakWorkaround(graph, node);
    }

    private void cleanupEdgeRemoved(Edge edge) {
        Graph2D g2d;
        EdgeRealizer realizer;
        Graph graph = this.getGraph();
        if (graph instanceof Graph2D && (realizer = (g2d = (Graph2D)graph).getRealizer(edge)) instanceof UserDataHolder) {
            ((UserDataHolder)realizer).setUserData(null);
        }
        this.yFilesMemLeakWorkaround(graph, edge);
    }

    public GraphDataStore getGraphDataStore() {
        return this.getGraphStoreView().getGraphDataStore();
    }

    public GraphStructureStore getGraphStructureStore() {
        return this.getGraphStoreView().getGraphStructureStore();
    }

    public GraphLayoutStore getGraphLayoutStore() {
        return this.getGraphStoreView().getGraphLayoutStore();
    }

    public GraphStoreView getGraphStoreView() {
        return this._graphStoreView;
    }

    private GraphID getGraphID() {
        return this._graphID;
    }

    private YPointPath listToYPointPath(List<Point> path) {
        ArrayList<YPoint> pointList = new ArrayList<YPoint>(path.size());
        for (Point point2D : path) {
            pointList.add(new YPoint((double)point2D.x, (double)point2D.y));
        }
        return new YPointPath(pointList);
    }

    public boolean isSyncing() {
        return this._isSyncing;
    }

    public void setIsSyncing(boolean isSyncing) {
        this._isSyncing = isSyncing;
    }

    private class GraphLayoutListener
    implements PropertyChangeListener {
        private GraphLayoutListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Graph2D graph = (Graph2D)GraphWrapper.this.graph();
            graph.firePreEvent();
            try {
                GraphLayoutMods mods = (GraphLayoutMods)evt.getNewValue();
                for (Map.Entry entry : mods.getCenters().entrySet()) {
                    EntityID entityID = (EntityID)entry.getKey();
                    Point center = (Point)entry.getValue();
                    if (center == null) continue;
                    Node node = GraphWrapper.this.node(entityID);
                    if (node != null) {
                        graph.setCenter(node, (double)center.x, (double)center.y);
                        continue;
                    }
                    LOG.log(Level.WARNING, "Node not found for entity {0}", entityID);
                }
                for (Map.Entry entrySet : mods.getPaths().entrySet()) {
                    LinkID linkID = (LinkID)entrySet.getKey();
                    List path = (List)entrySet.getValue();
                    if (path == null) continue;
                    Edge edge = GraphWrapper.this.edge(linkID);
                    if (edge != null) {
                        YPointPath pointPath = GraphWrapper.this.listToYPointPath(path);
                        graph.setPath(edge, pointPath);
                        graph.setSourcePointRel(edge, pointPath.getFirst());
                        graph.setTargetPointRel(edge, pointPath.getLast());
                        continue;
                    }
                    LOG.log(Level.WARNING, "Edge not found for link {0}", linkID);
                }
            }
            finally {
                graph.firePostEvent();
                graph.updateViews();
            }
        }
    }

    private class GraphStructureListener
    implements PropertyChangeListener {
        private GraphStructureListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphWrapper.this.graph().firePreEvent();
            boolean updateViews = false;
            try {
                GraphID graphID = GraphWrapper.this.getGraphID();
                GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
                for (LinkID linkID : mods.getLinksRemoved().keySet()) {
                    this.onLinkRemoved(linkID);
                    updateViews = true;
                }
                for (EntityID entityID : mods.getEntitiesRemoved()) {
                    this.onEntityRemoved(entityID);
                    updateViews = true;
                }
                if (!mods.getEntitiesAdded().isEmpty()) {
                    this.onEntitiesAdded(mods.getEntitiesAdded(), graphID);
                    updateViews = true;
                }
                if (!mods.getLinksAdded().isEmpty()) {
                    this.onLinksAdded(mods.getLinksAdded(), graphID);
                    updateViews = true;
                }
            }
            finally {
                GraphWrapper.this.graph().firePostEvent();
                if (updateViews) {
                    Graph2D g2d = (Graph2D)GraphWrapper.this.graph();
                    g2d.updateViews();
                }
            }
        }

        private void onLinksAdded(Set<LinkID> linkIDs, GraphID graphID) {
            try {
                GraphStructureReader reader = GraphWrapper.this.getGraphStructureStore().getStructureReader();
                Map linkEntities = reader.getEntities(linkIDs);
                GraphStoreView graphStoreView = GraphWrapper.this.getGraphStoreView();
                GraphLayoutReader viewLayoutReader = graphStoreView.getGraphLayoutStore().getLayoutReader();
                Map paths = viewLayoutReader.getPaths(linkIDs);
                for (LinkID linkID : linkIDs) {
                    List path;
                    GraphSelection selection;
                    LinkEntityIDs entities = (LinkEntityIDs)linkEntities.get(linkID);
                    Graph2D graph = (Graph2D)GraphWrapper.this.graph();
                    Edge edge = graph.createEdge(GraphWrapper.this.node(entities.getSourceID()), GraphWrapper.this.node(entities.getTargetID()));
                    GraphWrapper.this.edgeMap().set((Object)edge, (Object)linkID);
                    GraphWrapper.this.linkMap().put((Guid)linkID, (Object)edge);
                    EdgeRealizer realizer = GraphWrapper.this.getRealizer(edge);
                    if (realizer instanceof UserDataHolder) {
                        ((UserDataHolder)realizer).setUserData((Object)new GraphLink(graphID, linkID));
                    }
                    if ((selection = GraphSelection.forGraph((GraphID)graphID)).isSelectedInView(linkID) && !GraphWrapper.this.isSyncing()) {
                        graph.setSelected(edge, true);
                    }
                    if ((path = (List)paths.get(linkID)) == null) continue;
                    YPointPath pointPath = GraphWrapper.this.listToYPointPath(path);
                    graph.setPath(edge, pointPath);
                    graph.setSourcePointRel(edge, pointPath.getFirst());
                    graph.setTargetPointRel(edge, pointPath.getLast());
                }
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void onEntitiesAdded(Set<EntityID> entityIDs, GraphID graphID) {
            Graph2D graph = (Graph2D)GraphWrapper.this.graph();
            GraphStoreView graphStoreView = GraphWrapper.this.getGraphStoreView();
            GraphLayoutReader layoutReader = graphStoreView.getGraphLayoutStore().getLayoutReader();
            Map centers = Collections.EMPTY_MAP;
            HashSet<EntityID> selectedEntities = new HashSet<EntityID>();
            try {
                centers = layoutReader.getCenters(entityIDs);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            for (EntityID entityID : entityIDs) {
                Point center = (Point)centers.get(entityID);
                Node node = center == null ? graph.createNode() : graph.createNode((double)center.x, (double)center.y);
                GraphWrapper.this.nodeMap().set((Object)node, (Object)entityID);
                GraphWrapper.this.entityMap().put((Guid)entityID, (Object)node);
                GenericNodeRealizer realizer = GraphWrapper.this.getRealizer(node);
                if (realizer instanceof GenericNodeRealizer) {
                    realizer.setUserData((Object)new GraphEntity(graphID, entityID));
                }
                if (selection.getViewSelectionState(entityID) == SelectionState.NO || GraphWrapper.this.isSyncing()) continue;
                selectedEntities.add(entityID);
            }
            if (!selectedEntities.isEmpty()) {
                selection.clearSelection();
                selection.setSelectedViewEntities(selectedEntities);
            }
        }

        private void onEntityRemoved(EntityID entityID) {
            Node node = GraphWrapper.this.node(entityID);
            if (node != null) {
                GraphWrapper.this.graph().removeNode(node);
                GraphWrapper.this.nodeMap().set((Object)node, null);
                GraphWrapper.this.cleanupRemovedNode(node);
            }
            GraphWrapper.this.entityMap().remove((Guid)entityID);
        }

        private void onLinkRemoved(LinkID linkID) {
            Edge edge = GraphWrapper.this.edge(linkID);
            if (edge != null) {
                GraphWrapper.this.graph().removeEdge(edge);
                GraphWrapper.this.edgeMap().set((Object)edge, null);
                GraphWrapper.this.cleanupEdgeRemoved(edge);
            }
            GraphWrapper.this.linkMap().remove((Guid)linkID);
        }
    }
}

