/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.HashMapGuidDataAdapter;
import com.paterva.maltego.graph.wrapper.EdgeCursorIterator;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import java.util.HashSet;
import java.util.Set;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeList;
import y.base.EdgeMap;
import y.base.Graph;
import y.base.Node;
import y.base.NodeMap;

public abstract class GraphStructureWrapper {
    private static final String NODE_MAP_PROVIDER_KEY = "maltego.NodeMap";
    private static final String EDGE_MAP_PROVIDER_KEY = "maltego.EdgeMap";
    private static final String ENTITY_MAP_PROVIDER_KEY = "maltego.EntityMap";
    private static final String LINK_MAP_PROVIDER_KEY = "maltego.LinkMap";
    private final Graph _graph;
    private final NodeMap _nodes;
    private final EdgeMap _edges;
    private final HashMapGuidDataAdapter<EntityID, Node> _entities;
    private final HashMapGuidDataAdapter<LinkID, Edge> _links;

    protected GraphStructureWrapper(Graph graph) {
        this._graph = graph;
        this._nodes = GraphStructureWrapper.getNodeMap(graph);
        this._edges = GraphStructureWrapper.getEdgeMap(graph);
        this._entities = GraphStructureWrapper.getEntityMap(graph);
        this._links = GraphStructureWrapper.getLinkMap(graph);
    }

    private static HashMapGuidDataAdapter<EntityID, Node> getEntityMap(Graph graph) {
        HashMapGuidDataAdapter entities = (HashMapGuidDataAdapter)graph.getDataProvider((Object)ENTITY_MAP_PROVIDER_KEY);
        if (entities == null) {
            entities = new HashMapGuidDataAdapter();
            graph.addDataProvider((Object)ENTITY_MAP_PROVIDER_KEY, (DataProvider)entities);
        }
        return entities;
    }

    private static HashMapGuidDataAdapter<LinkID, Edge> getLinkMap(Graph graph) {
        HashMapGuidDataAdapter links = (HashMapGuidDataAdapter)graph.getDataProvider((Object)LINK_MAP_PROVIDER_KEY);
        if (links == null) {
            links = new HashMapGuidDataAdapter();
            graph.addDataProvider((Object)LINK_MAP_PROVIDER_KEY, (DataProvider)links);
        }
        return links;
    }

    private static NodeMap getNodeMap(Graph graph) {
        NodeMap nodes = (NodeMap)graph.getDataProvider((Object)NODE_MAP_PROVIDER_KEY);
        if (nodes == null) {
            nodes = graph.createNodeMap();
            graph.addDataProvider((Object)NODE_MAP_PROVIDER_KEY, (DataProvider)nodes);
        }
        return nodes;
    }

    private static EdgeMap getEdgeMap(Graph graph) {
        EdgeMap edges = (EdgeMap)graph.getDataProvider((Object)EDGE_MAP_PROVIDER_KEY);
        if (edges == null) {
            edges = graph.createEdgeMap();
            graph.addDataProvider((Object)EDGE_MAP_PROVIDER_KEY, (DataProvider)edges);
        }
        return edges;
    }

    protected Graph graph() {
        return this._graph;
    }

    protected NodeMap nodeMap() {
        return this._nodes;
    }

    protected EdgeMap edgeMap() {
        return this._edges;
    }

    protected HashMapGuidDataAdapter<EntityID, Node> entityMap() {
        return this._entities;
    }

    protected HashMapGuidDataAdapter<LinkID, Edge> linkMap() {
        return this._links;
    }

    public EntityID entityID(Node node) {
        return (EntityID)this.nodeMap().get((Object)node);
    }

    public MaltegoEntity entity(Node node) {
        EntityID entityID = this.entityID(node);
        return this.getEntity(entityID);
    }

    public LinkID linkID(Edge edge) {
        return (LinkID)this.edgeMap().get((Object)edge);
    }

    public MaltegoLink link(Edge edge) {
        return this.getLink(this.linkID(edge));
    }

    public Node node(EntityID entityID) {
        return (Node)this.entityMap().get((Guid)entityID);
    }

    public Edge edge(LinkID linkID) {
        return (Edge)this.linkMap().get((Guid)linkID);
    }

    public Graph getGraph() {
        return this._graph;
    }

    public boolean containsEntity(EntityID entityID) {
        return this._entities.get((Guid)entityID) != null;
    }

    public boolean containsLink(LinkID linkID) {
        return this._links.get((Guid)linkID) != null;
    }

    public Iterable<LinkID> incomingIDs(EntityID entityID) {
        return new EdgeCursorIterator(this, this.node(entityID).inEdges());
    }

    public Iterable<LinkID> outgoingIDs(EntityID entityID) {
        return new EdgeCursorIterator(this, this.node(entityID).outEdges());
    }

    public Iterable<LinkID> linkIDs(EntityID entityID) {
        return new EdgeCursorIterator(this, this.node(entityID).edges());
    }

    public Set<LinkID> linkIDs(EdgeList edges) {
        EdgeCursorIterator itr = new EdgeCursorIterator(this, edges.edges());
        HashSet<LinkID> linkIDs = new HashSet<LinkID>(edges.size());
        while (itr.hasNext()) {
            linkIDs.add(itr.next());
        }
        return linkIDs;
    }

    public EntityID sourceID(LinkID link) {
        Node node;
        Edge edge = this.edge(link);
        if (edge != null && (node = edge.source()) != null) {
            return this.entityID(node);
        }
        return null;
    }

    public EntityID targetID(LinkID linkID) {
        Node node;
        Edge edge = this.edge(linkID);
        if (edge != null && (node = edge.target()) != null) {
            return this.entityID(node);
        }
        return null;
    }

    public MaltegoEntity getEntity(EntityID id) {
        return GraphStoreHelper.getEntity(this._graph, id);
    }

    public MaltegoLink getLink(LinkID id) {
        return GraphStoreHelper.getLink(this._graph, id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Graph ");
        sb.append(System.identityHashCode(this)).append("\n Entities->yNodes\n");
        for (EntityID entityID : this._entities.keys()) {
            sb.append("  ").append(entityID);
            sb.append("->").append(this.node(entityID)).append("\n");
        }
        return sb.toString();
    }
}

