/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.wrapper;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import java.util.Iterator;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;

public final class Cursors {
    private Cursors() {
    }

    public static Iterable<Node> sourceNodes(EdgeCursor edges) {
        return new SourceIterator(edges);
    }

    public static Iterable<Node> targetNodes(EdgeCursor edges) {
        return new TargetIterator(edges);
    }

    public static Iterable<Node> parents(Node node) {
        return Cursors.sourceNodes(node.inEdges());
    }

    public static Iterable<Node> children(Node node) {
        return Cursors.targetNodes(node.outEdges());
    }

    public static Iterable<EntityID> parentEntities(Node node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper(node.getGraph());
        return new EntityIterator(wrapper, new SourceIterator(node.inEdges()));
    }

    public static Iterable<EntityID> childEntities(Node node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper(node.getGraph());
        return new EntityIterator(wrapper, new TargetIterator(node.outEdges()));
    }

    private static class EntityIterator
    implements Iterator<EntityID>,
    Iterable<EntityID> {
        private Iterator<Node> _nodes;
        private GraphWrapper _wrapper;

        public EntityIterator(GraphWrapper wrapper, Iterator<Node> nodes) {
            this._nodes = nodes;
            this._wrapper = wrapper;
        }

        @Override
        public boolean hasNext() {
            return this._nodes.hasNext();
        }

        @Override
        public EntityID next() {
            Node node = this._nodes.next();
            return this._wrapper.entityID(node);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<EntityID> iterator() {
            return this;
        }
    }

    private static abstract class EdgeCursorIterator
    implements Iterator<Node>,
    Iterable<Node> {
        private EdgeCursor _ec;

        public EdgeCursorIterator(EdgeCursor ec) {
            this._ec = ec;
        }

        @Override
        public boolean hasNext() {
            return this._ec.ok();
        }

        @Override
        public Node next() {
            Node node = this.node(this._ec.edge());
            this._ec.next();
            return node;
        }

        protected abstract Node node(Edge var1);

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Iterator<Node> iterator() {
            return this;
        }
    }

    private static class SourceIterator
    extends EdgeCursorIterator {
        public SourceIterator(EdgeCursor ec) {
            super(ec);
        }

        @Override
        protected Node node(Edge edge) {
            return edge.source();
        }
    }

    private static class TargetIterator
    extends EdgeCursorIterator {
        public TargetIterator(EdgeCursor ec) {
            super(ec);
        }

        @Override
        protected Node node(Edge edge) {
            return edge.target();
        }
    }
}

