/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.csv.io;

import com.paterva.maltego.graph.table.io.exp.TabularGraphFileExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Exceptions;

public class CSVExporter
extends TabularGraphFileExporter {
    static final String delimiter = DecimalFormatSymbols.getInstance().getDecimalSeparator() == '.' ? "," : ";";

    public String getFileType() {
        return "Comma Separated Values";
    }

    public String getExtension() {
        return "csv";
    }

    protected void write(File file, List<List<String>> table, ProgressHandle handle) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            for (List<String> row : table) {
                String csv = row.stream().map(value -> this.escape((String)value)).collect(Collectors.joining(delimiter, "", System.lineSeparator()));
                osw.write(csv);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected String escape(String value) {
        String escaped = value.replace("\"", "\"\"");
        if (escaped.length() > value.length() || escaped.startsWith(" ") || escaped.endsWith(" ") || escaped.contains("\n") || escaped.contains(delimiter)) {
            escaped = "\"" + escaped + "\"";
        }
        return escaped;
    }
}

