/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v2;

import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.archive.mtz.discover.DiscoveryContext;
import com.paterva.maltego.archive.mtz.discover.DiscoveryMergingRules;
import com.paterva.maltego.archive.mtz.discover.MtzDiscoveryProvider;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerListingProvider;
import com.paterva.maltego.transform.protocol.v2api.messaging.Proxy;
import com.paterva.maltego.transform.protocol.v2api.messaging.ProxyFactory;
import com.paterva.maltego.util.NormalException;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import net.lingala.zip4j.core.ZipFile;
import org.apache.commons.io.FileUtils;

public class MtzListingProvider
extends TransformServerListingProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TransformServerDetail serverDetail, TransformServerListing listing) throws Exception {
        File tempFile = null;
        String source = serverDetail.getBaseUrl().toString();
        DiscoveryContext ctx = new DiscoveryContext(serverDetail.getSeedUrl(), DiscoveryMergingRules.getDefault());
        try {
            Proxy proxy = ProxyFactory.getDefault().createProxy(source);
            byte[] mtzConfig = proxy.getMtzConfig();
            if (mtzConfig.length > 2) {
                tempFile = File.createTempFile("mtz", null);
                FileUtils.writeByteArrayToFile((File)tempFile, (byte[])mtzConfig);
                ZipFile zipFile = new ZipFile(tempFile);
                MaltegoArchiveReader reader = new MaltegoArchiveReader(zipFile);
                Set items = listing.getMtzDiscoveryItems();
                Collection providers = MtzDiscoveryProvider.getAll();
                for (MtzDiscoveryProvider provider : providers) {
                    items.add(provider.read(ctx, reader));
                }
            }
        }
        catch (Exception ex) {
            System.out.println("source = " + source);
            NormalException.logStackTrace((Throwable)ex);
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                tempFile.delete();
            }
        }
    }
}

