/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.graph.GraphFreezableRegistry;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.transform.runner.api.GlobalInputProvider;
import com.paterva.maltego.transform.runner.api.TransformHandle;
import com.paterva.maltego.transform.runner.api.TransformRunManager;
import com.paterva.maltego.transform.runner.api.TransformRunner;
import com.paterva.maltego.transform.runner.api.TransformRunnerContext;
import com.paterva.maltego.transform.runner.api.TransformsCallback;
import com.paterva.maltego.transform.runner.api.TransformsHandle;
import com.paterva.maltego.transform.runner.api.TransformsRunContext;
import com.paterva.maltego.transform.runner.api.impl.TransformResultBatcher;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DataSources;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.progress.aggregate.ProgressMonitor;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public abstract class DefaultTransformRunManager
extends TransformRunManager
implements Cancellable,
ProgressMonitor {
    private static final Logger LOG = Logger.getLogger(DefaultTransformRunManager.class.getName());
    private AggregateProgressHandle _progressHandle = null;
    private Map<TransformsHandle, Set<TransformRunInfo>> _handles;

    @Override
    public TransformsHandle runTransforms(GraphID targetGraphID, Map<TransformDefinition, TransformServerInfo> transforms, Map<TransformDefinition, DataSource> transformInputs, Set<EntityID> entityIDs, EntityRegistry entityRegistry, EntityFactory entityFactory, LinkFactory linkFactory, boolean popupErrors, TransformsCallback callback) {
        this.checkEDT("runTransforms(...)");
        LOG.log(Level.FINE, "Running {0} transforms", transforms.size());
        TransformRunner runner = TransformRunner.getDefault();
        ProgressContributor[] progressContributors = new ProgressContributor[transforms.size()];
        for (int i = 0; i < transforms.size(); ++i) {
            progressContributors[i] = AggregateProgressFactory.createProgressContributor((String)("Transform " + i));
            if (this._progressHandle == null) continue;
            this._progressHandle.addContributor(progressContributors[i]);
        }
        if (this._progressHandle == null) {
            this._progressHandle = AggregateProgressFactory.createHandle((String)"Running Transforms", (ProgressContributor[])progressContributors, (Cancellable)this, null);
            this._progressHandle.setMonitor((ProgressMonitor)this);
            this._progressHandle.start();
        }
        if (this.getHandles().isEmpty() && !transforms.isEmpty()) {
            this.onTransformsStarted(transforms, targetGraphID, entityIDs);
        }
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(targetGraphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            entityIDs = structureReader.getExistingEntities(entityIDs);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Map allInputEntities = GraphStoreHelper.getEntities((GraphID)targetGraphID, entityIDs);
        int transformNum = 0;
        TransformsHandle groupHandle = new TransformsHandle(){};
        HashSet<TransformRunInfo> transformInfo = new HashSet<TransformRunInfo>();
        TransformsRunContext ctx = new TransformsRunContext(targetGraphID, transforms.keySet(), allInputEntities, entityRegistry, entityFactory, linkFactory, popupErrors, callback);
        for (Map.Entry<TransformDefinition, TransformServerInfo> entry : transforms.entrySet()) {
            ProgressContributor progressContributor;
            DataSource proxy;
            Map<EntityID, MaltegoEntity> transformInputEntities;
            TransformRunnerContext runnerCtx;
            TransformHandle handle;
            TransformDefinition def = entry.getKey();
            TransformServerInfo server = entry.getValue();
            DataSource inputs = transformInputs.get(def);
            if (inputs == null) {
                inputs = DataSources.empty();
            }
            if ((handle = runner.run(runnerCtx = new TransformRunnerContext(ctx, transformInputEntities = this.getEntityIDs(targetGraphID, allInputEntities, (TransformDescriptor)def, entityRegistry), def, proxy = DataSources.readOnlyProxy((DataSource[])new DataSource[]{inputs, GlobalInputProvider.getDefault().getInputs(), def}), server), progressContributor = progressContributors[transformNum++])) == null) continue;
            transformInfo.add(new TransformRunInfo(targetGraphID, progressContributor, groupHandle, handle));
        }
        this.getHandles().put(groupHandle, transformInfo);
        return groupHandle;
    }

    private Map<TransformsHandle, Set<TransformRunInfo>> getHandles() {
        this.checkEDT("getHandles()");
        if (this._handles == null) {
            this._handles = new HashMap<TransformsHandle, Set<TransformRunInfo>>();
        }
        return this._handles;
    }

    @Override
    public void cancel(TransformsHandle groupHandle) {
        LOG.log(Level.FINE, "Canceling transforms");
        Map<TransformsHandle, Set<TransformRunInfo>> groupHandles = this.getHandles();
        Set<TransformRunInfo> transformRunInfos = groupHandles.get(groupHandle);
        if (transformRunInfos != null) {
            for (TransformRunInfo transformRunInfo : transformRunInfos) {
                TransformRunner.getDefault().cancel(transformRunInfo.getTransformHandle());
                this.remove(transformRunInfo);
            }
        }
    }

    @Override
    public boolean isRunning(TransformsHandle groupHandle) {
        Map<TransformsHandle, Set<TransformRunInfo>> groupHandles = this.getHandles();
        return groupHandles.get(groupHandle) != null;
    }

    public boolean cancel() {
        LOG.log(Level.FINE, "Canceling all transforms");
        TransformRunner.getDefault().cancelAll();
        this.fireGraphTransformsDone();
        this.onTransformsDone();
        this.getHandles().clear();
        return true;
    }

    public void started(ProgressContributor pc) {
    }

    public void finished(ProgressContributor pc) {
        LOG.log(Level.FINE, "Finished transforms");
        Runnable finish = () -> {
            TransformRunInfo transformRunInfo = this.getTransformRunInfo(pc);
            if (transformRunInfo != null) {
                this.remove(transformRunInfo);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            finish.run();
        } else {
            SwingUtilities.invokeLater(finish);
        }
    }

    public void progressed(ProgressContributor pc) {
    }

    private TransformRunInfo getTransformRunInfo(ProgressContributor pc) {
        for (Map.Entry<TransformsHandle, Set<TransformRunInfo>> entry : this.getHandles().entrySet()) {
            for (TransformRunInfo transformRunInfo : entry.getValue()) {
                if (!transformRunInfo.getProgressContributor().equals(pc)) continue;
                return transformRunInfo;
            }
        }
        return null;
    }

    protected void onTransformsStarted(Map<TransformDefinition, TransformServerInfo> transforms, GraphID graphID, Set<EntityID> entityIDs) {
        LOG.log(Level.FINE, "On transforms started for graph {0}", graphID);
        SwingUtilities.invokeLater(() -> DefaultTransformRunManager.getResultBatcher(graphID).onTransformsStarted());
    }

    protected void onTransformsDone(GraphID graphID) {
        LOG.log(Level.FINE, "On transforms done for graph {0}", graphID);
        SwingUtilities.invokeLater(() -> DefaultTransformRunManager.getResultBatcher(graphID).onTransformsDone());
    }

    protected void onTransformsDone() {
        LOG.log(Level.FINE, "On all transforms done");
        if (this._progressHandle != null) {
            this._progressHandle.finish();
            this._progressHandle = null;
        }
    }

    private void remove(TransformRunInfo transformRunInfo) {
        TransformsHandle groupHandle = transformRunInfo.getGroupHandle();
        Map<TransformsHandle, Set<TransformRunInfo>> groupHandles = this.getHandles();
        Set<TransformRunInfo> transformRunInfos = groupHandles.get(groupHandle);
        if (transformRunInfos != null) {
            transformRunInfos.remove(transformRunInfo);
            GraphID graphID = transformRunInfo.getGraphID();
            if (this.isGraphTransformsDone(graphID)) {
                this.onTransformsDone(graphID);
            }
            if (transformRunInfos.isEmpty()) {
                groupHandles.remove(groupHandle);
                if (groupHandles.isEmpty()) {
                    TransformRunner.getDefault().cancelAll();
                    this.onTransformsDone();
                }
            }
        }
    }

    private boolean isGraphTransformsDone(GraphID graphID) {
        Map<TransformsHandle, Set<TransformRunInfo>> groupHandles = this.getHandles();
        for (Map.Entry<TransformsHandle, Set<TransformRunInfo>> entry : groupHandles.entrySet()) {
            Set<TransformRunInfo> infos = entry.getValue();
            for (TransformRunInfo info : infos) {
                if (!graphID.equals((Object)info.getGraphID())) continue;
                return false;
            }
        }
        return true;
    }

    private void fireGraphTransformsDone() {
        HashSet<GraphID> graphIDs = new HashSet<GraphID>();
        Map<TransformsHandle, Set<TransformRunInfo>> groupHandles = this.getHandles();
        for (Map.Entry<TransformsHandle, Set<TransformRunInfo>> entry : groupHandles.entrySet()) {
            Set<TransformRunInfo> infos = entry.getValue();
            for (TransformRunInfo info : infos) {
                graphIDs.add(info.getGraphID());
            }
        }
        for (GraphID graphID : graphIDs) {
            this.onTransformsDone(graphID);
        }
    }

    private static TransformResultBatcher getResultBatcher(GraphID graphID) {
        return (TransformResultBatcher)GraphFreezableRegistry.getDefault().forGraph(graphID);
    }

    public abstract Map<EntityID, MaltegoEntity> getEntityIDs(GraphID var1, Map<EntityID, MaltegoEntity> var2, TransformDescriptor var3, EntityRegistry var4);

    private void checkEDT(String methodName) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                throw new IllegalStateException(methodName + " may not be called outside the UI thread");
            }
            catch (IllegalStateException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class TransformRunInfo {
        private final GraphID _graphID;
        private final ProgressContributor _progressContributor;
        private final TransformsHandle _groupHandle;
        private final TransformHandle _transformHandle;

        public TransformRunInfo(GraphID graphID, ProgressContributor progressContributor, TransformsHandle groupHandle, TransformHandle transformHandle) {
            this._graphID = graphID;
            this._progressContributor = progressContributor;
            this._groupHandle = groupHandle;
            this._transformHandle = transformHandle;
        }

        public GraphID getGraphID() {
            return this._graphID;
        }

        public ProgressContributor getProgressContributor() {
            return this._progressContributor;
        }

        public TransformsHandle getGroupHandle() {
            return this._groupHandle;
        }

        public TransformHandle getTransformHandle() {
            return this._transformHandle;
        }
    }
}

