/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api.impl;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.runner.api.TransformErrorHelper;
import com.paterva.maltego.transform.runner.api.TransformMessageHandler;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transform.runner.api.TransformsRunContext;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.List;

public class DefaultTransformMessageHandler
extends TransformMessageHandler {
    @Override
    public void handle(TransformRunContext ctx, List<TransformMessage> messages, MaltegoEntity inputEntity) {
        Args.notNull((Object)ctx, (String)"ctx");
        Args.notNull(messages, (String)"messages");
        messages = this.handleSpecialErrors(ctx, messages);
        boolean hasErrors = false;
        for (TransformMessage message : messages) {
            this.display(ctx, message, inputEntity);
            if (message.getSeverity() != TransformMessage.Severity.Error) continue;
            hasErrors = true;
        }
        TransformsRunContext transformsContext = ctx.getTransformsContext();
        if (hasErrors) {
            if (transformsContext.isPopupErrors()) {
                this.popupErrors(ctx.getTransform(), messages);
            }
            transformsContext.onTransformError(ctx, messages);
        }
    }

    protected void display(TransformRunContext ctx, TransformMessage message, MaltegoEntity inputEntity) {
        System.out.println("Transform message: " + message.getSeverity().toString().toUpperCase() + " " + message.getText());
    }

    private List<TransformMessage> handleSpecialErrors(TransformRunContext ctx, List<TransformMessage> messages) {
        ArrayList<TransformMessage> result = new ArrayList<TransformMessage>(messages);
        for (TransformMessage message : messages) {
            if (message.getSeverity() != TransformMessage.Severity.Error || message.getCode() == 0 || !TransformErrorHelper.handle(ctx, message)) continue;
            result.remove(message);
        }
        return result;
    }

    protected void popupErrors(TransformDefinition transform, List<TransformMessage> messages) {
    }
}

