/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.util.Args;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TransformResult {
    private List<TransformMessage> _messages;
    private int _lastProgress = -1;
    private String _lastProgressMessage;
    private int _entityCount;
    private GraphID _graphID;
    private boolean _transformComplete = false;
    private Map<EntityID, List<EntityID>> _inputToOutputEntities;
    private MaltegoEntity _inputEntity;
    private static final TransformResult EMPTY = new TransformResult();

    public List<TransformMessage> getMessages() {
        return this._messages;
    }

    public int getLastProgress() {
        return this._lastProgress;
    }

    public GraphID getGraphID() {
        return this._graphID;
    }

    public Map<EntityID, List<EntityID>> getInputToOutputEntities() {
        return this._inputToOutputEntities;
    }

    public int getEntityCount() {
        return this._entityCount;
    }

    public boolean transformComplete() {
        return this._transformComplete;
    }

    public MaltegoEntity getInputEntity() {
        return this._inputEntity;
    }

    public static TransformResult message(TransformMessage message) {
        return TransformResult.message(message, null);
    }

    public static TransformResult message(TransformMessage message, MaltegoEntity inputEntity) {
        return TransformResult.messages(Collections.singletonList(message), inputEntity);
    }

    public static TransformResult messages(List<TransformMessage> messages) {
        return TransformResult.messages(messages, null);
    }

    public static TransformResult messages(List<TransformMessage> messages, MaltegoEntity inputEntity) {
        TransformResult result = new TransformResult();
        result._messages = messages;
        result._inputEntity = inputEntity;
        return result;
    }

    public static TransformResult info(String message, boolean log) {
        return TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Info, message, log));
    }

    public static TransformResult warning(String message) {
        return TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Warning, message));
    }

    public static TransformResult progress(int progress) {
        TransformResult result = new TransformResult();
        result._lastProgress = progress;
        return result;
    }

    public static TransformResult info(String message, int progress) {
        TransformResult result = new TransformResult();
        result._messages = Collections.singletonList(new TransformMessage(new Date(), TransformMessage.Severity.Info, message));
        result._lastProgress = progress;
        result._lastProgressMessage = message;
        return result;
    }

    public static TransformResult error(Exception e) {
        return TransformResult.error(e.getMessage());
    }

    public static TransformResult error(Exception e, int code) {
        return TransformResult.error(e.getMessage(), code);
    }

    public static TransformResult error(String error) {
        TransformResult result = TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Error, error));
        result._transformComplete = true;
        return result;
    }

    public static TransformResult error(String error, int code) {
        TransformResult result = TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Error, error, code));
        result._transformComplete = true;
        return result;
    }

    public static TransformResult nonInterruptingError(String error, int code) {
        TransformResult result = TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Error, error, code));
        return result;
    }

    public static TransformResult nonInterruptingError(String error) {
        TransformResult result = TransformResult.message(new TransformMessage(new Date(), TransformMessage.Severity.Error, error));
        return result;
    }

    public static TransformResult progress(String message, int progress, GraphID resultGraphID, int entityCount, boolean complete, Map<EntityID, List<EntityID>> inputToOutputEntities) {
        Args.notNull((Object)resultGraphID, (String)"resultGraphID");
        Args.notNull(inputToOutputEntities, (String)"inputToOutputEntities");
        TransformResult result = new TransformResult();
        result._graphID = resultGraphID;
        result._entityCount = entityCount;
        result._lastProgress = progress;
        result._lastProgressMessage = message;
        result._transformComplete = complete;
        result._inputToOutputEntities = inputToOutputEntities;
        return result;
    }

    public static TransformResult complete(String message) {
        Args.notNull((Object)message, (String)"message");
        TransformResult result = new TransformResult();
        result._messages = Collections.singletonList(new TransformMessage(new Date(), TransformMessage.Severity.Info, message));
        result._lastProgress = 100;
        result._lastProgressMessage = message;
        result._transformComplete = true;
        result._inputToOutputEntities = Collections.EMPTY_MAP;
        return result;
    }

    public static TransformResult empty() {
        return EMPTY;
    }

    public String getLastProgressMessage() {
        return this._lastProgressMessage;
    }

    public String toString() {
        return this._lastProgress + " " + this._lastProgressMessage;
    }

    static {
        TransformResult.EMPTY._transformComplete = true;
    }
}

