/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.api;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.transform.runner.api.MatchingRuleUpdater;
import com.paterva.maltego.transform.runner.api.TransformAdapter;
import com.paterva.maltego.transform.runner.api.TransformCallback;
import com.paterva.maltego.transform.runner.api.TransformDoneMutex;
import com.paterva.maltego.transform.runner.api.TransformResult;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.Args;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.util.Cancellable;

public abstract class AbstractTransformAdapter
extends MatchingRuleUpdater
implements TransformAdapter {
    private static final Logger LOG = Logger.getLogger(AbstractTransformAdapter.class.getName());
    private static final PropertyDescriptor SLIDER = new PropertyDescriptor(Integer.class, "maltego.global.slider");
    private TransformDoneMutex doneMutex;
    private int limit;
    private boolean cancelled = false;

    protected abstract List<Cancellable> runAsync(TransformRunContext var1) throws Exception;

    protected TransformDoneMutex createDoneMutex(TransformRunContext ctx) {
        return new TransformDoneMutex();
    }

    public TransformDoneMutex getDoneMutex() {
        return this.doneMutex;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TransformRunContext ctx) {
        block11: {
            Args.notNull((Object)ctx, (String)"ctx");
            TransformCallback cb = ctx.getCallback();
            try {
                Map<EntityID, MaltegoEntity> inputEntities = ctx.getInputEntities();
                this.limit = this.getLimit(ctx.getTransformInputs());
                String msg = "Running transform " + ctx.getTransform().getDisplayName() + " on " + inputEntities.size() + " entities.";
                LOG.fine(msg);
                cb.resultReceived(TransformResult.info(msg, true));
                if (inputEntities.isEmpty()) {
                    cb.resultReceived(TransformResult.empty());
                    break block11;
                }
                this.doneMutex = this.createDoneMutex(ctx);
                List<Cancellable> cancellables = this.runAsync(ctx);
                cancellables.forEach(this.doneMutex::add);
                TransformDoneMutex transformDoneMutex = this.doneMutex;
                synchronized (transformDoneMutex) {
                    try {
                        if (Thread.interrupted()) {
                            this.cancelled = true;
                        } else {
                            this.doneMutex.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        this.cancelled = true;
                    }
                }
                if (this.cancelled) {
                    cb.cancelled();
                }
            }
            catch (Exception ex) {
                cb.resultReceived(TransformResult.error(ex.getMessage()));
            }
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        TransformDoneMutex handler = this.getDoneMutex();
        if (handler != null) {
            handler.cancel();
        }
    }

    protected int getLimit(DataSource transformInputs) {
        Args.notNull((Object)transformInputs, (String)"transformInputs");
        Integer slider = (Integer)transformInputs.getValue(SLIDER);
        return slider != null ? slider : 50;
    }
}

